/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildUltraliskCavern;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildUltralisk
extends EcAction
implements Serializable {
    private static final int time = 70;
    private static final int supply = 6;
    private static final int gas = 200;
    private static final int minerals = 300;

    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 300.0;
        s.gas -= 200.0;
        s.consumeLarva(e);
        s.supplyUsed += 6.0;
        s.addFutureAction(70.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Ultralisk+1");
                }
                ++s.ultralisks;
            }
        });
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        return s.ultraliskCavern == 0;
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 300.0) {
            return false;
        }
        if (s.gas < 200.0) {
            return false;
        }
        if (s.larva < 1) {
            return false;
        }
        return s.hasSupply(6.0);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildUltraliskCavern());
        destination.ultraliskCavern = Math.max(destination.ultraliskCavern, 1);
        return l;
    }
}

