/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildSpawningPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildQueen
extends EcAction
implements Serializable {
    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.supplyUsed += 2.0;
        s.minerals -= 150.0;
        s.consumeHatch(50);
        s.addFutureAction(50.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Queen+1");
                }
                ++s.queens;
                if (s.hatcheriesSpawningLarva < s.bases()) {
                    ++s.hatcheriesSpawningLarva;
                    s.addFutureAction(45.0, new Runnable(){

                        @Override
                        public void run() {
                            if (e.debug) {
                                e.obtained(s, " Larva+4");
                            }
                            s.larva += 4;
                            s.addFutureAction(45.0, this);
                        }
                    });
                } else {
                    s.addFutureAction(5.0, new Runnable(){

                        @Override
                        public void run() {
                            if (s.hatcheriesSpawningLarva < s.bases()) {
                                ++s.hatcheriesSpawningLarva;
                                s.addFutureAction(45.0, new Runnable(){

                                    @Override
                                    public void run() {
                                        if (e.debug) {
                                            e.obtained(s, " Larva+4");
                                        }
                                        s.larva += 4;
                                        s.addFutureAction(45.0, this);
                                    }
                                });
                            } else {
                                s.addFutureAction(5.0, this);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        if (s.spawningPools == 0) {
            return true;
        }
        return s.hatcheries + s.lairs + s.hives == 0;
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 150.0) {
            return false;
        }
        return s.hasSupply(2.0);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildSpawningPool());
        return l;
    }
}

