/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildNydusNetwork;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildNydusWorm
extends EcAction
implements Serializable {
    private static final int time = 20;
    private static final int minerals = 100;
    private static final int gas = 100;

    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 100.0;
        s.gas -= 100.0;
        s.addFutureAction(20.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Nydus Worm+1");
                }
                ++s.nydusWorm;
            }
        });
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 100.0) {
            return false;
        }
        return !(s.gas < 100.0);
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        if (s.lairs == 0 && s.evolvingLairs == 0 && s.hives == 0 && s.evolvingHives == 0) {
            return true;
        }
        if (s.nydusNetwork == 0) {
            return true;
        }
        return super.isInvalid(s);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildNydusNetwork());
        return l;
    }
}

