/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildLair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildHydraliskDen
extends EcAction
implements Serializable {
    private static final int time = 40;
    private static final int minerals = 100;
    private static final int gas = 100;

    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 100.0;
        s.gas -= 100.0;
        --s.drones;
        --s.dronesOnMinerals;
        s.supplyUsed -= 1.0;
        s.addFutureAction(40.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Hydralisk Den+1");
                }
                ++s.hydraliskDen;
            }
        });
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 100.0) {
            return false;
        }
        if (s.gas < 100.0) {
            return false;
        }
        return s.drones >= 1;
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        if (s.lairs == 0 && s.evolvingLairs == 0 && s.hives == 0 && s.evolvingHives == 0) {
            return true;
        }
        if (s.hydraliskDen == 2) {
            return true;
        }
        return super.isInvalid(s);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildLair());
        return l;
    }
}

