/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildHydraliskDen;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildHydralisk
extends EcAction
implements Serializable {
    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 100.0;
        s.gas -= 50.0;
        s.consumeLarva(e);
        s.supplyUsed += 2.0;
        s.addFutureAction(33.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Hydralisk+1");
                }
                ++s.hydralisks;
            }
        });
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        return s.hydraliskDen == 0;
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 100.0) {
            return false;
        }
        if (s.gas < 50.0) {
            return false;
        }
        if (s.larva < 1) {
            return false;
        }
        return s.hasSupply(2.0);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildHydraliskDen());
        destination.hydraliskDen = Math.max(destination.hydraliskDen, 1);
        return l;
    }
}

