/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildSpire;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildCorruptor
extends EcAction
implements Serializable {
    private static final int time = 40;
    private static final int supply = 2;
    private static final int gas = 100;
    private static final int minerals = 150;

    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 150.0;
        s.gas -= 100.0;
        s.consumeLarva(e);
        s.supplyUsed += 2.0;
        s.addFutureAction(40.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Corruptor+1");
                }
                ++s.corruptors;
            }
        });
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        return s.spire == 0 && s.greaterSpire == 0 && s.evolvingSpires == 0;
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 150.0) {
            return false;
        }
        if (s.gas < 100.0) {
            return false;
        }
        if (s.larva < 1) {
            return false;
        }
        return s.hasSupply(2.0);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildSpire());
        return l;
    }
}

