/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildCorruptor;
import com.fray.evo.action.build.EcActionBuildGreaterSpire;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildBroodLord
extends EcAction
implements Serializable {
    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 150.0;
        s.gas -= 150.0;
        --s.corruptors;
        s.addFutureAction(34.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Brood Lord+1");
                }
                ++s.broodlords;
            }
        });
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 150.0) {
            return false;
        }
        if (s.gas < 150.0) {
            return false;
        }
        return s.corruptors >= 1;
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        if (s.hives == 0 && s.evolvingHives == 0) {
            return true;
        }
        if (s.greaterSpire == 0) {
            return true;
        }
        return super.isInvalid(s);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildGreaterSpire());
        l.add(new EcActionBuildCorruptor());
        destination.hives = Math.max(destination.hives, 1);
        destination.greaterSpire = Math.max(destination.greaterSpire, 1);
        return l;
    }
}

