/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildExtractor;
import com.fray.evo.action.build.EcActionBuildSpawningPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildBanelingNest
extends EcAction
implements Serializable {
    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 100.0;
        s.gas -= 50.0;
        --s.drones;
        --s.dronesOnMinerals;
        s.supplyUsed -= 1.0;
        s.addFutureAction(60.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Baneling Nest+1");
                }
                ++s.banelingNest;
            }
        });
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        if (s.spawningPools == 0) {
            return true;
        }
        return s.banelingNest == 1;
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 100.0) {
            return false;
        }
        if (s.gas < 50.0) {
            return false;
        }
        return s.drones >= 1;
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildSpawningPool());
        l.add(new EcActionBuildExtractor());
        destination.spawningPools = Math.max(destination.spawningPools, 1);
        destination.gasExtractors = Math.max(destination.gasExtractors, 1);
        return l;
    }
}

