/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcGeneticUtil;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.util.EcFileSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.event.GeneticEvent;
import org.jgap.event.GeneticEventListener;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.IntegerGene;

public class EvolutionChamber {
    private static File SEEDS_EVO = null;
    private static File SEEDS_EVO_2 = null;
    public int CHROMOSOME_LENGTH = 120;
    int NUM_THREADS = 4;
    public int POPULATION_SIZE = 200;
    public Double bestScore = new Double(0.0);
    static List<EcBuildOrder> seeds = new ArrayList<EcBuildOrder>();
    private EcState destination = EcState.defaultDestination();
    public ActionListener onNewBuild;
    public List<Thread> threads = new ArrayList<Thread>();
    private boolean kill = false;
    public double BASE_CHANCE = 5.0;
    public static Double[] bestScores;
    public static Integer[] evolutionsSinceDiscovery;
    static boolean haveSavedBefore;

    static {
        try {
            SEEDS_EVO = new File(EcFileSystem.getTempPath(), "seeds.evo");
            SEEDS_EVO.getParentFile().mkdirs();
            SEEDS_EVO_2 = new File(EcFileSystem.getTempPath(), "seeds2.evo");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        haveSavedBefore = false;
    }

    public static void main(String[] args) throws InvalidConfigurationException {
        new EvolutionChamber().go();
    }

    public void go() throws InvalidConfigurationException {
        this.kill = false;
        EcBuildOrder s = this.importSource();
        EcState d = this.getInternalDestination();
        EcAction.setup(d);
        this.CHROMOSOME_LENGTH = d.getSumStuff() + 70;
        this.bestScore = new Double(0.0);
        bestScores = new Double[this.NUM_THREADS];
        evolutionsSinceDiscovery = new Integer[this.NUM_THREADS];
        int threadIndex = 0;
        while (threadIndex < this.NUM_THREADS) {
            this.spawnEvolutionaryChamber(s, d, threadIndex);
            ++threadIndex;
        }
        if (this.onNewBuild == null) {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public void stop() {
        this.kill = true;
        for (Thread t : this.threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.threads.clear();
    }

    private void spawnEvolutionaryChamber(EcState s, EcState d, int threadIndex) throws InvalidConfigurationException {
        EvolutionChamber.bestScores[threadIndex] = new Double(0.0);
        EvolutionChamber.evolutionsSinceDiscovery[threadIndex] = new Integer(0);
        DefaultConfiguration.reset((String)(String.valueOf(threadIndex) + " thread."));
        DefaultConfiguration conf = new DefaultConfiguration(String.valueOf(threadIndex) + " thread.", String.valueOf(threadIndex) + " thread.");
        EcEvolver myFunc = new EcEvolver(s, d);
        conf.setFitnessFunction((FitnessFunction)myFunc);
        conf.addGeneticOperator(EcGeneticUtil.getCleansingOperator(this));
        conf.addGeneticOperator(EcGeneticUtil.getOverlordingOperator(this));
        conf.addGeneticOperator(EcGeneticUtil.getInsertionOperator(this));
        conf.addGeneticOperator(EcGeneticUtil.getDeletionOperator(this));
        conf.addGeneticOperator(EcGeneticUtil.getTwiddleOperator(this));
        conf.addGeneticOperator(EcGeneticUtil.getSwapOperator(this));
        conf.setPopulationSize(this.POPULATION_SIZE);
        conf.setSelectFromPrevGen(1.0);
        conf.setPreservFittestIndividual(false);
        conf.setAlwaysCaculateFitness(false);
        conf.setKeepPopulationSizeConstant(false);
        Gene[] initialGenes = this.importInitialGenes((Configuration)conf);
        Chromosome c = new Chromosome((Configuration)conf, initialGenes);
        conf.setSampleChromosome((IChromosome)c);
        Genotype population = Genotype.randomInitialGenotype((Configuration)conf);
        if (threadIndex == 0) {
            this.loadOldBuildOrders(population, (Configuration)conf, myFunc);
        }
        Thread t1 = new Thread((Runnable)population);
        conf.getEventManager().addEventListener("genotype_evolved_event", new GeneticEventListener((Configuration)conf, population, t1, threadIndex, s, d, myFunc){
            private final /* synthetic */ Configuration val$conf;
            private final /* synthetic */ Genotype val$population;
            private final /* synthetic */ Thread val$t1;
            private final /* synthetic */ int val$threadIndex;
            private final /* synthetic */ EcState val$s;
            private final /* synthetic */ EcState val$d;
            private final /* synthetic */ EcEvolver val$myFunc;
            {
                this.val$conf = configuration;
                this.val$population = genotype;
                this.val$t1 = thread;
                this.val$threadIndex = n;
                this.val$s = ecState;
                this.val$d = ecState2;
                this.val$myFunc = ecEvolver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void geneticEventFired(GeneticEvent a_firedEvent) {
                double fitnessValue;
                Collections.shuffle(this.val$conf.getGeneticOperators());
                EvolutionChamber.this.BASE_CHANCE += 0.001;
                if (EvolutionChamber.this.BASE_CHANCE >= (double)(EvolutionChamber.this.CHROMOSOME_LENGTH / 2)) {
                    EvolutionChamber.this.BASE_CHANCE = 1.0;
                }
                IChromosome fittestChromosome = this.val$population.getFittestChromosome();
                if (EvolutionChamber.this.kill) {
                    this.val$t1.interrupt();
                }
                if ((fitnessValue = fittestChromosome.getFitnessValue()) > bestScores[this.val$threadIndex]) {
                    EvolutionChamber.bestScores[this.val$threadIndex] = fitnessValue;
                    EvolutionChamber.evolutionsSinceDiscovery[this.val$threadIndex] = 0;
                    EvolutionChamber.this.BASE_CHANCE = 1.0;
                } else {
                    int n = this.val$threadIndex;
                    evolutionsSinceDiscovery[n] = evolutionsSinceDiscovery[n] + 1;
                }
                if (evolutionsSinceDiscovery[this.val$threadIndex] > 1000 && fitnessValue < EvolutionChamber.this.bestScore) {
                    System.out.println("Restarting thread " + this.val$threadIndex);
                    try {
                        EvolutionChamber.this.spawnEvolutionaryChamber(this.val$s, this.val$d, this.val$threadIndex);
                    }
                    catch (InvalidConfigurationException e) {
                        e.printStackTrace();
                    }
                    this.val$t1.interrupt();
                }
                Double d = EvolutionChamber.this.bestScore;
                synchronized (d) {
                    if (fitnessValue > EvolutionChamber.this.bestScore) {
                        EvolutionChamber.this.BASE_CHANCE = 1.0;
                        EvolutionChamber.this.bestScore = fitnessValue;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(byteArrayOutputStream);
                        if (EvolutionChamber.this.onNewBuild != null) {
                            this.val$myFunc.log = ps;
                        }
                        EvolutionChamber.this.displayBuildOrder(this.val$myFunc, fittestChromosome);
                        this.val$myFunc.log.println(new Date() + ": " + fitnessValue);
                        EvolutionChamber.displayChromosome(fittestChromosome);
                        EvolutionChamber.this.saveSeeds(fittestChromosome);
                        if (EvolutionChamber.this.onNewBuild != null) {
                            EvolutionChamber.this.onNewBuild.actionPerformed(new ActionEvent(this.val$myFunc.evaluateGetBuildOrder(fittestChromosome), EvolutionChamber.this.bestScore.intValue(), new String(byteArrayOutputStream.toByteArray())));
                        }
                        System.out.println();
                    }
                }
            }
        });
        t1.start();
        t1.setPriority(1);
        this.threads.add(t1);
    }

    public static void displayChromosome(IChromosome fittestChromosome) {
        int i = 0;
        Gene[] geneArray = fittestChromosome.getGenes();
        int n = geneArray.length;
        int n2 = 0;
        while (n2 < n) {
            Gene g = geneArray[n2];
            if (i++ == 100) break;
            if ((Integer)g.getAllele() >= 10) {
                System.out.print((char)(97 + (Integer)g.getAllele() - 10));
            } else {
                System.out.print(g.getAllele().toString());
            }
            ++n2;
        }
    }

    private void displayBuildOrder(EcEvolver myFunc, IChromosome fittestChromosome) {
        myFunc.debug = true;
        myFunc.evaluateGetBuildOrder(fittestChromosome);
        myFunc.debug = false;
    }

    private synchronized void loadOldBuildOrders(Genotype population, final Configuration conf, final EcEvolver myFunc) {
        EvolutionChamber.loadSeeds();
        int cindex = 0;
        Collections.sort(seeds, new Comparator<EcBuildOrder>(){

            @Override
            public int compare(EcBuildOrder arg0, EcBuildOrder arg1) {
                double score = 0.0;
                try {
                    score = myFunc.getFitnessValue((IChromosome)EvolutionChamber.this.buildChromosome(conf, arg1)) - myFunc.getFitnessValue((IChromosome)EvolutionChamber.this.buildChromosome(conf, arg0));
                }
                catch (InvalidConfigurationException e) {
                    e.printStackTrace();
                }
                return (int)score;
            }
        });
        for (EcBuildOrder bo : seeds) {
            try {
                Chromosome c = this.buildChromosome(conf, bo);
                System.out.println(myFunc.getFitnessValue((IChromosome)c));
                population.getPopulation().setChromosome(cindex++, (IChromosome)c);
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadSeeds() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(SEEDS_EVO));
            seeds = (List)ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Seeds file not found.");
        }
        catch (InvalidClassException ex) {
            System.out.println("Seeds file is in old format. Starting over. :-(");
        }
        catch (IOException e) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(SEEDS_EVO_2));
                seeds = (List)ois.readObject();
                ois.close();
            }
            catch (FileNotFoundException e1) {
                System.out.println("Seeds file not found.");
            }
            catch (InvalidClassException ex) {
                System.out.println("Seeds 2 file is in old format. Starting over. :-(");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Seeds 2 file is in old format. Starting over. :-(");
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Seeds file is in old format. Starting over. :-(");
        }
    }

    protected synchronized void saveSeeds(IChromosome fittestChromosome) {
        EcBuildOrder bo = this.importSource();
        try {
            bo = EcEvolver.populateBuildOrder(bo, fittestChromosome);
            if (haveSavedBefore) {
                seeds.remove(seeds.size() - 1);
            }
            haveSavedBefore = true;
            seeds.add(bo);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(SEEDS_EVO, false));
            oos.writeObject(seeds);
            oos.close();
            oos = new ObjectOutputStream(new FileOutputStream(SEEDS_EVO_2, false));
            oos.writeObject(seeds);
            oos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Gene[] importInitialGenes(Configuration conf) {
        ArrayList<IntegerGene> genes = new ArrayList<IntegerGene>();
        int i = 0;
        while (i < this.CHROMOSOME_LENGTH) {
            try {
                IntegerGene g = new IntegerGene(conf, 0, EcAction.actions.size() - 1);
                g.setAllele((Object)0);
                genes.add(g);
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return genes.toArray(new Gene[genes.size()]);
    }

    private EcBuildOrder importSource() {
        EcBuildOrder ecBuildOrder = new EcBuildOrder();
        ecBuildOrder.targetSeconds = this.importDestination().targetSeconds;
        return ecBuildOrder;
    }

    public EcState importDestination() {
        try {
            return (EcState)this.getInternalDestination().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    Chromosome buildChromosome(Configuration conf, EcBuildOrder bo) throws InvalidConfigurationException {
        ArrayList<IntegerGene> genes = new ArrayList<IntegerGene>();
        int CC = 0;
        for (EcAction a : bo.actions) {
            if (++CC > this.CHROMOSOME_LENGTH) continue;
            IntegerGene g = new IntegerGene(conf, 0, EcAction.actions.size() - 1);
            Integer allele = EcAction.findAllele(a);
            if (allele == null) break;
            g.setAllele((Object)allele);
            genes.add(g);
        }
        while (genes.size() < this.CHROMOSOME_LENGTH) {
            IntegerGene g = new IntegerGene(conf, 0, EcAction.actions.size() - 1);
            g.setAllele((Object)0);
            genes.add(g);
        }
        Chromosome c = new Chromosome(conf);
        c.setGenes(genes.toArray(new Gene[genes.size()]));
        c.setIsSelectedForNextGeneration(true);
        return c;
    }

    public void setThreads(int digit) {
        this.NUM_THREADS = digit;
    }

    public void setDestination(EcState destination) {
        this.destination = destination;
    }

    public EcState getInternalDestination() {
        return this.destination;
    }
}

