/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.ui.swingx;

import com.fray.evo.EcEvolver;
import com.fray.evo.EcReportable;
import com.fray.evo.EcState;
import com.fray.evo.EvolutionChamber;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXStatusBar;
import org.jgap.InvalidConfigurationException;

public class EcSwingX
extends JXPanel
implements EcReportable {
    private JTextArea outputText;
    private JLabel status2;
    private JLabel status1;
    protected long timeStarted;
    protected long lastUpdate;
    int gridy = 0;
    private JXStatusBar statusbar;
    private List<JComponent> textBoxes = new ArrayList<JComponent>();
    EvolutionChamber ec = new EvolutionChamber();
    EcState[] destination;
    private JButton goButton;
    private JButton stopButton;
    private JLabel status3;
    private JTextArea statsText;
    private JTabbedPane tabPane;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame frame = new JFrame();
                frame.setTitle("Evolution Chamber v0015");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add((Component)((Object)new EcSwingX()));
                frame.setPreferredSize(new Dimension(900, 800));
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public EcSwingX() {
        try {
            this.destination = new EcState[5];
            this.destination[0] = (EcState)this.ec.getInternalDestination().clone();
            this.destination[0].targetSeconds = 180;
            this.destination[1] = (EcState)this.ec.getInternalDestination().clone();
            this.destination[1].targetSeconds = 360;
            this.destination[2] = (EcState)this.ec.getInternalDestination().clone();
            this.destination[2].targetSeconds = 540;
            this.destination[3] = (EcState)this.ec.getInternalDestination().clone();
            this.destination[3].targetSeconds = 720;
            this.destination[4] = (EcState)this.ec.getInternalDestination().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        JSplitPane outside = new JSplitPane(1);
        JPanel leftbottom = new JPanel(new GridBagLayout());
        JScrollPane stuffPanel = new JScrollPane(leftbottom);
        outside.setLeftComponent(stuffPanel);
        JPanel right = new JPanel(new FlowLayout());
        outside.setRightComponent(new JScrollPane(right));
        this.addControlParts(leftbottom);
        this.tabPane = new JTabbedPane(2);
        int i = 0;
        while (i < 5) {
            JPanel lb = new JPanel(new GridBagLayout());
            if (i == 4) {
                this.tabPane.addTab("Final", lb);
            } else {
                this.tabPane.addTab("WP" + Integer.toString(i), lb);
            }
            this.addInputContainer(i, lb);
            ++i;
        }
        JPanel stats = new JPanel(new GridBagLayout());
        this.addStats(stats);
        this.tabPane.addTab("Stats", stats);
        this.tabPane.setSelectedIndex(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.gridy = this.gridy;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        leftbottom.add((Component)this.tabPane, gridBagConstraints);
        this.addStatusBar(leftbottom);
        this.addOutputContainer(right);
        this.add(outside);
        outside.setDividerLocation(395);
    }

    private void addStats(JPanel stats) {
        this.statsText = new JTextArea();
        stats.add(this.statsText);
        this.statsText.setAlignmentX(0.0f);
        this.statsText.setAlignmentY(0.0f);
        this.statsText.setTabSize(4);
    }

    private void addStatusBar(JPanel leftbottom) {
        this.statusbar = new JXStatusBar();
        this.status1 = new JLabel("Ready.");
        this.statusbar.add((Component)this.status1);
        this.status2 = new JLabel("Not Running.");
        this.statusbar.add((Component)this.status2);
        this.status3 = new JLabel("");
        this.statusbar.add((Component)this.status3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridy = this.gridy + 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        leftbottom.add((Component)this.statusbar, gridBagConstraints);
        Timer t = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long hours;
                long minutes;
                long seconds;
                long ms;
                if (EcSwingX.this.timeStarted == 0L) {
                    EcSwingX.this.status1.setText("Ready");
                } else {
                    ms = new Date().getTime() - EcSwingX.this.timeStarted;
                    seconds = ms / 1000L;
                    minutes = seconds / 60L;
                    hours = minutes / 60L;
                    EcSwingX.this.status1.setText("Running for " + hours % 60L + ":" + minutes % 60L + ":" + seconds % 60L);
                }
                if (EcSwingX.this.lastUpdate != 0L) {
                    ms = new Date().getTime() - EcSwingX.this.lastUpdate;
                    seconds = ms / 1000L;
                    minutes = seconds / 60L;
                    hours = minutes / 60L;
                    EcSwingX.this.status2.setText("Last update: " + hours % 60L + ":" + minutes % 60L + ":" + seconds % 60L + " ago");
                    double evalseconds = System.currentTimeMillis() - EcSwingX.this.timeStarted;
                    double permsPerSecond = EcEvolver.evaluations;
                    permsPerSecond /= (evalseconds /= 1000.0);
                    StringBuilder stats = new StringBuilder();
                    int threadIndex = 0;
                    stats.append(String.valueOf(EcEvolver.evaluations / 1000L) + "K games played.");
                    stats.append("\n" + EcSwingX.this.ec.CHROMOSOME_LENGTH + " alleles in the chromosome.");
                    stats.append("\n" + (int)permsPerSecond + " games played/second.");
                    stats.append("\nEvolution Rate: " + EcSwingX.this.ec.BASE_CHANCE / (double)EcSwingX.this.ec.CHROMOSOME_LENGTH);
                    Double[] doubleArray = EvolutionChamber.bestScores;
                    int n = EvolutionChamber.bestScores.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Double d = doubleArray[n2];
                        stats.append("\nProcessor " + threadIndex + " age: (" + EvolutionChamber.evolutionsSinceDiscovery[threadIndex++] + ") score: " + d);
                        ++n2;
                    }
                    EcSwingX.this.statsText.setText(stats.toString());
                }
                EcSwingX.this.statusbar.invalidate();
            }
        });
        t.start();
    }

    private void addOutputContainer(JPanel component) {
        this.outputText = new JTextArea();
        component.add(this.outputText);
        this.outputText.setAlignmentX(0.0f);
        this.outputText.setAlignmentY(0.0f);
        this.outputText.setTabSize(4);
        StringBuilder sb = new StringBuilder();
        sb.append("Hello! Welcome to the Evolution Chamber.");
        sb.append("\nTo start, enter in some units you would like to have.");
        sb.append("\nWhen you have decided what you would like, hit Start.");
        sb.append("\n\nPlease report any issues or new features you would like at: \nhttp://code.google.com/p/evolutionchamber/issues/list");
        sb.append("\n\nHow to use:");
        sb.append("\nEnter in what you would like to see as your end state. Hit Go. Be patient.");
        sb.append("\nThe build order will compute, and it can take several minutes to potentially hours.");
        sb.append("\nAll build orders are automatically saved when you exit or hit stop, so, if you put in");
        sb.append("\nthe same build order, you will get the same result.");
        sb.append("\n\nRemember that this is evolutionary science, so don't be surprised if things seem wonky!");
        sb.append("\n\nHow to use waypoints:");
        sb.append("\nTo use waypoints, enter first what you would like at the end of the build.");
        sb.append("\nThen go to a waypoint slot, enter a deadline time, and units.");
        sb.append("\nAll the waypoints are cumulative, so if you enter 6 zergling@3:00 on WP1,");
        sb.append("\n7 roach@6:00 on WP2, and 6 muta on final, you will end up with 6 lings,");
        sb.append("\n7 roaches, and 6 mutas by the time it finds a valid build.");
        this.outputText.setText(sb.toString());
    }

    private void addInputContainer(final int i, JPanel component) {
        this.addInput(component, "Drones", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].drones = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Deadline", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].targetSeconds = EcSwingX.this.getDigit(e);
            }
        }).setText(String.valueOf(Integer.toString(this.destination[i].targetSeconds / 60)) + ":" + Integer.toString(this.destination[i].targetSeconds % 60));
        ++this.gridy;
        this.addInput(component, "Overlords", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].overlords = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Overseers", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].overseers = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Pneumatized Carapace", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].pneumatizedCarapace = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "Ventral Sacs", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].ventralSacs = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Queens", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].queens = EcSwingX.this.getDigit(e);
            }
        });
        this.addCheck(component, "Burrow", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].burrow = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Zerglings", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].zerglings = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Metabolic Boost", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].metabolicBoost = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "Adrenal Glands", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].adrenalGlands = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Banelings", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].banelings = EcSwingX.this.getDigit(e);
            }
        });
        this.addCheck(component, "Centrifugal Hooks", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].centrifugalHooks = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Roaches", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].roaches = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Glial Reconstitution", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].glialReconstitution = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "Tunneling Claws", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].tunnelingClaws = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Hydralisks", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].hydralisks = EcSwingX.this.getDigit(e);
            }
        });
        this.addCheck(component, "Grooved Spines", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].groovedSpines = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Infestors", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].infestors = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Neural Parasite", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].neuralParasite = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "Pathogen Glands", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].pathogenGlands = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Mutalisks", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].mutalisks = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Ultralisks", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].ultralisks = EcSwingX.this.getDigit(e);
            }
        });
        this.addCheck(component, "Chitinous Plating", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].chitinousPlating = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Corruptors", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].corruptors = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Broodlords", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].broodlords = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Melee +1", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].melee1 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+2", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].melee2 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+3", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].melee3 = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Missile +1", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].missile1 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+2", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].missile2 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+3", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].missile3 = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Carapace +1", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].armor1 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+2", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].armor2 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+3", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].armor3 = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Flyer Attack +1", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].flyerAttack1 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+2", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].flyerAttack2 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+3", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].flyerAttack3 = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addCheck(component, "Flyer Armor +1", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].flyerArmor1 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+2", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].flyerArmor2 = EcSwingX.this.getTrue(e);
            }
        });
        this.addCheck(component, "+3", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].flyerArmor3 = EcSwingX.this.getTrue(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Hatcheries", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].hatcheries = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Lairs", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].lairs = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Hives", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].hives = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Gas Extractors", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].gasExtractors = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Evolution Chambers", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].evolutionChambers = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Spine Crawlers", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].spineCrawlers = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Spore Crawlers", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].sporeCrawlers = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Spawning Pools", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].spawningPools = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Baneling Nests", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].banelingNest = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Roach Warrens", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].roachWarrens = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Hydralisk Dens", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].hydraliskDen = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Infestation Pits", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].infestationPit = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Spires", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].spire = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Nydus Networks", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].nydusNetwork = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Nydus Worms", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].nydusWorm = EcSwingX.this.getDigit(e);
            }
        });
        ++this.gridy;
        this.addInput(component, "Ultralisk Caverns", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].ultraliskCavern = EcSwingX.this.getDigit(e);
            }
        });
        this.addInput(component, "Greater Spires", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.destination[i].greaterSpire = EcSwingX.this.getDigit(e);
            }
        });
    }

    private void addControlParts(JPanel component) {
        this.addInput(component, "Processors", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.ec.setThreads(EcSwingX.this.getDigit(e));
            }
        }).setText("4");
        this.stopButton = this.addButton(component, "Stop", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EcSwingX.this.ec.stop();
                EcSwingX.this.goButton.setEnabled(true);
                EcSwingX.this.stopButton.setEnabled(false);
                EcSwingX.this.timeStarted = 0L;
                for (JComponent j : EcSwingX.this.textBoxes) {
                    j.setEnabled(true);
                }
                EcSwingX.this.lastUpdate = 0L;
            }
        });
        this.stopButton.setEnabled(false);
        this.goButton = this.addButton(component, "Start", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcSwingX.this.ec.onNewBuild = new ActionListener(){

                    @Override
                    public void actionPerformed(final ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EcState destination = (EcState)e.getSource();
                                EcSwingX.this.outputText.setText(e.getActionCommand());
                                ((this).this).EcSwingX.this.lastUpdate = new Date().getTime();
                            }
                        });
                    }
                };
                for (JComponent j : EcSwingX.this.textBoxes) {
                    j.setEnabled(false);
                }
                EcSwingX.this.restartChamber();
                EcSwingX.this.tabPane.setSelectedIndex(5);
                EcSwingX.this.timeStarted = new Date().getTime();
                EcSwingX.this.goButton.setEnabled(false);
                EcSwingX.this.stopButton.setEnabled(true);
                EcEvolver.evaluations = 0L;
                EcEvolver.cachehits = 0L;
            }
        });
        ++this.gridy;
    }

    private JButton addButton(JPanel container, String string, ActionListener actionListener) {
        JButton button = new JButton();
        button.setText(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.gridy = this.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        container.add((Component)button, gridBagConstraints);
        button.addActionListener(actionListener);
        return button;
    }

    protected int getDigit(ActionEvent e) {
        JTextField tf = (JTextField)e.getSource();
        String text = tf.getText();
        try {
            if (text.contains(":")) {
                String[] split = text.split(":");
                if (Integer.parseInt(split[0]) < 0) {
                    throw new NumberFormatException();
                }
                if (Integer.parseInt(split[1]) < 0) {
                    throw new NumberFormatException();
                }
                return Integer.parseInt(split[0]) * 60 + Integer.parseInt(split[1]);
            }
            Integer i = Integer.parseInt(text);
            if (i < 0) {
                throw new NumberFormatException();
            }
            return i;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            tf.setText("0");
            return 0;
        }
        catch (NumberFormatException ex) {
            tf.setText("0");
            return 0;
        }
    }

    private void restartChamber() {
        if (this.ec.threads.size() > 0) {
            this.ec.stop();
        }
        try {
            EcState finalDestination = (EcState)this.destination[this.destination.length - 1].clone();
            int i = 0;
            while (i < this.destination.length - 1) {
                finalDestination.waypoints.add((EcState)this.destination[i].clone());
                ++i;
            }
            this.ec.setDestination(finalDestination);
            this.ec.go();
        }
        catch (InvalidConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    protected boolean getTrue(ActionEvent e) {
        JCheckBox tf = (JCheckBox)e.getSource();
        this.ec.bestScore = new Double(0.0);
        return tf.isSelected();
    }

    private JTextField addInput(JPanel container, String name, final ActionListener a) {
        JXLabel label = new JXLabel("  " + name);
        label.setAlignmentX(0.5f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.gridy = this.gridy;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        container.add((Component)label, gridBagConstraints);
        JTextField textField = new JTextField();
        textField.setColumns(5);
        textField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.gridy = this.gridy;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        container.add((Component)textField, gridBagConstraints);
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                a.actionPerformed(new ActionEvent(e.getSource(), 0, "changed"));
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.textBoxes.add((JComponent)label);
        this.textBoxes.add(textField);
        return textField;
    }

    private void addCheck(JPanel container, String name, final ActionListener a) {
        final JCheckBox checkBox = new JCheckBox();
        checkBox.setText(name);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = name.length() == 2 ? 1 : 2;
        gridBagConstraints.gridy = this.gridy;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        container.add((Component)checkBox, gridBagConstraints);
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                a.actionPerformed(new ActionEvent(checkBox, 0, "changed"));
            }
        });
        this.textBoxes.add(checkBox);
    }
}

