/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo;

import com.fray.evo.EvolutionChamber;
import com.fray.evo.action.EcAction;
import java.util.List;
import org.jgap.Gene;
import org.jgap.GeneticOperator;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.impl.IntegerGene;

public class EcGeneticUtil {
    static GeneticOperator getDeletionOperator(final EvolutionChamber c) {
        return new GeneticOperator(){

            public void operate(Population arg0, List arg1) {
                int i = 0;
                while (i < arg0.size()) {
                    if (!(Math.random() > c.BASE_CHANCE / (double)c.CHROMOSOME_LENGTH)) {
                        IChromosome chromosome = (IChromosome)arg0.getChromosome(i).clone();
                        Gene[] beforeArray = chromosome.getGenes();
                        int j = (int)(Math.random() * (double)beforeArray.length);
                        while (j < beforeArray.length - 1) {
                            beforeArray[j] = beforeArray[j + 1];
                            ++j;
                        }
                        try {
                            chromosome.setGenes(beforeArray);
                        }
                        catch (InvalidConfigurationException e) {
                            e.printStackTrace();
                        }
                        arg1.add(chromosome);
                    }
                    ++i;
                }
            }
        };
    }

    static GeneticOperator getCleansingOperator(final EvolutionChamber c) {
        return new GeneticOperator(){

            public void operate(Population arg0, List arg1) {
                if (Math.random() > c.BASE_CHANCE / (double)c.CHROMOSOME_LENGTH) {
                    return;
                }
                IChromosome best = arg0.determineFittestChromosome();
                int i = 0;
                while (i < best.getGenes().length) {
                    IChromosome chromosome = (IChromosome)best.clone();
                    Gene[] beforeArray = chromosome.getGenes();
                    int j = i;
                    while (j < beforeArray.length - 1) {
                        beforeArray[j].setAllele(beforeArray[j + 1].getAllele());
                        ++j;
                    }
                    try {
                        chromosome.setGenes(beforeArray);
                    }
                    catch (InvalidConfigurationException e) {
                        e.printStackTrace();
                    }
                    arg1.add(chromosome);
                    ++i;
                }
            }
        };
    }

    static GeneticOperator getOverlordingOperator(final EvolutionChamber c) {
        return new GeneticOperator(){

            public void operate(Population arg0, List arg1) {
                if (Math.random() > c.BASE_CHANCE / (double)c.CHROMOSOME_LENGTH) {
                    return;
                }
                IChromosome best = arg0.determineFittestChromosome();
                int overlord = 0;
                for (Integer c2 : EcAction.actions.keySet()) {
                    if (!EcAction.actions.get(c2).getName().contains("BuildOverlord")) continue;
                    overlord = c2;
                }
                int i = 0;
                while (i < best.getGenes().length) {
                    IChromosome chromosome = (IChromosome)best.clone();
                    Gene[] beforeArray = chromosome.getGenes();
                    beforeArray[i].setAllele((Object)overlord);
                    try {
                        chromosome.setGenes(beforeArray);
                    }
                    catch (InvalidConfigurationException e) {
                        e.printStackTrace();
                    }
                    arg1.add(chromosome);
                    ++i;
                }
            }
        };
    }

    static GeneticOperator getInsertionOperator(final EvolutionChamber c) {
        return new GeneticOperator(){

            public void operate(Population arg0, List arg1) {
                int i = 0;
                while (i < arg0.size()) {
                    if (!(Math.random() > c.BASE_CHANCE / (double)c.CHROMOSOME_LENGTH)) {
                        int randomPoint;
                        IChromosome chromosome = (IChromosome)arg0.getChromosome(i).clone();
                        Gene[] beforeArray = chromosome.getGenes();
                        int j = randomPoint = (int)(Math.random() * (double)beforeArray.length);
                        while (j < beforeArray.length - 1) {
                            beforeArray[j + 1] = beforeArray[j];
                            ++j;
                        }
                        beforeArray[randomPoint].setAllele((Object)((int)(Math.random() * (double)((IntegerGene)chromosome.getGene(randomPoint)).getUpperBounds())));
                        try {
                            chromosome.setGenes(beforeArray);
                        }
                        catch (InvalidConfigurationException e) {
                            e.printStackTrace();
                        }
                        arg1.add(chromosome);
                    }
                    ++i;
                }
            }
        };
    }

    private static GeneticOperator getLengthenOperator(final EvolutionChamber c) {
        return new GeneticOperator(){

            public void operate(Population arg0, List arg1) {
                int i = 0;
                while (i < arg0.size()) {
                    if (!(Math.random() > c.BASE_CHANCE / (double)c.CHROMOSOME_LENGTH)) {
                        IChromosome chromosome = arg0.getChromosome(i);
                        Gene[] beforeArray = chromosome.getGenes();
                        Gene[] afterArray = new Gene[beforeArray.length + 1];
                        int j = 0;
                        while (j < beforeArray.length) {
                            afterArray[j] = beforeArray[j];
                            ++j;
                        }
                        afterArray[afterArray.length - 1] = afterArray[0].newGene();
                        try {
                            chromosome.setGenes(afterArray);
                        }
                        catch (InvalidConfigurationException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                IChromosome chromosome = arg0.getConfiguration().getSampleChromosome();
                Gene[] beforeArray = chromosome.getGenes();
                Gene[] afterArray = new Gene[beforeArray.length + 1];
                int j = 0;
                while (j < beforeArray.length) {
                    afterArray[j] = beforeArray[j];
                    ++j;
                }
                afterArray[afterArray.length - 1] = afterArray[0].newGene();
                try {
                    chromosome.setGenes(afterArray);
                }
                catch (InvalidConfigurationException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private static GeneticOperator getShortenOperator(final EvolutionChamber c) {
        return new GeneticOperator(){

            public void operate(Population arg0, List arg1) {
                if (Math.random() > c.BASE_CHANCE / (double)c.CHROMOSOME_LENGTH) {
                    return;
                }
                int i = 0;
                while (i < arg0.size()) {
                    IChromosome chromosome = arg0.getChromosome(i);
                    Gene[] beforeArray = chromosome.getGenes();
                    Gene[] afterArray = new Gene[beforeArray.length - 1];
                    int j = 0;
                    while (j < afterArray.length) {
                        afterArray[j] = beforeArray[j];
                        ++j;
                    }
                    try {
                        chromosome.setGenes(afterArray);
                    }
                    catch (InvalidConfigurationException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                IChromosome chromosome = arg0.getConfiguration().getSampleChromosome();
                Gene[] beforeArray = chromosome.getGenes();
                Gene[] afterArray = new Gene[beforeArray.length - 1];
                int j = 0;
                while (j < afterArray.length) {
                    afterArray[j] = beforeArray[j];
                    ++j;
                }
                try {
                    chromosome.setGenes(afterArray);
                }
                catch (InvalidConfigurationException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    static GeneticOperator getSwapOperator(final EvolutionChamber c) {
        return new GeneticOperator(){

            public void operate(Population arg0, List arg1) {
                int i = 0;
                while (i < arg0.size()) {
                    if (!(Math.random() > c.BASE_CHANCE / (double)c.CHROMOSOME_LENGTH)) {
                        IChromosome chromosome = (IChromosome)arg0.getChromosome(i).clone();
                        Gene[] beforeArray = chromosome.getGenes();
                        int randomPoint = (int)(Math.random() * (double)beforeArray.length);
                        int randomPoint2 = (int)(Math.random() * (double)beforeArray.length);
                        Gene swap = beforeArray[randomPoint];
                        beforeArray[randomPoint] = beforeArray[randomPoint2];
                        beforeArray[randomPoint2] = swap;
                        try {
                            chromosome.setGenes(beforeArray);
                        }
                        catch (InvalidConfigurationException e) {
                            e.printStackTrace();
                        }
                        arg1.add(chromosome);
                    }
                    ++i;
                }
            }
        };
    }

    static GeneticOperator getTwiddleOperator(final EvolutionChamber c) {
        return new GeneticOperator(){

            public void operate(Population arg0, List arg1) {
                int i = 0;
                while (i < arg0.size()) {
                    if (!(Math.random() > c.BASE_CHANCE / (double)c.CHROMOSOME_LENGTH)) {
                        IChromosome chromosome = (IChromosome)arg0.getChromosome(i).clone();
                        Gene[] beforeArray = chromosome.getGenes();
                        int randomPoint = (int)(Math.random() * (double)beforeArray.length);
                        if (randomPoint < beforeArray.length - 1) {
                            Gene swap = beforeArray[randomPoint];
                            beforeArray[randomPoint] = beforeArray[randomPoint + 1];
                            beforeArray[randomPoint + 1] = swap;
                        }
                        try {
                            chromosome.setGenes(beforeArray);
                        }
                        catch (InvalidConfigurationException e) {
                            e.printStackTrace();
                        }
                        arg1.add(chromosome);
                    }
                    ++i;
                }
            }
        };
    }
}

