/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.EcActionWait;
import java.io.PrintStream;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.IChromosome;
import org.jgap.impl.IntegerGene;

public class EcEvolver
extends FitnessFunction {
    EcState source;
    private EcState destination;
    public boolean debug = false;
    public static long evaluations = 0L;
    public static long cachehits = 0L;
    public PrintStream log = System.out;

    public EcEvolver(EcState source, EcState destination) {
        this.source = source;
        this.destination = destination;
    }

    protected String getAlleleAsString(IChromosome c) {
        StringBuilder sb = new StringBuilder();
        Gene[] geneArray = c.getGenes();
        int n = geneArray.length;
        int n2 = 0;
        while (n2 < n) {
            Gene g = geneArray[n2];
            if ((Integer)g.getAllele() >= 10) {
                sb.append((char)(97 + (Integer)g.getAllele() - 10));
            } else {
                sb.append(g.getAllele().toString());
            }
            ++n2;
        }
        return sb.toString();
    }

    protected double evaluate(IChromosome arg0) {
        try {
            String chrome = this.getAlleleAsString(arg0);
            ++evaluations;
            EcBuildOrder s = EcEvolver.populateBuildOrder((EcBuildOrder)this.source, arg0);
            Double score = this.destination.score(this.doEvaluate(s));
            return score;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return Double.NEGATIVE_INFINITY;
        }
    }

    public EcState evaluateGetBuildOrder(IChromosome arg0) {
        try {
            EcBuildOrder s = EcEvolver.populateBuildOrder((EcBuildOrder)this.source, arg0);
            return this.doEvaluate(s);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EcBuildOrder populateBuildOrder(EcBuildOrder source, IChromosome arg0) throws CloneNotSupportedException {
        EcBuildOrder s = source.clone();
        Gene[] geneArray = arg0.getGenes();
        int n = geneArray.length;
        int n2 = 0;
        while (n2 < n) {
            Gene g1 = geneArray[n2];
            IntegerGene g = (IntegerGene)g1;
            Integer i = (Integer)g.getAllele();
            try {
                s.addAction((EcAction)EcAction.actions.get(i).newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    public EcState doEvaluate(EcBuildOrder s) {
        i = 0;
        for (EcAction a : s.getActions()) {
            ++i;
            if (!a.isInvalid(s)) ** GOTO lbl29
            s.invalidActions = s.invalidActions + 1;
            continue;
lbl-1000:
            // 1 sources

            {
                if (s.seconds >= s.targetSeconds || this.destination.waypointMissed(s)) {
                    if (this.debug) {
                        this.log.println("Failed to meet waypoint. " + a);
                        this.log.println(s.toLongString());
                    }
                    return s;
                }
                if (this.debug) {
                    waypointIndex = 0;
                    for (EcState se : this.destination.waypoints) {
                        if (se.targetSeconds == s.seconds && se.getSumStuff() > 0) {
                            this.log.println("---Waypoint " + waypointIndex + "---");
                            this.log.println(s.toLongString());
                            this.log.println("----------------");
                        }
                        ++waypointIndex;
                    }
                }
                if (!this.destination.isSatisfied(s)) continue;
                if (this.debug) {
                    this.log.println("Satisfied.");
                    this.log.println("Number of actions in build order: " + (i - s.invalidActions));
                    this.log.println("---Final Output---");
                    this.log.println(s.toLongString());
                    this.log.println("------------------");
                }
                return s;
lbl29:
                // 2 sources

                ** while (!a.canExecute((EcBuildOrder)s))
            }
lbl30:
            // 1 sources

            if (this.debug && !(a instanceof EcActionWait)) {
                this.log.println(String.valueOf(s.toString()) + "\t" + a);
            }
            a.execute(s, this);
        }
        if (this.debug) {
            this.log.println("Ran out of things to do.");
            this.log.println(s.toLongString());
        }
        return s;
    }

    public void obtained(EcBuildOrder s, String string) {
        this.log.println("@" + s.timestamp() + "\tSpawned:\t" + string.trim());
    }

    public void evolved(EcBuildOrder s, String string) {
        this.log.println("@" + s.timestamp() + "\tEvolved:\t" + string.trim());
    }
}

