/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo;

import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.map.MultiValueMap;

public class EcBuildOrder
extends EcState
implements Serializable {
    static final long serialVersionUID = 1L;
    public int larva = 3;
    public int dronesOnMinerals = 6;
    public int dronesOnGas = 0;
    boolean buildingLarva = false;
    public int evolvingSpires = 0;
    public int queensBuilding = 0;
    public int spiresInUse = 0;
    public int evolutionChambersInUse;
    transient MultiValueMap futureAction = new MultiValueMap();
    ArrayList<EcAction> actions = new ArrayList();
    int[] patches = new int[24];
    public int extractorsBuilding = 0;
    public int hatcheriesBuilding = 0;
    public int spawningPoolsInUse = 0;
    public int roachWarrensInUse = 0;
    public int infestationPitInUse = 0;
    public int hatcheriesSpawningLarva = 0;

    @Override
    public EcBuildOrder clone() throws CloneNotSupportedException {
        EcBuildOrder s = new EcBuildOrder();
        s.larva = this.larva;
        s.dronesOnMinerals = this.dronesOnMinerals;
        s.dronesOnGas = this.dronesOnGas;
        s.buildingLarva = this.buildingLarva;
        s.queensBuilding = this.queensBuilding;
        s.evolutionChambersInUse = this.evolutionChambersInUse;
        this.assign(s);
        return s;
    }

    public String toString() {
        return "@" + this.timestamp() + "\tM:" + (int)this.minerals + "\tG:" + (int)this.gas + "\tL:" + this.larva + "\tS:" + (int)this.supplyUsed + "/" + this.supply();
    }

    public String toLongString() {
        StringBuilder sb = new StringBuilder();
        sb.append("At time: " + this.timestamp());
        sb.append("\nMinerals: " + (int)this.minerals + "\tGas:      " + (int)this.gas + "\tSupply:   " + (int)this.supplyUsed + "/" + this.supply());
        this.append(sb, "Drones", this.drones);
        this.append(sb, "Overlords", this.overlords);
        this.append(sb, "Overseers", this.overseers);
        this.append(sb, "Queens", this.queens);
        this.append(sb, "Zerglings", this.zerglings);
        this.append(sb, "Banelings", this.banelings);
        this.append(sb, "Roaches", this.roaches);
        this.append(sb, "Hydralisks", this.hydralisks);
        this.append(sb, "Infestors", this.infestors);
        this.append(sb, "Mutalisks", this.mutalisks);
        this.append(sb, "Corruptors", this.corruptors);
        this.append(sb, "Ultralisks", this.ultralisks);
        this.append(sb, "Brood Lords", this.broodlords);
        this.append(sb, "Hatcheries", this.hatcheries);
        this.append(sb, "Lairs", this.lairs);
        this.append(sb, "Hives", this.hives);
        this.append(sb, "Gas Extractors", this.gasExtractors);
        this.append(sb, "Spawning Pools", this.spawningPools);
        this.append(sb, "Baneling Nest", this.banelingNest);
        this.append(sb, "Roach Warrens", this.roachWarrens);
        this.append(sb, "Hydralisk Den", this.hydraliskDen);
        this.append(sb, "Infestation Pit", this.infestationPit);
        this.append(sb, "Spire", this.spire);
        this.append(sb, "Ultralisk Cavern", this.ultraliskCavern);
        this.append(sb, "Greater Spire", this.greaterSpire);
        this.append(sb, "Evolution Chambers", this.evolutionChambers);
        this.append(sb, "Spine Crawlers", this.spineCrawlers);
        this.append(sb, "Spore Crawlers", this.sporeCrawlers);
        this.append(sb, "Nydus Networks", this.nydusNetwork);
        this.append(sb, "Nydus Worms", this.nydusWorm);
        this.append(sb, "Melee +1", this.melee1);
        this.append(sb, "Melee +2", this.melee2);
        this.append(sb, "Melee +3", this.melee3);
        this.append(sb, "Missile +1", this.missile1);
        this.append(sb, "Missile +2", this.missile2);
        this.append(sb, "Missile +3", this.missile3);
        this.append(sb, "Armor +1", this.armor1);
        this.append(sb, "Armor +2", this.armor2);
        this.append(sb, "Armor +3", this.armor3);
        this.append(sb, "Flyer Attack +1", this.flyerAttack1);
        this.append(sb, "Flyer Attack +2", this.flyerAttack2);
        this.append(sb, "Flyer Attack +3", this.flyerAttack3);
        this.append(sb, "Flyer Armor +1", this.flyerArmor1);
        this.append(sb, "Flyer Armor +2", this.flyerArmor2);
        this.append(sb, "Flyer Armor +3", this.flyerArmor3);
        this.append(sb, "Metabolic Boost", this.metabolicBoost);
        this.append(sb, "Adrenal Glands", this.adrenalGlands);
        this.append(sb, "Glial Reconstitution", this.glialReconstitution);
        this.append(sb, "Tunneling Claws", this.tunnelingClaws);
        this.append(sb, "Burrow", this.burrow);
        this.append(sb, "Pneumatized Carapace", this.pneumatizedCarapace);
        this.append(sb, "Ventral Sacs", this.ventralSacs);
        this.append(sb, "Centrifugal Hooks", this.centrifugalHooks);
        this.append(sb, "Grooved Spines", this.groovedSpines);
        this.append(sb, "Neural Parasite", this.neuralParasite);
        this.append(sb, "Pathogen Glands", this.pathogenGlands);
        this.append(sb, "Chitinous Plating", this.chitinousPlating);
        return sb.toString();
    }

    private void append(StringBuilder sb, String name, boolean doit) {
        if (doit) {
            sb.append("\n" + name);
        }
    }

    private void append(StringBuilder sb, String name, int count) {
        if (count > 0) {
            sb.append("\n" + name + ": " + count);
        }
    }

    public List<EcAction> getActions() {
        return this.actions;
    }

    public void addAction(EcAction ecActionBuildDrone) {
        this.actions.add(ecActionBuildDrone);
    }

    public void addFutureAction(double time, Runnable runnable) {
        time = (double)this.seconds + time;
        this.futureAction.put((Object)time, (Object)runnable);
        this.actionLength += 1.0;
    }

    public Collection<Runnable> getFutureActions(double time) {
        Object result = this.futureAction.get((Object)time);
        if (result == null) {
            return null;
        }
        return (Collection)result;
    }

    public boolean nothingGoingToHappen(double time) {
        Iterator iterator = this.futureAction.keySet().iterator();
        while (iterator.hasNext()) {
            double t = (Double)iterator.next();
            if (!(t > time)) continue;
            return false;
        }
        return true;
    }

    public void consumeLarva(final EcEvolver e) {
        final EcBuildOrder t = this;
        --this.larva;
        if (!this.buildingLarva) {
            this.buildingLarva = true;
            this.addFutureAction(15.0, new Runnable(){

                @Override
                public void run() {
                    if (e.debug) {
                        e.obtained(t, " Larva+1");
                    }
                    EcBuildOrder.this.larva = Math.max(Math.min(EcBuildOrder.this.larva + EcBuildOrder.this.bases(), EcBuildOrder.this.bases() * 3), EcBuildOrder.this.larva);
                    if (EcBuildOrder.this.larva < 3 * EcBuildOrder.this.bases()) {
                        EcBuildOrder.this.addFutureAction(15.0, this);
                    } else {
                        EcBuildOrder.this.buildingLarva = false;
                    }
                }
            });
        }
    }

    public boolean hasSupply(double i) {
        return this.supplyUsed + i <= (double)this.supply();
    }

    public int mineralPatches() {
        if (this.patches.length < this.bases() * 8) {
            this.patches = new int[this.bases() * 8];
        }
        return this.bases() * 8;
    }

    public double mineMinerals() {
        int drones = this.dronesOnMinerals;
        int mineralPatches = this.mineralPatches();
        int i = 0;
        while (i < mineralPatches) {
            this.patches[i] = 0;
            ++i;
        }
        i = 0;
        while (i < mineralPatches) {
            if (drones > 0) {
                int n = i;
                this.patches[n] = this.patches[n] + 1;
                --drones;
            }
            ++i;
        }
        if (drones > 0) {
            i = 0;
            while (i < mineralPatches) {
                if (drones > 0) {
                    int n = i;
                    this.patches[n] = this.patches[n] + 1;
                    --drones;
                }
                ++i;
            }
        }
        if (drones > 0) {
            i = 0;
            while (i < mineralPatches) {
                if (drones > 0) {
                    int n = i;
                    this.patches[n] = this.patches[n] + 1;
                    --drones;
                }
                ++i;
            }
        }
        double mineralsMined = 0.0;
        int i2 = 0;
        while (i2 < mineralPatches) {
            if (i2 < mineralPatches / 2) {
                if (this.patches[i2] != 0) {
                    mineralsMined = this.patches[i2] == 1 ? (mineralsMined += 0.75) : (this.patches[i2] == 2 ? (mineralsMined += 1.5) : (mineralsMined += 1.7));
                }
            } else if (this.patches[i2] != 0) {
                mineralsMined = this.patches[i2] == 1 ? (mineralsMined += 0.65) : (this.patches[i2] == 2 ? (mineralsMined += 1.3) : (mineralsMined += 1.7));
            }
            ++i2;
        }
        return mineralsMined;
    }

    public double mineGas() {
        if (this.gasExtractors == 0) {
            return 0.0;
        }
        int drones = this.dronesOnGas;
        int[] extractors = new int[Math.min(this.gasExtractors, this.bases() * 2)];
        int i = 0;
        while (i < extractors.length) {
            extractors[i] = 0;
            ++i;
        }
        i = 0;
        while (i < extractors.length) {
            if (drones > 0) {
                int n = i;
                extractors[n] = extractors[n] + 1;
                --drones;
            }
            ++i;
        }
        i = 0;
        while (i < extractors.length) {
            if (drones > 0) {
                int n = i;
                extractors[n] = extractors[n] + 1;
                --drones;
            }
            ++i;
        }
        i = 0;
        while (i < extractors.length) {
            if (drones > 0) {
                int n = i;
                extractors[n] = extractors[n] + 1;
                --drones;
            }
            ++i;
        }
        double gasMined = 0.0;
        int i2 = 0;
        while (i2 < extractors.length) {
            if (extractors[i2] != 0) {
                gasMined = extractors[i2] == 1 ? (gasMined += 0.7) : (extractors[i2] == 2 ? (gasMined += 1.4) : (gasMined += 1.9));
            }
            ++i2;
        }
        return gasMined;
    }

    public void accumulateMaterials() {
        this.minerals += this.mineMinerals();
        this.gas += this.mineGas();
    }

    public String timestamp() {
        return String.valueOf(this.seconds / 60) + ":" + (this.seconds % 60 < 10 ? "0" : "") + this.seconds % 60;
    }

    public int extractors() {
        return (this.bases() + this.hatcheriesBuilding) * 2;
    }

    public void consumeHatch(int seconds) {
        boolean usehatch = false;
        boolean uselair = false;
        if (this.hatcheries > 0) {
            --this.hatcheries;
            ++this.evolvingHatcheries;
            usehatch = true;
        } else if (this.lairs > 0) {
            --this.lairs;
            ++this.evolvingLairs;
            uselair = true;
        } else {
            --this.hives;
            ++this.evolvingHives;
        }
        final boolean useHatch = usehatch;
        final boolean useLair = uselair;
        this.addFutureAction(seconds, new Runnable(){

            @Override
            public void run() {
                if (useHatch) {
                    --EcBuildOrder.this.evolvingHatcheries;
                    ++EcBuildOrder.this.hatcheries;
                } else if (useLair) {
                    --EcBuildOrder.this.evolvingLairs;
                    ++EcBuildOrder.this.lairs;
                } else {
                    --EcBuildOrder.this.evolvingHives;
                    ++EcBuildOrder.this.hives;
                }
            }
        });
    }
}

