/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.util;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EcCacheMap<E, T>
implements Map<E, T> {
    private static final long serialVersionUID = 1L;
    HashMap<E, SoftReference<T>> map = new HashMap();
    long lastCleaned = System.currentTimeMillis();

    @Override
    public void clear() {
        this.map.clear();
    }

    private void cull() {
        long current = System.currentTimeMillis();
        if (current == this.lastCleaned) {
            return;
        }
        if (current < this.lastCleaned + 60000L) {
            return;
        }
        System.out.println("Cleaning... Before: " + this.map.size());
        for (E e : new ArrayList<E>(this.keySet())) {
            if (this.getInner(e) != null) continue;
            this.remove(e);
        }
        System.out.println("Cleaning... After: " + this.map.size());
        this.lastCleaned = current;
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.map.get(arg0) != null;
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.map.containsValue(new WeakReference<Object>(arg0));
    }

    @Override
    public Set<Map.Entry<E, T>> entrySet() {
        HashMap<E, T> set = new HashMap<E, T>();
        for (Map.Entry<E, SoftReference<T>> r : this.map.entrySet()) {
            T value = r.getValue().get();
            if (value == null) continue;
            set.put(r.getKey(), value);
        }
        return set.entrySet();
    }

    @Override
    public T get(Object arg0) {
        this.cull();
        return this.getInner(arg0);
    }

    private T getInner(Object arg0) {
        SoftReference<T> weakReference = this.map.get(arg0);
        if (weakReference != null) {
            return weakReference.get();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (SoftReference<T> t : this.map.values()) {
            if (t.get() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<E> keySet() {
        return this.map.keySet();
    }

    @Override
    public T put(E arg0, T arg1) {
        this.cull();
        this.map.put(arg0, new SoftReference<T>(arg1));
        return arg1;
    }

    @Override
    public void putAll(Map<? extends E, ? extends T> arg0) {
        for (E e : arg0.keySet()) {
            this.put(e, arg0.get(e));
        }
    }

    @Override
    public T remove(Object arg0) {
        return this.map.remove(arg0).get();
    }

    @Override
    public int size() {
        int i = 0;
        for (SoftReference<T> t : this.map.values()) {
            if (t.get() == null) continue;
            ++i;
        }
        return i;
    }

    @Override
    public Collection<T> values() {
        ArrayList<T> results = new ArrayList<T>();
        for (SoftReference<T> t : this.map.values()) {
            T t2 = t.get();
            if (t2 == null) continue;
            results.add(t2);
        }
        return results;
    }
}

