/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.upgrade;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildHive;
import com.fray.evo.action.build.EcActionBuildSpawningPool;
import com.fray.evo.action.upgrade.EcActionUpgrade;
import java.util.ArrayList;
import java.util.List;

public class EcActionUpgradeAdrenalGlands
extends EcActionUpgrade {
    @Override
    public void init() {
        this.init(200, 200, 130, "Adrenal Glands");
    }

    @Override
    public void execute(EcBuildOrder s, EcEvolver e) {
        super.execute(s, e);
        ++s.spawningPoolsInUse;
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        if (s.spawningPools - s.spawningPoolsInUse == 0) {
            return true;
        }
        return s.hives == 0 && s.evolvingHives == 0;
    }

    @Override
    public void afterTime(EcBuildOrder s, EcEvolver e) {
        s.adrenalGlands = true;
        --s.spawningPoolsInUse;
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildSpawningPool());
        l.add(new EcActionBuildHive());
        return l;
    }
}

