/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.upgrade;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.action.EcAction;
import java.io.Serializable;

public abstract class EcActionUpgrade
extends EcAction
implements Serializable {
    public int minerals = 0;
    public int gas = 0;
    public int time = 0;
    public String name = "EROAR";

    public EcActionUpgrade() {
        this.init();
    }

    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= (double)this.minerals;
        s.gas -= (double)this.gas;
        s.addFutureAction(this.time, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.evolved(s, EcActionUpgrade.this.name);
                }
                EcActionUpgrade.this.afterTime(s, e);
            }
        });
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < (double)this.minerals) {
            return false;
        }
        return !(s.gas < (double)this.gas);
    }

    public abstract void init();

    protected void init(int minerals, int gas, int time, String name) {
        this.minerals = minerals;
        this.gas = gas;
        this.time = time;
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public abstract void afterTime(EcBuildOrder var1, EcEvolver var2);
}

