/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildHive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildUltraliskCavern
extends EcAction
implements Serializable {
    private static final int time = 65;
    private static final int minerals = 150;
    private static final int gas = 200;

    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 150.0;
        s.gas -= 200.0;
        --s.drones;
        --s.dronesOnMinerals;
        s.supplyUsed -= 1.0;
        s.addFutureAction(65.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Ultralisk Cavern+1");
                }
                ++s.ultraliskCavern;
            }
        });
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 150.0) {
            return false;
        }
        if (s.gas < 200.0) {
            return false;
        }
        return s.drones >= 1;
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        if (s.hives == 0 && s.evolvingHives == 0) {
            return true;
        }
        if (s.ultraliskCavern == 1) {
            return true;
        }
        return super.isInvalid(s);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildHive());
        destination.hives = Math.max(destination.hives, 1);
        return l;
    }
}

