/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildExtractor;
import com.fray.evo.action.build.EcActionBuildRoachWarren;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildRoach
extends EcAction
implements Serializable {
    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 75.0;
        s.gas -= 25.0;
        s.consumeLarva(e);
        s.supplyUsed += 2.0;
        s.addFutureAction(27.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Roach+1");
                }
                ++s.roaches;
            }
        });
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        return s.roachWarrens == 0;
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 75.0) {
            return false;
        }
        if (s.gas < 25.0) {
            return false;
        }
        if (s.larva < 1) {
            return false;
        }
        return s.hasSupply(2.0);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildRoachWarren());
        l.add(new EcActionBuildExtractor());
        destination.roachWarrens = Math.max(destination.roachWarrens, 1);
        return l;
    }
}

