/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo.action.build;

import com.fray.evo.EcBuildOrder;
import com.fray.evo.EcEvolver;
import com.fray.evo.EcState;
import com.fray.evo.action.EcAction;
import com.fray.evo.action.build.EcActionBuildExtractor;
import com.fray.evo.action.build.EcActionBuildSpawningPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EcActionBuildLair
extends EcAction
implements Serializable {
    @Override
    public void execute(final EcBuildOrder s, final EcEvolver e) {
        s.minerals -= 150.0;
        s.gas -= 100.0;
        --s.hatcheries;
        ++s.evolvingHatcheries;
        s.addFutureAction(80.0, new Runnable(){

            @Override
            public void run() {
                if (e.debug) {
                    e.obtained(s, " Lairs+1");
                }
                ++s.lairs;
                --s.evolvingHatcheries;
            }
        });
    }

    @Override
    public boolean isPossible(EcBuildOrder s) {
        if (s.minerals < 150.0) {
            return false;
        }
        if (s.gas < 100.0) {
            return false;
        }
        return s.hatcheries > s.queensBuilding;
    }

    @Override
    public boolean isInvalid(EcBuildOrder s) {
        if (s.hatcheries == 0) {
            return true;
        }
        if (s.spawningPools == 0) {
            return true;
        }
        return super.isInvalid(s);
    }

    @Override
    public List<EcAction> requirements(EcState destination) {
        ArrayList<EcAction> l = new ArrayList<EcAction>();
        l.add(new EcActionBuildSpawningPool());
        l.add(new EcActionBuildExtractor());
        destination.gasExtractors = Math.max(destination.gasExtractors, 1);
        return l;
    }
}

