/*
 * Decompiled with CFR 0.152.
 */
package com.fray.evo;

import com.fray.evo.EcBuildOrder;
import java.util.ArrayList;
import java.util.List;

public class EcState {
    public double minerals = 50.0;
    public double gas = 0.0;
    public double supplyUsed = 6.0;
    public int evolvingHatcheries = 0;
    public int evolvingLairs = 0;
    public int evolvingHives = 0;
    public int hatcheries = 1;
    public int lairs = 0;
    public int hives = 0;
    public int spawningPools = 0;
    public int evolutionChambers = 0;
    public int roachWarrens = 0;
    public int hydraliskDen = 0;
    public int banelingNest = 0;
    public int infestationPit = 0;
    public int greaterSpire = 0;
    public int ultraliskCavern = 0;
    public int gasExtractors = 0;
    public int spire = 0;
    public int spineCrawlers = 0;
    public int sporeCrawlers = 0;
    public int nydusNetwork = 0;
    public int nydusWorm = 0;
    public int drones = 6;
    public int overlords = 1;
    public int overseers = 0;
    public int zerglings = 0;
    public int banelings = 0;
    public int roaches = 0;
    public int mutalisks = 0;
    public int infestors = 0;
    public int queens = 0;
    public int hydralisks = 0;
    public int corruptors = 0;
    public int ultralisks = 0;
    public int broodlords = 0;
    public boolean metabolicBoost = false;
    public boolean adrenalGlands = false;
    public boolean glialReconstitution = false;
    public boolean tunnelingClaws = false;
    public boolean burrow = false;
    public boolean pneumatizedCarapace = false;
    public boolean ventralSacs = false;
    public boolean centrifugalHooks = false;
    public boolean melee1 = false;
    public boolean melee2 = false;
    public boolean melee3 = false;
    public boolean missile1 = false;
    public boolean missile2 = false;
    public boolean missile3 = false;
    public boolean armor1 = false;
    public boolean armor2 = false;
    public boolean armor3 = false;
    public boolean groovedSpines = false;
    public boolean neuralParasite = false;
    public boolean pathogenGlands = false;
    public boolean flyerAttack1 = false;
    public boolean flyerAttack2 = false;
    public boolean flyerAttack3 = false;
    public boolean flyerArmor1 = false;
    public boolean flyerArmor2 = false;
    public boolean flyerArmor3 = false;
    public boolean chitinousPlating = false;
    public int seconds = 0;
    public int targetSeconds = 0;
    public int invalidActions = 0;
    public double actionLength = 0.0;
    public int waits;
    public transient List<EcState> waypoints = new ArrayList<EcState>();

    public Object clone() throws CloneNotSupportedException {
        EcState s = new EcState();
        this.assign(s);
        return s;
    }

    protected void assign(EcState s) {
        for (EcState st : this.waypoints) {
            try {
                s.waypoints.add((EcState)st.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        s.minerals = this.minerals;
        s.gas = this.gas;
        s.supplyUsed = this.supplyUsed;
        s.hatcheries = this.hatcheries;
        s.lairs = this.lairs;
        s.hives = this.hives;
        s.spawningPools = this.spawningPools;
        s.banelingNest = this.banelingNest;
        s.evolutionChambers = this.evolutionChambers;
        s.roachWarrens = this.roachWarrens;
        s.hydraliskDen = this.hydraliskDen;
        s.infestationPit = this.infestationPit;
        s.greaterSpire = this.greaterSpire;
        s.ultraliskCavern = this.ultraliskCavern;
        s.gasExtractors = this.gasExtractors;
        s.spire = this.spire;
        s.greaterSpire = this.greaterSpire;
        s.spineCrawlers = this.spineCrawlers;
        s.sporeCrawlers = this.sporeCrawlers;
        s.nydusNetwork = this.nydusNetwork;
        s.nydusWorm = this.nydusWorm;
        s.zerglings = this.zerglings;
        s.banelings = this.banelings;
        s.roaches = this.roaches;
        s.mutalisks = this.mutalisks;
        s.drones = this.drones;
        s.queens = this.queens;
        s.hydralisks = this.hydralisks;
        s.infestors = this.infestors;
        s.corruptors = this.corruptors;
        s.ultralisks = this.ultralisks;
        s.broodlords = this.broodlords;
        s.overlords = this.overlords;
        s.overseers = this.overseers;
        s.metabolicBoost = this.metabolicBoost;
        s.adrenalGlands = this.adrenalGlands;
        s.glialReconstitution = this.glialReconstitution;
        s.tunnelingClaws = this.tunnelingClaws;
        s.burrow = this.burrow;
        s.pneumatizedCarapace = this.pneumatizedCarapace;
        s.ventralSacs = this.ventralSacs;
        s.centrifugalHooks = this.centrifugalHooks;
        s.melee1 = this.melee1;
        s.melee2 = this.melee2;
        s.melee3 = this.melee3;
        s.missile1 = this.missile1;
        s.missile2 = this.missile2;
        s.missile3 = this.missile3;
        s.armor1 = this.armor1;
        s.armor2 = this.armor2;
        s.armor3 = this.armor3;
        s.groovedSpines = this.groovedSpines;
        s.neuralParasite = this.neuralParasite;
        s.pathogenGlands = this.pathogenGlands;
        s.flyerAttack1 = this.flyerAttack1;
        s.flyerAttack2 = this.flyerAttack2;
        s.flyerAttack3 = this.flyerAttack3;
        s.flyerArmor1 = this.flyerArmor1;
        s.flyerArmor2 = this.flyerArmor2;
        s.flyerArmor3 = this.flyerArmor3;
        s.chitinousPlating = this.chitinousPlating;
        s.seconds = this.seconds;
        s.targetSeconds = this.targetSeconds;
        s.invalidActions = this.invalidActions;
        s.actionLength = this.actionLength;
    }

    public int supply() {
        return (this.overlords + this.overseers) * 8 + 2 * this.bases();
    }

    public static EcState defaultDestination() {
        EcState d = new EcState();
        d.drones = 0;
        d.overlords = 0;
        d.hatcheries = 0;
        d.targetSeconds = 7200;
        return d;
    }

    public double score(EcState candidate) {
        EcState c = candidate;
        double score = 0.0;
        boolean keepgoing = true;
        EcState state = EcState.defaultDestination();
        for (EcState s : this.waypoints) {
            if (keepgoing) {
                state.union(s);
            }
            if (s.isSatisfied(c)) continue;
            keepgoing = false;
        }
        if (keepgoing) {
            state.union(this);
            score = state.augmentScore(c, score, false);
        } else {
            score = state.augmentScore(c, score, false);
        }
        if (state.isSatisfied(c)) {
            score *= (double)c.targetSeconds / (double)c.seconds * ((double)c.targetSeconds / (double)c.seconds);
            score = this.augmentScore(score, (int)c.minerals, (int)this.minerals, 0.011, 0.011, false);
            score = this.augmentScore(score, (int)c.gas, (int)this.gas, 0.015, 0.015, false);
        } else {
            score = this.augmentScore(score, (int)c.minerals, (int)this.minerals, 0.001, 0.001, false);
            score = this.augmentScore(score, (int)c.gas, (int)this.gas, 0.0015, 0.0015, false);
        }
        score = Math.max(score, 0.0);
        return score;
    }

    private void union(EcState s) {
        this.hatcheries = Math.max(s.hatcheries, this.hatcheries);
        this.lairs = Math.max(s.lairs, this.lairs);
        this.hives = Math.max(s.hives, this.hives);
        this.spawningPools = Math.max(s.spawningPools, this.spawningPools);
        this.banelingNest = Math.max(s.banelingNest, this.banelingNest);
        this.evolutionChambers = Math.max(s.evolutionChambers, this.evolutionChambers);
        this.roachWarrens = Math.max(s.roachWarrens, this.roachWarrens);
        this.hydraliskDen = Math.max(s.hydraliskDen, this.hydraliskDen);
        this.infestationPit = Math.max(s.infestationPit, this.infestationPit);
        this.greaterSpire = Math.max(s.greaterSpire, this.greaterSpire);
        this.ultraliskCavern = Math.max(s.ultraliskCavern, this.ultraliskCavern);
        this.gasExtractors = Math.max(s.gasExtractors, this.gasExtractors);
        this.spire = Math.max(s.spire, this.spire);
        this.greaterSpire = Math.max(s.greaterSpire, this.greaterSpire);
        this.spineCrawlers = Math.max(s.spineCrawlers, this.spineCrawlers);
        this.sporeCrawlers = Math.max(s.sporeCrawlers, this.sporeCrawlers);
        this.nydusNetwork = Math.max(s.nydusNetwork, this.nydusNetwork);
        this.nydusWorm = Math.max(s.nydusWorm, this.nydusWorm);
        this.zerglings = Math.max(s.zerglings, this.zerglings);
        this.banelings = Math.max(s.banelings, this.banelings);
        this.roaches = Math.max(s.roaches, this.roaches);
        this.mutalisks = Math.max(s.mutalisks, this.mutalisks);
        this.drones = Math.max(s.drones, this.drones);
        this.queens = Math.max(s.queens, this.queens);
        this.hydralisks = Math.max(s.hydralisks, this.hydralisks);
        this.infestors = Math.max(s.infestors, this.infestors);
        this.corruptors = Math.max(s.corruptors, this.corruptors);
        this.ultralisks = Math.max(s.ultralisks, this.ultralisks);
        this.broodlords = Math.max(s.broodlords, this.broodlords);
        this.overlords = Math.max(s.overlords, this.overlords);
        this.overseers = Math.max(s.overseers, this.overseers);
        this.metabolicBoost = s.metabolicBoost | this.metabolicBoost;
        this.adrenalGlands = s.adrenalGlands | this.adrenalGlands;
        this.glialReconstitution = s.glialReconstitution | this.glialReconstitution;
        this.tunnelingClaws = s.tunnelingClaws | this.tunnelingClaws;
        this.burrow = s.burrow | this.burrow;
        this.pneumatizedCarapace = s.pneumatizedCarapace | this.pneumatizedCarapace;
        this.ventralSacs = s.ventralSacs | this.ventralSacs;
        this.centrifugalHooks = s.centrifugalHooks | this.centrifugalHooks;
        this.melee1 = s.melee1 | this.melee1;
        this.melee2 = s.melee2 | this.melee2;
        this.melee3 = s.melee3 | this.melee3;
        this.missile1 = s.missile1 | this.missile1;
        this.missile2 = s.missile2 | this.missile2;
        this.missile3 = s.missile3 | this.missile3;
        this.armor1 = s.armor1 | this.armor1;
        this.armor2 = s.armor2 | this.armor2;
        this.armor3 = s.armor3 | this.armor3;
        this.groovedSpines = s.groovedSpines | this.groovedSpines;
        this.neuralParasite = s.neuralParasite | this.neuralParasite;
        this.pathogenGlands = s.pathogenGlands | this.pathogenGlands;
        this.flyerAttack1 = s.flyerAttack1 | this.flyerAttack1;
        this.flyerAttack2 = s.flyerAttack2 | this.flyerAttack2;
        this.flyerAttack3 = s.flyerAttack3 | this.flyerAttack3;
        this.flyerArmor1 = s.flyerArmor1 | this.flyerArmor1;
        this.flyerArmor2 = s.flyerArmor2 | this.flyerArmor2;
        this.flyerArmor3 = s.flyerArmor3 | this.flyerArmor3;
        this.chitinousPlating = s.chitinousPlating | this.chitinousPlating;
    }

    private double augmentScore(EcState c, double score, boolean waypoint) {
        score = this.augmentScore(score, c.drones, this.drones, 50.0, 0.5, waypoint);
        score = this.augmentScore(score, c.zerglings, this.zerglings, 25.0, 0.25, waypoint);
        score = this.augmentScore(score, c.banelings, this.banelings, 75.0, 0.75, waypoint);
        score = this.augmentScore(score, c.roaches, this.roaches, 100.0, 1.0, waypoint);
        score = this.augmentScore(score, c.mutalisks, this.mutalisks, 200.0, 2.0, waypoint);
        score = this.augmentScore(score, c.queens, this.queens, 150.0, 1.5, waypoint);
        score = this.augmentScore(score, c.hydralisks, this.hydralisks, 150.0, 1.5, waypoint);
        score = this.augmentScore(score, c.infestors, this.infestors, 250.0, 2.5, waypoint);
        score = this.augmentScore(score, c.corruptors, this.corruptors, 250.0, 2.5, waypoint);
        score = this.augmentScore(score, c.ultralisks, this.ultralisks, 500.0, 5.0, waypoint);
        score = this.augmentScore(score, c.broodlords, this.broodlords, 400.0, 4.0, waypoint);
        score = this.augmentScore(score, c.overlords, this.overlords, 100.0, 1.0, waypoint);
        score = this.augmentScore(score, c.overseers, this.overseers, 250.0, 2.5, waypoint);
        score = this.augmentScore(score, c.hatcheries, this.hatcheries, 300.0, 3.0, waypoint);
        score = this.augmentDropoffScore(score, c.lairs, this.lairs, 550.0, 5.5, waypoint);
        score = this.augmentDropoffScore(score, c.hives, this.hives, 900.0, 9.0, waypoint);
        score = this.augmentDropoffScore(score, c.spawningPools, this.spawningPools, 200.0, 2.0, waypoint);
        score = this.augmentDropoffScore(score, c.roachWarrens, this.roachWarrens, 150.0, 1.5, waypoint);
        score = this.augmentDropoffScore(score, c.hydraliskDen, this.hydraliskDen, 200.0, 2.0, waypoint);
        score = this.augmentDropoffScore(score, c.banelingNest, this.banelingNest, 150.0, 1.5, waypoint);
        score = this.augmentDropoffScore(score, c.greaterSpire, this.greaterSpire, 650.0, 6.5, waypoint);
        score = this.augmentDropoffScore(score, c.ultraliskCavern, this.ultraliskCavern, 350.0, 3.5, waypoint);
        score = this.augmentDropoffScore(score, c.spire, this.spire, 400.0, 4.0, waypoint);
        score = this.augmentDropoffScore(score, c.infestationPit, this.infestationPit, 200.0, 2.0, waypoint);
        score = this.augmentDropoffScore(score, c.evolutionChambers, this.evolutionChambers, 75.0, 0.75, waypoint);
        score = this.augmentScore(score, c.spineCrawlers, this.spineCrawlers, 100.0, 1.0, waypoint);
        score = this.augmentScore(score, c.sporeCrawlers, this.sporeCrawlers, 75.0, 0.75, waypoint);
        score = this.augmentDropoffScore(score, c.nydusNetwork, this.nydusNetwork, 350.0, 3.0, waypoint);
        score = this.augmentScore(score, c.nydusWorm, this.nydusWorm, 200.0, 2.0, waypoint);
        score = this.augmentScore(score, c.metabolicBoost, this.metabolicBoost, 200, 2.0, waypoint);
        score = this.augmentScore(score, c.adrenalGlands, this.adrenalGlands, 400, 4.0, waypoint);
        score = this.augmentScore(score, c.glialReconstitution, this.glialReconstitution, 200, 2.0, waypoint);
        score = this.augmentScore(score, c.tunnelingClaws, this.tunnelingClaws, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.burrow, this.burrow, 200, 2.0, waypoint);
        score = this.augmentScore(score, c.pneumatizedCarapace, this.pneumatizedCarapace, 200, 2.0, waypoint);
        score = this.augmentScore(score, c.ventralSacs, this.ventralSacs, 400, 4.0, waypoint);
        score = this.augmentScore(score, c.centrifugalHooks, this.centrifugalHooks, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.melee1, this.melee1, 200, 2.0, waypoint);
        score = this.augmentScore(score, c.melee2, this.melee2, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.melee3, this.melee3, 400, 4.0, waypoint);
        score = this.augmentScore(score, c.missile1, this.missile1, 200, 2.0, waypoint);
        score = this.augmentScore(score, c.missile2, this.missile2, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.missile3, this.missile3, 400, 4.0, waypoint);
        score = this.augmentScore(score, c.armor1, this.armor1, 200, 3.0, waypoint);
        score = this.augmentScore(score, c.armor2, this.armor2, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.armor3, this.armor3, 400, 3.0, waypoint);
        score = this.augmentScore(score, c.groovedSpines, this.groovedSpines, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.neuralParasite, this.neuralParasite, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.pathogenGlands, this.pathogenGlands, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.flyerAttack1, this.flyerAttack1, 200, 2.0, waypoint);
        score = this.augmentScore(score, c.flyerAttack2, this.flyerAttack2, 350, 3.5, waypoint);
        score = this.augmentScore(score, c.flyerAttack3, this.flyerAttack3, 500, 5.0, waypoint);
        score = this.augmentScore(score, c.flyerArmor1, this.flyerArmor1, 300, 3.0, waypoint);
        score = this.augmentScore(score, c.flyerArmor2, this.flyerArmor2, 450, 4.5, waypoint);
        score = this.augmentScore(score, c.flyerArmor3, this.flyerArmor3, 600, 6.0, waypoint);
        score = this.augmentScore(score, c.chitinousPlating, this.chitinousPlating, 300, 3.0, waypoint);
        return score;
    }

    private double augmentScore(double score, boolean a, boolean b, int mula, double mulb, boolean waypoint) {
        return this.augmentScore(score, a ? 1 : 0, b ? 1 : 0, (double)mula, mulb, waypoint);
    }

    private double augmentScore(double score, int a, int b, double mula, double mulb, boolean waypoint) {
        score += (double)Math.max(Math.min(a, b), 0) * mula;
        if (!waypoint) {
            score += (double)Math.max(a - b, 0) * mulb;
        }
        return score;
    }

    private double augmentDropoffScore(double score, int a, int b, double mula, double mulb, boolean waypoint) {
        score += (double)Math.max(Math.min(a, b), 0) * mula;
        if (!waypoint) {
            int i = 0;
            while (i < Math.max(a - b, 0)) {
                score += (mulb /= 2.0);
                ++i;
            }
        }
        return score;
    }

    public boolean isSatisfied(EcState candidate) {
        EcState c = candidate;
        if (c.drones < this.drones) {
            return false;
        }
        if (c.zerglings < this.zerglings) {
            return false;
        }
        if (c.banelings < this.banelings) {
            return false;
        }
        if (c.roaches < this.roaches) {
            return false;
        }
        if (c.hatcheries < this.hatcheries) {
            return false;
        }
        if (c.mutalisks < this.mutalisks) {
            return false;
        }
        if (c.queens < this.queens) {
            return false;
        }
        if (c.hydralisks < this.hydralisks) {
            return false;
        }
        if (c.infestors < this.infestors) {
            return false;
        }
        if (c.corruptors < this.corruptors) {
            return false;
        }
        if (c.ultralisks < this.ultralisks) {
            return false;
        }
        if (c.broodlords < this.broodlords) {
            return false;
        }
        if (c.overlords < this.overlords) {
            return false;
        }
        if (c.overseers < this.overseers) {
            return false;
        }
        if (c.hatcheries < this.hatcheries) {
            return false;
        }
        if (c.lairs < this.lairs) {
            return false;
        }
        if (c.hives < this.hives) {
            return false;
        }
        if (c.spawningPools < this.spawningPools) {
            return false;
        }
        if (c.banelingNest < this.banelingNest) {
            return false;
        }
        if (c.roachWarrens < this.roachWarrens) {
            return false;
        }
        if (c.hydraliskDen < this.hydraliskDen) {
            return false;
        }
        if (c.infestationPit < this.infestationPit) {
            return false;
        }
        if (c.spire < this.spire) {
            return false;
        }
        if (c.greaterSpire < this.greaterSpire) {
            return false;
        }
        if (c.ultraliskCavern < this.ultraliskCavern) {
            return false;
        }
        if (c.evolutionChambers < this.evolutionChambers) {
            return false;
        }
        if (c.spineCrawlers < this.spineCrawlers) {
            return false;
        }
        if (c.sporeCrawlers < this.sporeCrawlers) {
            return false;
        }
        if (c.nydusNetwork < this.nydusNetwork) {
            return false;
        }
        if (c.nydusWorm < this.nydusWorm) {
            return false;
        }
        if (!c.metabolicBoost & this.metabolicBoost) {
            return false;
        }
        if (!c.adrenalGlands & this.adrenalGlands) {
            return false;
        }
        if (!c.glialReconstitution & this.glialReconstitution) {
            return false;
        }
        if (!c.tunnelingClaws & this.tunnelingClaws) {
            return false;
        }
        if (!c.burrow & this.burrow) {
            return false;
        }
        if (!c.pneumatizedCarapace & this.pneumatizedCarapace) {
            return false;
        }
        if (!c.ventralSacs & this.ventralSacs) {
            return false;
        }
        if (!c.centrifugalHooks & this.centrifugalHooks) {
            return false;
        }
        if (!c.melee1 & this.melee1) {
            return false;
        }
        if (!c.melee2 & this.melee2) {
            return false;
        }
        if (!c.melee3 & this.melee3) {
            return false;
        }
        if (!c.missile1 & this.missile1) {
            return false;
        }
        if (!c.missile2 & this.missile2) {
            return false;
        }
        if (!c.missile3 & this.missile3) {
            return false;
        }
        if (!c.armor1 & this.armor1) {
            return false;
        }
        if (!c.armor2 & this.armor2) {
            return false;
        }
        if (!c.armor3 & this.armor3) {
            return false;
        }
        if (!c.groovedSpines & this.groovedSpines) {
            return false;
        }
        if (!c.neuralParasite & this.neuralParasite) {
            return false;
        }
        if (!c.pathogenGlands & this.pathogenGlands) {
            return false;
        }
        if (!c.flyerAttack1 & this.flyerAttack1) {
            return false;
        }
        if (!c.flyerAttack2 & this.flyerAttack2) {
            return false;
        }
        if (!c.flyerAttack3 & this.flyerAttack3) {
            return false;
        }
        if (!c.flyerArmor1 & this.flyerArmor1) {
            return false;
        }
        if (!c.flyerArmor2 & this.flyerArmor2) {
            return false;
        }
        if (!c.flyerArmor3 & this.flyerArmor3) {
            return false;
        }
        return !(!c.chitinousPlating & this.chitinousPlating);
    }

    public int bases() {
        return this.hatcheries + this.lairs + this.evolvingHatcheries + this.evolvingLairs + this.hives + this.evolvingHives;
    }

    public int getSumStuff() {
        if (this.waypoints.size() > 0) {
            EcState state = EcState.defaultDestination();
            for (EcState s : this.waypoints) {
                state.union(s);
            }
            state.union(this);
            return state.getSumStuff();
        }
        int i = this.hatcheries + this.lairs + this.hives + this.spawningPools + this.evolutionChambers + this.roachWarrens + this.hydraliskDen + this.banelingNest + this.infestationPit + this.greaterSpire + this.ultraliskCavern + this.gasExtractors + this.spire + this.spineCrawlers + this.sporeCrawlers + this.nydusNetwork + this.nydusWorm + this.drones + this.overlords + this.overseers + this.zerglings + this.banelings * 2 + this.roaches + this.mutalisks + this.infestors + this.queens + this.hydralisks + this.corruptors + this.ultralisks + this.broodlords * 2;
        if (this.metabolicBoost) {
            ++i;
        }
        if (this.adrenalGlands) {
            ++i;
        }
        if (this.glialReconstitution) {
            ++i;
        }
        if (this.tunnelingClaws) {
            ++i;
        }
        if (this.burrow) {
            ++i;
        }
        if (this.pneumatizedCarapace) {
            ++i;
        }
        if (this.ventralSacs) {
            ++i;
        }
        if (this.centrifugalHooks) {
            ++i;
        }
        if (this.melee1) {
            ++i;
        }
        if (this.melee2) {
            ++i;
        }
        if (this.melee3) {
            ++i;
        }
        if (this.missile1) {
            ++i;
        }
        if (this.missile2) {
            ++i;
        }
        if (this.missile3) {
            ++i;
        }
        if (this.armor1) {
            ++i;
        }
        if (this.armor2) {
            ++i;
        }
        if (this.armor3) {
            ++i;
        }
        if (this.groovedSpines) {
            ++i;
        }
        if (this.neuralParasite) {
            ++i;
        }
        if (this.pathogenGlands) {
            ++i;
        }
        if (this.flyerAttack1) {
            ++i;
        }
        if (this.flyerAttack2) {
            ++i;
        }
        if (this.flyerAttack3) {
            ++i;
        }
        if (this.flyerArmor1) {
            ++i;
        }
        if (this.flyerArmor2) {
            ++i;
        }
        if (this.flyerArmor3) {
            ++i;
        }
        if (this.chitinousPlating) {
            ++i;
        }
        for (EcState s : this.waypoints) {
            i += s.getSumStuff();
        }
        return i;
    }

    public boolean waypointMissed(EcBuildOrder candidate) {
        for (EcState s : this.waypoints) {
            if (candidate.seconds < s.targetSeconds || s.isSatisfied(candidate)) continue;
            return true;
        }
        return false;
    }
}

