/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.OfficeXP;

import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.fife.plaf.OfficeXP.OfficeXPArrowButton;

public class OfficeXPComboBoxUI
extends WindowsComboBoxUI {
    private boolean isMouseOver = false;
    private boolean isFocused = false;
    protected boolean popupVisible;
    private OfficeXPArrowButton xpArrowButton;
    private MouseListener mouseHandler;
    private FocusListener focusListener;
    private PopupMenuListener popupListener;

    protected final JButton createArrowButton() {
        OfficeXPArrowButton officeXPArrowButton = this.createArrowButtonImpl();
        officeXPArrowButton.addMouseListener(this.mouseHandler);
        this.xpArrowButton = officeXPArrowButton;
        return officeXPArrowButton;
    }

    protected OfficeXPArrowButton createArrowButtonImpl() {
        return new OfficeXPArrowButton(this);
    }

    protected FocusListener createFocusHandler() {
        return new FocusHandler();
    }

    protected MouseListener createMouseHandler() {
        return new MouseHandler();
    }

    protected PopupMenuListener createPopupListener() {
        return new OfficeXPComboPopupListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new OfficeXPComboBoxUI();
    }

    public Color getBorderColor() {
        boolean bl = this.comboBox.isEnabled() && (this.isFocused() || this.isMouseOver());
        return bl ? UIManager.getColor("OfficeLnF.HighlightBorderColor") : this.comboBox.getBackground();
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseHandler = this.createMouseHandler();
        this.focusListener = this.createFocusHandler();
        this.comboBox.addMouseListener(this.mouseHandler);
        JTextComponent jTextComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
        jTextComponent.addMouseListener(this.mouseHandler);
        jTextComponent.addFocusListener(this.focusListener);
        this.popupListener = this.createPopupListener();
        this.comboBox.addPopupMenuListener(this.popupListener);
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public boolean isMouseOver() {
        return this.isMouseOver;
    }

    protected void setFocused(boolean bl) {
        this.isFocused = bl;
        this.comboBox.repaint();
    }

    protected void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
    }

    public void uninstallListeners() {
        this.comboBox.removeMouseListener(this.mouseHandler);
        JTextComponent jTextComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
        jTextComponent.removeMouseListener(this.mouseHandler);
        jTextComponent.removeFocusListener(this.focusListener);
        this.comboBox.removePopupMenuListener(this.popupListener);
        super.uninstallListeners();
    }

    protected class OfficeXPComboPopupListener
    implements PopupMenuListener {
        protected OfficeXPComboPopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            OfficeXPComboBoxUI.this.popupVisible = false;
            if (OfficeXPComboBoxUI.this.isFocused()) {
                OfficeXPComboBoxUI.this.xpArrowButton.updatePaintState(2);
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            OfficeXPComboBoxUI.this.popupVisible = false;
            if (OfficeXPComboBoxUI.this.isFocused()) {
                OfficeXPComboBoxUI.this.xpArrowButton.updatePaintState(2);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            OfficeXPComboBoxUI.this.popupVisible = true;
            OfficeXPComboBoxUI.this.xpArrowButton.updatePaintState(3);
        }
    }

    protected class FocusHandler
    implements FocusListener {
        protected FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            OfficeXPComboBoxUI.this.setFocused(true);
            if (!OfficeXPComboBoxUI.this.popupVisible) {
                OfficeXPComboBoxUI.this.xpArrowButton.updatePaintState(2);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            OfficeXPComboBoxUI.this.setFocused(false);
            OfficeXPComboBoxUI.this.xpArrowButton.updatePaintState(1);
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        protected void doMouseEnteredNotFocused() {
            if (OfficeXPComboBoxUI.this.comboBox.isEnabled()) {
                OfficeXPComboBoxUI.this.xpArrowButton.updatePaintState(2);
            }
        }

        protected void doMouseExitedNotFocused() {
            OfficeXPComboBoxUI.this.xpArrowButton.updatePaintState(1);
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
            if (!OfficeXPComboBoxUI.this.isFocused()) {
                this.doMouseEnteredNotFocused();
            }
            OfficeXPComboBoxUI.this.setMouseOver(true);
            OfficeXPComboBoxUI.this.comboBox.repaint();
        }

        public final void mouseExited(MouseEvent mouseEvent) {
            if (!OfficeXPComboBoxUI.this.isFocused()) {
                this.doMouseExitedNotFocused();
            }
            OfficeXPComboBoxUI.this.setMouseOver(false);
            OfficeXPComboBoxUI.this.comboBox.repaint();
        }
    }

    public static class ComboBorder
    extends AbstractBorder
    implements UIResource {
        private static ComboBorder border;

        private ComboBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.top = 1;
            insets.left = 1;
            return insets;
        }

        public static synchronized ComboBorder getComboBorder() {
            if (border == null) {
                border = new ComboBorder();
            }
            return border;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            if (component instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)component;
                if (jComboBox.getUI() instanceof OfficeXPComboBoxUI) {
                    OfficeXPComboBoxUI officeXPComboBoxUI = (OfficeXPComboBoxUI)((Object)jComboBox.getUI());
                    graphics.setColor(officeXPComboBoxUI.getBorderColor());
                } else {
                    graphics.setColor(UIManager.getColor("OfficeLnF.HighlightBorderColor"));
                }
            } else {
                graphics.setColor(UIManager.getColor("OfficeLnF.HighlightBorderColor"));
            }
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(color);
        }
    }
}

