/*
 * Decompiled with CFR 0.152.
 */
package com.easynth.lookandfeel;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.plaf.synth.SynthLookAndFeel;

public class EaSynthLookAndFeel
extends SynthLookAndFeel {
    private static final long serialVersionUID = 6942508771080867071L;
    private String synthXml;

    public EaSynthLookAndFeel() {
        try {
            this.load(this.getClass().getResourceAsStream("easynth.xml"), this.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDescription() {
        return "EaSynth Look and Feel Designer's default LAF, created by the tool.";
    }

    public String getID() {
        return this.getClass().getSimpleName();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public void setDefaultFont(String fontName, int size, boolean isBold, boolean isItalic) {
        StringBuilder replaceBuf = new StringBuilder();
        replaceBuf.append("$1");
        replaceBuf.append(fontName);
        replaceBuf.append("$3");
        replaceBuf.append(size);
        replaceBuf.append("$5");
        if (isBold || isItalic) {
            replaceBuf.append(" style=\"");
            if (isBold) {
                replaceBuf.append("BOLD");
                if (isItalic) {
                    replaceBuf.append(' ');
                }
            }
            if (isItalic) {
                replaceBuf.append("ITALIC");
            }
            replaceBuf.append("\"");
        }
        replaceBuf.append("$7");
        this.replaceXmlSegment("(<style id=\"Default\">\\s*<font name=\")([^\"]*)(\" size=\")([^\"]*)(\")([^/]*)(/>)", replaceBuf.toString());
    }

    public void replaceXmlSegment(String regex, String replacement) {
        this.replaceXmlSegmentInCache(regex, replacement);
        this.applyCachedSynthXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceXmlSegmentInCache(String regex, String replacement) {
        EaSynthLookAndFeel eaSynthLookAndFeel = this;
        synchronized (eaSynthLookAndFeel) {
            if (this.synthXml == null) {
                this.synthXml = this.getSynthXmlAsString();
            }
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(this.synthXml);
        this.synthXml = m.replaceFirst(replacement);
    }

    public void applyCachedSynthXml() {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.synthXml.getBytes("UTF-8"));
            this.load(is, this.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSynthXmlAsString() {
        InputStream is = this.getClass().getResourceAsStream("easynth.xml");
        if (is != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String line = null;
                StringBuilder strBuf = new StringBuilder();
                do {
                    if ((line = reader.readLine()) == null) continue;
                    strBuf.append(line.trim());
                    strBuf.append(System.getProperty("line.separator"));
                } while (line != null);
                String resourceStr = strBuf.toString();
                return resourceStr;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

