/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.SearchField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class BuildOrderSearchField
extends SearchField {
    private static final String ANY_BUILDING_NAME = "*";
    private static final Vector<Object> BUILDING_VECTOR = new Vector<ReplayConsts.Building>(ReplayUtils.CURRENT_ABILITY_CODES.BUILD_ABILITY_CODES.values());
    protected JTextField textField = new JTextField(1);
    protected JComboBox comboBox = new JComboBox<Object>(BUILDING_VECTOR);

    static {
        Collections.sort(BUILDING_VECTOR, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        BUILDING_VECTOR.insertElementAt("* (" + Language.getText("module.repSearch.tab.filters.name.buildOrderAnyBuilding") + ")", 0);
    }

    public BuildOrderSearchField() {
        super("module.repSearch.tab.filters.name.buildOrder");
        this.textField.setToolTipText(Language.getText("module.repSearch.tab.filters.name.buildOrderTextToolTip"));
        this.uiComponent.add(this.textField);
        JButton jButton = new JButton(Icons.ARROW_180);
        jButton.setToolTipText(Language.getText("module.repSearch.tab.filters.name.buildOrderAddToolTip"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = BuildOrderSearchField.this.textField.getText();
                BuildOrderSearchField.this.textField.setText(String.valueOf(string) + (string.length() == 0 ? "" : (string.trim().endsWith(",") ? "" : ", ")) + (BuildOrderSearchField.this.comboBox.getSelectedIndex() == 0 ? BuildOrderSearchField.ANY_BUILDING_NAME : BuildOrderSearchField.this.comboBox.getSelectedItem()));
            }
        });
        this.uiComponent.add(jButton);
        this.comboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object object) {
                return object instanceof ReplayConsts.Building ? Icons.getBuildingIcon((ReplayConsts.Building)((Object)object), IconHandler.Size.MEDIUM) : IconHandler.NULL.get((Object)IconHandler.Size.MEDIUM);
            }
        });
        this.uiComponent.add(this.comboBox);
    }

    @Override
    public boolean validate() {
        if (BuildOrderSearchField.parseBuildOrder(this.textField.getText()) == null) {
            this.textField.setBackground(ERROR_COLOR);
            return false;
        }
        this.textField.setBackground(null);
        return true;
    }

    @Override
    public void reset() {
        this.comboBox.setSelectedIndex(0);
        this.textField.setText("");
        this.textField.setBackground(null);
    }

    @Override
    public ReplayFilter getFilter() {
        final ReplayConsts.Building[] buildingArray = BuildOrderSearchField.parseBuildOrder(this.textField.getText());
        if (buildingArray == null || buildingArray.length == 0) {
            return null;
        }
        return new ReplayFilter(){

            @Override
            public Set<ReplayFactory.ReplayContent> getRequiredReplayContentSet() {
                return GAME_EVENTS_REPLAY_CONTENT_SET;
            }

            @Override
            public boolean accept(File file, Replay replay) {
                GameEvents.Action[] actionArray = replay.gameEvents.actions;
                int n = actionArray.length;
                int[] nArray = new int[replay.details.players.length];
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    GameEvents.Action action = actionArray[n3];
                    if (action.type == ReplayConsts.ActionType.BUILD && nArray[action.player] >= 0) {
                        ReplayConsts.Building building = ((GameEvents.BuildAction)action).building;
                        ReplayConsts.Building building2 = buildingArray[nArray[action.player]];
                        if (building2 == null || building2 == building) {
                            byte by = action.player;
                            nArray[by] = nArray[by] + 1;
                            if (nArray[by] == buildingArray.length) {
                                return true;
                            }
                        } else {
                            nArray[action.player] = -1;
                            if (--n2 == 0) {
                                return false;
                            }
                        }
                    }
                    ++n3;
                }
                return false;
            }
        };
    }

    private static ReplayConsts.Building[] parseBuildOrder(String string) {
        if (string.length() == 0) {
            return new ReplayConsts.Building[0];
        }
        String[] stringArray = string.split(",");
        ArrayList<ReplayConsts.Building> arrayList = new ArrayList<ReplayConsts.Building>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if ((string2 = string2.trim()).length() == 0) {
                return null;
            }
            if (string2.equals(ANY_BUILDING_NAME)) {
                arrayList.add(null);
            } else {
                boolean bl = false;
                ReplayConsts.Building[] buildingArray = ReplayConsts.Building.values();
                int n3 = buildingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ReplayConsts.Building building = buildingArray[n4];
                    if (building.toString().equalsIgnoreCase(string2)) {
                        arrayList.add(building);
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl) {
                    return null;
                }
            }
            ++n2;
        }
        return arrayList.toArray(new ReplayConsts.Building[arrayList.size()]);
    }
}

