/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.multirepanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayCache;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.PlayerPopupMenu;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.BuildOrderStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartData;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartPainter;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.ChartParams;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.DateRangeStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.MapStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerGameParticipationStats;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlaymateStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.Record;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.TrendPainter;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.TrendParams;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplaySearch;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gears.util.NullAwareComparable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class MultiRepAnalysis
extends ModuleFrame {
    private static final String[] DAY_TEXT_KEYS = new String[]{"general.day.sunday", "general.day.monday", "general.day.tuesday", "general.day.wednesday", "general.day.thursday", "general.day.friday", "general.day.saturday"};
    private static final String[] MONTH_TEXT_KEYS = new String[]{"general.month.january", "general.month.february", "general.month.march", "general.month.april", "general.month.may", "general.month.june", "general.month.july", "general.month.august", "general.month.september", "general.month.october", "general.month.november", "general.month.december"};
    private static final String[] PLAYERS_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.players.header.playerName", "module.multiRepAnal.tab.players.header.replays", "module.multiRepAnal.tab.players.header.avgApm", "module.multiRepAnal.tab.players.header.record", "module.multiRepAnal.tab.players.header.winRatio", "module.multiRepAnal.tab.players.header.raceDistribution", "module.multiRepAnal.tab.players.header.totalTimeInGames", "module.multiRepAnal.tab.players.header.avgGameLength", "module.multiRepAnal.tab.players.header.presence", "module.multiRepAnal.tab.players.header.avgGamesPerDay", "module.multiRepAnal.tab.players.header.firstGame", "module.multiRepAnal.tab.players.header.lastGame"};
    private static final String[] PLAYER_MAPS_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.maps.header.mapName", "module.multiRepAnal.tab.maps.header.replays", "module.multiRepAnal.tab.maps.header.replaysRatio", "module.multiRepAnal.tab.maps.header.record", "module.multiRepAnal.tab.maps.header.winRatio", "module.multiRepAnal.tab.maps.header.1v1PWinRatio", "module.multiRepAnal.tab.maps.header.1v1TWinRatio", "module.multiRepAnal.tab.maps.header.1v1ZWinRatio", "module.multiRepAnal.tab.maps.header.firstPlayed", "module.multiRepAnal.tab.maps.header.lastPlayed"};
    private static final String[] BUILD_ORDERS_1V1_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.1v1BuildOrders.header.race", "module.multiRepAnal.tab.1v1BuildOrders.header.buildOrder", "module.multiRepAnal.tab.1v1BuildOrders.header.occurrences", "module.multiRepAnal.tab.1v1BuildOrders.header.record", "module.multiRepAnal.tab.1v1BuildOrders.header.winRatio", "module.multiRepAnal.tab.1v1BuildOrders.header.recordVsP", "module.multiRepAnal.tab.1v1BuildOrders.header.recordVsT", "module.multiRepAnal.tab.1v1BuildOrders.header.recordVsZ", "module.multiRepAnal.tab.1v1BuildOrders.header.firstUsed", "module.multiRepAnal.tab.1v1BuildOrders.header.lastUsed"};
    private static final String[] PLAYMATES_HEADER_KEYS = new String[]{"module.multiRepAnal.tab.player.tab.playmates.header.playmate", "module.multiRepAnal.tab.player.tab.playmates.header.commonGames", "module.multiRepAnal.tab.player.tab.playmates.header.gamesAsAllies", "module.multiRepAnal.tab.player.tab.playmates.header.gamesAsOpponents", "module.multiRepAnal.tab.player.tab.playmates.header.recordAsAllies", "module.multiRepAnal.tab.player.tab.playmates.header.winRatioAsAllies", "module.multiRepAnal.tab.player.tab.playmates.header.recordAsOpponents", "module.multiRepAnal.tab.player.tab.playmates.header.winRatioAsOpponents", "module.multiRepAnal.tab.player.tab.playmates.header.totalTimeTogether", "module.multiRepAnal.tab.player.tab.playmates.header.firstCommonGame", "module.multiRepAnal.tab.player.tab.playmates.header.lastCommonGame"};
    private static final String[] PLAYERS_HEADER_NAMES = new String[PLAYERS_HEADER_KEYS.length];
    private static final String[] MAPS_HEADER_NAMES = new String[PLAYER_MAPS_HEADER_KEYS.length - 2];
    private static final String[] BUILD_ORDERS_1V1_HEADER_NAMES = new String[BUILD_ORDERS_1V1_HEADER_KEYS.length];
    private static final String[] TYPE_RECORDS_HEADER_NAMES;
    private static final String[] FORMAT_RECORDS_HEADER_NAMES;
    private static final String[] MATCHUP_RECORDS_HEADER_NAMES;
    private static final String[] PLAYER_MAPS_HEADER_NAMES;
    private static final String[] PLAYMATES_HEADER_NAMES;
    private static final AtomicInteger counter;
    private final File[] files;
    private final JCheckBox autoOpenFirstPlayerCheckBox = GuiUtils.createCheckBox("module.multiRepAnal.autoOpenFirstPlayer", "module.multiRepAnal.autoOpenFirstPlayer");
    private final JCheckBox stretchToWindowCheckBox = GuiUtils.createCheckBox("module.multiRepAnal.stretchToWindow", "module.multiRepAnal.stretchToWindow");
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private int replaysIncludedInAnalysis;
    private final Map<String, PlayerStatistics> playerStatisticsMap = new HashMap<String, PlayerStatistics>();
    private final Map<String, MapStatistics> mapStatisticsMap = new HashMap<String, MapStatistics>();
    private final Map<String, BuildOrderStatistics> buildOrder1v1StatisticsMap = new HashMap<String, BuildOrderStatistics>();
    private String firstPlayerName;
    private final MouseListener playersTableMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            if (mouseEvent.getButton() == 1) {
                if (jTable.getSelectedRow() >= 0 && mouseEvent.getClickCount() == 2) {
                    String string = (String)jTable.getValueAt(jTable.rowAtPoint(mouseEvent.getPoint()), GuiUtils.getColumnViewIndex(jTable, 0));
                    MultiRepAnalysis.this.openPlayer(string);
                }
            } else if (mouseEvent.getButton() == 3) {
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                jTable.getSelectionModel().setSelectionInterval(n, n);
                final String string = (String)jTable.getValueAt(n, GuiUtils.getColumnViewIndex(jTable, 0));
                PlayerStatistics playerStatistics = (PlayerStatistics)MultiRepAnalysis.this.playerStatisticsMap.get(string);
                if (playerStatistics != null) {
                    PlayerPopupMenu playerPopupMenu = new PlayerPopupMenu(playerStatistics.name, playerStatistics.battleNetId, playerStatistics.battleNetSubid, playerStatistics.gateway, playerStatistics.playerType);
                    playerPopupMenu.addSeparator();
                    JMenuItem jMenuItem = new JMenuItem(Language.getText("module.multiRepAnal.playerMenu.openPlayer"), Icons.CHART_UP);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            MultiRepAnalysis.this.openPlayer(string);
                        }
                    });
                    playerPopupMenu.add(jMenuItem);
                    playerPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    };

    static {
        PLAYER_MAPS_HEADER_NAMES = new String[PLAYER_MAPS_HEADER_KEYS.length];
        PLAYMATES_HEADER_NAMES = new String[PLAYMATES_HEADER_KEYS.length];
        int n = 0;
        while (n < PLAYERS_HEADER_KEYS.length) {
            MultiRepAnalysis.PLAYERS_HEADER_NAMES[n] = Language.getText(PLAYERS_HEADER_KEYS[n]);
            ++n;
        }
        n = 0;
        while (n < BUILD_ORDERS_1V1_HEADER_KEYS.length) {
            MultiRepAnalysis.BUILD_ORDERS_1V1_HEADER_NAMES[n] = Language.getText(BUILD_ORDERS_1V1_HEADER_KEYS[n]);
            ++n;
        }
        TYPE_RECORDS_HEADER_NAMES = (String[])PLAYERS_HEADER_NAMES.clone();
        MultiRepAnalysis.TYPE_RECORDS_HEADER_NAMES[0] = Language.getText("module.multiRepAnal.tab.player.tab.typeRecords.header.format");
        FORMAT_RECORDS_HEADER_NAMES = (String[])PLAYERS_HEADER_NAMES.clone();
        MultiRepAnalysis.FORMAT_RECORDS_HEADER_NAMES[0] = Language.getText("module.multiRepAnal.tab.player.tab.formatRecords.header.format");
        MATCHUP_RECORDS_HEADER_NAMES = new String[PLAYERS_HEADER_KEYS.length - 1];
        MultiRepAnalysis.MATCHUP_RECORDS_HEADER_NAMES[0] = Language.getText("module.multiRepAnal.tab.player.tab.matchupRecords.header.matchup");
        n = 1;
        int n2 = 1;
        while (n < PLAYERS_HEADER_NAMES.length) {
            if (!"module.multiRepAnal.tab.players.header.raceDistribution".equals(PLAYERS_HEADER_KEYS[n])) {
                MultiRepAnalysis.MATCHUP_RECORDS_HEADER_NAMES[n2++] = Language.getText(PLAYERS_HEADER_KEYS[n]);
            }
            ++n;
        }
        n = 0;
        while (n < PLAYER_MAPS_HEADER_KEYS.length) {
            MultiRepAnalysis.PLAYER_MAPS_HEADER_NAMES[n] = Language.getText(PLAYER_MAPS_HEADER_KEYS[n]);
            ++n;
        }
        n = 0;
        n2 = 0;
        while (n < PLAYER_MAPS_HEADER_NAMES.length) {
            if (!"module.multiRepAnal.tab.maps.header.record".equals(PLAYER_MAPS_HEADER_KEYS[n]) && !"module.multiRepAnal.tab.maps.header.winRatio".equals(PLAYER_MAPS_HEADER_KEYS[n])) {
                MultiRepAnalysis.MAPS_HEADER_NAMES[n2++] = PLAYER_MAPS_HEADER_NAMES[n];
            }
            ++n;
        }
        n = 0;
        while (n < PLAYMATES_HEADER_KEYS.length) {
            MultiRepAnalysis.PLAYMATES_HEADER_NAMES[n] = Language.getText(PLAYMATES_HEADER_KEYS[n]);
            ++n;
        }
        counter = new AtomicInteger();
    }

    /*
     * Unable to fully structure code
     */
    public MultiRepAnalysis(Object ... var1_1) {
        super(var1_1.length == 0 ? Language.getText("module.multiRepAnal.opening") : null);
        this.setFrameIcon(Icons.CHART_UP_COLOR);
        if (var1_1.length != 0) ** GOTO lbl25
        var2_2 = Settings.getString("settings.folders.defaultReplay");
        var3_4 = new JFileChooser(var2_2 == null ? Settings.getString("settings.folders.sc2AutoReplay") : var2_2);
        var3_4.setDialogTitle(Language.getText("module.multiRepAnal.openTitle"));
        var3_4.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
        var3_4.setAccessory(GuiUtils.createReplayFilePreviewAccessory(var3_4));
        var3_4.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
        var3_4.setFileSelectionMode(2);
        var3_4.setMultiSelectionEnabled(true);
        if (var3_4.showOpenDialog(MainFrame.INSTANCE) == 0) {
            this.files = var3_4.getSelectedFiles();
        } else {
            this.dispose();
            this.files = null;
            return;
lbl25:
            // 1 sources

            if (var1_1.length > 0 && var1_1[0] != null) {
                this.files = MultiRepAnalysis.loadReplaySourceFile((File)var1_1[0]);
            } else if (var1_1.length > 1 && var1_1[1] != null) {
                var2_3 = ReplaySearch.loadReplayListFile((File)var1_1[1]);
                this.files = new File[var2_3.size()];
                var3_5 = var2_3.size() - 1;
                while (var3_5 >= 0) {
                    this.files[var3_5] = new File((String)var2_3.get(var3_5)[ReplaySearch.COLUMN_FILE_NAME]);
                    --var3_5;
                }
            } else if (var1_1.length > 2 && var1_1[2] != null) {
                this.files = (File[])var1_1[2];
            } else {
                throw new RuntimeException("The source for Multi-rep analysis is incorrectly specified!");
            }
        }
        this.setTitle(Language.getText("module.multiRepAnal.title", new Object[]{MultiRepAnalysis.counter.incrementAndGet()}));
        this.buildGUI();
    }

    private static File[] loadReplaySourceFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            ArrayList<File> arrayList = new ArrayList<File>();
            while (bufferedReader.ready()) {
                arrayList.add(new File(bufferedReader.readLine()));
            }
            File[] fileArray = arrayList.toArray(new File[arrayList.size()]);
            return fileArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GuiUtils.showErrorDialog(Language.getText("module.repSearch.tab.source.failedToLoadRepSource"));
            File[] fileArray = new File[]{};
            return fileArray;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void buildGUI() {
        Box box = Box.createVerticalBox();
        final Box box2 = Box.createHorizontalBox();
        final JButton jButton = new JButton(Icons.CROSS_OCTAGON);
        GuiUtils.updateButtonText(jButton, "module.multiRepAnal.abortAnalysisButton", new Object[0]);
        box2.add(jButton);
        this.autoOpenFirstPlayerCheckBox.setToolTipText(Language.getText("module.multiRepAnal.autoOpenFirstPlayerToolTip"));
        box2.add(this.autoOpenFirstPlayerCheckBox);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.stretchToWindowCheckBox);
        box2.add(Box.createHorizontalStrut(15));
        box2.add(MiscSettingsDialog.createLinkLabelToSettings("miscSettings.tab.analyzer"));
        box.add(GuiUtils.wrapInPanel(box2));
        final JProgressBar jProgressBar = new JProgressBar();
        box.add(jProgressBar);
        this.getContentPane().add((Component)box, "North");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        final NormalThread normalThread = new NormalThread("Multi-replay analysis"){
            private volatile boolean aborted;
            private int replaysCount;
            private int analyzedCount;
            private int skippedCount;
            private final boolean useRealTime;
            private final int timeLimitToBeIncluded;
            private final int buildOrderLength;
            private final int timeExclusionForApm;
            private final boolean cacheEnabled;
            final List<String> helperPlayerList;
            final List<Character> raceLetterList;
            final StringBuilder teamCompositionBuilder;
            {
                super(string);
                this.useRealTime = Settings.getBoolean("settings.misc.useRealTimeMeasurement");
                this.timeLimitToBeIncluded = Settings.getInt("settings.misc.timeLimitForMultiRepAnalysis");
                this.buildOrderLength = Settings.getInt("settings.misc.buildOrderLength");
                this.timeExclusionForApm = Settings.getInt("settings.misc.initialTimeToExcludeFromApm") << 6;
                this.cacheEnabled = Settings.getBoolean("settings.misc.cachePreprocessedReplays");
                this.helperPlayerList = Arrays.asList("");
                this.raceLetterList = new ArrayList<Character>(4);
                this.teamCompositionBuilder = new StringBuilder(5);
            }

            @Override
            public void run() {
                File file;
                InternalFrameAdapter internalFrameAdapter = new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                        jButton.doClick();
                    }
                };
                MultiRepAnalysis.this.addInternalFrameListener(internalFrameAdapter);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        box2.remove(jButton);
                        MultiRepAnalysis.this.getContentPane().validate();
                        aborted = true;
                    }
                });
                jProgressBar.setStringPainted(true);
                jProgressBar.setString(Language.getText("module.multiRepAnal.countingReplays"));
                File[] fileArray = MultiRepAnalysis.this.files;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    file = fileArray[n2];
                    if (this.aborted) break;
                    this.replaysCount += this.countReplays(file);
                    ++n2;
                }
                if (this.aborted) {
                    jProgressBar.setString(String.valueOf(Language.getText("module.multiRepAnal.analysisAborted")) + " [" + jProgressBar.getString() + "]");
                } else {
                    jProgressBar.setMaximum(this.replaysCount);
                    this.updateProgressBar();
                    fileArray = MultiRepAnalysis.this.files;
                    n = fileArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        file = fileArray[n2];
                        if (this.aborted) break;
                        this.analyzeReplays(file);
                        ++n2;
                    }
                    if (this.aborted) {
                        jProgressBar.setString(String.valueOf(Language.getText("module.multiRepAnal.analysisAborted")) + " [" + jProgressBar.getString() + "]");
                    } else {
                        box2.remove(jButton);
                        MultiRepAnalysis.this.getContentPane().validate();
                    }
                    MultiRepAnalysis.this.replaysIncludedInAnalysis = this.analyzedCount - this.skippedCount;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.players.title"), Icons.USERS, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createPlayersTab(), false, null);
                                GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.maps.title"), Icons.MAPS_STACK, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.createMapsTab(), false, null);
                                GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.1v1BuildOrders.title"), Icons.BLOCK, false, MultiRepAnalysis.this.tabbedPane, MultiRepAnalysis.this.create1v1BuildOrdersTab(), false, null);
                                if (MultiRepAnalysis.this.autoOpenFirstPlayerCheckBox.isSelected() && MultiRepAnalysis.this.firstPlayerName != null) {
                                    MultiRepAnalysis.this.openPlayer(MultiRepAnalysis.this.firstPlayerName);
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                MultiRepAnalysis.this.removeInternalFrameListener(internalFrameAdapter);
            }

            private int countReplays(File file) {
                if (file.isFile()) {
                    return GuiUtils.SC2_REPLAY_FILTER.accept(file) ? 1 : 0;
                }
                File[] fileArray = file.listFiles();
                int n = 0;
                if (fileArray != null) {
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file2 = fileArray2[n3];
                        if (this.aborted) {
                            return 0;
                        }
                        n += this.countReplays(file2);
                        ++n3;
                    }
                }
                return n;
            }

            private void analyzeReplays(File file) {
                if (file.isFile()) {
                    if (GuiUtils.SC2_REPLAY_FILTER.accept(file)) {
                        ++this.analyzedCount;
                        Replay replay = ReplayCache.getReplay(file, this.buildOrderLength, this.timeExclusionForApm, this.cacheEnabled, this.cacheEnabled, null);
                        if (replay != null && replay.gameLength >= this.timeLimitToBeIncluded << 1) {
                            Object object;
                            int n;
                            Object object2;
                            Object object3;
                            int n2;
                            int n3;
                            Object object4;
                            Date date = new Date(replay.details.saveTime);
                            Details.Player[] playerArray = replay.details.players;
                            ReplayConsts.Format format = replay.initData.format;
                            ReplayConsts.Race race = null;
                            ReplayConsts.Race race2 = null;
                            PlayerGameParticipationStats[] playerGameParticipationStatsArray = new PlayerGameParticipationStats[playerArray.length];
                            int n4 = -1;
                            Details.Player[] playerArray2 = playerArray;
                            int n5 = playerArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                object4 = playerArray2[n6];
                                ++n4;
                                n3 = ((Details.Player)object4).lastActionFrame >> 6;
                                if (this.useRealTime) {
                                    n3 = replay.initData.gameSpeed.convertToRealTime(n3);
                                }
                                if (n3 >= this.timeLimitToBeIncluded) {
                                    n2 = Math.max(0, ((Details.Player)object4).lastActionFrame - replay.excludedInitialFrames) >> 6;
                                    if (this.useRealTime) {
                                        n2 = replay.initData.gameSpeed.convertToRealTime(n2);
                                    }
                                    if ((object3 = (PlayerStatistics)MultiRepAnalysis.this.playerStatisticsMap.get(((Details.Player)object4).fullName)) == null) {
                                        object3 = new PlayerStatistics((Details.Player)object4, replay.initData.gateway);
                                        MultiRepAnalysis.this.playerStatisticsMap.put(((Details.Player)object4).fullName, object3);
                                    }
                                    String[] stringArray = this.getTeamCompositions(replay.details, (Details.Player)object4, format);
                                    playerGameParticipationStatsArray[n4] = new PlayerGameParticipationStats(date, format, n3, n2, (Details.Player)object4, playerArray.length > 1 ? playerArray[playerArray[0] == object4 ? 1 : 0].finalRace : ReplayConsts.Race.UNKNOWN, replay.details.mapName, stringArray, replay.initData.gameType);
                                    ((PlayerStatistics)object3).buildInPlayerGameParticipation(playerGameParticipationStatsArray[n4]);
                                    if (format == ReplayConsts.Format.ONE_VS_ONE && ((Details.Player)object4).isWinner != null) {
                                        if (((Details.Player)object4).isWinner.booleanValue()) {
                                            race = ((Details.Player)object4).finalRace;
                                        } else {
                                            race2 = ((Details.Player)object4).finalRace;
                                        }
                                    }
                                    object2 = playerArray;
                                    int n7 = playerArray.length;
                                    n = 0;
                                    while (n < n7) {
                                        object = object2[n];
                                        if (object != object4) {
                                            (((Details.Player)object4).team != Integer.MAX_VALUE && ((Details.Player)object4).team == object.team ? playerGameParticipationStatsArray[n4].allyList : playerGameParticipationStatsArray[n4].opponentList).add(object.fullName);
                                        }
                                        ++n;
                                    }
                                    ((PlayerStatistics)object3).playerGameParticipationStatsList.add(playerGameParticipationStatsArray[n4]);
                                }
                                ++n6;
                            }
                            object4 = (MapStatistics)MultiRepAnalysis.this.mapStatisticsMap.get(replay.details.mapName);
                            if (object4 == null) {
                                object4 = new MapStatistics(replay.details.mapName);
                                MultiRepAnalysis.this.mapStatisticsMap.put(replay.details.mapName, object4);
                            }
                            ++((MapStatistics)object4).record.totalGames;
                            ((DateRangeStatistics)object4).registerDate(date);
                            if (race != null) {
                                Record record = ((MapStatistics)object4).getRaceRecord(race);
                                ++record.totalGames;
                                ++record.wins;
                            }
                            if (race2 != null) {
                                Record record = ((MapStatistics)object4).getRaceRecord(race2);
                                ++record.totalGames;
                                ++record.losses;
                            }
                            if (replay.initData.format == ReplayConsts.Format.ONE_VS_ONE) {
                                ReplayConsts.Building[][] buildingArray = new ReplayConsts.Building[playerArray.length][this.buildOrderLength];
                                int[] nArray = new int[playerArray.length];
                                int n8 = 0;
                                n3 = 0;
                                while (n3 < playerGameParticipationStatsArray.length) {
                                    if (playerGameParticipationStatsArray[n3] == null) {
                                        nArray[n3] = this.buildOrderLength;
                                        ++n8;
                                    }
                                    ++n3;
                                }
                                GameEvents.Action[] actionArray = replay.gameEvents.actions;
                                n2 = actionArray.length;
                                int n9 = 0;
                                while (n9 < n2) {
                                    object3 = actionArray[n9];
                                    if (object3 instanceof GameEvents.BuildAction && nArray[((GameEvents.Action)object3).player] < this.buildOrderLength) {
                                        buildingArray[((GameEvents.Action)object3).player][nArray[((GameEvents.Action)object3).player]] = ((GameEvents.BuildAction)object3).building;
                                        byte by = ((GameEvents.Action)object3).player;
                                        nArray[by] = nArray[by] + 1;
                                        if (nArray[by] == this.buildOrderLength && ++n8 == nArray.length) break;
                                    }
                                    ++n9;
                                }
                                n9 = buildingArray.length - 1;
                                while (n9 >= 0) {
                                    if (playerGameParticipationStatsArray[n9] != null) {
                                        object = buildingArray[n9];
                                        n = nArray[n9];
                                        if (n != 0) {
                                            StringBuilder stringBuilder = new StringBuilder();
                                            int n10 = 0;
                                            while (n10 < n) {
                                                if (stringBuilder.length() > 0) {
                                                    stringBuilder.append(", ");
                                                }
                                                stringBuilder.append(object[n10].stringValue);
                                                ++n10;
                                            }
                                            playerGameParticipationStatsArray[n9].buildOrder = object2 = stringBuilder.toString();
                                            BuildOrderStatistics buildOrderStatistics = (BuildOrderStatistics)MultiRepAnalysis.this.buildOrder1v1StatisticsMap.get(object2);
                                            if (buildOrderStatistics == null) {
                                                buildOrderStatistics = new BuildOrderStatistics((String)object2, playerGameParticipationStatsArray[n9].race);
                                                MultiRepAnalysis.this.buildOrder1v1StatisticsMap.put(object2, buildOrderStatistics);
                                            }
                                            buildOrderStatistics.buildInPlayerGameParticipation(playerGameParticipationStatsArray[n9]);
                                        }
                                    }
                                    --n9;
                                }
                            }
                        } else {
                            ++this.skippedCount;
                        }
                        this.updateProgressBar();
                    }
                } else {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        File[] fileArray2 = fileArray;
                        int n = fileArray.length;
                        int n11 = 0;
                        while (n11 < n) {
                            File file2 = fileArray2[n11];
                            if (this.aborted) {
                                return;
                            }
                            this.analyzeReplays(file2);
                            ++n11;
                        }
                    }
                }
            }

            private String[] getTeamCompositions(Details details, Details.Player player, ReplayConsts.Format format) {
                String[] stringArray;
                if (details.players.length == 0) {
                    return new String[0];
                }
                if (format == ReplayConsts.Format.ONE_VS_ONE) {
                    return new String[]{Character.toString(player.finalRace.letter), Character.toString((details.players.length > 1 ? details.players[details.players[0] == player ? 1 : 0].finalRace : ReplayConsts.Race.UNKNOWN).letter)};
                }
                this.helperPlayerList.set(0, player.name);
                details.rearrangePlayers(this.helperPlayerList);
                int[] nArray = details.getTeamOrderPlayerIndices();
                this.raceLetterList.clear();
                if (format == ReplayConsts.Format.FREE_FOR_ALL) {
                    stringArray = new String[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        this.raceLetterList.add(Character.valueOf(details.players[nArray[n]].raceLetter()));
                        ++n;
                    }
                    Collections.sort(this.raceLetterList);
                    n = nArray.length - 1;
                    while (n >= 0) {
                        stringArray[n] = Character.toString(this.raceLetterList.get(n).charValue());
                        --n;
                    }
                } else {
                    int n;
                    int n2 = 1;
                    int n3 = details.players[nArray[0]].team;
                    int n4 = 1;
                    while (n4 < nArray.length) {
                        n = details.players[nArray[n4]].team;
                        if (n != n3) {
                            n3 = n;
                            ++n2;
                        }
                        ++n4;
                    }
                    stringArray = new String[n2];
                    this.teamCompositionBuilder.setLength(0);
                    this.teamCompositionBuilder.append(details.players[nArray[0]].raceLetter());
                    this.teamCompositionBuilder.append('+');
                    n2 = 0;
                    n3 = details.players[nArray[0]].team;
                    n4 = 1;
                    while (n4 < nArray.length) {
                        n = details.players[nArray[n4]].team;
                        if (n != n3) {
                            Collections.sort(this.raceLetterList);
                            for (Character c : this.raceLetterList) {
                                this.teamCompositionBuilder.append(c);
                            }
                            stringArray[n2++] = this.teamCompositionBuilder.toString();
                            this.teamCompositionBuilder.setLength(0);
                            this.raceLetterList.clear();
                            n3 = n;
                        }
                        this.raceLetterList.add(Character.valueOf(details.players[nArray[n4]].raceLetter()));
                        ++n4;
                    }
                    Collections.sort(this.raceLetterList);
                    for (Character c : this.raceLetterList) {
                        this.teamCompositionBuilder.append(c);
                    }
                    stringArray[stringArray.length - 1] = this.teamCompositionBuilder.toString();
                }
                return stringArray;
            }

            private void updateProgressBar() {
                jProgressBar.setValue(this.analyzedCount);
                jProgressBar.setString(Language.getText("module.multiRepAnal.analysisStatus", this.analyzedCount, this.skippedCount, this.replaysCount, this.replaysCount == 0 ? 100 : 100 * this.analyzedCount / this.replaysCount));
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                normalThread.start();
            }
        });
    }

    private JComponent createPlayersTab() {
        Object object;
        Object[][] objectArray = new Object[this.playerStatisticsMap.size()][];
        int n = 0;
        for (PlayerStatistics object22 : this.playerStatisticsMap.values()) {
            objectArray[n++] = new Object[]{object22.fullName, object22.record.totalGames, object22.getAvgApm(), object22.record, object22.record.getWinRatio(), object22.getRaceDistributionString(), object22.getFormattedTotalTimeInGames(), ReplayUtils.formatMs(object22.getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL), object22.getPresence(), Float.valueOf(object22.getAvgGamesPerDay()), Language.formatDate(object22.firstDate), Language.formatDate(object22.lastDate)};
        }
        if (this.autoOpenFirstPlayerCheckBox.isSelected()) {
            boolean n2 = false;
            Object[][] objectArray2 = objectArray;
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                object = objectArray2[n4];
                if (n5 < (Integer)object[1]) {
                    this.firstPlayerName = (String)object[0];
                    n5 = (Integer)object[1];
                }
                ++n4;
            }
        }
        Holder<JTable> holder = new Holder<JTable>();
        int[] nArray = new int[2];
        nArray[0] = 1;
        object = this.createStatisticsTableTab("module.multiRepAnal.tab.players.info", new Object[]{this.playerStatisticsMap.size()}, 0, nArray, objectArray, PLAYERS_HEADER_NAMES, holder, null);
        ((JTable)holder.value).addMouseListener(this.playersTableMouseListener);
        this.registerEnterToOpenPlayer((JTable)holder.value);
        return object;
    }

    private void registerEnterToOpenPlayer(final JTable jTable) {
        Object object = new Object();
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), object);
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 64), object);
        jTable.getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.getSelectedRow() >= 0) {
                    String string = (String)jTable.getValueAt(jTable.getSelectedRow(), GuiUtils.getColumnViewIndex(jTable, 0));
                    MultiRepAnalysis.this.openPlayer(string);
                }
            }
        });
    }

    private void openPlayer(String string) {
        PlayerStatistics playerStatistics = this.playerStatisticsMap.get(string);
        if (playerStatistics == null) {
            return;
        }
        final Holder<JComponent> holder = new Holder<JComponent>();
        final ArrayList<ActionListener> arrayList = new ArrayList<ActionListener>();
        GuiUtils.addNewTab(string, Icons.USER, true, this.tabbedPane, this.createPlayerTab(playerStatistics, holder, arrayList), false, new Runnable(){

            @Override
            public void run() {
                for (ActionListener actionListener : arrayList) {
                    MultiRepAnalysis.this.stretchToWindowCheckBox.removeActionListener(actionListener);
                }
                MultiRepAnalysis.this.tabbedPane.setSelectedIndex(0);
            }
        });
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JComponent)holder.value).requestFocusInWindow();
            }
        });
    }

    private JComponent createMapsTab() {
        Object[][] objectArray = new Object[this.mapStatisticsMap.size()][];
        NullAwareComparable<Integer> nullAwareComparable = NullAwareComparable.getPercent(null);
        int n = 0;
        for (MapStatistics mapStatistics : this.mapStatisticsMap.values()) {
            Record record = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.PROTOSS);
            Record record2 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.TERRAN);
            Record record3 = mapStatistics.raceRecordMap.get((Object)ReplayConsts.Race.ZERG);
            objectArray[n++] = new Object[]{mapStatistics.name, mapStatistics.record.totalGames, NullAwareComparable.getPercent(mapStatistics.record.totalGames * 100 / this.replaysIncludedInAnalysis), record == null ? nullAwareComparable : record.getWinRatio(), record2 == null ? nullAwareComparable : record2.getWinRatio(), record3 == null ? nullAwareComparable : record3.getWinRatio(), Language.formatDate(mapStatistics.firstDate), Language.formatDate(mapStatistics.lastDate)};
        }
        int[] nArray = new int[2];
        nArray[0] = 1;
        return this.createStatisticsTableTab("module.multiRepAnal.tab.maps.info", new Object[]{this.mapStatisticsMap.size()}, 0, nArray, objectArray, MAPS_HEADER_NAMES, null, null);
    }

    private JComponent create1v1BuildOrdersTab() {
        Object[][] objectArray = new Object[this.buildOrder1v1StatisticsMap.size()][];
        int n = 0;
        for (BuildOrderStatistics buildOrderStatistics : this.buildOrder1v1StatisticsMap.values()) {
            Record record = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.PROTOSS);
            Record record2 = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.TERRAN);
            Record record3 = buildOrderStatistics.recordVsRaceMap.get((Object)ReplayConsts.Race.ZERG);
            objectArray[n++] = new Object[]{buildOrderStatistics.race, buildOrderStatistics.buildOrder, buildOrderStatistics.record.totalGames, buildOrderStatistics.record, buildOrderStatistics.record.getWinRatio(), record == null ? new Record() : record, record2 == null ? new Record() : record2, record3 == null ? new Record() : record3, Language.formatDate(buildOrderStatistics.firstDate), Language.formatDate(buildOrderStatistics.lastDate)};
        }
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[2] = 4;
        return this.createStatisticsTableTab("module.multiRepAnal.tab.1v1BuildOrders.info", new Object[]{this.buildOrder1v1StatisticsMap.size()}, 1, nArray, objectArray, BUILD_ORDERS_1V1_HEADER_NAMES, null, null);
    }

    private JComponent createPlayerTab(PlayerStatistics playerStatistics, Holder<JComponent> holder, List<ActionListener> list) {
        Object object;
        Object n52;
        Object object2;
        Object n9;
        Object object3;
        Object object4;
        JPanel jPanel = new JPanel(new BorderLayout());
        EnumMap<ReplayConsts.Format, PlayerStatistics> enumMap = new EnumMap<ReplayConsts.Format, PlayerStatistics>(ReplayConsts.Format.class);
        EnumMap<ReplayConsts.GameType, PlayerStatistics> enumMap2 = new EnumMap<ReplayConsts.GameType, PlayerStatistics>(ReplayConsts.GameType.class);
        HashMap hashMap = new HashMap(ReplayConsts.Format.values().length);
        HashMap<String, MapStatistics> hashMap2 = new HashMap<String, MapStatistics>();
        HashMap<String, BuildOrderStatistics> hashMap3 = new HashMap<String, BuildOrderStatistics>();
        HashMap<String, PlaymateStatistics> hashMap4 = new HashMap<String, PlaymateStatistics>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int[] nArray = new int[24];
        int[] nArray2 = new int[7];
        int[] nArray3 = new int[12];
        for (PlayerGameParticipationStats object72 : playerStatistics.playerGameParticipationStatsList) {
            block40: {
                block39: {
                    String n;
                    gregorianCalendar.setTime(object72.date);
                    int n2 = gregorianCalendar.get(11);
                    nArray[n2] = nArray[n2] + 1;
                    int n3 = gregorianCalendar.get(7) - 1;
                    nArray2[n3] = nArray2[n3] + 1;
                    int n4 = gregorianCalendar.get(2);
                    nArray3[n4] = nArray3[n4] + 1;
                    object4 = (PlayerStatistics)enumMap2.get((Object)object72.gameType);
                    if (object4 == null) {
                        object4 = new PlayerStatistics(null, null);
                        enumMap2.put(object72.gameType, (PlayerStatistics)object4);
                    }
                    ((PlayerStatistics)object4).buildInPlayerGameParticipation(object72);
                    object4 = (PlayerStatistics)enumMap.get((Object)object72.format);
                    if (object4 == null) {
                        object4 = new PlayerStatistics(null, null);
                        enumMap.put(object72.format, (PlayerStatistics)object4);
                    }
                    ((PlayerStatistics)object4).buildInPlayerGameParticipation(object72);
                    object3 = (Map)hashMap.get((Object)object72.format);
                    if (object3 == null) {
                        object3 = new HashMap<Object, PlayerStatistics>();
                        hashMap.put(object72.format, object3);
                    }
                    if (object72.format != ReplayConsts.Format.FREE_FOR_ALL && object72.format != ReplayConsts.Format.UNKNOWN) break block39;
                    n9 = new StringBuilder();
                    object2 = object72.teamCompositions;
                    int playmateStatistics = object72.teamCompositions.length;
                    int n6 = 0;
                    while (n6 < playmateStatistics) {
                        n = object2[n6];
                        if (((StringBuilder)n9).length() > 0) {
                            ((StringBuilder)n9).append('v');
                        }
                        ((StringBuilder)n9).append(n);
                        ++n6;
                    }
                    n = ((StringBuilder)n9).toString();
                    object4 = (PlayerStatistics)object3.get(n);
                    if (object4 == null) {
                        object4 = new PlayerStatistics(null, null);
                        object3.put(n, object4);
                    }
                    ((PlayerStatistics)object4).buildInPlayerGameParticipation(object72);
                    if (object72.format == ReplayConsts.Format.FREE_FOR_ALL) {
                        n = String.valueOf(object72.teamCompositions[0]) + "v" + ReplayConsts.Race.ANY.letter;
                        object4 = (PlayerStatistics)object3.get(n);
                        if (object4 == null) {
                            object4 = new PlayerStatistics(null, null);
                            object3.put(n, object4);
                        }
                        ((PlayerStatistics)object4).buildInPlayerGameParticipation(object72);
                    }
                    break block40;
                }
                n9 = object72.format == ReplayConsts.Format.ONE_VS_ONE ? "v" : " vs ";
                int record = 0;
                while (record < 3) {
                    block42: {
                        block41: {
                            if (object72.teamCompositions.length <= 1) break block41;
                            switch (record) {
                                case 0: {
                                    n52 = String.valueOf(object72.teamCompositions[0]) + (String)n9 + object72.teamCompositions[1];
                                    break block42;
                                }
                                case 1: {
                                    n52 = String.valueOf(object72.teamCompositions[0]) + (String)n9 + ReplayConsts.Race.ANY.letter;
                                    break block42;
                                }
                                case 2: {
                                    n52 = String.valueOf(ReplayConsts.Race.ANY.letter) + (String)n9 + object72.teamCompositions[1];
                                    break block42;
                                }
                                default: {
                                    throw new RuntimeException("Fix the cycle!");
                                }
                            }
                        }
                        if (record > 0) break;
                        n52 = object72.teamCompositions.length == 1 ? object72.teamCompositions[0] : Language.getText("general.unknown");
                    }
                    object4 = (PlayerStatistics)object3.get(n52);
                    if (object4 == null) {
                        object4 = new PlayerStatistics(null, null);
                        object3.put(n52, object4);
                    }
                    ((PlayerStatistics)object4).buildInPlayerGameParticipation(object72);
                    ++record;
                }
            }
            if ((n9 = (MapStatistics)hashMap2.get(object72.mapName)) == null) {
                n9 = new MapStatistics(object72.mapName);
                hashMap2.put(object72.mapName, (MapStatistics)n9);
            }
            ++((MapStatistics)n9).record.totalGames;
            if (object72.isWinner != null) {
                if (object72.isWinner.booleanValue()) {
                    ++((MapStatistics)n9).record.wins;
                } else {
                    ++((MapStatistics)n9).record.losses;
                }
            }
            ((DateRangeStatistics)n9).registerDate(object72.date);
            if (object72.format == ReplayConsts.Format.ONE_VS_ONE && object72.isWinner != null) {
                Record buildOrderStatistics = ((MapStatistics)n9).getRaceRecord(object72.race);
                ++buildOrderStatistics.totalGames;
                if (object72.isWinner.booleanValue()) {
                    ++buildOrderStatistics.wins;
                } else {
                    ++buildOrderStatistics.losses;
                }
            }
            if (object72.format == ReplayConsts.Format.ONE_VS_ONE) {
                BuildOrderStatistics string = (BuildOrderStatistics)hashMap3.get(object72.buildOrder);
                if (string == null) {
                    string = new BuildOrderStatistics(object72.buildOrder, object72.race);
                    hashMap3.put(object72.buildOrder, string);
                }
                string.buildInPlayerGameParticipation(object72);
            }
            for (String string : object72.allyList) {
                PlaymateStatistics playmateStatistics = (PlaymateStatistics)hashMap4.get(string);
                if (playmateStatistics == null) {
                    playmateStatistics = new PlaymateStatistics(string);
                    hashMap4.put(string, playmateStatistics);
                }
                playmateStatistics.buildInPlayerGameParticipation(object72, true);
            }
            for (String entry2 : object72.opponentList) {
                PlaymateStatistics object8 = (PlaymateStatistics)hashMap4.get(entry2);
                if (object8 == null) {
                    object8 = new PlaymateStatistics(entry2);
                    hashMap4.put(entry2, object8);
                }
                object8.buildInPlayerGameParticipation(object72, false);
            }
        }
        JLabel jLabel = new JLabel(Language.getText("module.multiRepAnal.tab.player.info", playerStatistics.fullName, playerStatistics.record.totalGames));
        GuiUtils.changeFontToBold(jLabel);
        jPanel.add((Component)jLabel, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        object4 = new JPanel(new BorderLayout());
        holder.value = object4;
        Collections.sort(playerStatistics.playerGameParticipationStatsList);
        object3 = new Holder();
        n9 = new ActionListener((Holder)object3){
            private final /* synthetic */ Holder val$chartCanvasHolder;
            {
                this.val$chartCanvasHolder = holder;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JComponent)this.val$chartCanvasHolder.value).repaint();
            }
        };
        Map.Entry n102 = Box.createHorizontalBox();
        ((Container)((Object)n102)).add(new JPanel(new BorderLayout()));
        ((Container)((Object)n102)).add(new JLabel(Language.getText("charts.chartType")));
        n52 = GuiUtils.createComboBox((Object[])ChartType.values(), "module.multiRepAnal.charts.chartType");
        ((JComponent)n52).setToolTipText(Language.getText("charts.chartTypeToolTip"));
        ((JComboBox)n52).addActionListener((ActionListener)n9);
        ((Container)((Object)n102)).add((Component)n52);
        ((Container)((Object)n102)).add(Box.createHorizontalStrut(5));
        ((Container)((Object)n102)).add(new JLabel(Language.getText("module.multiRepAnal.tab.player.tab.charts.granularity")));
        Object object5 = GuiUtils.createComboBox((Object[])ChartGranularity.values(), "module.multiRepAnal.charts.chartGranularity");
        object2 = new Holder();
        Object object6 = new ActionListener((JComboBox)object5, (Holder)object2, playerStatistics){
            private final /* synthetic */ JComboBox val$chartGranularityComboBox;
            private final /* synthetic */ Holder val$chartDataHolder;
            private final /* synthetic */ PlayerStatistics val$ps;
            {
                this.val$chartGranularityComboBox = jComboBox;
                this.val$chartDataHolder = holder;
                this.val$ps = playerStatistics;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChartGranularity chartGranularity = (ChartGranularity)((Object)this.val$chartGranularityComboBox.getSelectedItem());
                if (this.val$chartDataHolder.value == null || ((ChartData)this.val$chartDataHolder.value).chartGranularity != chartGranularity) {
                    this.val$chartDataHolder.value = new ChartData(this.val$ps, chartGranularity);
                }
            }
        };
        ((JComboBox)object5).addActionListener((ActionListener)object6);
        ((JComboBox)object5).addActionListener((ActionListener)n9);
        ((Container)((Object)n102)).add((Component)object5);
        ((Container)((Object)n102)).add(Box.createHorizontalStrut(5));
        ((Container)((Object)n102)).add(new JLabel(Language.getText("charts.graphApproximation")));
        JComboBox n8 = GuiUtils.createComboBox((Object[])ChartUtils.GraphApproximation.values(), "module.multiRepAnal.charts.graphApproximation");
        n8.addActionListener((ActionListener)n9);
        ((Container)((Object)n102)).add(n8);
        object6.actionPerformed(null);
        ((Container)((Object)n102)).add(new JPanel(new BorderLayout()));
        ((Container)object4).add((Component)((Object)n102), "North");
        object3.value = new JComponent((Holder)object3, playerStatistics, (Holder)object2, (JComboBox)n52, (JComboBox)object5, n8){
            private final /* synthetic */ Holder val$chartCanvasHolder;
            private final /* synthetic */ PlayerStatistics val$ps;
            private final /* synthetic */ Holder val$chartDataHolder;
            private final /* synthetic */ JComboBox val$chartTypeComboBox;
            private final /* synthetic */ JComboBox val$chartGranularityComboBox;
            private final /* synthetic */ JComboBox val$graphApproximationComboBox;
            {
                this.val$chartCanvasHolder = holder;
                this.val$ps = playerStatistics;
                this.val$chartDataHolder = holder2;
                this.val$chartTypeComboBox = jComboBox;
                this.val$chartGranularityComboBox = jComboBox2;
                this.val$graphApproximationComboBox = jComboBox3;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                ChartParams chartParams = new ChartParams();
                chartParams.chartCanvas = (JComponent)this.val$chartCanvasHolder.value;
                chartParams.g2 = (Graphics2D)graphics;
                chartParams.playerStatistics = this.val$ps;
                chartParams.segmentStats = ((ChartData)this.val$chartDataHolder.value).segmentStats;
                chartParams.chartType = (ChartType)((Object)this.val$chartTypeComboBox.getSelectedItem());
                chartParams.chartGranularity = (ChartGranularity)((Object)this.val$chartGranularityComboBox.getSelectedItem());
                chartParams.graphApproximation = (ChartUtils.GraphApproximation)((Object)this.val$graphApproximationComboBox.getSelectedItem());
                chartParams.width = this.getWidth();
                chartParams.height = this.getHeight();
                new ChartPainter(chartParams).paintChart();
            }
        };
        JComponent n7 = object3.value;
        ((Container)object4).add((Component)n7, "Center");
        Object object7 = new Object();
        ChartType[] chartTypeArray = ChartType.values();
        int n = chartTypeArray.length;
        int n11 = 0;
        while (n11 < n) {
            object = chartTypeArray[n11];
            object7 = new Object();
            ((JComponent)object4).getInputMap(1).put(((ChartType)((Object)object)).keyStroke, object7);
            ((JComponent)object4).getActionMap().put(object7, new AbstractAction((JComboBox)n52, (ChartType)((Object)object)){
                private final /* synthetic */ JComboBox val$chartTypeComboBox;
                private final /* synthetic */ ChartType val$chartType;
                {
                    this.val$chartTypeComboBox = jComboBox;
                    this.val$chartType = chartType;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$chartTypeComboBox.setSelectedItem((Object)this.val$chartType);
                }
            });
            ++n11;
        }
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.charts.title"), Icons.CHART_UP_COLOR, false, jTabbedPane, (JComponent)object4, null);
        object4 = new JPanel(new BorderLayout());
        object3 = new Holder();
        n9 = new ActionListener((Holder)object3){
            private final /* synthetic */ Holder val$chartCanvasHolder;
            {
                this.val$chartCanvasHolder = holder;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JComponent)this.val$chartCanvasHolder.value).repaint();
            }
        };
        n102 = Box.createHorizontalBox();
        ((Container)((Object)n102)).add(new JPanel(new BorderLayout()));
        ((Container)((Object)n102)).add(new JLabel(Language.getText("module.multiRepAnal.tab.player.tab.trends.type")));
        n52 = GuiUtils.createComboBox((Object[])TrendType.values(), "module.multiRepAnal.trends.trendType");
        ((JComponent)n52).setToolTipText(Language.getText("charts.chartTypeToolTip"));
        ((JComboBox)n52).addActionListener((ActionListener)n9);
        ((Container)((Object)n102)).add((Component)n52);
        ((Container)((Object)n102)).add(new JPanel(new BorderLayout()));
        ((Container)object4).add((Component)((Object)n102), "North");
        object3.value = new JComponent((Holder)object3, (JComboBox)n52, nArray, nArray2, nArray3){
            private final /* synthetic */ Holder val$chartCanvasHolder;
            private final /* synthetic */ JComboBox val$trendTypeComboBox;
            private final /* synthetic */ int[] val$hourlyActivities;
            private final /* synthetic */ int[] val$dailyActivities;
            private final /* synthetic */ int[] val$monthlyActivities;
            {
                this.val$chartCanvasHolder = holder;
                this.val$trendTypeComboBox = jComboBox;
                this.val$hourlyActivities = nArray;
                this.val$dailyActivities = nArray2;
                this.val$monthlyActivities = nArray3;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                TrendParams trendParams = new TrendParams();
                trendParams.chartCanvas = (JComponent)this.val$chartCanvasHolder.value;
                trendParams.g2 = (Graphics2D)graphics;
                trendParams.trendType = (TrendType)((Object)this.val$trendTypeComboBox.getSelectedItem());
                switch (trendParams.trendType) {
                    case HOURLY: {
                        trendParams.activityData = this.val$hourlyActivities;
                        break;
                    }
                    case DAILY: {
                        trendParams.activityData = this.val$dailyActivities;
                        break;
                    }
                    case MONTHLY: {
                        trendParams.activityData = this.val$monthlyActivities;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Insert proper activity data here!");
                    }
                }
                trendParams.width = this.getWidth();
                trendParams.height = this.getHeight();
                new TrendPainter(trendParams).paintChart();
            }
        };
        object5 = object3.value;
        ((Container)object4).add((Component)object5, "Center");
        object2 = new Object();
        object7 = TrendType.values();
        int entry3 = ((TrendType[])object7).length;
        int record = 0;
        while (record < entry3) {
            object6 = object7[record];
            object2 = new Object();
            ((JComponent)object4).getInputMap(1).put(((TrendType)((Object)object6)).keyStroke, object2);
            ((JComponent)object4).getActionMap().put(object2, new AbstractAction((JComboBox)n52, (TrendType)((Object)object6)){
                private final /* synthetic */ JComboBox val$trendTypeComboBox;
                private final /* synthetic */ TrendType val$trendType;
                {
                    this.val$trendTypeComboBox = jComboBox;
                    this.val$trendType = trendType;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$trendTypeComboBox.setSelectedItem((Object)this.val$trendType);
                }
            });
            ++record;
        }
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.trends.title"), Icons.CHART, false, jTabbedPane, (JComponent)object4, null);
        object4 = new JPanel(new BorderLayout());
        object3 = new Object[hashMap4.size()][];
        int nullAwareComparable = 0;
        for (Map.Entry n102 : hashMap4.entrySet()) {
            object5 = (PlaymateStatistics)n102.getValue();
            object3[nullAwareComparable++] = new Object[]{n102.getKey(), ((PlaymateStatistics)object5).recordAsAllies.totalGames + ((PlaymateStatistics)object5).recordAsOpponents.totalGames, ((PlaymateStatistics)object5).recordAsAllies.totalGames, ((PlaymateStatistics)object5).recordAsOpponents.totalGames, ((PlaymateStatistics)object5).recordAsAllies, ((PlaymateStatistics)object5).recordAsAllies.getWinRatio(), ((PlaymateStatistics)object5).recordAsOpponents, ((PlaymateStatistics)object5).recordAsOpponents.getWinRatio(), ((PlaymateStatistics)object5).getFormattedTotalTimeInGames(), Language.formatDate(((PlaymateStatistics)object5).firstDate), Language.formatDate(((PlaymateStatistics)object5).lastDate)};
        }
        n102 = new Holder();
        int[] nArray4 = new int[2];
        nArray4[0] = 1;
        n52 = this.createStatisticsTableTab("module.multiRepAnal.tab.players.info", new Object[]{hashMap4.size()}, 0, nArray4, (Object[][])object3, PLAYMATES_HEADER_NAMES, (Holder<JTable>)((Object)n102), list);
        ((JTable)((Holder)((Object)n102)).value).addMouseListener(this.playersTableMouseListener);
        this.registerEnterToOpenPlayer((JTable)((Holder)((Object)n102)).value);
        ((Container)object4).add((Component)n52);
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.playmates.title"), Icons.GROUP_LINK, false, jTabbedPane, (JComponent)object4, null);
        object4 = new JPanel(new BorderLayout());
        object3 = new Object[enumMap2.size()][];
        nullAwareComparable = 0;
        for (Map.Entry n102 : enumMap2.entrySet()) {
            object5 = (PlayerStatistics)n102.getValue();
            object3[nullAwareComparable++] = new Object[]{n102.getKey(), ((PlayerStatistics)object5).record.totalGames, ((PlayerStatistics)object5).getAvgApm(), ((PlayerStatistics)object5).record, ((PlayerStatistics)object5).record.getWinRatio(), ((PlayerStatistics)object5).getRaceDistributionString(), ((PlayerStatistics)object5).getFormattedTotalTimeInGames(), ReplayUtils.formatMs(((PlayerStatistics)object5).getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL), ((DateRangeStatistics)object5).getPresence(), Float.valueOf(((PlayerStatistics)object5).getAvgGamesPerDay()), Language.formatDate(((PlayerStatistics)object5).firstDate), Language.formatDate(((PlayerStatistics)object5).lastDate)};
        }
        int[] nArray5 = new int[2];
        nArray5[0] = 1;
        ((Container)object4).add(this.createStatisticsTableTab(null, null, 0, nArray5, (Object[][])object3, TYPE_RECORDS_HEADER_NAMES, null, list));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.typeRecords.title"), null, false, jTabbedPane, (JComponent)object4, null);
        object4 = new JPanel(new BorderLayout());
        object3 = new Object[enumMap.size()][];
        nullAwareComparable = 0;
        for (Map.Entry n102 : enumMap.entrySet()) {
            object5 = (PlayerStatistics)n102.getValue();
            object3[nullAwareComparable++] = new Object[]{n102.getKey(), ((PlayerStatistics)object5).record.totalGames, ((PlayerStatistics)object5).getAvgApm(), ((PlayerStatistics)object5).record, ((PlayerStatistics)object5).record.getWinRatio(), ((PlayerStatistics)object5).getRaceDistributionString(), ((PlayerStatistics)object5).getFormattedTotalTimeInGames(), ReplayUtils.formatMs(((PlayerStatistics)object5).getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL), ((DateRangeStatistics)object5).getPresence(), Float.valueOf(((PlayerStatistics)object5).getAvgGamesPerDay()), Language.formatDate(((PlayerStatistics)object5).firstDate), Language.formatDate(((PlayerStatistics)object5).lastDate)};
        }
        int[] nArray6 = new int[2];
        nArray6[0] = 1;
        ((Container)object4).add(this.createStatisticsTableTab(null, null, 0, nArray6, (Object[][])object3, FORMAT_RECORDS_HEADER_NAMES, null, list));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.formatRecords.title"), Icons.FORMAT, false, jTabbedPane, (JComponent)object4, null);
        object4 = new JTabbedPane();
        n52 = ReplayConsts.Format.values();
        int buildOrderStatistics = ((ReplayConsts.Format[])n52).length;
        nullAwareComparable = 0;
        while (nullAwareComparable < buildOrderStatistics) {
            object3 = n52[nullAwareComparable];
            object5 = (Map)hashMap.get(object3);
            if (object5 != null) {
                object2 = new JPanel(new BorderLayout());
                object6 = new Object[object5.size()][];
                record = 0;
                for (Map.Entry entry : object5.entrySet()) {
                    object = (PlayerStatistics)entry.getValue();
                    object6[record++] = new Object[]{entry.getKey(), ((PlayerStatistics)object).record.totalGames, ((PlayerStatistics)object).getAvgApm(), ((PlayerStatistics)object).record, ((PlayerStatistics)object).record.getWinRatio(), ((PlayerStatistics)object).getFormattedTotalTimeInGames(), ReplayUtils.formatMs(((PlayerStatistics)object).getAvgGameLength() * 1000, ReplayConsts.GameSpeed.NORMAL), ((DateRangeStatistics)object).getPresence(), Float.valueOf(((PlayerStatistics)object).getAvgGamesPerDay()), Language.formatDate(((PlayerStatistics)object).firstDate), Language.formatDate(((PlayerStatistics)object).lastDate)};
                }
                int[] nArray7 = new int[2];
                nArray7[0] = 1;
                ((Container)object2).add(this.createStatisticsTableTab(null, null, 0, nArray7, (Object[][])object6, MATCHUP_RECORDS_HEADER_NAMES, null, list));
                GuiUtils.addNewTab(object3.stringValue, null, false, (JTabbedPane)object4, (JComponent)object2, false, null);
            }
            ++nullAwareComparable;
        }
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.player.tab.matchupRecords.title"), Icons.RACE_ANY, false, jTabbedPane, (JComponent)object4, null);
        object4 = new JPanel(new BorderLayout());
        object3 = new Object[hashMap2.size()][];
        NullAwareComparable<Integer> n112 = NullAwareComparable.getPercent(null);
        buildOrderStatistics = 0;
        for (Object n52 : hashMap2.values()) {
            object2 = ((MapStatistics)n52).raceRecordMap.get((Object)ReplayConsts.Race.PROTOSS);
            object6 = ((MapStatistics)n52).raceRecordMap.get((Object)ReplayConsts.Race.TERRAN);
            Record record2 = ((MapStatistics)n52).raceRecordMap.get((Object)ReplayConsts.Race.ZERG);
            object3[buildOrderStatistics++] = new Object[]{((MapStatistics)n52).name, ((MapStatistics)n52).record.totalGames, NullAwareComparable.getPercent(((MapStatistics)n52).record.totalGames * 100 / playerStatistics.playerGameParticipationStatsList.size()), ((MapStatistics)n52).record, ((MapStatistics)n52).record.getWinRatio(), object2 == null ? n112 : ((Record)object2).getWinRatio(), object6 == null ? n112 : ((Record)object6).getWinRatio(), record2 == null ? n112 : record2.getWinRatio(), Language.formatDate(((MapStatistics)n52).firstDate), Language.formatDate(((MapStatistics)n52).lastDate)};
        }
        int[] nArray8 = new int[2];
        nArray8[0] = 1;
        ((Container)object4).add(this.createStatisticsTableTab(null, null, 0, nArray8, (Object[][])object3, PLAYER_MAPS_HEADER_NAMES, null, list));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.maps.title"), Icons.MAPS_STACK, false, jTabbedPane, (JComponent)object4, null);
        object4 = new JPanel(new BorderLayout());
        object3 = new Object[hashMap3.size()][];
        int n12 = 0;
        for (BuildOrderStatistics buildOrderStatistics2 : hashMap3.values()) {
            object5 = buildOrderStatistics2.recordVsRaceMap.get((Object)ReplayConsts.Race.PROTOSS);
            object2 = buildOrderStatistics2.recordVsRaceMap.get((Object)ReplayConsts.Race.TERRAN);
            object6 = buildOrderStatistics2.recordVsRaceMap.get((Object)ReplayConsts.Race.ZERG);
            object3[n12++] = new Object[]{buildOrderStatistics2.race, buildOrderStatistics2.buildOrder, buildOrderStatistics2.record.totalGames, buildOrderStatistics2.record, buildOrderStatistics2.record.getWinRatio(), object5 == null ? new Record() : object5, object2 == null ? new Record() : object2, object6 == null ? new Record() : object6, Language.formatDate(buildOrderStatistics2.firstDate), Language.formatDate(buildOrderStatistics2.lastDate)};
        }
        int[] nArray9 = new int[3];
        nArray9[0] = 2;
        nArray9[2] = 4;
        ((Container)object4).add(this.createStatisticsTableTab(null, null, 1, nArray9, (Object[][])object3, BUILD_ORDERS_1V1_HEADER_NAMES, null, list));
        GuiUtils.addNewTab(Language.getText("module.multiRepAnal.tab.1v1BuildOrders.title"), Icons.BLOCK, false, jTabbedPane, (JComponent)object4, null);
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    private JComponent createStatisticsTableTab(String string, Object[] objectArray, final int n, int[] nArray, Object[][] objectArray2, String[] stringArray, Holder<JTable> holder, List<ActionListener> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (string != null) {
            jPanel.add((Component)new JLabel(Language.getText(string, objectArray)), "North");
        }
        final JTable jTable = GuiUtils.createNonEditableTable();
        jPanel.add((Component)new JScrollPane(jTable), "Center");
        Box box = Box.createVerticalBox();
        box.add(jTable.getTableHeader());
        box.add(new JScrollPane(jTable));
        jPanel.add((Component)box, "Center");
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int n) {
                int n2 = this.getRowCount();
                if (n2 == 0) {
                    return super.getColumnClass(n);
                }
                if (n2 > 10) {
                    n2 = 10;
                }
                int n3 = 0;
                while (n3 < n2) {
                    Object object = this.getValueAt(n3, n);
                    if (object != null) {
                        return object.getClass();
                    }
                    ++n3;
                }
                return Object.class;
            }
        };
        defaultTableModel.setDataVector(objectArray2, stringArray);
        jTable.setModel(defaultTableModel);
        jTable.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>((TableModel)defaultTableModel, nArray){
            {
                super(tableModel);
                ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
                int[] nArray2 = nArray;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4;
                    arrayList.add(new RowSorter.SortKey(n4, (n4 = nArray2[n3]) == n5 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
                    ++n3;
                }
                this.setSortKeys(arrayList);
                this.setMaxSortKeys(3);
            }

            @Override
            public void toggleSortOrder(int n2) {
                ArrayList<RowSorter.SortKey> arrayList;
                if (n2 != n && ((arrayList = new ArrayList<RowSorter.SortKey>(this.getSortKeys())).isEmpty() || ((RowSorter.SortKey)arrayList.get(0)).getColumn() != n2)) {
                    arrayList.add(0, new RowSorter.SortKey(n2, SortOrder.DESCENDING));
                    if (arrayList.size() > this.getMaxSortKeys()) {
                        arrayList.remove(this.getMaxSortKeys());
                    }
                    this.setSortKeys(arrayList);
                    return;
                }
                super.toggleSortOrder(n2);
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable.setAutoResizeMode(MultiRepAnalysis.this.stretchToWindowCheckBox.isSelected() ? 4 : 0);
            }
        };
        actionListener.actionPerformed(null);
        this.stretchToWindowCheckBox.addActionListener(actionListener);
        if (list != null) {
            list.add(actionListener);
        }
        if (holder != null) {
            holder.value = jTable;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiUtils.packTable(jTable);
            }
        });
        return jPanel;
    }

    public static enum ChartGranularity {
        DAY("module.multiRepAnal.tab.player.tab.charts.granularity.day"),
        WEEK("module.multiRepAnal.tab.player.tab.charts.granularity.week"),
        MONTH("module.multiRepAnal.tab.player.tab.charts.granularity.month"),
        YEAR("module.multiRepAnal.tab.player.tab.charts.granularity.year");

        private final String stringValue;

        private ChartGranularity(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum ChartType {
        ACTIVITY("module.multiRepAnal.tab.player.tab.charts.chartType.activity", "module.multiRepAnal.tab.player.tab.charts.chartType.activity.yAxisLabel"),
        APM_DEVELOPMENT("module.multiRepAnal.tab.player.tab.charts.chartType.apmDevelopment", "module.multiRepAnal.tab.player.tab.charts.chartType.apmDevelopment.yAxisLabel"),
        WIN_RATIO_DEVELOPMENT("module.multiRepAnal.tab.player.tab.charts.chartType.winRatioDevelopment", "module.multiRepAnal.tab.player.tab.charts.chartType.winRatioDevelopment.yAxisLabel"),
        RACE_DISTRIBUTION("module.multiRepAnal.tab.player.tab.charts.chartType.raceDistribution", "module.multiRepAnal.tab.player.tab.charts.chartType.raceDistribution.yAxisLabel#2"),
        GAME_TYPE_DISTRIBUTION("module.multiRepAnal.tab.player.tab.charts.chartType.gameTypeDistribution", "module.multiRepAnal.tab.player.tab.charts.chartType.gameTypeDistribution.yAxisLabel"),
        FORMAT_DISTRIBUTION("module.multiRepAnal.tab.player.tab.charts.chartType.formatDistribution", "module.multiRepAnal.tab.player.tab.charts.chartType.formatDistribution.yAxisLabel");

        public final String stringValue;
        public final String yAxisLabelKey;
        public final KeyStroke keyStroke;

        private ChartType(String string2, String string3) {
            this.stringValue = Language.getText(string2);
            this.yAxisLabelKey = string3;
            this.keyStroke = KeyStroke.getKeyStroke(49 + this.ordinal(), 2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum TrendType {
        HOURLY("module.multiRepAnal.tab.player.tab.trends.hourly"),
        DAILY("module.multiRepAnal.tab.player.tab.trends.daily"),
        MONTHLY("module.multiRepAnal.tab.player.tab.trends.monthly");

        public final String stringValue;
        public final KeyStroke keyStroke;
        public final String[] labels;

        private TrendType(String string2) {
            this.stringValue = Language.getText(string2);
            this.keyStroke = KeyStroke.getKeyStroke(49 + this.ordinal(), 2);
            if ("module.multiRepAnal.tab.player.tab.trends.hourly".equals(string2)) {
                this.labels = new String[24];
                int n2 = 0;
                while (n2 < 24) {
                    this.labels[n2] = Integer.toString(n2);
                    ++n2;
                }
            } else if ("module.multiRepAnal.tab.player.tab.trends.daily".equals(string2)) {
                this.labels = new String[DAY_TEXT_KEYS.length];
                int n3 = 0;
                while (n3 < DAY_TEXT_KEYS.length) {
                    this.labels[n3] = Language.getText(DAY_TEXT_KEYS[n3]);
                    ++n3;
                }
            } else if ("module.multiRepAnal.tab.player.tab.trends.monthly".equals(string2)) {
                this.labels = new String[MONTH_TEXT_KEYS.length];
                int n4 = 0;
                while (n4 < MONTH_TEXT_KEYS.length) {
                    this.labels[n4] = Language.getText(MONTH_TEXT_KEYS[n4]);
                    ++n4;
                }
            } else {
                throw new RuntimeException("Set the labels for the trend: " + this.stringValue);
            }
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

