/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.ReplayOperationsPopupMenu;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.TemplateEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ReplayRenameDialog
extends BaseDialog {
    public ReplayRenameDialog(final ReplayOperationsPopupMenu.ReplayOpCallback replayOpCallback, final File[] fileArray) {
        super("replayops.renameDialog.title", Icons.DOCUMENT_RENAME);
        JPanel jPanel = new JPanel(new BorderLayout());
        final JTextField jTextField = new JTextField(Settings.getString("module.repSearch.results.renameTemplate"));
        jPanel.add((Component)GuiUtils.createNameTemplateEditor(jTextField, "/Fx"), "Center");
        JPanel jPanel2 = new JPanel();
        final JButton jButton = new JButton();
        GuiUtils.updateButtonText(jButton, "replayops.renameDialog.previewButton", new Object[0]);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton();
        GuiUtils.updateButtonText(jButton2, "replayops.renameDialog.renameButton", new Object[0]);
        jPanel2.add(jButton2);
        JButton jButton3 = this.createCloseButton("button.cancel");
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add((Component)jPanel, "North");
        final JTextArea jTextArea = new JTextArea(10, 50);
        jTextArea.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = actionEvent.getSource() == jButton;
                if (bl) {
                    jTextArea.setText("");
                }
                int n = 0;
                try {
                    try {
                        TemplateEngine templateEngine = new TemplateEngine(jTextField.getText());
                        int n2 = 0;
                        while (n2 < fileArray.length) {
                            File file = fileArray[n2];
                            String string = templateEngine.applyToReplay(file, file.getParentFile());
                            if (string == null) {
                                ++n;
                            } else if (bl) {
                                jTextArea.append(String.valueOf(string) + "\n");
                            } else {
                                File file2 = new File(file.getParent(), string);
                                if (file.renameTo(file2)) {
                                    if (replayOpCallback != null) {
                                        replayOpCallback.replayRenamed(file, file2, n2);
                                    }
                                } else {
                                    System.out.println("Failed to rename replay file!");
                                    ++n;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        GuiUtils.showErrorDialog(Language.getText("replayops.renameDialog.invalidTemplate"));
                        jTextField.requestFocusInWindow();
                        return;
                    }
                }
                finally {
                    jTextField.requestFocusInWindow();
                }
                if (bl) {
                    jTextArea.setCaretPosition(0);
                } else {
                    if (replayOpCallback != null) {
                        replayOpCallback.moveRenameDeleteEnded();
                    }
                    Settings.set("module.repSearch.results.renameTemplate", jTextField.getText());
                    if (n == 0) {
                        GuiUtils.showInfoDialog(Language.getText("replayops.renameDialog.successfullyRenamed", fileArray.length));
                    } else {
                        GuiUtils.showErrorDialog(new Object[]{Language.getText("replayops.renameDialog.successfullyRenamed", fileArray.length - n), Language.getText("replayops.renameDialog.failedToRename", n)});
                    }
                    ReplayRenameDialog.this.dispose();
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton.doClick();
        this.packAndShow(jTextField, false);
    }
}

