/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay.model;

import hu.belicza.andras.sc2gears.util.Pair;
import java.awt.Point;
import java.util.List;
import javax.swing.ImageIcon;

public class MapInfo {
    public int width;
    public int height;
    public int boundaryLeft;
    public int boundaryBottom;
    public int boundaryRight;
    public int boundaryTop;
    public ImageIcon previewIcon;
    public List<Pair<MapObject, Point>> mapObjectList;
    public List<Point> startLocationList;

    public String getSizeString() {
        return String.valueOf(this.width) + "x" + this.height;
    }

    public String getPlayableSizeString() {
        return String.valueOf(this.boundaryRight - this.boundaryLeft) + "x" + (this.boundaryTop - this.boundaryBottom);
    }

    public static enum MapObject {
        MINERAL_FIELD(1, 1, "MineralField", null),
        HIGH_YIELD_MINERAL_FIELD(1, 1, "RichMineralField", null),
        VESPENE_GEYSER(3, 3, "VespeneGeyser", null),
        SPACE_PLATFORM_GEYSER(3, 3, "SpacePlatformGeyser", null),
        OBSERVATORY(5, 5, "XelNagaTower", "Xel'Naga Tower"),
        DESTRUCTIBLE_ROCK_4X4(4, 4, "DestructibleRock4x4", "Destructible Rock"),
        DESTRUCTIBLE_ROCK_6X6(4, 4, "DestructibleRock6x6", "Destructible Rock"),
        DESTRUCTIBLE_ROCK_2X6_VERTICAL(2, 6, "DestructibleRock2x6Vertical", "Destructible Rock"),
        DESTRUCTIBLE_ROCK_2X6_HORIZONTAL(6, 2, "DestructibleRock2x6Horizontal", "Destructible Rock"),
        DESTRUCTIBLE_DERBIS_4X4(4, 4, "DestructibleDebris4x4", "Destructible Derbis"),
        DESTRUCTIBLE_DERBIS_6X6(6, 6, "DestructibleDebris6x6", "Destructible Derbis");

        public final int width;
        public final int height;
        public final String toolTip;
        public final String binaryValue;

        private MapObject(int n2, int n3, String string2, String string3) {
            this.width = n2;
            this.height = n3;
            this.binaryValue = string2;
            this.toolTip = string3;
        }

        public static MapObject fromBinaryValue(String string) {
            MapObject[] mapObjectArray = MapObject.values();
            int n = mapObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                MapObject mapObject = mapObjectArray[n2];
                if (mapObject.binaryValue.equals(string)) {
                    return mapObject;
                }
                ++n2;
            }
            return null;
        }
    }
}

