/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay.model;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Details {
    public Player[] players;
    public String mapName;
    public String mapPreviewFileName;
    public long saveTime;
    private int[] teamOrderPlayerIndices;

    public String getPlayerNames() {
        int[] nArray = this.getTeamOrderPlayerIndices();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.players[nArray[n]].name);
            ++n;
        }
        return stringBuilder.toString();
    }

    public String getPlayerNamesGrouped() {
        int[] nArray = this.getTeamOrderPlayerIndices();
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.players[nArray[0]].team;
        boolean bl = true;
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            Player player = this.players[n4];
            if (player.team != n) {
                stringBuilder.append(" vs ");
                n = player.team;
                bl = true;
            }
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(player.name);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public String getPlayerFullNames() {
        int[] nArray = this.getTeamOrderPlayerIndices();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.players[nArray[n]].fullName);
            ++n;
        }
        return stringBuilder.toString();
    }

    public String getRaceMatchup() {
        int[] nArray = this.getTeamOrderPlayerIndices();
        StringBuilder stringBuilder = new StringBuilder();
        int n = nArray.length == 0 ? -1 : this.players[nArray[0]].team;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = this.players[nArray[n2]].team;
            if (n3 != n) {
                stringBuilder.append('v');
                n = n3;
            }
            stringBuilder.append(this.players[nArray[n2]].raceLetter());
            ++n2;
        }
        return stringBuilder.toString();
    }

    public int[] getTeamOrderPlayerIndices() {
        return this.getTeamOrderPlayerIndices(new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                return nArray[0] - nArray2[0];
            }
        });
    }

    public int[] getTeamOrderPlayerIndices(Comparator<int[]> comparator) {
        if (this.teamOrderPlayerIndices == null) {
            int[][] nArrayArray = new int[this.players.length][];
            int n = 0;
            while (n < nArrayArray.length) {
                nArrayArray[n] = new int[]{this.players[n].team, n};
                ++n;
            }
            Arrays.sort(nArrayArray, comparator);
            this.teamOrderPlayerIndices = new int[this.players.length];
            n = 0;
            while (n < nArrayArray.length) {
                this.teamOrderPlayerIndices[n] = nArrayArray[n][1];
                ++n;
            }
        }
        return this.teamOrderPlayerIndices;
    }

    public void rearrangePlayers(final List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        final ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        block0: for (String string : list) {
            Player[] playerArray = this.players;
            int n = this.players.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                if (player.name.equals(string)) {
                    if (arrayList.contains(player.team)) continue block0;
                    arrayList.add(player.team);
                    continue block0;
                }
                ++n2;
            }
        }
        this.teamOrderPlayerIndices = null;
        this.getTeamOrderPlayerIndices(new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                if (nArray[0] == nArray2[0]) {
                    int n = list.indexOf(Details.this.players[nArray[1]].name);
                    int n2 = list.indexOf(Details.this.players[nArray2[1]].name);
                    if (n < 0 && n2 >= 0) {
                        return 1;
                    }
                    if (n >= 0 && n2 < 0) {
                        return -1;
                    }
                    if (n >= 0 && n2 >= 0) {
                        return n - n2;
                    }
                    return 0;
                }
                int n = arrayList.indexOf(nArray[0]);
                int n3 = arrayList.indexOf(nArray2[0]);
                if (n < 0 && n3 >= 0) {
                    return 1;
                }
                if (n >= 0 && n3 < 0) {
                    return -1;
                }
                if (n >= 0 && n3 >= 0 && n != n3) {
                    return n - n3;
                }
                return nArray[0] - nArray2[0];
            }
        });
    }

    public void setTeamIsWinner(int n, Boolean bl) {
        Player[] playerArray = this.players;
        int n2 = this.players.length;
        int n3 = 0;
        while (n3 < n2) {
            Player player = playerArray[n3];
            if (player.team == n) {
                player.isWinner = bl;
            }
            ++n3;
        }
    }

    public static class Player {
        public static final int TEAM_UNKNOWN = Integer.MAX_VALUE;
        public String name;
        public int battleNetSubid;
        public int battleNetId;
        public String fullName;
        public String raceString;
        public final int[] argbColor = new int[4];
        public int lastActionFrame;
        public int actionsCount;
        public int excludedActionsCount;
        public ReplayConsts.PlayerType type = ReplayConsts.PlayerType.UNKNOWN;
        public ReplayConsts.Race race = ReplayConsts.Race.UNKNOWN;
        public ReplayConsts.Race finalRace;
        public int team = Integer.MAX_VALUE;
        public Point startLocation;
        public ReplayConsts.Difficulty difficulty = ReplayConsts.Difficulty.UNKNOWN;
        public ReplayConsts.PlayerColor playerColor = ReplayConsts.PlayerColor.UNKNOWN;
        public int handicap = 100;
        public Boolean isWinner;

        public String raceString() {
            if (this.race == ReplayConsts.Race.RANDOM) {
                return (Object)((Object)ReplayConsts.Race.RANDOM) + " (" + this.finalRace.stringValue + ")";
            }
            return this.finalRace.stringValue;
        }

        public char raceLetter() {
            return this.finalRace.isConcrete ? this.finalRace.letter : (this.race == ReplayConsts.Race.RANDOM ? ReplayConsts.Race.RANDOM.letter : ReplayConsts.Race.UNKNOWN.letter);
        }

        public Color getColor() {
            return new Color(this.argbColor[1], this.argbColor[2], this.argbColor[3]);
        }

        public Color getDarkerColor() {
            return new Color(this.argbColor[1] >> 1, this.argbColor[2] >> 1, this.argbColor[3] >> 1);
        }

        public Color getBrighterColor() {
            return new Color(127 + (this.argbColor[1] >> 1), 127 + (this.argbColor[2] >> 1), 127 + (this.argbColor[3] >> 1));
        }

        public String getColorName() {
            return String.valueOf(this.playerColor == ReplayConsts.PlayerColor.UNKNOWN ? "(" : String.valueOf(this.playerColor.stringValue) + " (") + this.argbColor[1] + "," + this.argbColor[2] + "," + this.argbColor[3] + ")";
        }
    }
}

