/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.sc2replay.AbilityCodes;
import hu.belicza.andras.sc2gears.sc2replay.Parser;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.InitData;
import hu.belicza.andras.sc2gears.sc2replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import hu.belicza.andras.sc2gears.util.Pair;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class ReplayParser
extends Parser {
    private static final byte[] STAR_S2MA = new byte[]{42, 115, 50, 109, 97};
    private static final byte[] S2MA = new byte[]{115, 50, 109, 97};
    private static final int EVENT_TYPE_INITIALIZATION = 0;
    private static final int EVENT_TYPE_ACTION = 1;
    private static final int EVENT_TYPE_UNNAMED = 2;
    private static final int EVENT_TYPE_REPLAY = 3;
    private static final int EVENT_TYPE_INACTION = 4;
    private static final int EVENT_TYPE_SYSTEM = 5;
    private static final byte OP_CODE_AUTO_SYNC = 0;
    private static final byte OP_CODE_GAME_START = 5;
    private static final byte OP_CODE_ALLIANCE = 6;
    private static final byte OP_CODE_PLAYER_LEAVE = 9;
    private static final byte OP_CODE_USE_ABILITY = 11;
    private static final byte OP_CODE_PLAYER_INIT_JOIN = 11;
    private static final byte OP_CODE_SELECT_FOLLOW_UP = -119;
    private static final byte OP_CODE_SELECT_DESELECT = -84;
    protected final Replay replay;
    protected byte opCode;

    public ReplayParser(Replay replay) {
        this.replay = replay;
    }

    public void parseInitData(byte[] byArray) {
        InitData initData = this.replay.initData = new InitData();
        this.setWrapper(byArray, ByteOrder.LITTLE_ENDIAN);
        int n = this.wrapper.get() & 0xFF;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < n) {
            String string = this.readString();
            arrayList.add(string);
            this.wrapper.position(this.wrapper.position() + 5);
            ++n2;
        }
        initData.clientNames = arrayList.toArray(new String[arrayList.size()]);
        if (this.positionAfter(STAR_S2MA)) {
            this.wrapper.getShort();
            initData.gateway = ReplayConsts.Gateway.fromBinaryValue(this.readStringWithLength(2));
            n2 = 1;
            int n3 = 0;
            while (n3 < 4 && n2 != 0) {
                n2 &= this.positionAfter(S2MA);
                ++n3;
            }
            if (n2 != 0) {
                this.wrapper.position(this.wrapper.position() + 4);
                byte[] byArray2 = new byte[32];
                this.wrapper.get(byArray2);
                String string = SharedUtils.convertToHexString(byArray2);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.charAt(0)).append(string.charAt(1)).append('/').append(string.charAt(2)).append(string.charAt(3)).append('/').append(string).append(".s2ma");
                initData.mapFileName = stringBuilder.toString();
            }
        } else {
            initData.gameType = ReplayConsts.GameType.SINGLE_PLAYER;
        }
    }

    public void parseDetails(byte[] byArray) {
        Details details = this.replay.details = new Details();
        this.setWrapper(byArray, ByteOrder.LITTLE_ENDIAN);
        this.wrapper.getInt();
        this.wrapper.getShort();
        int n = (this.wrapper.get() & 0xFF) >> 1;
        this.wrapper.position(7);
        ArrayList<Details.Player> arrayList = new ArrayList<Details.Player>(n);
        int n2 = 0;
        while (n2 < n) {
            Details.Player player = new Details.Player();
            this.wrapper.getInt();
            player.name = this.readStringWithLength(this.readValueStrut());
            if (player.name.length() == 0) {
                this.wrapper.position(this.wrapper.position() + 51 + (n - n2 - 2) * 56);
                break;
            }
            this.wrapper.get();
            this.wrapper.getInt();
            this.readValueStrut();
            this.wrapper.getShort();
            this.wrapper.getInt();
            this.wrapper.getShort();
            player.battleNetSubid = this.readValueStrut();
            this.wrapper.getShort();
            player.battleNetId = this.readValueStrut();
            player.fullName = player.name;
            this.wrapper.get();
            if (this.wrapper.get() != 2) {
                this.wrapper.get();
            }
            player.raceString = this.readStringWithLength(this.readValueStrut());
            this.wrapper.getShort();
            int n3 = this.wrapper.get() & 0xFF;
            int n4 = 0;
            while (n4 < 4) {
                this.wrapper.getShort();
                player.argbColor[n4] = this.readValueStrut();
                ++n4;
            }
            n4 = 4;
            while (n4 <= n3) {
                this.wrapper.getShort();
                this.readValueStrut();
                ++n4;
            }
            arrayList.add(player);
            ++n2;
        }
        details.players = arrayList.toArray(new Details.Player[arrayList.size()]);
        this.wrapper.getShort();
        details.mapName = this.readStringWithLength(this.readValueStrut());
        this.wrapper.getShort();
        this.readStringWithLength(this.readValueStrut());
        this.wrapper.getShort();
        this.wrapper.get();
        this.wrapper.getShort();
        details.mapPreviewFileName = this.readStringWithLength(this.readValueStrut());
        this.wrapper.getShort();
        this.wrapper.get();
        this.wrapper.getShort();
        details.saveTime = (this.readLongValueStrut() - 116444736000000000L) / 10000L;
    }

    public void parseAttributesEvents(byte[] byArray) {
        if (byArray.length == 0) {
            return;
        }
        this.setWrapper(byArray, ByteOrder.LITTLE_ENDIAN);
        this.wrapper.getInt();
        ArrayList<Pair<Integer, String>> arrayList = new ArrayList<Pair<Integer, String>>(4);
        ArrayList<Pair<Integer, String>> arrayList2 = new ArrayList<Pair<Integer, String>>(4);
        ArrayList<Pair<Integer, String>> arrayList3 = new ArrayList<Pair<Integer, String>>(6);
        ArrayList<Pair<Integer, String>> arrayList4 = new ArrayList<Pair<Integer, String>>(8);
        ArrayList<Pair<Integer, String>> arrayList5 = new ArrayList<Pair<Integer, String>>(8);
        Details.Player[] playerArray = this.replay.details.players;
        int n = this.wrapper.getInt();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            this.wrapper.getInt();
            short s = this.wrapper.getShort();
            this.wrapper.getShort();
            int n4 = (this.wrapper.get() & 0xFF) - 1;
            String string = this.readStringWithLength(4);
            try {
                switch (s) {
                    case 500: {
                        playerArray[n4].type = ReplayConsts.PlayerType.fromBinaryValue(string);
                        break;
                    }
                    case 3001: {
                        playerArray[n4].race = ReplayConsts.Race.fromBinaryValue(string);
                        break;
                    }
                    case 2001: {
                        this.replay.initData.format = ReplayConsts.Format.fromBinaryValue(string.indexOf(0) < 0 ? string : string.substring(0, string.indexOf(0)));
                        break;
                    }
                    case 2002: {
                        arrayList.add(new Pair<Integer, String>(n4, string));
                        break;
                    }
                    case 2003: {
                        arrayList2.add(new Pair<Integer, String>(n4, string));
                        break;
                    }
                    case 2004: {
                        arrayList3.add(new Pair<Integer, String>(n4, string));
                        break;
                    }
                    case 2005: {
                        arrayList4.add(new Pair<Integer, String>(n4, string));
                        break;
                    }
                    case 2006: {
                        arrayList5.add(new Pair<Integer, String>(n4, string));
                        break;
                    }
                    case 3000: {
                        this.replay.initData.gameSpeed = ReplayConsts.GameSpeed.fromBinaryValue(string);
                        break;
                    }
                    case 3009: {
                        this.replay.initData.gameType = ReplayConsts.GameType.fromBinaryValue(string.indexOf(0) < 0 ? string : string.substring(0, string.indexOf(0)));
                        break;
                    }
                    case 3007: {
                        if (n2 < n4) {
                            n2 = n4;
                        }
                        break;
                    }
                    case 3004: {
                        playerArray[n4].difficulty = ReplayConsts.Difficulty.fromBinaryValue(string);
                        break;
                    }
                    case 3002: {
                        playerArray[n4].playerColor = ReplayConsts.PlayerColor.fromBinaryValue(string);
                        break;
                    }
                    case 3003: {
                        int n5 = 0;
                        int n6 = 3;
                        while (n6 >= 0) {
                            char c = string.charAt(n6);
                            if (c != ' ') {
                                n5 = n5 * 10 + (c - 48);
                            }
                            --n6;
                        }
                        playerArray[n4].handicap = n5;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++n3;
        }
        ArrayList<Pair<Integer, String>> arrayList6 = null;
        switch (this.replay.initData.format) {
            case ONE_VS_ONE: {
                arrayList6 = arrayList;
                break;
            }
            case TWO_VS_TWO: {
                arrayList6 = arrayList2;
                break;
            }
            case THREE_VS_THREE: {
                arrayList6 = arrayList3;
                break;
            }
            case FOUR_VS_FOUR: {
                arrayList6 = arrayList4;
                break;
            }
            case FREE_FOR_ALL: {
                arrayList6 = arrayList5;
            }
        }
        if (arrayList6 != null) {
            for (Pair pair : arrayList6) {
                if ((Integer)pair.value1 >= playerArray.length) continue;
                playerArray[((Integer)pair.value1).intValue()].team = ((String)pair.value2).charAt(0) - 48;
            }
        }
        if (playerArray.length >= n2) {
            this.replay.details.players = Arrays.copyOfRange(playerArray, 0, n2 + 1);
        }
    }

    public void parseMessageEvents(byte[] byArray) {
        MessageEvents messageEvents = this.replay.messageEvents = new MessageEvents();
        this.setWrapper(byArray, ByteOrder.LITTLE_ENDIAN);
        int n = 0;
        while (n + 2 < byArray.length && byArray[n] == 0 && byArray[n + 2] == -128) {
            n += 7;
        }
        this.wrapper.position(n);
        ArrayList<MessageEvents.Blink> arrayList = new ArrayList<MessageEvents.Blink>();
        while (this.wrapper.hasRemaining()) {
            int n2 = this.wrapper.get() & 0xFF;
            int n3 = n2 >> 2;
            if ((n2 & 1) != 0) {
                n3 = (n3 << 8) + (this.wrapper.get() & 0xFF);
            } else if ((n2 & 2) != 0) {
                n3 = (n3 << 16) + ((this.wrapper.get() & 0xFF) << 8) + (this.wrapper.get() & 0xFF);
            }
            n3 = n3 * 125 / 2;
            int n4 = (this.wrapper.get() & 0xF) - 1;
            this.opCode = this.wrapper.get();
            MessageEvents.Message message = this.opCode == -125 ? new MessageEvents.Blink() : new MessageEvents.Text((byte)(this.opCode & 7));
            message.time = n3;
            message.client = n4;
            if (this.opCode == -125) {
                message.x = Integer.reverseBytes(this.wrapper.getInt()) >> 1;
                message.y = Integer.reverseBytes(this.wrapper.getInt()) >> 1;
            } else {
                int n5 = this.wrapper.get() & 0xFF;
                if ((this.opCode & 8) != 0) {
                    n5 += 64;
                }
                if ((this.opCode & 0x10) != 0) {
                    n5 += 128;
                }
                ((MessageEvents.Text)message).text = this.readStringWithLength(n5);
            }
            arrayList.add((MessageEvents.Blink)message);
        }
        messageEvents.messages = arrayList.toArray(new MessageEvents.Message[arrayList.size()]);
    }

    public void parseGameEvents(byte[] byArray) {
        ArrayList<Integer> arrayList;
        int n;
        AbilityCodes abilityCodes = ReplayUtils.getAbilityCodesForVersion(this.replay.buildNumbers);
        Details.Player[] playerArray = this.replay.details.players;
        byte by = (byte)playerArray.length;
        HashMap<Integer, List<Integer>> hashMap = new HashMap<Integer, List<Integer>>();
        int n2 = 0;
        while (n2 < playerArray.length) {
            n = playerArray[n2].team;
            arrayList = (ArrayList<Integer>)hashMap.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>(4);
                hashMap.put(n, arrayList);
            }
            arrayList.add(n2);
            ++n2;
        }
        this.replay.gameEvents = new GameEvents(this.replay, abilityCodes.UNIT_TYPE_NAME);
        this.setWrapper(byArray, ByteOrder.LITTLE_ENDIAN);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        n = 0;
        int n3 = this.replay.excludedInitialFrames = Settings.getInt("settings.misc.initialTimeToExcludeFromApm") << 6;
        int n4 = 0;
        int n5 = 0;
        this.opCode = 0;
        while (this.wrapper.hasRemaining()) {
            n4 = n5;
            byte by2 = this.opCode;
            n5 = this.wrapper.position();
            int n6 = this.wrapper.get() & 0xFF;
            int n7 = n6 >> 2;
            if ((n6 & 1) != 0) {
                n7 = (n7 << 8) + (this.wrapper.get() & 0xFF);
            } else if ((n6 & 2) != 0) {
                n7 = (this.wrapper.get() & 0xFF) >> 2;
            }
            n += n7 << 2;
            byte by3 = this.wrapper.get();
            byte by4 = (byte)((by3 & 0xF) - 1);
            this.opCode = this.wrapper.get();
            int n8 = this.opCode & 0xF0;
            int n9 = this.opCode & 0xF;
            arrayList = null;
            block0 : switch ((by3 & 0xE0) >> 5) {
                case 0: {
                    switch (this.opCode) {
                        case 11: 
                        case 27: 
                        case 43: {
                            break block0;
                        }
                        case 5: {
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", this.opCode) + ", event desc=0x" + String.format("%02x", by3) + ": INITIALIZATION), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by2) + ", total parsed: " + arrayList2.size() + ", stream pos: 0x" + String.format("%04x", this.wrapper.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    this.wrapper.position(this.wrapper.limit());
                    break;
                }
                case 1: {
                    if (this.opCode == -84 || n9 == 12 && n8 < 160) {
                        arrayList = this.readSelectAction();
                        break;
                    }
                    if (n9 == 13 && n8 < 160) {
                        arrayList = this.readHotkeyAction();
                        break;
                    }
                    if (n9 == 15 && n8 > 0 && n8 < 144) {
                        arrayList = this.parseSendResourcesAction();
                        break;
                    }
                    switch (this.opCode) {
                        case -117: 
                        case 11: {
                            arrayList = this.readUseAbilityAction(abilityCodes);
                            break;
                        }
                        case 9: {
                            if (by4 >= by) break block0;
                            arrayList = this.replay.gameEvents.new GameEvents.LeaveGameAction();
                            this.trackPlayerLeave(hashMap, by4);
                            break;
                        }
                        default: {
                            System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", this.opCode) + ", event desc=0x" + String.format("%02x", by3) + ": ACTION), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by2) + ", total parsed: " + arrayList2.size() + ", stream pos: 0x" + String.format("%04x", this.wrapper.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                            this.wrapper.position(this.wrapper.limit());
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.opCode) {
                        case 115: {
                            arrayList = this.replay.gameEvents.new GameEvents.DecreaseGameSpeedAction();
                            this.wrapper.get();
                            break block0;
                        }
                        case -125: {
                            arrayList = this.replay.gameEvents.new GameEvents.IncreaseGameSpeedAction();
                            this.wrapper.get();
                            break block0;
                        }
                        case 6: {
                            arrayList = this.replay.gameEvents.new GameEvents.AllianceAction();
                            this.wrapper.position(this.wrapper.position() + 8);
                            break block0;
                        }
                        case 7: {
                            this.wrapper.getInt();
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", this.opCode) + ", event desc=0x" + String.format("%02x", by3) + ": UNNAMED), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by2) + ", total parsed: " + arrayList2.size() + ", stream pos: 0x" + String.format("%04x", this.wrapper.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    this.wrapper.position(this.wrapper.limit());
                    break;
                }
                case 3: {
                    if (n9 == 1) {
                        arrayList = this.readMoveScreenAction();
                        break;
                    }
                    switch (this.opCode) {
                        case 8: {
                            short s = this.wrapper.getShort();
                            this.wrapper.position(this.wrapper.position() + ((s & 0xF) << 1) * 4);
                            break block0;
                        }
                        case -121: {
                            this.wrapper.position(this.wrapper.position() + 8);
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", this.opCode) + ", event desc=0x" + String.format("%02x", by3) + ": REPLAY), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by2) + ", total parsed: " + arrayList2.size() + ", stream pos: 0x" + String.format("%04x", this.wrapper.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    this.wrapper.position(this.wrapper.limit());
                    break;
                }
                case 4: {
                    if (n9 == 6 && n8 > 0 && n8 < 144) {
                        arrayList = this.parseRequestResourcesAction();
                        break;
                    }
                    if (n9 == 8 && n8 > 0 && n8 < 144) {
                        arrayList = this.replay.gameEvents.new GameEvents.CancelResRequestAction();
                        this.wrapper.getInt();
                        break;
                    }
                    if (n9 == 12) break;
                    switch (this.opCode) {
                        case -58: {
                            this.wrapper.position(this.wrapper.position() + 16);
                            break block0;
                        }
                        case 0: {
                            this.wrapper.getInt();
                            break block0;
                        }
                        case -121: {
                            this.wrapper.getInt();
                            break block0;
                        }
                        case -126: {
                            this.wrapper.getShort();
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", this.opCode) + ", event desc=0x" + String.format("%02x", by3) + ": INACTION), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by2) + ", total parsed: " + arrayList2.size() + ", stream pos: 0x" + String.format("%04x", this.wrapper.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    this.wrapper.position(this.wrapper.limit());
                    break;
                }
                case 5: {
                    switch (this.opCode) {
                        case -119: {
                            this.wrapper.getInt();
                            break block0;
                        }
                    }
                    System.out.println("Unrecognized action (opCode=0x" + String.format("%02x", this.opCode) + ", event desc=0x" + String.format("%02x", by3) + ": SYSTEM), aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by2) + ", total parsed: " + arrayList2.size() + ", stream pos: 0x" + String.format("%04x", this.wrapper.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    this.wrapper.position(this.wrapper.limit());
                    break;
                }
                default: {
                    System.out.println("Unrecognized event desc: 0x" + String.format("%02x", by3) + ", aborting parse.\n\t(last opcode: 0x" + String.format("%02x", by2) + ", total parsed: " + arrayList2.size() + ", stream pos: 0x" + String.format("%04x", this.wrapper.position()) + ", last action startPos: 0x" + String.format("%04x", n4) + " )");
                    this.wrapper.position(this.wrapper.limit());
                }
            }
            if (arrayList == null || by4 < 0 || by4 >= by) continue;
            ((GameEvents.Action)((Object)arrayList)).player = by4;
            ((GameEvents.Action)((Object)arrayList)).opCode = this.opCode;
            ((GameEvents.Action)((Object)arrayList)).frame = n;
            if (((GameEvents.Action)((Object)arrayList)).type != ReplayConsts.ActionType.INACTION) {
                playerArray[by4].lastActionFrame = n;
                ++playerArray[by4].actionsCount;
                if (n < n3) {
                    ++playerArray[by4].excludedActionsCount;
                }
            }
            arrayList2.add(arrayList);
        }
        this.completeWinnerDetection(hashMap);
        this.replay.gameEvents.actions = arrayList2.toArray(new GameEvents.Action[arrayList2.size()]);
    }

    private GameEvents.Action parseRequestResourcesAction() {
        GameEvents.RequestResoucesAction requestResoucesAction = this.replay.gameEvents.new GameEvents.RequestResoucesAction();
        this.wrapper.getInt();
        this.wrapper.getInt();
        this.wrapper.getInt();
        requestResoucesAction.minRequested = this.wrapper.getInt();
        requestResoucesAction.gasRequested = this.wrapper.getInt();
        this.wrapper.getInt();
        return requestResoucesAction;
    }

    private GameEvents.Action parseSendResourcesAction() {
        GameEvents.SendResourcesAction sendResourcesAction = this.replay.gameEvents.new GameEvents.SendResourcesAction();
        sendResourcesAction.targetPlayer = ((this.opCode & 0xF0) >> 4) - 1;
        this.wrapper.get();
        int n = Integer.reverseBytes(this.wrapper.getInt());
        sendResourcesAction.minSent = (n >> 8 << 3) + (n & 0xF);
        n = Integer.reverseBytes(this.wrapper.getInt());
        sendResourcesAction.gasSent = (n >> 8 << 3) + (n & 0xF);
        this.wrapper.position(this.wrapper.position() + 8);
        return sendResourcesAction;
    }

    private GameEvents.MoveScreenAction readMoveScreenAction() {
        int n = Integer.reverseBytes(this.wrapper.getInt());
        GameEvents.MoveScreenAction moveScreenAction = this.replay.gameEvents.new GameEvents.MoveScreenAction();
        moveScreenAction.x = (this.opCode & 0xF0) << 8 | (n & 0xFF000000) >>> 20 | (n & 0xF0000) >> 16;
        moveScreenAction.y = (n & 0xF00000) >> 8 | (n & 0xFF00) >> 4 | n & 0xF;
        if (((n <<= 8) & 0x1000) > 0) {
            moveScreenAction.zooming = true;
            n = this.wrapper.getShort() & 0xFFFF;
        }
        if ((n & 0x2000) > 0) {
            moveScreenAction.zooming = true;
            n = this.wrapper.getShort() & 0xFFFF;
        }
        if ((n & 0x4000) > 0) {
            moveScreenAction.rotating = true;
            this.wrapper.getShort();
        }
        return moveScreenAction;
    }

    protected abstract GameEvents.HotkeyAction readHotkeyAction();

    private GameEvents.SelectAction readSelectAction() {
        GameEvents.SelectAction selectAction = this.replay.gameEvents.new GameEvents.SelectAction();
        boolean bl = selectAction.automatic = this.opCode != -84;
        if (selectAction.automatic) {
            selectAction.type = ReplayConsts.ActionType.INACTION;
        }
        this.readCustomSelectAction(selectAction);
        return selectAction;
    }

    protected abstract void readCustomSelectAction(GameEvents.SelectAction var1);

    protected abstract GameEvents.BaseUseAbilityAction readUseAbilityAction(AbilityCodes var1);

    private void trackPlayerLeave(Map<Integer, List<Integer>> map, byte by) {
        if (map.size() > 1) {
            int n = this.replay.details.players[by].team;
            List<Integer> list = map.get(n);
            list.remove(new Integer(by));
            if (list.isEmpty()) {
                map.remove(n);
                this.replay.details.setTeamIsWinner(n, Boolean.FALSE);
                if (map.size() == 1) {
                    int n2 = map.keySet().iterator().next();
                    map.remove(n2);
                    this.replay.details.setTeamIsWinner(n2, Boolean.TRUE);
                }
            }
        }
    }

    private void completeWinnerDetection(Map<Integer, List<Integer>> map) {
        Map.Entry<Integer, List<Integer>> entry3;
        Details.Player[] playerArray = this.replay.details.players;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(map.size());
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(map.size());
        int n = 0;
        for (Map.Entry<Integer, List<Integer>> entry2 : map.entrySet()) {
            int n2 = entry2.getKey();
            boolean bl = true;
            boolean bl2 = false;
            for (Integer n3 : entry2.getValue()) {
                if (playerArray[n3.intValue()].type == ReplayConsts.PlayerType.HUMAN) {
                    bl2 = true;
                    break;
                }
                if (playerArray[n3.intValue()].type != ReplayConsts.PlayerType.UNKNOWN) continue;
                bl = false;
            }
            if (bl2) {
                arrayList.add(n2);
                continue;
            }
            if (bl) {
                arrayList2.add(n2);
                continue;
            }
            ++n;
        }
        if (n == 0 && arrayList.size() == 1) {
            this.replay.details.setTeamIsWinner((Integer)arrayList.get(0), Boolean.TRUE);
            entry3 = arrayList2.iterator();
            while (entry3.hasNext()) {
                int n4 = (Integer)entry3.next();
                this.replay.details.setTeamIsWinner(n4, Boolean.FALSE);
            }
        }
        if (Settings.getBoolean("settings.misc.declareLargestAsWinner") && map.size() > 1) {
            int n5 = 0;
            for (Map.Entry<Integer, List<Integer>> entry3 : map.entrySet()) {
                if (n5 >= ((List)entry3.getValue()).size()) continue;
                n5 = ((List)entry3.getValue()).size();
            }
            block4: do {
                entry3 = null;
                for (Map.Entry<Integer, List<Integer>> entry4 : map.entrySet()) {
                    if (((List)entry4.getValue()).size() >= n5) continue;
                    entry3 = (Integer)entry4.getKey();
                    map.remove(entry3);
                    this.replay.details.setTeamIsWinner((Integer)((Object)entry3), Boolean.FALSE);
                    continue block4;
                }
            } while (entry3 != null);
            if (map.size() == 1) {
                int n6 = map.keySet().iterator().next();
                map.remove(n6);
                this.replay.details.setTeamIsWinner(n6, Boolean.TRUE);
            }
        }
    }
}

