/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.mpq.MpqParser;
import hu.belicza.andras.sc2gears.mpq.model.UserData;
import hu.belicza.andras.sc2gears.sc2map.MapParser;
import hu.belicza.andras.sc2gears.sc2replay.Parser;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParser;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParserV10;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParserV11;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Set;

public class ReplayFactory {
    public static final String VERSION = "1.10";
    public static final Set<ReplayContent> ALL_CONTENT = EnumSet.allOf(ReplayContent.class);
    public static final Set<ReplayContent> GENERAL_INFO_CONTENT = EnumSet.of(ReplayContent.INIT_DATA, ReplayContent.DETAILS, ReplayContent.ATTRIBUTES_EVENTS);
    public static final Set<ReplayContent> GENERAL_DATA_CONTENT = EnumSet.of(ReplayContent.INIT_DATA, ReplayContent.DETAILS, ReplayContent.ATTRIBUTES_EVENTS, ReplayContent.GAME_EVENTS);

    private ReplayFactory() {
    }

    public static Replay parseReplay(String string, Set<ReplayContent> set) {
        MpqParser mpqParser = null;
        try {
            ReplayParser replayParser;
            mpqParser = new MpqParser(string);
            UserData userData = mpqParser.getUserData();
            Parser parser = new Parser();
            parser.setWrapper(userData.userData, ByteOrder.BIG_ENDIAN);
            ByteBuffer byteBuffer = parser.wrapper;
            byteBuffer.getInt();
            byteBuffer.getInt();
            parser.readStringWithLength(parser.readValueStrut());
            byteBuffer.getShort();
            byteBuffer.get();
            byteBuffer.getShort();
            parser.readValueStrut();
            int[] nArray = new int[4];
            int n = 0;
            while (n < 4) {
                byteBuffer.getShort();
                nArray[n] = parser.readValueStrut();
                ++n;
            }
            if (ReplayUtils.getAbilityCodesForVersion(nArray) == null) {
                System.out.println("Unsupported replay version: " + ReplayUtils.convertBuildNumbersToString(nArray) + " (" + string + ")!");
                return null;
            }
            Replay replay = new Replay();
            replay.setBuildNumbers(nArray);
            byteBuffer.getShort();
            parser.readValueStrut();
            byteBuffer.getShort();
            parser.readValueStrut();
            byteBuffer.getShort();
            replay.setGameDuration(parser.readValueStrut() << 2);
            switch (VersionCompatibility.fromBuildNumbers(replay.buildNumbers)) {
                case V10: {
                    replayParser = new ReplayParserV10(replay);
                    break;
                }
                case V11: {
                    replayParser = new ReplayParserV11(replay);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled version compatibility!");
                }
            }
            if (set.contains((Object)ReplayContent.INIT_DATA)) {
                replayParser.parseInitData(mpqParser.getFile(ReplayContent.INIT_DATA.hash1, ReplayContent.INIT_DATA.hash2, ReplayContent.INIT_DATA.hash3));
            }
            if (set.contains((Object)ReplayContent.DETAILS)) {
                replayParser.parseDetails(mpqParser.getFile(ReplayContent.DETAILS.hash1, ReplayContent.DETAILS.hash2, ReplayContent.DETAILS.hash3));
            }
            if (set.contains((Object)ReplayContent.ATTRIBUTES_EVENTS)) {
                replayParser.parseAttributesEvents(mpqParser.getFile(ReplayContent.ATTRIBUTES_EVENTS.hash1, ReplayContent.ATTRIBUTES_EVENTS.hash2, ReplayContent.ATTRIBUTES_EVENTS.hash3));
            }
            if (replay.details != null) {
                Details.Player[] playerArray = replay.details.players;
                int n2 = replay.details.players.length;
                int n3 = 0;
                while (n3 < n2) {
                    Details.Player object = playerArray[n3];
                    object.finalRace = object.race.isConcrete ? object.race : ReplayConsts.Race.fromLocalizedValue(object.raceString);
                    ++n3;
                }
            }
            replay.converterGameSpeed = Settings.getBoolean("settings.misc.useRealTimeMeasurement") ? replay.initData.gameSpeed : ReplayConsts.GameSpeed.NORMAL;
            for (ReplayContent replayContent : set) {
                byte[] byArray = mpqParser.getFile(replayContent.hash1, replayContent.hash2, replayContent.hash3);
                switch (replayContent) {
                    case GAME_EVENTS: {
                        replayParser.parseGameEvents(byArray);
                        break;
                    }
                    case MESSAGE_EVENTS: {
                        replayParser.parseMessageEvents(byArray);
                        break;
                    }
                    case MAP_INFO: {
                        MapParser.parseMapInfo(replay);
                        break;
                    }
                    case SMARTCAM_EVENTS: {
                        break;
                    }
                }
            }
            Replay replay2 = replay;
            return replay2;
        }
        catch (Exception exception) {
            System.out.println("Error parsing replay: " + string);
            exception.printStackTrace();
            return null;
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    public static enum ReplayContent {
        INIT_DATA("replay.initData", -750801643, 1518242780, -14336164),
        DETAILS("replay.details", 620083690, -746339684, -281006446),
        ATTRIBUTES_EVENTS("replay.attributes.events", 1306016990, 497594575, -1563492568),
        GAME_EVENTS("replay.game.events", 496563520, -1430084277, -193582187),
        MESSAGE_EVENTS("replay.message.events", 1089231967, 831857289, 1784674979),
        SMARTCAM_EVENTS("replay.smartcam.events", 1029411303, 992681632, -1221660585),
        SYNC_EVENTS("replay.sync.events", 1206425669, -907692176, 991491766),
        MAP_INFO("MapInfo", 456326858, 2000504491, 1514959542),
        MAP_OBJECTS("Objects", 602486196, -842158972, 1775018687),
        MINIMAP_TGA("Minimap.tga", -1658863222, -1379586317, 1671265210);

        public final String fileName;
        public final int hash1;
        public final int hash2;
        public final int hash3;

        private ReplayContent(String string2, int n2, int n3, int n4) {
            this.fileName = string2;
            this.hash1 = n2;
            this.hash2 = n3;
            this.hash3 = n4;
        }
    }

    public static enum VersionCompatibility {
        V10,
        V11;


        public static VersionCompatibility fromBuildNumbers(int[] nArray) {
            if (nArray[0] < 1 || nArray[0] == 1 && nArray[1] < 1) {
                return V10;
            }
            return V11;
        }
    }
}

