/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gearsupdater;

import hu.belicza.andras.sc2gears.shared.SharedConsts;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipInputStream;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class Updater
extends JFrame {
    private static final String VERSION = "1.12";
    public static final String URL_DOWNLOADS = "http://sites.google.com/site/sc2gears/version-history";
    private static final File LIB_FOLDER = new File("lib").getAbsoluteFile();
    private static final File CURRENT_FOLDER = LIB_FOLDER.getParentFile();
    private static final File UPDATE_CACHE_FOLDER = new File("_Update cache").getAbsoluteFile();
    private static final File USER_CONTENT_FOLDER = new File("User content").getAbsoluteFile();
    private static final File SC2GEARS_JAR = new File(LIB_FOLDER, "Sc2gears.jar").getAbsoluteFile();
    private static final File ARCHIVE_SC2GEARS_FOLDER = new File(UPDATE_CACHE_FOLDER, "Sc2gears");
    private static final File ARCHIVE_UPDATER_LIB = new File(ARCHIVE_SC2GEARS_FOLDER, String.valueOf(SharedConsts.LIB_UPDATER_FOLDER.getName()) + "/" + "Sc2gearsUpdater.jar");
    private static final String[] SC2GEARS_FILE_NAMES = new String[]{"lib/EaSynthLookAndFeel.jar", "lib/jl1.0.1.jar", "lib/mp3spi1.9.4.jar", "lib/OfficeLnFs_2.7.jar", "lib/Sc2gears.jar", "lib/tritonus_share.jar", "lib/Sc2gears-logo.png", "lib", "Languages/Chinese.xml", "Languages/Dutch.xml", "Languages/English.xml", "Languages/French.xml", "Languages/German.xml", "Languages/Hungarian.xml", "Languages/Korean.xml", "Languages/Russian.xml", "Languages/Swedish.xml", "Languages", "Sc2gears-win.cmd", "Sc2gears.exe", "Sc2gears-linux.sh", "Sc2gears-os-x.sh", "LICENSE.txt"};
    private final JTextArea logTextArea = new JTextArea();
    private final JProgressBar dlProgressBar = new JProgressBar();
    private final JPanel controlButtonsPanel = new JPanel();
    private final JButton closeAndStartSc2gearsButton = new JButton("Close and Start Sc2gears", new ImageIcon(new ImageIcon(Updater.class.getResource("sc2gears.png")).getImage().getScaledInstance(16, 16, 4)));
    private final JButton closeButton = new JButton("Close", new ImageIcon(Updater.class.getResource("door-open-in.png")));
    private final JButton abortButton = new JButton("Abort", new ImageIcon(Updater.class.getResource("cross-octagon.png")));
    private volatile boolean updateInProgress;
    private volatile boolean abortAllowed;
    private final byte[] buffer = new byte[8192];
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss - ");

    public static void main(String[] stringArray) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n2];
            if ("Nimbus".equals(lookAndFeelInfo.getName())) {
                try {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        if (stringArray.length < 4) {
            JOptionPane.showMessageDialog(null, new String[]{"Sc2gears Updater is handled by Sc2gears internally.", "You do not need to run it."}, "Sc2gears Updater", 2);
            System.exit(0);
        }
        new Updater(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
    }

    public Updater(String string, String string2, String string3, String string4) {
        super("Sc2gears Updater");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Updater.this.exit();
            }
        });
        this.setIconImage(new ImageIcon(Updater.class.getResource("sc2gears.png")).getImage());
        this.buildGui();
        this.setBounds(100, 100, 700, 500);
        this.setVisible(true);
        this.startUpdate(string, string2, string3, string4);
    }

    private void buildGui() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Sc2gears Updater ver. 1.12 \u00a9 Andr\u00e1s Belicza, 2010", 0);
        jPanel.add(jLabel);
        this.getContentPane().add((Component)jPanel, "North");
        this.logTextArea.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(this.logTextArea), "Center");
        Box box = Box.createVerticalBox();
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Download status:"));
        this.dlProgressBar.setString("");
        this.dlProgressBar.setStringPainted(true);
        this.dlProgressBar.setPreferredSize(new Dimension(300, 23));
        jPanel2.add(this.dlProgressBar);
        box.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(SharedUtils.createLinkLabel("View version history", URL_DOWNLOADS));
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(SharedUtils.createLinkLabel("View download page", URL_DOWNLOADS));
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(SharedUtils.createLinkLabel("Visit home page", "http://sites.google.com/site/sc2gears/"));
        box.add(jPanel3);
        this.closeAndStartSc2gearsButton.setEnabled(false);
        this.closeAndStartSc2gearsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SharedUtils.isWindows() || SharedUtils.isMac() || SharedUtils.isUnix()) {
                    if (SharedUtils.isMac() || SharedUtils.isUnix()) {
                        try {
                            Runtime.getRuntime().exec(SharedUtils.isMac() ? "chmod +x Sc2gears-os-x.sh" : (SharedUtils.isUnix() ? "chmod +x Sc2gears-linux.sh" : ""));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    try {
                        Runtime.getRuntime().exec(SharedUtils.isWindows() ? "Sc2gears.exe" : (SharedUtils.isMac() ? "./Sc2gears-os-x.sh" : (SharedUtils.isUnix() ? "./Sc2gears-linux.sh" : "")));
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception);
                        exception.printStackTrace();
                    }
                }
                Updater.this.exit();
            }
        });
        this.controlButtonsPanel.add(this.closeAndStartSc2gearsButton);
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Updater.this.exit();
            }
        });
        this.controlButtonsPanel.add(this.closeButton);
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Updater.this.exit();
            }
        });
        this.controlButtonsPanel.add(this.abortButton);
        box.add(this.controlButtonsPanel);
        this.getContentPane().add((Component)box, "South");
    }

    private void exit() {
        if (this.updateInProgress && this.abortAllowed && 1 == JOptionPane.showConfirmDialog(this, new String[]{"Are you sure you want to abort the update?", "Hit 'No' to continue."}, "Warning!", 0, 2)) {
            return;
        }
        if (this.updateInProgress && !this.abortAllowed) {
            JOptionPane.showMessageDialog(this, new String[]{"The Update process cannot be aborted at this time without damaging Sc2gears!"}, "Error!", 0);
            return;
        }
        System.exit(0);
    }

    /*
     * Unable to fully structure code
     */
    private void startUpdate(String var1_1, String var2_2, String var3_3, String var4_4) {
        this.updateInProgress = true;
        this.abortAllowed = true;
        try {
            try {
                this.logTextArea.append("If the update fails and you cannot start Sc2gears, visit the home page and download it manually.\n\n");
                this.logMessage("Available latest version: " + var1_1);
                if (new BigDecimal(var2_2).compareTo(new BigDecimal("1.12")) > 0) {
                    this.logMessage("The update cannot be performed, because this update requires a newer version of Updater (" + var2_2 + ")!");
                    this.logMessage("Please download the latest version manually.");
                    throw new Exception();
                }
                this.logMessage("Preparing for update...");
                if (Updater.SC2GEARS_JAR.exists()) ** GOTO lbl18
                this.logMessage("It appears you did not start Sc2gears from its folder, aborting update!");
                throw new Exception();
lbl-1000:
                // 1 sources

                {
                    if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not delete folder:", Updater.UPDATE_CACHE_FOLDER.getAbsolutePath(), " ", "Retry?"}, "Error!", 0, 0)) continue;
                    this.logMessage("Failed to delete file: " + Updater.UPDATE_CACHE_FOLDER.getAbsolutePath());
                    throw new Exception();
lbl18:
                    // 2 sources

                    ** while (!Updater.deleteFile((File)Updater.UPDATE_CACHE_FOLDER, (boolean)true))
                }
lbl19:
                // 2 sources

                while (!Updater.UPDATE_CACHE_FOLDER.mkdir()) {
                    if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not create folder:", Updater.UPDATE_CACHE_FOLDER.getAbsolutePath(), " ", "Retry?"}, "Error!", 0, 0)) continue;
                    this.logMessage("Could not create update cache folder!");
                    throw new Exception();
                }
                this.logMessage("Downloading archive...");
                var5_5 = new File(Updater.UPDATE_CACHE_FOLDER, "archive.zip");
                try {
                    var6_7 = new URL(var3_3).openConnection();
                    var7_10 = var6_7.getContentLength();
                    if (var7_10 < 0) {
                        this.dlProgressBar.setString("Downloading... (size unknown)");
                    } else {
                        this.dlProgressBar.setString(null);
                        this.dlProgressBar.setMaximum(var7_10);
                    }
                    var8_14 = var6_7.getInputStream();
                    var9_16 = new FileOutputStream(var5_5);
                    var10_20 = 0;
                    while ((var11_23 = var8_14.read(this.buffer)) > 0) {
                        var9_16.write(this.buffer, 0, var11_23);
                        var10_20 += var11_23;
                        if (var7_10 <= 0) continue;
                        this.dlProgressBar.setValue(var10_20);
                    }
                    if (var7_10 < 0) {
                        this.dlProgressBar.setValue(this.dlProgressBar.getMaximum());
                        this.dlProgressBar.setString(null);
                    }
                    var9_16.flush();
                    var9_16.close();
                    var8_14.close();
                    this.logMessage("Download complete.");
                }
                catch (Exception var6_8) {
                    this.logMessage("Failed to download archive.");
                    throw var6_8;
                }
                this.logMessage("Checking SHA-256 checksum of the archive...");
                if (!var4_4.equals(SharedUtils.calculateFileSha256(var5_5))) {
                    this.logMessage("SHA-256 checksum does not match!");
                    this.logMessage("To protect your computer, the update process has been aborted!");
                    this.logMessage("You can start the update process again if you think this is due to a download error.");
                    this.logMessage("If the SHA-256 checksum test fails repeatedly, please contact the author.");
                    throw new Exception("SHA-256 checksum test failed, aborting update!");
                }
                this.logMessage("SHA-256 checksum OK.");
                this.logMessage("Extracting archive...");
                try {
                    var6_7 = new ZipInputStream(new FileInputStream(var5_5));
                    while ((var7_11 = var6_7.getNextEntry()) != null) {
                        var8_14 = new File(Updater.UPDATE_CACHE_FOLDER, var7_11.getName());
                        if (var7_11.isDirectory()) {
                            var8_14.mkdirs();
                            continue;
                        }
                        var9_17 = var7_11.getSize();
                        var11_24 = new FileOutputStream((File)var8_14);
                        while (var9_17 > 0L) {
                            var12_25 = var6_7.read(this.buffer);
                            var11_24.write(this.buffer, 0, var12_25);
                            var9_17 -= (long)var12_25;
                        }
                        var11_24.flush();
                        var11_24.close();
                    }
                    var6_7.close();
                    this.logMessage("Extracting done.");
                    if (!Updater.ARCHIVE_SC2GEARS_FOLDER.exists()) {
                        this.logMessage("Error: the extracted archive does not seem to be a valid archive! Aborting update!");
                        throw new Exception();
                    }
                }
                catch (Exception var6_9) {
                    this.logMessage("Failed to extract archive!");
                    throw var6_9;
                }
                this.logMessage("Replacing/patching files...");
                this.abortAllowed = false;
                this.abortButton.setEnabled(false);
                var9_18 = Updater.SC2GEARS_FILE_NAMES;
                var8_15 = Updater.SC2GEARS_FILE_NAMES.length;
                var7_12 = 0;
                while (var7_12 < var8_15) {
                    var6_7 = var9_18[var7_12];
                    var10_21 = new File(Updater.CURRENT_FOLDER, (String)var6_7);
                    while (!Updater.deleteFile(var10_21, false)) {
                        if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not delete file or folder:", var10_21.getAbsolutePath(), " ", "At this point your Sc2gears is probably damaged.", "Retry?"}, "Error!", 0, 0)) continue;
                        this.logMessage("Failed to delete file or folder: " + var10_21.getAbsolutePath());
                        this.logMessage("Your Sc2gears is probably damaged now.");
                        throw new Exception();
                    }
                    ++var7_12;
                }
                var6_7 = new File(Updater.ARCHIVE_UPDATER_LIB.getParent(), "Sc2gearsUpdater2.jar");
                while (!Updater.ARCHIVE_UPDATER_LIB.renameTo((File)var6_7)) {
                    if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not rename file:", Updater.ARCHIVE_UPDATER_LIB.getAbsolutePath(), "To:", var6_7.getAbsolutePath(), " ", "At this point your Sc2gears is probably damaged.", "Retry?"}, "Error!", 0, 0)) continue;
                    this.logMessage("Failed to rename file: " + Updater.ARCHIVE_UPDATER_LIB.getAbsolutePath());
                    this.logMessage("Your Sc2gears is probably damaged now.");
                    throw new Exception();
                }
                var10_22 = Updater.ARCHIVE_SC2GEARS_FOLDER.listFiles();
                var9_19 = var10_22.length;
                var8_15 = 0;
                while (var8_15 < var9_19) {
                    var7_13 = var10_22[var8_15];
                    if (!var7_13.getName().equals(Updater.USER_CONTENT_FOLDER.getName())) {
                        while (!this.copyFile(var7_13, Updater.CURRENT_FOLDER)) {
                            if (1 != JOptionPane.showConfirmDialog(this, new String[]{"Could not copy file or folder from:", var7_13.getAbsolutePath(), "To:", Updater.CURRENT_FOLDER.getAbsolutePath(), " ", "At this point your Sc2gears is probably damaged.", "Retry?"}, "Error!", 0, 0)) continue;
                            this.logMessage("Failed to copy file or folder: " + var7_13.getAbsolutePath());
                            this.logMessage("Your Sc2gears is probably damaged now.");
                            throw new Exception();
                        }
                    }
                    ++var8_15;
                }
                this.abortAllowed = true;
                this.logMessage("Replace/patch complete.");
                this.logMessage("Cleaning up...");
                if (!Updater.deleteFile(Updater.UPDATE_CACHE_FOLDER, true)) {
                    this.logMessage("Warning: there were some errors during cleanup.");
                } else {
                    this.logMessage("Cleanup complete.");
                }
                this.logMessage("Sc2gears has been successfully updated to version: " + var1_1);
            }
            catch (Exception var5_6) {
                this.logMessage("Update failed!");
                this.closeAndStartSc2gearsButton.setEnabled(true);
                this.closeAndStartSc2gearsButton.requestFocusInWindow();
                this.closeButton.setEnabled(true);
                this.abortButton.setEnabled(false);
                this.updateInProgress = false;
            }
        }
        finally {
            this.closeAndStartSc2gearsButton.setEnabled(true);
            this.closeAndStartSc2gearsButton.requestFocusInWindow();
            this.closeButton.setEnabled(true);
            this.abortButton.setEnabled(false);
            this.updateInProgress = false;
        }
    }

    private static boolean deleteFile(File file, boolean bl) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        File[] fileArray = file.listFiles();
        if (bl) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                if (!Updater.deleteFile(file2, true)) {
                    return false;
                }
                ++n2;
            }
            return file.delete();
        }
        if (fileArray.length == 0) {
            return file.delete();
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private boolean copyFile(File file, File file2) {
        InputStream inputStream;
        FileOutputStream fileOutputStream;
        block26: {
            int n;
            File file3 = new File(file2, file.getName()).getAbsoluteFile();
            if (file.isDirectory()) {
                if (!file3.exists() ? !file3.mkdir() : file3.isFile()) {
                    return false;
                }
                File[] fileArray = file.listFiles();
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file4 = fileArray[n3];
                    if (!this.copyFile(file4, file3)) {
                        return false;
                    }
                    ++n3;
                }
                return true;
            }
            fileOutputStream = null;
            inputStream = null;
            fileOutputStream = new FileOutputStream(file3);
            inputStream = new FileInputStream(file);
            while ((n = inputStream.read(this.buffer)) > 0) {
                ((OutputStream)fileOutputStream).write(this.buffer, 0, n);
            }
            fileOutputStream.flush();
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
            if (inputStream == null) break block26;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
        catch (Exception exception) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void logMessage(String string) {
        this.logTextArea.append(String.valueOf(TIME_FORMAT.format(new Date())) + string + "\n");
        this.logTextArea.setCaretPosition(this.logTextArea.getDocument().getLength());
    }
}

