/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.util;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ToolTipManager;

public class GeneralUtils {
    public static final FileFilter SC2REPLAY_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".sc2replay");
        }
    };
    public static final FileFilter SC2REPLAY_FILES_ONLY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && file.getName().toLowerCase().endsWith(".sc2replay");
        }
    };
    private static final DateFormat MIN_SEC_PARSER = new SimpleDateFormat("m:s");
    private static final DateFormat HOUR_MIN_SEC_PARSER = new SimpleDateFormat("H:m:s");

    private GeneralUtils() {
    }

    public static String getFileNameWithoutExt(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(0, n);
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? "" : string.substring(n, string.length());
    }

    public static boolean isDescendant(File file, File file2) {
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        while (file2 != null) {
            if (file.equals(file2)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static boolean copyFile(File file, File file2, byte[] byArray, String string) {
        if (!file2.exists() && !file2.mkdirs()) {
            return false;
        }
        if (file2.exists() && !file2.isDirectory()) {
            return false;
        }
        File file3 = new File(file2, string == null ? file.getName() : string);
        if (file3.exists()) {
            System.out.println("Copy failed: target file already exists!");
            return false;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file3);
                if (byArray == null) {
                    byArray = new byte[4096];
                }
                while ((n = fileInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        file3.setLastModified(file.lastModified());
        return true;
    }

    public static String[] splitBySemicolon(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((n = string.indexOf(59, n2)) >= 0) {
            arrayList.add(string.substring(n2, n));
            n2 = n + 1;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int maxValue(int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        int n = nArray[0];
        int n2 = nArray.length - 1;
        while (n2 > 0) {
            if (n < nArray[n2]) {
                n = nArray[n2];
            }
            --n2;
        }
        return n;
    }

    public static String convertConstNameToNormal(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '_') {
                stringBuilder.append(' ');
                bl = true;
            } else if (bl) {
                stringBuilder.append(c);
                bl = false;
            } else {
                stringBuilder.append(Character.toLowerCase(c));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static boolean isOsWindows7() {
        return "Windows 7".equals(SharedUtils.OS_NAME);
    }

    public static boolean isOsWindowsVista() {
        return "Windows Vista".equals(SharedUtils.OS_NAME);
    }

    public static boolean isOsWindowsXp() {
        return "Windows XP".equals(SharedUtils.OS_NAME);
    }

    public static boolean isOsMac() {
        return SharedUtils.OS_NAME.toLowerCase().indexOf("mac") >= 0;
    }

    public static int countElements(Object[] objectArray, Object object) {
        int n = 0;
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object2 = objectArray2[n3];
            if (object2.equals(object)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public static <T> T[] remainingElements(T[] TArray, Set<T> set) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length - set.size());
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            if (!set.contains(t)) {
                arrayList.add(t);
            }
            ++n2;
        }
        return arrayList.toArray((Object[])Array.newInstance(TArray[0].getClass(), arrayList.size()));
    }

    public static int distanceSquare(int n, int n2, int n3, int n4) {
        return ((n >>= 16) - (n3 >>= 16)) * (n - n3) + ((n2 >>= 16) - (n4 >>= 16)) * (n2 - n4);
    }

    public static String formatLongSeconds(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = l / 3600L;
        stringBuilder.append(l2).append(':');
        long l3 = (l %= 3600L) / 60L;
        if (l3 < 10L) {
            stringBuilder.append(0);
        }
        stringBuilder.append(l3).append(':');
        if ((l %= 60L) < 10L) {
            stringBuilder.append(0);
        }
        stringBuilder.append(l);
        return stringBuilder.toString();
    }

    public static List<File> getAutoRepFolderList() {
        ArrayList<File> arrayList = new ArrayList<File>(5);
        int n = 1;
        while (n <= 5) {
            block5: {
                String string;
                block4: {
                    block3: {
                        if (n != 1) break block3;
                        string = Settings.getString("settings.folders.sc2AutoReplay");
                        break block4;
                    }
                    if (!Settings.getBoolean("settings.folders.enableExtraSc2AutoReplay" + n)) break block5;
                    string = Settings.getString("settings.folders.sc2AutoReplay" + n);
                }
                File file = new File(string);
                arrayList.add(file.exists() ? file : new File(Consts.FOLDER_USER_HOME, string));
            }
            ++n;
        }
        return arrayList;
    }

    public static List<String> getFavoredPlayerList() {
        String string = Settings.getString("settings.misc.favoredPlayerList").trim();
        if (string.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(4);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList;
        }
        return new ArrayList<String>(0);
    }

    public static <T> Set<T> assembleHashSet(T ... TArray) {
        HashSet<T> hashSet = new HashSet<T>(TArray.length);
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            hashSet.add(t);
            ++n2;
        }
        return hashSet;
    }

    public static boolean downloadUrl(String string, File file) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            inputStream = new URL(string).openStream();
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Integer parseSeconds(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            Date date = null;
            try {
                date = HOUR_MIN_SEC_PARSER.parse(string);
            }
            catch (Exception exception2) {
                try {
                    date = MIN_SEC_PARSER.parse(string);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            if (date == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return gregorianCalendar.get(11) * 3600 + gregorianCalendar.get(12) * 60 + gregorianCalendar.get(13);
        }
    }

    public static File getLastReplay(File file, File file2) {
        long l = file2 == null ? 0L : file2.lastModified();
        File[] fileArray = file.listFiles(SC2REPLAY_FILE_FILTER);
        if (fileArray == null) {
            return file2;
        }
        int n = fileArray.length - 1;
        while (n >= 0) {
            File file3 = fileArray[n];
            if (file3.isDirectory()) {
                l = (file2 = GeneralUtils.getLastReplay(file3, file2)) == null ? 0L : file2.lastModified();
            } else if (file3.lastModified() > l) {
                file2 = file3;
                l = file3.lastModified();
            }
            --n;
        }
        return file2;
    }

    public static void setToolTipDelays() {
        ToolTipManager.sharedInstance().setInitialDelay(Settings.getInt("settings.misc.toolTipInitialDelay"));
        ToolTipManager.sharedInstance().setDismissDelay(Settings.getInt("settings.misc.toolTipDismissDelay"));
    }
}

