/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.startpage;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class StartPage
extends ModuleFrame {
    private final JEditorPane browser = new JEditorPane();

    public StartPage() {
        super(Language.getText("module.startPage.title"));
        this.setFrameIcon(Icons.NEWSPAPER);
        this.buildGUI();
    }

    private void buildGUI() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        JLabel jLabel = SharedUtils.createLinkStyledLabel(Language.getText("module.startPage.refresh"));
        jLabel.setIcon(Icons.ARROW_CIRCLE_315);
        jLabel.setToolTipText(Language.getText("module.startPage.refreshToolTip"));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                StartPage.this.refresh();
            }
        });
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(20));
        JLabel jLabel2 = SharedUtils.createLinkLabel(Language.getText("module.startPage.visitHomePage"), "http://sites.google.com/site/sc2gears/");
        jLabel2.setIcon(Icons.HOME_ARROW);
        box.add(jLabel2);
        this.getContentPane().add((Component)GuiUtils.wrapInPanelLeftAligned(box), "North");
        this.browser.setEditable(false);
        this.browser.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SharedUtils.showURLInBrowser(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        });
        Object object = new Object();
        this.browser.getInputMap(0).put(KeyStroke.getKeyStroke(79, 192), object);
        this.browser.getActionMap().put(object, null);
        object = new Object();
        this.browser.getInputMap(1).put(KeyStroke.getKeyStroke(116, 0), object);
        this.browser.getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartPage.this.refresh();
            }
        });
        this.getContentPane().add((Component)new JScrollPane(this.browser), "Center");
    }

    public void refresh() {
        try {
            if (Consts.DEVELOPER_MODE) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader("../start_page.html"));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                }
                bufferedReader.close();
                this.browser.setContentType("text/html");
                this.browser.setText(stringBuffer.toString());
            } else {
                this.browser.setPage("http://sites.google.com/site/sc2gears/storage/start_page.html?t=" + new Date().getTime());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.browser.setContentType("text/html");
            this.browser.setText("<html><body><p><i>The Start page is currently unavailable. Please try again later.</i></p></body></html>");
        }
    }
}

