/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replayanal;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2map.MapParser;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.services.Downloader;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.ReplayOperationsPopupMenu;
import hu.belicza.andras.sc2gears.ui.charts.ChartUtils;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.PlayerPopupMenu;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.Animator;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartPainter;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ChartParams;
import hu.belicza.andras.sc2gears.util.BoolHolder;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Holder;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gears.util.Task;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ReplayAnalyzer
extends ModuleFrame {
    private static final int MAX_MAP_PREVIEW_ZOOM = 6;
    private static final Dictionary<Integer, JComponent> LABEL_DICTIONARY = new Hashtable<Integer, JComponent>();
    private File replayFile;
    private final Replay replay;

    static {
        int n = 0;
        while (n <= 6) {
            LABEL_DICTIONARY.put(n, new JLabel(n == 0 ? "1/2x" : String.valueOf(n) + "x"));
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ReplayAnalyzer(Object ... objectArray) {
        super(objectArray.length < 1 ? Language.getText("module.replayAnalyzer.opening") : null);
        if (objectArray.length == 0) {
            String string = Settings.getString("settings.folders.defaultReplay");
            JFileChooser jFileChooser = new JFileChooser(string == null ? Settings.getString("settings.folders.sc2AutoReplay") : string);
            jFileChooser.setDialogTitle(Language.getText("module.repAnalyzer.openTitle"));
            jFileChooser.setFileFilter(GuiUtils.SC2_REPLAY_FILTER);
            jFileChooser.setAccessory(GuiUtils.createReplayFilePreviewAccessory(jFileChooser));
            jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
            if (jFileChooser.showOpenDialog(MainFrame.INSTANCE) != 0) {
                this.dispose();
                this.replayFile = null;
                this.replay = null;
                return;
            }
            this.replayFile = jFileChooser.getSelectedFile();
        } else {
            this.replayFile = (File)objectArray[0];
        }
        this.replay = ReplayFactory.parseReplay(this.replayFile.getAbsolutePath(), ReplayFactory.ALL_CONTENT);
        if (this.replay == null) {
            new NormalThread("Non-blocking executor thread"){

                @Override
                public void run() {
                    GuiUtils.showErrorDialog(Language.getText("module.repAnalyzer.openError"));
                }
            }.start();
            this.dispose();
            return;
        }
        if (Settings.getBoolean("settings.misc.rearrangePlayersInRepAnalyzer")) {
            ReplayUtils.applyFavoredPlayerListSetting(this.replay.details);
        }
        MainFrame.INSTANCE.updateRecentReplays(this.replayFile);
        this.setTitle(GeneralUtils.getFileNameWithoutExt(this.replayFile));
        this.setFrameIcon(Icons.SC2);
        this.buildGui();
    }

    private void buildGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.charts.title"), Icons.CHART, false, jTabbedPane, this.createChartsTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.gameInfo.title"), Icons.INFORMATION_BALLOON, false, jTabbedPane, this.createGameInfoTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.inGameChat.title"), Icons.BALLOONS, false, jTabbedPane, this.createInGameChatTab(), null);
        GuiUtils.addNewTab(Language.getText("module.repAnalyzer.tab.mapPreview.title"), Icons.MAP, false, jTabbedPane, this.createMapPreviewTab(), null);
        this.getContentPane().add(jTabbedPane);
    }

    private JComponent createChartsTab() {
        Object object;
        JComponent jComponent;
        Object object2;
        JComponent jComponent2;
        JComponent jComponent3;
        JComponent jComponent4;
        Object object3;
        JPanel jPanel = new JPanel(new BorderLayout());
        final JList jList = new JList();
        final EnumMap<ReplayConsts.ActionType, JCheckBox> enumMap = new EnumMap<ReplayConsts.ActionType, JCheckBox>(ReplayConsts.ActionType.class);
        final JCheckBox jCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.actions.useListedActionsAsInput", "module.repAnalyzer.charts.actions.useListedAsInput");
        final Holder holder = new Holder();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JComponent)holder.value).repaint();
            }
        };
        final Holder holder2 = new Holder();
        final JCheckBox[] jCheckBoxArray = new JCheckBox[this.replay.details.players.length];
        final int[] nArray = this.replay.details.getTeamOrderPlayerIndices();
        final Holder holder3 = new Holder();
        final Holder holder4 = new Holder();
        final JLabel jLabel = new JLabel();
        final ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[][] stringArray;
                EnumSet<ReplayConsts.ActionType> enumSet = EnumSet.noneOf(ReplayConsts.ActionType.class);
                ReplayConsts.ActionType[] actionTypeArray = ReplayConsts.ActionType.values();
                int n = actionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    stringArray = actionTypeArray[n2];
                    if (((JCheckBox)enumMap.get(stringArray)).isSelected()) {
                        enumSet.add((ReplayConsts.ActionType)stringArray);
                    }
                    ++n2;
                }
                stringArray = (String[][])holder3.value;
                String[][] stringArray2 = (String[][])holder4.value;
                boolean[] blArray = new boolean[jCheckBoxArray.length];
                int n3 = 0;
                while (n3 < blArray.length) {
                    blArray[nArray[n3]] = jCheckBoxArray[n3].isSelected();
                    ++n3;
                }
                ArrayList<GameEvents.Action> arrayList = new ArrayList<GameEvents.Action>();
                GameEvents.Action[] actionArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions;
                int n4 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions.length;
                int n5 = 0;
                while (n5 < n4) {
                    block15: {
                        GameEvents.Action action;
                        block17: {
                            String string;
                            int n6;
                            int n7;
                            String[] stringArray3;
                            String[] stringArray4;
                            int n8;
                            int n9;
                            String[][] stringArray5;
                            boolean bl;
                            String string2;
                            block16: {
                                action = actionArray[n5];
                                if (!blArray[action.player] || !enumSet.contains((Object)action.type)) break block15;
                                string2 = null;
                                if (stringArray2 == null) break block16;
                                bl = true;
                                string2 = action.toString().toLowerCase();
                                stringArray5 = stringArray2;
                                n9 = stringArray2.length;
                                n8 = 0;
                                while (n8 < n9) {
                                    stringArray4 = stringArray5[n8];
                                    bl = true;
                                    stringArray3 = stringArray4;
                                    n7 = stringArray4.length;
                                    n6 = 0;
                                    while (n6 < n7) {
                                        string = stringArray3[n6];
                                        if (!string2.contains(string)) {
                                            bl = false;
                                            break;
                                        }
                                        ++n6;
                                    }
                                    if (bl) break;
                                    ++n8;
                                }
                                if (bl) break block15;
                            }
                            if (stringArray == null) break block17;
                            bl = true;
                            if (string2 == null) {
                                string2 = action.toString().toLowerCase();
                            }
                            stringArray5 = stringArray;
                            n9 = stringArray.length;
                            n8 = 0;
                            while (n8 < n9) {
                                stringArray4 = stringArray5[n8];
                                bl = true;
                                stringArray3 = stringArray4;
                                n7 = stringArray4.length;
                                n6 = 0;
                                while (n6 < n7) {
                                    string = stringArray3[n6];
                                    if (!string2.contains(string)) {
                                        bl = false;
                                        break;
                                    }
                                    ++n6;
                                }
                                if (bl) break;
                                ++n8;
                            }
                            if (!bl) break block15;
                        }
                        arrayList.add(action);
                    }
                    ++n5;
                }
                holder2.value = arrayList.toArray(new GameEvents.Action[arrayList.size()]);
                jList.setListData((E[])holder2.value);
                jLabel.setText(Language.getText("module.repAnalyzer.tab.charts.actions.listedActionsCount", ((GameEvents.Action[])holder2.value).length));
                if (jCheckBox.isSelected()) {
                    ((JComponent)holder.value).repaint();
                }
            }
        };
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(new JPanel(new BorderLayout()));
        box2.add(new JLabel(Language.getText("charts.chartType")));
        final JComboBox jComboBox = GuiUtils.createComboBox((Object[])ChartType.values(), "module.repAnalyzer.charts.chartType");
        jComboBox.setToolTipText(Language.getText("charts.chartTypeToolTip"));
        jComboBox.addActionListener(actionListener);
        box2.add(jComboBox);
        box2.add(Box.createHorizontalStrut(5));
        final JCheckBox jCheckBox2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.groupByTeams", "module.repAnalyzer.charts.groupByTeams");
        jCheckBox2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.groupByTeamToolTip"));
        jCheckBox2.addActionListener(actionListener);
        box2.add(jCheckBox2);
        box2.add(Box.createHorizontalStrut(5));
        final JCheckBox jCheckBox3 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.allPlayersOn1Chart", "module.repAnalyzer.charts.allPlayersOn1Chart");
        jCheckBox3.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.allPlayersOn1ChartToolTip"));
        jCheckBox3.addActionListener(actionListener);
        box2.add(jCheckBox3);
        box2.add(Box.createHorizontalStrut(8));
        final JCheckBox jCheckBox4 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.usePlayersColors", "module.repAnalyzer.charts.usePlayersColors");
        jCheckBox4.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.usePlayersColorsToolTip"));
        jCheckBox4.addActionListener(actionListener);
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jList.invalidate();
                jList.getParent().repaint();
                if (jCheckBox.isSelected()) {
                    ((JComponent)holder.value).repaint();
                }
            }
        };
        jCheckBox4.addActionListener(actionListener3);
        box2.add(jCheckBox4);
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox4.setEnabled(!jCheckBox3.isSelected());
            }
        };
        jCheckBox3.addActionListener(actionListener4);
        actionListener4.actionPerformed(null);
        box2.add(Box.createHorizontalStrut(8));
        final JCheckBox jCheckBox5 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.displayInSeconds", "module.repAnalyzer.charts.displayInSeconds");
        jCheckBox5.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.displayInSecondsToolTip"));
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.displayInSeconds = jCheckBox5.isSelected();
            }
        };
        actionListener5.actionPerformed(null);
        jCheckBox5.addActionListener(actionListener5);
        jCheckBox5.addActionListener(actionListener2);
        jCheckBox5.addActionListener(actionListener);
        box2.add(jCheckBox5);
        box2.add(Box.createHorizontalStrut(9));
        final JLabel jLabel2 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.zoom"));
        jLabel2.setOpaque(true);
        box2.add(jLabel2);
        final JComboBox jComboBox2 = GuiUtils.createComboBox(new Object[]{"x1", "x2", "x4", "x8", "x16", "x32"}, "module.repAnalyzer.charts.zoom");
        jComboBox2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.zoomToolTip"));
        box2.add(jComboBox2);
        box2.add(new JPanel(new BorderLayout()));
        box.add(box2);
        final Box box3 = Box.createHorizontalBox();
        box.add(box3);
        box.add(Box.createVerticalStrut(2));
        Box box4 = Box.createHorizontalBox();
        box4.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.players")));
        box4.add(Box.createHorizontalStrut(5));
        int n = nArray.length == 0 ? -1 : this.replay.details.players[nArray[0]].team;
        int n2 = 0;
        while (n2 < this.replay.details.players.length) {
            object3 = this.replay.details.players[nArray[n2]];
            jCheckBoxArray[n2] = new JCheckBox(((Details.Player)object3).name, ((Details.Player)object3).lastActionFrame > 0);
            jComponent4 = jCheckBoxArray[n2];
            ((AbstractButton)jComponent4).addActionListener(actionListener2);
            ((AbstractButton)jComponent4).addActionListener(actionListener);
            int n3 = this.replay.details.players[nArray[n2]].team;
            if (n3 != n) {
                box4.add(Box.createHorizontalStrut(7));
                box4.add(new JLabel("VS."));
                box4.add(Box.createHorizontalStrut(12));
                n = n3;
            }
            jComponent3 = Box.createHorizontalBox();
            jComponent3.setBorder(BorderFactory.createLoweredBevelBorder());
            if (((Details.Player)object3).handicap < 100) {
                jComponent2 = new JLabel(Icons.HANDICAP);
                jComponent2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.players.handicapToolTip", ((Details.Player)object3).handicap));
                jComponent3.add(jComponent2);
            }
            if (((Details.Player)object3).isWinner != null && ((Details.Player)object3).isWinner.booleanValue() && Settings.getBoolean("settings.misc.showWinners")) {
                jComponent2 = new JLabel(Icons.TROPHY);
                jComponent2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.players.winnerToolTip"));
                jComponent3.add(jComponent2);
            }
            jComponent3.add(jComponent4);
            ((AbstractButton)jComponent4).addActionListener(new ActionListener((Box)jComponent3, (JCheckBox)jComponent4){
                private final /* synthetic */ Box val$playerBox;
                private final /* synthetic */ JCheckBox val$playerCheckBox;
                {
                    this.val$playerBox = box;
                    this.val$playerCheckBox = jCheckBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$playerBox.setBorder(this.val$playerCheckBox.isSelected() ? BorderFactory.createLoweredBevelBorder() : BorderFactory.createRaisedBevelBorder());
                }
            });
            jComponent3.add(GuiUtils.createRaceIconLabel(((Details.Player)object3).race == null ? ((Details.Player)object3).finalRace : ((Details.Player)object3).race));
            jComponent4.addMouseListener(new MouseAdapter((Details.Player)object3, jCheckBoxArray, (JCheckBox)jComponent4){
                private final /* synthetic */ Details.Player val$player;
                private final /* synthetic */ JCheckBox[] val$playerCheckBoxes;
                private final /* synthetic */ JCheckBox val$playerCheckBox;
                {
                    this.val$player = player;
                    this.val$playerCheckBoxes = jCheckBoxArray;
                    this.val$playerCheckBox = jCheckBox;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 3) {
                        PlayerPopupMenu playerPopupMenu = new PlayerPopupMenu(this.val$player.name, this.val$player.battleNetId, this.val$player.battleNetSubid, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.initData.gateway, this.val$player.type);
                        playerPopupMenu.addSeparator();
                        JMenuItem jMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.showOnlyThisPlayer"), Icons.USER_ARROW);
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                JCheckBox[] jCheckBoxArray = val$playerCheckBoxes;
                                int n = val$playerCheckBoxes.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    JCheckBox jCheckBox = jCheckBoxArray[n2];
                                    if (val$playerCheckBox != jCheckBox && jCheckBox.isSelected() || val$playerCheckBox == jCheckBox && !jCheckBox.isSelected()) {
                                        jCheckBox.doClick(0);
                                    }
                                    ++n2;
                                }
                            }
                        });
                        playerPopupMenu.add(jMenuItem);
                        playerPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            box4.add(jComponent3);
            box4.add(Box.createHorizontalStrut(5));
            ++n2;
        }
        box.add(box4);
        jPanel.add((Component)box, "North");
        final JSplitPane jSplitPane = new JSplitPane(0, true);
        jSplitPane.setDividerSize(6);
        object3 = GuiUtils.createComboBox(new Integer[]{1, 2, 3, 4, 5, 10, 15, 20, 30, 50, 100}, "module.repAnalyzer.charts.apm.granularity");
        ((JComboBox)object3).addActionListener(actionListener);
        jComponent4 = GuiUtils.createComboBox((Object[])ChartUtils.GraphApproximation.values(), "module.repAnalyzer.charts.apm.graphApproximation");
        ((JComboBox)jComponent4).addActionListener(actionListener);
        JCheckBox jCheckBox6 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.hotkeys.showSelectHotkeys", "module.repAnalyzer.charts.hotkeys.showSelectHotkeys");
        jCheckBox6.addActionListener(actionListener);
        jComponent3 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showBuilds", "module.repAnalyzer.charts.buildsTech.showBuilds");
        ((AbstractButton)jComponent3).addActionListener(actionListener);
        jComponent2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showTrains", "module.repAnalyzer.charts.buildsTech.showTrains");
        ((AbstractButton)jComponent2).addActionListener(actionListener);
        final JCheckBox jCheckBox7 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showWorkers", "module.repAnalyzer.charts.buildsTech.showWorkers");
        ActionListener actionListener6 = new ActionListener((JCheckBox)jComponent2){
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            {
                this.val$showTrainsCheckBox = jCheckBox2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox7.setEnabled(this.val$showTrainsCheckBox.isSelected());
            }
        };
        actionListener6.actionPerformed(null);
        ((AbstractButton)jComponent2).addActionListener(actionListener6);
        jCheckBox7.addActionListener(actionListener);
        JCheckBox jCheckBox8 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showResearches", "module.repAnalyzer.charts.buildsTech.showResearches");
        jCheckBox8.addActionListener(actionListener);
        JCheckBox jCheckBox9 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.showUpgrades", "module.repAnalyzer.charts.buildsTech.showUpgrades");
        jCheckBox9.addActionListener(actionListener);
        JCheckBox jCheckBox10 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTech.useIcons", "module.repAnalyzer.charts.buildsTech.useIcons");
        jCheckBox10.addActionListener(actionListener);
        JCheckBox jCheckBox11 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showUnits", "module.repAnalyzer.charts.buildsTechStat.showUnits");
        jCheckBox11.addActionListener(actionListener);
        JCheckBox jCheckBox12 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showBuildings", "module.repAnalyzer.charts.buildsTechStat.showBuildings");
        jCheckBox12.addActionListener(actionListener);
        JCheckBox jCheckBox13 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showResearches", "module.repAnalyzer.charts.buildsTechStat.showResearches");
        jCheckBox13.addActionListener(actionListener);
        JCheckBox jCheckBox14 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showUpgrades", "module.repAnalyzer.charts.buildsTech.showUpgrades");
        jCheckBox14.addActionListener(actionListener);
        JCheckBox jCheckBox15 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.buildsTechStat.showAbilityGroups", "module.repAnalyzer.charts.buildsTechStat.showAbilityGroups");
        jCheckBox15.addActionListener(actionListener);
        JComboBox jComboBox3 = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(IconHandler.Size.values(), EnumSet.of(IconHandler.Size.HIDDEN)), "module.repAnalyzer.charts.buildsTechStat.barSize");
        jComboBox3.addActionListener(actionListener);
        JComboBox jComboBox4 = GuiUtils.createComboBox((Object[])MapViewQuality.values(), "module.repAnalyzer.charts.mapView.quality");
        jComboBox4.addActionListener(actionListener);
        final JComboBox jComboBox5 = GuiUtils.createComboBox(new Object[]{"2x2", "3x3", "4x4", "6x6", "8x8", "12x12", "16x16", "32x32", "64x64", "128x128", "256x256"}, "module.repAnalyzer.charts.mapView.hotAreasCount");
        final JComboBox jComboBox6 = GuiUtils.createComboBox((Object[])MapBackground.values(), "module.repAnalyzer.charts.mapView.background");
        jComboBox6.addActionListener(actionListener);
        ActionListener actionListener7 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jComboBox5.setEnabled(jComboBox6.getSelectedItem() == MapBackground.HOT_AREAS);
            }
        };
        actionListener7.actionPerformed(null);
        jComboBox6.addActionListener(actionListener7);
        jComboBox5.setMaximumRowCount(jComboBox5.getModel().getSize());
        jComboBox5.addActionListener(actionListener);
        JCheckBox jCheckBox16 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.mapView.hideOverlappedBuildings", "module.repAnalyzer.charts.mapView.hideOverlappedBuildings");
        jCheckBox16.addActionListener(actionListener);
        JCheckBox jCheckBox17 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.mapView.fillBuildingIcons", "module.repAnalyzer.charts.mapView.fillBuildingIcons");
        jCheckBox17.addActionListener(actionListener);
        JCheckBox jCheckBox18 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.mapView.showMapObjects", "module.repAnalyzer.charts.mapView.showMapObjects");
        jCheckBox18.addActionListener(actionListener);
        ActionListener actionListener8 = new ActionListener((JComboBox)object3, (JComboBox)jComponent4, jCheckBox6, (JCheckBox)jComponent3, (JCheckBox)jComponent2, jCheckBox7, jCheckBox8, jCheckBox9, jCheckBox10, jCheckBox11, jCheckBox12, jCheckBox13, jCheckBox14, jCheckBox15, jComboBox3, jComboBox4, jComboBox6, jComboBox5, jCheckBox16, jCheckBox17, jCheckBox18, jPanel){
            private final /* synthetic */ JComboBox val$apmGranularityComboBox;
            private final /* synthetic */ JComboBox val$apmApproximationComboBox;
            private final /* synthetic */ JCheckBox val$showSelectHotkeysCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildsCheckBox;
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            private final /* synthetic */ JCheckBox val$showWorkersCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesCheckBox;
            private final /* synthetic */ JCheckBox val$useIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showUnitsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildingsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsStatCheckBox;
            private final /* synthetic */ JComboBox val$barSizeComboBox;
            private final /* synthetic */ JComboBox val$mapViewQualityComboBox;
            private final /* synthetic */ JComboBox val$mapBackgroundComboBox;
            private final /* synthetic */ JComboBox val$hotAreasCountComboBox;
            private final /* synthetic */ JCheckBox val$hideOverlappedBuildingsCheckBox;
            private final /* synthetic */ JCheckBox val$fillBuildingIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showMapObjectsCheckBox;
            private final /* synthetic */ JPanel val$chartsPanel;
            {
                this.val$apmGranularityComboBox = jComboBox2;
                this.val$apmApproximationComboBox = jComboBox3;
                this.val$showSelectHotkeysCheckBox = jCheckBox;
                this.val$showBuildsCheckBox = jCheckBox2;
                this.val$showTrainsCheckBox = jCheckBox3;
                this.val$showWorkersCheckBox = jCheckBox4;
                this.val$showResearchesCheckBox = jCheckBox5;
                this.val$showUpgradesCheckBox = jCheckBox6;
                this.val$useIconsCheckBox = jCheckBox7;
                this.val$showUnitsStatCheckBox = jCheckBox8;
                this.val$showBuildingsStatCheckBox = jCheckBox9;
                this.val$showResearchesStatCheckBox = jCheckBox10;
                this.val$showUpgradesStatCheckBox = jCheckBox11;
                this.val$showAbilityGroupsStatCheckBox = jCheckBox12;
                this.val$barSizeComboBox = jComboBox4;
                this.val$mapViewQualityComboBox = jComboBox5;
                this.val$mapBackgroundComboBox = jComboBox6;
                this.val$hotAreasCountComboBox = jComboBox7;
                this.val$hideOverlappedBuildingsCheckBox = jCheckBox13;
                this.val$fillBuildingIconsCheckBox = jCheckBox14;
                this.val$showMapObjectsCheckBox = jCheckBox15;
                this.val$chartsPanel = jPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                box3.removeAll();
                switch ((ChartType)((Object)jComboBox.getSelectedItem())) {
                    case APM: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(new JLabel(Language.getText("charts.granularity")));
                        box3.add(this.val$apmGranularityComboBox);
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.apm.pixels")));
                        box3.add(Box.createHorizontalStrut(6));
                        box3.add(new JLabel(Language.getText("charts.graphApproximation")));
                        box3.add(this.val$apmApproximationComboBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case HOTKEYS: {
                        box3.add(this.val$showSelectHotkeysCheckBox);
                        break;
                    }
                    case BUILDS_TECH: {
                        box3.add(this.val$showBuildsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showTrainsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showWorkersCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showResearchesCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showUpgradesCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$useIconsCheckBox);
                        break;
                    }
                    case BUILDS_TECH_STAT: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(this.val$showUnitsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showBuildingsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showResearchesStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showUpgradesStatCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showAbilityGroupsStatCheckBox);
                        box3.add(Box.createHorizontalStrut(4));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.buildsTechStat.barSize")));
                        box3.add(this.val$barSizeComboBox);
                        box3.add(new JPanel(new BorderLayout()));
                        break;
                    }
                    case MAP_VIEW: {
                        box3.add(new JPanel(new BorderLayout()));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.mapView.quality")));
                        box3.add(this.val$mapViewQualityComboBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.mapView.background")));
                        box3.add(this.val$mapBackgroundComboBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.mapView.hotAreasCount")));
                        box3.add(this.val$hotAreasCountComboBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$hideOverlappedBuildingsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$fillBuildingIconsCheckBox);
                        box3.add(Box.createHorizontalStrut(3));
                        box3.add(this.val$showMapObjectsCheckBox);
                        box3.add(new JPanel(new BorderLayout()));
                    }
                }
                this.val$chartsPanel.validate();
                this.val$chartsPanel.repaint();
            }
        };
        jComboBox.addActionListener(actionListener8);
        actionListener8.actionPerformed(null);
        final Holder<Integer> holder5 = new Holder<Integer>();
        final Holder<Integer> holder6 = new Holder<Integer>();
        final Holder holder7 = new Holder();
        final Holder<ChartParams> holder8 = new Holder<ChartParams>();
        final JScrollPane jScrollPane = new JScrollPane(21, 31);
        holder.value = new JComponent((JComboBox)object3, (JComboBox)jComponent4, jCheckBox6, (JCheckBox)jComponent3, (JCheckBox)jComponent2, jCheckBox7, jCheckBox8, jCheckBox9, jCheckBox10, jCheckBox11, jCheckBox12, jCheckBox13, jCheckBox14, jCheckBox15, jComboBox3, jComboBox4, jComboBox6, jComboBox5, jCheckBox16, jCheckBox17, jCheckBox18, jScrollPane){
            private final /* synthetic */ JComboBox val$apmGranularityComboBox;
            private final /* synthetic */ JComboBox val$apmApproximationComboBox;
            private final /* synthetic */ JCheckBox val$showSelectHotkeysCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildsCheckBox;
            private final /* synthetic */ JCheckBox val$showTrainsCheckBox;
            private final /* synthetic */ JCheckBox val$showWorkersCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesCheckBox;
            private final /* synthetic */ JCheckBox val$useIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showUnitsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showBuildingsStatCheckBox;
            private final /* synthetic */ JCheckBox val$showResearchesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showUpgradesStatCheckBox;
            private final /* synthetic */ JCheckBox val$showAbilityGroupsStatCheckBox;
            private final /* synthetic */ JComboBox val$barSizeComboBox;
            private final /* synthetic */ JComboBox val$mapViewQualityComboBox;
            private final /* synthetic */ JComboBox val$mapBackgroundComboBox;
            private final /* synthetic */ JComboBox val$hotAreasCountComboBox;
            private final /* synthetic */ JCheckBox val$hideOverlappedBuildingsCheckBox;
            private final /* synthetic */ JCheckBox val$fillBuildingIconsCheckBox;
            private final /* synthetic */ JCheckBox val$showMapObjectsCheckBox;
            private final /* synthetic */ JScrollPane val$chartCanvasScrollPane;
            {
                this.val$apmGranularityComboBox = jComboBox3;
                this.val$apmApproximationComboBox = jComboBox4;
                this.val$showSelectHotkeysCheckBox = jCheckBox6;
                this.val$showBuildsCheckBox = jCheckBox7;
                this.val$showTrainsCheckBox = jCheckBox8;
                this.val$showWorkersCheckBox = jCheckBox9;
                this.val$showResearchesCheckBox = jCheckBox10;
                this.val$showUpgradesCheckBox = jCheckBox11;
                this.val$useIconsCheckBox = jCheckBox12;
                this.val$showUnitsStatCheckBox = jCheckBox13;
                this.val$showBuildingsStatCheckBox = jCheckBox14;
                this.val$showResearchesStatCheckBox = jCheckBox15;
                this.val$showUpgradesStatCheckBox = jCheckBox16;
                this.val$showAbilityGroupsStatCheckBox = jCheckBox17;
                this.val$barSizeComboBox = jComboBox5;
                this.val$mapViewQualityComboBox = jComboBox6;
                this.val$mapBackgroundComboBox = jComboBox7;
                this.val$hotAreasCountComboBox = jComboBox8;
                this.val$hideOverlappedBuildingsCheckBox = jCheckBox18;
                this.val$fillBuildingIconsCheckBox = jCheckBox19;
                this.val$showMapObjectsCheckBox = jCheckBox20;
                this.val$chartCanvasScrollPane = jScrollPane;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                holder8.value = new ChartParams();
                ChartParams chartParams = holder8.value;
                chartParams.chartCanvas = (JComponent)holder.value;
                chartParams.markerFrame = (Integer)holder5.value;
                chartParams.markerX = (Integer)holder6.value;
                chartParams.selectedAction = (GameEvents.Action)holder7.value;
                chartParams.visibleRectangle = this.getVisibleRect();
                chartParams.g2 = (Graphics2D)graphics;
                chartParams.replay = ReplayAnalyzer.this.replay;
                chartParams.actions = jCheckBox.isSelected() ? (GameEvents.Action[])holder2.value : ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.actions;
                chartParams.chartType = (ChartType)((Object)jComboBox.getSelectedItem());
                chartParams.groupByTeam = jCheckBox2.isSelected();
                chartParams.allPlayersOnOneChart = jCheckBox3.isSelected();
                chartParams.usePlayersInGameColors = jCheckBox4.isSelected();
                chartParams.displayInSeconds = jCheckBox5.isSelected();
                chartParams.zoom = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                chartParams.setVisiblePlayers(jCheckBoxArray, nArray);
                chartParams.width = this.getWidth();
                chartParams.height = this.getHeight();
                switch (chartParams.chartType) {
                    case APM: {
                        chartParams.apmGranularity = (Integer)this.val$apmGranularityComboBox.getSelectedItem();
                        chartParams.apmApproximation = (ChartUtils.GraphApproximation)((Object)this.val$apmApproximationComboBox.getSelectedItem());
                        break;
                    }
                    case HOTKEYS: {
                        chartParams.showSelectHotkeys = this.val$showSelectHotkeysCheckBox.isSelected();
                        break;
                    }
                    case BUILDS_TECH: {
                        chartParams.showBuilds = this.val$showBuildsCheckBox.isSelected();
                        chartParams.showTrains = this.val$showTrainsCheckBox.isSelected();
                        chartParams.showWorkers = this.val$showWorkersCheckBox.isSelected();
                        chartParams.showResearches = this.val$showResearchesCheckBox.isSelected();
                        chartParams.showUpgrades = this.val$showUpgradesCheckBox.isSelected();
                        chartParams.useIcons = this.val$useIconsCheckBox.isSelected();
                        break;
                    }
                    case BUILDS_TECH_STAT: {
                        chartParams.showUnitsStat = this.val$showUnitsStatCheckBox.isSelected();
                        chartParams.showBuildingsStat = this.val$showBuildingsStatCheckBox.isSelected();
                        chartParams.showResearchesStat = this.val$showResearchesStatCheckBox.isSelected();
                        chartParams.showUpgradesStat = this.val$showUpgradesStatCheckBox.isSelected();
                        chartParams.showAbilityGroupsStat = this.val$showAbilityGroupsStatCheckBox.isSelected();
                        chartParams.barSize = (IconHandler.Size)((Object)this.val$barSizeComboBox.getSelectedItem());
                        break;
                    }
                    case MAP_VIEW: {
                        chartParams.mapViewQuality = (MapViewQuality)((Object)this.val$mapViewQualityComboBox.getSelectedItem());
                        chartParams.mapBackground = (MapBackground)((Object)this.val$mapBackgroundComboBox.getSelectedItem());
                        String string = (String)this.val$hotAreasCountComboBox.getSelectedItem();
                        chartParams.hotAreasCount = Integer.parseInt(string.substring(0, string.indexOf(120)));
                        chartParams.hideOverlappedBuildings = this.val$hideOverlappedBuildingsCheckBox.isSelected();
                        chartParams.fillBuildingIcons = this.val$fillBuildingIconsCheckBox.isSelected();
                        chartParams.showMapObjectsCheckBox = this.val$showMapObjectsCheckBox.isSelected();
                    }
                }
                new ChartPainter(chartParams).paintChart();
            }

            @Override
            public Dimension getPreferredSize() {
                if (jComboBox.getSelectedItem() == ChartType.MAP_VIEW && ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo != null) {
                    int n = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                    return new Dimension(((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.width * n << 1, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.height * n << 1);
                }
                Dimension dimension = this.val$chartCanvasScrollPane.getViewport().getExtentSize();
                dimension.width *= Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                return dimension;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                ChartParams chartParams = (ChartParams)holder8.value;
                if (chartParams == null) {
                    return null;
                }
                if (chartParams.toolTipProvider == null) {
                    int n = chartParams.xToFrame(mouseEvent.getX());
                    return n < 0 ? null : Language.getText("module.repAnalyzer.tab.charts.chartTooltip.frameTime", n, ReplayUtils.formatFrames(n, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.converterGameSpeed));
                }
                return chartParams.toolTipProvider.getToolTip(mouseEvent.getPoint());
            }
        };
        final JComponent jComponent5 = holder.value;
        jComponent5.setToolTipText("");
        GuiUtils.makeComponentDragScrollable(jComponent5);
        final BoolHolder boolHolder = new BoolHolder();
        final Task<Integer> task = new Task<Integer>(){

            @Override
            public void execute(Integer n) {
                if (holder8.value != null && ((GameEvents.Action[])holder2.value).length > 0) {
                    GameEvents.Action action = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.new GameEvents.Action();
                    action.frame = n;
                    int n2 = Arrays.binarySearch((GameEvents.Action[])holder2.value, action, ReplayUtils.ACTION_FRAME_COMPARATOR);
                    int n3 = n2 >= 0 ? n2 : (-n2 <= ((GameEvents.Action[])holder2.value).length ? -n2 - 1 : -n2 - 2);
                    boolHolder.value = true;
                    jList.setSelectedIndex(n3);
                    jList.ensureIndexIsVisible(n3);
                    boolHolder.value = false;
                }
            }
        };
        final Animator animator = new Animator(this.replay, jComponent5, holder8, holder6, holder5, task);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                animator.requestToCancel();
            }
        });
        jComponent5.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    new ReplayOperationsPopupMenu(new File[]{ReplayAnalyzer.this.replayFile}, new ReplayOperationsPopupMenu.ReplayOpCallback(){

                        @Override
                        public void replayRenamed(File file, File file2, int n) {
                            ReplayAnalyzer.this.replayFile = file2;
                        }

                        @Override
                        public void replayMoved(File file, File file2, int n) {
                            ReplayAnalyzer.this.replayFile = new File(file2, file.getName());
                        }

                        @Override
                        public void replayDeleted(File file, int n) {
                        }

                        @Override
                        public void moveRenameDeleteEnded() {
                            ReplayAnalyzer.this.setTitle(GeneralUtils.getFileNameWithoutExt(ReplayAnalyzer.this.replayFile));
                            MainFrame.INSTANCE.refreshRepAnalNavigationNode();
                        }
                    }).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (jComboBox.getSelectedItem() != ChartType.MAP_VIEW && holder8.value != null) {
                    holder6.value = Math.max(25, mouseEvent.getX());
                    holder5.value = null;
                    jComponent5.repaint();
                    task.execute(((ChartParams)holder8.value).xToFrame((Integer)holder6.value));
                    animator.setCurrentFrame(((ChartParams)holder8.value).xToFrame((Integer)holder6.value));
                }
            }
        });
        jScrollPane.setViewportView(jComponent5);
        jSplitPane.setTopComponent(jScrollPane);
        final ActionListener actionListener9 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(((String)jComboBox2.getSelectedItem()).substring(1));
                jLabel2.setBackground(n == 1 ? null : Color.GREEN);
                if (jComboBox.getSelectedItem() == ChartType.MAP_VIEW) {
                    jScrollPane.setHorizontalScrollBarPolicy(32);
                    jScrollPane.setVerticalScrollBarPolicy(22);
                } else {
                    jScrollPane.setHorizontalScrollBarPolicy(n > 1 ? 32 : 31);
                    jScrollPane.setVerticalScrollBarPolicy(21);
                }
                jComponent5.invalidate();
                jScrollPane.validate();
            }
        };
        actionListener9.actionPerformed(null);
        jComboBox2.addActionListener(actionListener9);
        jComboBox.addActionListener(new ActionListener(){
            private boolean lastWasMapView;
            {
                this.lastWasMapView = jComboBox2.getSelectedItem() == ChartType.MAP_VIEW;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = jComboBox.getSelectedItem() == ChartType.MAP_VIEW;
                if (bl ^ this.lastWasMapView) {
                    actionListener9.actionPerformed(null);
                }
                this.lastWasMapView = bl;
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        Box box5 = Box.createHorizontalBox();
        box5.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.displayActionTypes")));
        box5.add(Box.createHorizontalStrut(5));
        Object object4 = ReplayConsts.ActionType.values();
        int n4 = ((ReplayConsts.ActionType[])object4).length;
        int n5 = 0;
        while (n5 < n4) {
            object2 = object4[n5];
            jComponent = GuiUtils.createCheckBox(((ReplayConsts.ActionType)((Object)object2)).textKey, "module.repAnalyzer.charts.actions.actionType." + ((Enum)object2).ordinal());
            ((AbstractButton)jComponent).addActionListener(actionListener2);
            enumMap.put((ReplayConsts.ActionType)((Object)object2), (JCheckBox)jComponent);
            box5.add(jComponent);
            box5.add(Box.createHorizontalStrut(5));
            ++n5;
        }
        box5.add(new JPanel(new BorderLayout()));
        box5.add(animator.getControlUIComponent());
        jPanel2.add((Component)box5, "North");
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && jList.getSelectedIndex() >= 0 && !boolHolder.value) {
                    holder6.value = null;
                    holder7.value = ((GameEvents.Action[])holder2.value)[jList.getSelectedIndex()];
                    holder5.value = ((GameEvents.Action)holder7.value).frame;
                    int n = (Integer)holder5.value;
                    animator.setCurrentFrame((Integer)holder5.value);
                    if (holder8.value != null) {
                        Rectangle rectangle = ((ChartParams)holder8.value).visibleRectangle;
                        if (((ChartParams)holder8.value).chartType == ChartType.MAP_VIEW) {
                            int n2;
                            int n3;
                            GameEvents.BaseUseAbilityAction baseUseAbilityAction;
                            GameEvents.Action action = (GameEvents.Action)jList.getSelectedValue();
                            if (action instanceof GameEvents.BaseUseAbilityAction && (baseUseAbilityAction = (GameEvents.BaseUseAbilityAction)action).hasTargetPoint() && !rectangle.contains(n3 = ((ChartParams)holder8.value).scaleMapCoord(baseUseAbilityAction.targetP1), n2 = (((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.height * ((ChartParams)holder8.value).zoom << 1) - ((ChartParams)holder8.value).scaleMapCoord(baseUseAbilityAction.targetP2))) {
                                int n4 = Math.min(Math.min(10 * ((ChartParams)holder8.value).zoom, rectangle.width), rectangle.height);
                                jComponent5.scrollRectToVisible(new Rectangle(n3 - n4, n2 - n4, n4 << 1, n4 << 1));
                                jScrollPane.repaint();
                            }
                        } else if (n < rectangle.x || n >= rectangle.x + rectangle.width) {
                            jComponent5.scrollRectToVisible(new Rectangle(((ChartParams)holder8.value).frameToX(n) - (rectangle.width >> 2), 0, rectangle.width >> 1, 1));
                        }
                    }
                    jComponent5.repaint();
                }
            }
        });
        jList.setFont(new Font("Monospaced", 0, 12));
        object2 = GuiUtils.createCheckBox("module.repAnalyzer.tab.charts.actions.invertColors", "module.repAnalyzer.charts.actions.invertColors");
        final JComboBox jComboBox7 = GuiUtils.createComboBox((Object[])IconHandler.Size.values(), "module.repAnalyzer.charts.actions.iconSize");
        jList.setCellRenderer(new ListCellRenderer((JCheckBox)object2, jCheckBox4){
            private final JLabel label = new JLabel();
            private final /* synthetic */ JCheckBox val$invertListColorsCheckBox;
            private final /* synthetic */ JCheckBox val$usePlayersColorsCheckBox;
            {
                this.val$invertListColorsCheckBox = jCheckBox;
                this.val$usePlayersColorsCheckBox = jCheckBox2;
                this.label.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                GameEvents.Action action = (GameEvents.Action)object;
                IconHandler.Size size = (IconHandler.Size)((Object)jComboBox7.getSelectedItem());
                if (size == IconHandler.Size.HIDDEN) {
                    this.label.setIcon(null);
                } else if (action instanceof GameEvents.UseUnitAbilityAction) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.UseUnitAbilityAction)action).unitAbility.abilityGroup, size));
                } else if (action instanceof GameEvents.TrainAction) {
                    this.label.setIcon(Icons.getUnitIcon(((GameEvents.TrainAction)action).unit, size));
                } else if (action instanceof GameEvents.UseBuildingAbilityAction) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.UseBuildingAbilityAction)action).buildingAbility.abilityGroup, size));
                } else if (action instanceof GameEvents.BuildAction) {
                    this.label.setIcon(Icons.getBuildingIcon(((GameEvents.BuildAction)action).building, size));
                } else if (action instanceof GameEvents.UpgradeAction) {
                    this.label.setIcon(Icons.getUpgradeIcon(((GameEvents.UpgradeAction)action).upgrade, size));
                } else if (action instanceof GameEvents.ResearchAction) {
                    this.label.setIcon(Icons.getResearchIcon(((GameEvents.ResearchAction)action).research, size));
                } else if (action instanceof GameEvents.BaseUseAbilityAction && ((GameEvents.BaseUseAbilityAction)action).abilityGroup != null) {
                    this.label.setIcon(Icons.getAbilityGroupIcon(((GameEvents.BaseUseAbilityAction)action).abilityGroup, size));
                } else {
                    this.label.setIcon(IconHandler.NULL.get((Object)size));
                }
                this.label.setText(action.toString());
                if (bl ^ this.val$invertListColorsCheckBox.isSelected()) {
                    this.label.setBackground(this.val$usePlayersColorsCheckBox.isSelected() ? ((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players[action.player].getDarkerColor() : jList.getSelectionBackground());
                    this.label.setForeground(this.val$usePlayersColorsCheckBox.isSelected() ? Color.WHITE : jList.getSelectionForeground());
                } else {
                    this.label.setBackground(jList.getBackground());
                    this.label.setForeground(this.val$usePlayersColorsCheckBox.isSelected() ? ((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players[action.player].getDarkerColor() : jList.getForeground());
                }
                this.label.setEnabled(jList.isEnabled());
                this.label.setFont(jList.getFont());
                return this.label;
            }
        });
        jPanel2.add((Component)new JScrollPane(jList), "Center");
        Box box6 = Box.createVerticalBox();
        object4 = new JPanel(new GridLayout(4, 2, 0, 0));
        ((Container)object4).add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.jumpToFrame")));
        jComponent = new JTextField(1);
        jComponent.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.jumpToFrameToolTip"));
        ((JTextField)jComponent).addActionListener(new ActionListener((JTextField)jComponent, jList, jComponent5){
            private final /* synthetic */ JTextField val$jumpToFrameTextField;
            private final /* synthetic */ JList val$actionsList;
            private final /* synthetic */ JComponent val$chartCanvas;
            {
                this.val$jumpToFrameTextField = jTextField;
                this.val$actionsList = jList;
                this.val$chartCanvas = jComponent;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((GameEvents.Action[])holder2.value).length > 0) {
                    try {
                        int n = Integer.parseInt(this.val$jumpToFrameTextField.getText());
                        GameEvents.Action action = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.gameEvents.new GameEvents.Action();
                        action.frame = n;
                        int n2 = Arrays.binarySearch((GameEvents.Action[])holder2.value, action, ReplayUtils.ACTION_FRAME_COMPARATOR);
                        int n3 = n2 >= 0 ? n2 : (-n2 <= ((GameEvents.Action[])holder2.value).length ? -n2 - 1 : -n2 - 2);
                        this.val$actionsList.setSelectedIndex(n3);
                        this.val$actionsList.ensureIndexIsVisible(n3);
                        this.val$chartCanvas.repaint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        ((Container)object4).add(jComponent);
        ((Container)object4).add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.searchText")));
        final JTextField jTextField = new JTextField(1);
        jTextField.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.searchTextToolTip"));
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText().trim().toLowerCase();
                if (((GameEvents.Action[])holder2.value).length > 0 && string.length() > 0) {
                    int n;
                    GameEvents.Action[] actionArray = (GameEvents.Action[])holder2.value;
                    int n2 = n = jList.getSelectedIndex() < 0 ? actionArray.length - 1 : jList.getSelectedIndex();
                    do {
                        if (++n2 == actionArray.length) {
                            n2 = 0;
                        }
                        if (!actionArray[n2].toString().toLowerCase().contains(string)) continue;
                        jList.setSelectedIndex(n2);
                        jList.ensureIndexIsVisible(n2);
                        jComponent5.repaint();
                        break;
                    } while (n2 != n);
                }
            }
        });
        ((Container)object4).add(jTextField);
        final JLabel jLabel3 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterActions"));
        jLabel3.setOpaque(true);
        ((Container)object4).add(jLabel3);
        final JTextField jTextField2 = new JTextField(1);
        jTextField2.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterActionsToolTip"));
        final ActionListener actionListener10 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                holder3.value = ReplayAnalyzer.createFilterGroups(jTextField2.getText());
                jLabel3.setBackground(holder3.value == null ? null : Color.GREEN);
                if (actionEvent != null) {
                    actionListener2.actionPerformed(null);
                }
            }
        };
        jTextField2.addActionListener(actionListener10);
        ((Container)object4).add(jTextField2);
        final JLabel jLabel4 = new JLabel(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterOutActions"));
        jLabel4.setOpaque(true);
        ((Container)object4).add(jLabel4);
        final JTextField jTextField3 = new JTextField(1);
        jTextField3.setToolTipText(Language.getText("module.repAnalyzer.tab.charts.actionOps.filterOutActionsToolTip"));
        final ActionListener actionListener11 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                holder4.value = ReplayAnalyzer.createFilterGroups(jTextField3.getText());
                jLabel4.setBackground(holder4.value == null ? null : Color.GREEN);
                if (actionEvent != null) {
                    actionListener2.actionPerformed(null);
                }
            }
        };
        jTextField3.addActionListener(actionListener11);
        ((Container)object4).add(jTextField3);
        box6.add((Component)object4);
        object4 = new JPanel(new GridLayout(1, 2, 0, 0));
        ((Container)object4).add(new JLabel());
        JButton jButton = new JButton();
        GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.charts.actionOps.clearFiltersButton", new Object[0]);
        jButton.putClientProperty("JComponent.sizeVariant", "small");
        jButton.updateUI();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField2.setText("");
                jTextField3.setText("");
                actionListener10.actionPerformed(null);
                actionListener11.actionPerformed(null);
                actionListener2.actionPerformed(null);
            }
        });
        ((Container)object4).add(jButton);
        box6.add((Component)object4);
        box6.add(new JPanel(new BorderLayout()));
        box6.setMinimumSize(new Dimension(10, 10));
        jPanel2.add((Component)box6, "East");
        Box box7 = Box.createHorizontalBox();
        box7.add(jLabel);
        box7.add(Box.createHorizontalStrut(12));
        ((AbstractButton)object2).addActionListener(actionListener3);
        box7.add((Component)object2);
        box7.add(Box.createHorizontalStrut(12));
        box7.add(new JLabel(Language.getText("module.repAnalyzer.tab.charts.actions.iconSizes")));
        jComboBox7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jList.updateUI();
            }
        });
        box7.add(jComboBox7);
        box7.add(Box.createHorizontalStrut(12));
        jCheckBox.setOpaque(true);
        ActionListener actionListener12 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox.setBackground(jCheckBox.isSelected() ? Color.GREEN : null);
            }
        };
        actionListener12.actionPerformed(null);
        jCheckBox.addActionListener(actionListener12);
        jCheckBox.addActionListener(actionListener);
        box7.add(jCheckBox);
        box7.add(new JPanel(new BorderLayout()));
        JLabel jLabel5 = MiscSettingsDialog.createLinkLabelToSettings("miscSettings.tab.analyzer");
        jLabel5.setHorizontalAlignment(4);
        box7.add(jLabel5);
        jPanel2.add((Component)box7, "South");
        jSplitPane.setBottomComponent(jPanel2);
        jPanel.add(jSplitPane);
        final double d = (double)Settings.getInt("settings.misc.chartsActionListPartitioning") / 100.0;
        jSplitPane.setResizeWeight(d);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jSplitPane.setDividerLocation(d);
            }
        });
        actionListener2.actionPerformed(null);
        ChartType[] chartTypeArray = ChartType.values();
        int n6 = chartTypeArray.length;
        int n7 = 0;
        while (n7 < n6) {
            final ChartType chartType = chartTypeArray[n7];
            object = new Object();
            jPanel.getInputMap(1).put(chartType.keyStroke, object);
            jPanel.getActionMap().put(object, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jComboBox.setSelectedItem((Object)chartType);
                }
            });
            ++n7;
        }
        object = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(73, 2), object);
        jPanel.getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox2.getSelectedIndex() < jComboBox2.getItemCount() - 1) {
                    jComboBox2.setSelectedIndex(jComboBox2.getSelectedIndex() + 1);
                }
            }
        });
        object = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(85, 2), object);
        jPanel.getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox2.getSelectedIndex() > 0) {
                    jComboBox2.setSelectedIndex(jComboBox2.getSelectedIndex() - 1);
                }
            }
        });
        object = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(74, 2), object);
        jPanel.getActionMap().put(object, new AbstractAction((JTextField)jComponent){
            private final /* synthetic */ JTextField val$jumpToFrameTextField;
            {
                this.val$jumpToFrameTextField = jTextField;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$jumpToFrameTextField.requestFocusInWindow();
            }
        });
        object = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(83, 2), object);
        jPanel.getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField.requestFocusInWindow();
            }
        });
        object = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(70, 2), object);
        jPanel.getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField2.requestFocusInWindow();
            }
        });
        object = new Object();
        jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(84, 2), object);
        jPanel.getActionMap().put(object, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField3.requestFocusInWindow();
            }
        });
        return jPanel;
    }

    private static String[][] createFilterGroups(String string) {
        String[][] stringArray;
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase());
        ArrayList<String[][]> arrayList2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (stringArray.equals("or")) {
                arrayList2 = null;
                continue;
            }
            if (stringArray.equals("and")) continue;
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<String[][]>(2);
                arrayList.add(arrayList2);
            }
            arrayList2.add(stringArray);
        }
        stringArray = new String[arrayList.size()][];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((List)arrayList.get(n)).toArray(new String[0]);
            ++n;
        }
        return stringArray;
    }

    private JComponent createGameInfoTab() {
        Details.Player[] playerArray;
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setTabSize(4);
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.fileName", this.replayFile.getAbsolutePath()));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.version", this.replay.version));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.date", Language.formatDateTime(new Date(this.replay.details.saveTime))));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameLength", ReplayUtils.formatMs(this.replay.gameLength * 500, this.replay.converterGameSpeed)));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameSpeed", new Object[]{this.replay.initData.gameSpeed}));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gameType", new Object[]{this.replay.initData.gameType}));
        if (this.replay.initData.format != null) {
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.format", new Object[]{this.replay.initData.format}));
        }
        if (this.replay.initData.gateway != null) {
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.gateway", new Object[]{this.replay.initData.gateway}));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.replay.initData.getArrangedClientNames(this.replay.details.players);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
            ++n2;
        }
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.clients", stringBuilder));
        GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapName", this.replay.details.mapName));
        if (this.replay.initData.mapFileName != null) {
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapFile", this.replay.initData.mapFileName));
        }
        if (this.replay.mapInfo != null) {
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapSize", this.replay.mapInfo.getSizeString()));
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.mapPlayableSize", this.replay.mapInfo.getPlayableSizeString()));
        }
        jTextArea.append("\n");
        jTextArea.append(Language.getText("module.repAnalyzer.tab.gameInfo.players"));
        int n3 = -1;
        int[] nArray = this.replay.details.getTeamOrderPlayerIndices();
        int n4 = nArray.length;
        n = 0;
        while (n < n4) {
            n2 = nArray[n];
            playerArray = this.replay.details.players[n2];
            if (playerArray.team != n3) {
                jTextArea.append("\n\t" + Language.getText("module.repAnalyzer.tab.gameInfo.team", playerArray.team == Integer.MAX_VALUE ? Language.getText("general.unknown") : Integer.valueOf(playerArray.team)));
                n3 = playerArray.team;
            }
            jTextArea.append("\n\t\t");
            jTextArea.append(playerArray.fullName);
            jTextArea.append(", ");
            jTextArea.append(playerArray.raceString());
            int n5 = ReplayUtils.calculateApm(playerArray.actionsCount - playerArray.excludedActionsCount, this.replay.converterGameSpeed.convertToRealTime(playerArray.lastActionFrame - this.replay.excludedInitialFrames));
            jTextArea.append(", ");
            jTextArea.append(Language.getText("module.repAnalyzer.tab.charts.chartText.apm", n5));
            if (playerArray.type != null) {
                jTextArea.append(", ");
                jTextArea.append(playerArray.type.stringValue);
                if (playerArray.type == ReplayConsts.PlayerType.COMPUTER) {
                    jTextArea.append(" (");
                    jTextArea.append(playerArray.difficulty.stringValue);
                    jTextArea.append(")");
                }
            }
            jTextArea.append(", ");
            jTextArea.append(playerArray.getColorName());
            if (playerArray.handicap < 100) {
                jTextArea.append(", ");
                jTextArea.append(Language.getText("module.repAnalyzer.tab.gameInfo.handicap", playerArray.handicap));
            }
            ++n;
        }
        jTextArea.append("\n");
        if (Settings.getBoolean("settings.misc.showWinners")) {
            jTextArea.append("\n");
            StringBuilder stringBuilder2 = new StringBuilder();
            playerArray = this.replay.details.players;
            int n6 = this.replay.details.players.length;
            n4 = 0;
            while (n4 < n6) {
                Details.Player player = playerArray[n4];
                if (player.isWinner != null && player.isWinner.booleanValue()) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(", ");
                    }
                    stringBuilder2.append(player.name);
                }
                ++n4;
            }
            GuiUtils.appendNewLine(jTextArea, Language.getText("module.repAnalyzer.tab.gameInfo.winners", stringBuilder2.toString()));
        }
        jPanel.add(new JScrollPane(jTextArea));
        return jPanel;
    }

    private JComponent createInGameChatTab() {
        Object object;
        Object object2;
        StyleContext styleContext = new StyleContext();
        Style style = styleContext.addStyle("default", StyleContext.getDefaultStyleContext().getStyle("default"));
        int n = 0;
        Object object3 = this.replay.details.players;
        int n2 = this.replay.details.players.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = object3[n3];
            object = styleContext.addStyle("p" + n, style);
            StyleConstants.setForeground((MutableAttributeSet)object, ((Details.Player)object2).getDarkerColor());
            ++n;
            ++n3;
        }
        object2 = new JPanel(new BorderLayout());
        Box box = Box.createHorizontalBox();
        JTextPane jTextPane = new JTextPane(){

            @Override
            public void paint(Graphics graphics) {
                Container container = this;
                while (!(container instanceof JViewport)) {
                    container = container.getParent();
                }
                Rectangle rectangle = ((JViewport)container).getViewRect();
                graphics.setColor(new Color(240, 240, 240));
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                super.paint(graphics);
            }
        };
        jTextPane.setOpaque(false);
        jTextPane.setBackground(new Color(0, 0, 0, 0));
        object3 = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.hideMessageTarget", "module.repAnalyzer.inGameChat.hideMessageTargets");
        object = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.showBlinks", "module.repAnalyzer.inGameChat.showBlinks");
        JCheckBox jCheckBox = GuiUtils.createCheckBox("module.repAnalyzer.tab.inGameChat.formatIntoParagraphs", "module.repAnalyzer.inGameChat.formatIntoParagraphs");
        ActionListener actionListener = new ActionListener((JCheckBox)object3, (JCheckBox)object, jCheckBox, jTextPane, styleContext){
            private final /* synthetic */ JCheckBox val$hideMessageTargetsCheckBox;
            private final /* synthetic */ JCheckBox val$showBlinksCheckBox;
            private final /* synthetic */ JCheckBox val$formatIntoParagraphsCheckBox;
            private final /* synthetic */ JTextPane val$chatTextPane;
            private final /* synthetic */ StyleContext val$STYLE_CONTEX;
            {
                this.val$hideMessageTargetsCheckBox = jCheckBox;
                this.val$showBlinksCheckBox = jCheckBox2;
                this.val$formatIntoParagraphsCheckBox = jCheckBox3;
                this.val$chatTextPane = jTextPane;
                this.val$STYLE_CONTEX = styleContext;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = this.val$hideMessageTargetsCheckBox.isSelected();
                boolean bl2 = this.val$showBlinksCheckBox.isSelected();
                boolean bl3 = this.val$formatIntoParagraphsCheckBox.isSelected();
                String string = bl ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAll");
                String string2 = bl ? null : Language.getText("module.repAnalyzer.tab.inGameChat.messageTargetAllies");
                this.val$chatTextPane.setText("");
                int n = 0;
                int n2 = 0;
                Document document = this.val$chatTextPane.getDocument();
                String[] stringArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.initData.getArrangedClientNames(((ReplayAnalyzer)ReplayAnalyzer.this).replay.details.players);
                MessageEvents.Message[] messageArray = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.messageEvents.messages;
                int n3 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.messageEvents.messages.length;
                int n4 = 0;
                while (n4 < n3) {
                    MessageEvents.Message message;
                    MessageEvents.Message message2 = messageArray[n4];
                    n2 = n;
                    String string3 = null;
                    String string4 = stringArray[message2.client];
                    n += message2.time;
                    if (message2 instanceof MessageEvents.Text) {
                        message = (MessageEvents.Text)message2;
                        string3 = bl ? Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageNoTarget", ReplayUtils.formatMs(n, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.converterGameSpeed), string4, message.text) : Language.getText("module.repAnalyzer.tab.inGameChat.chatMessageFull", ReplayUtils.formatMs(n, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.converterGameSpeed), string4, message.opCode == 0 ? string : string2, message.text);
                    } else if (message2 instanceof MessageEvents.Blink && bl2) {
                        message = (MessageEvents.Blink)message2;
                        string3 = Language.getText("module.repAnalyzer.tab.inGameChat.blinkMessage", ReplayUtils.formatMs(n, ((ReplayAnalyzer)ReplayAnalyzer.this).replay.converterGameSpeed), string4, ReplayUtils.formatCoordinate(((MessageEvents.Blink)message).x), ReplayUtils.formatCoordinate(((MessageEvents.Blink)message).y));
                    }
                    if (string3 != null) {
                        try {
                            document.insertString(document.getLength(), bl3 && n - n2 > 6000 && n2 > 0 ? "\n" + string3 + "\n" : String.valueOf(string3) + "\n", this.val$STYLE_CONTEX.getStyle("p" + message2.client));
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                    ++n4;
                }
                this.val$chatTextPane.setCaretPosition(0);
            }
        };
        ((AbstractButton)object3).addActionListener(actionListener);
        ((AbstractButton)object).addActionListener(actionListener);
        jCheckBox.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        box.add((Component)object3);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)object);
        box.add(Box.createHorizontalStrut(10));
        box.add(jCheckBox);
        ((Container)object2).add((Component)GuiUtils.wrapInPanel(box), "North");
        jTextPane.setEditable(false);
        ((Container)object2).add((Component)new JScrollPane(jTextPane), "Center");
        return object2;
    }

    private JComponent createMapPreviewTab() {
        Object object;
        Object object2;
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        Box box = Box.createVerticalBox();
        JLabel jLabel2 = new JLabel(Language.getText("module.repAnalyzer.tab.gameInfo.mapName", this.replay.mapInfo == null ? this.replay.details.mapName : String.valueOf(this.replay.details.mapName) + " " + this.replay.mapInfo.getPlayableSizeString() + " (" + this.replay.mapInfo.getSizeString() + ")"), 0);
        GuiUtils.changeFontToBold(jLabel2);
        box.add(GuiUtils.wrapInPanel(jLabel2));
        if (this.replay.mapInfo == null && (serializable = MapParser.getMapFile(this.replay)) != null && !((File)serializable).exists() && ((String)(object2 = ((File)serializable).getName())).length() == 69) {
            object = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            JLabel jLabel3 = new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.mapFileNotExists"), 0);
            box2.add(jLabel3);
            box2.add(Box.createHorizontalStrut(5));
            Box box3 = Box.createHorizontalBox();
            JComboBox jComboBox = GuiUtils.createComboBox((Object[])GeneralUtils.remainingElements(ReplayConsts.Gateway.values(), EnumSet.of(ReplayConsts.Gateway.UNKNOWN)), "module.repAnalyzer.mapPreview.downloadFromGateway");
            JButton jButton = new JButton(Icons.DRIVE_DOWNLOAD);
            GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.mapPreview.downloadMapButton", new Object[0]);
            jButton.addActionListener(new ActionListener((Box)object, box3, jButton, jLabel3, jComboBox, (String)object2, (File)serializable, jPanel, box2){
                private final /* synthetic */ Box val$downloadBox;
                private final /* synthetic */ Box val$downloadSourceBox;
                private final /* synthetic */ JButton val$downloadButton;
                private final /* synthetic */ JLabel val$downloadInfoLabel;
                private final /* synthetic */ JComboBox val$downloadFromGatewayComboBox;
                private final /* synthetic */ String val$mapFileName;
                private final /* synthetic */ File val$mapFile;
                private final /* synthetic */ JPanel val$mapPreviewPanel;
                private final /* synthetic */ Box val$controlBox;
                {
                    this.val$downloadBox = box;
                    this.val$downloadSourceBox = box2;
                    this.val$downloadButton = jButton;
                    this.val$downloadInfoLabel = jLabel;
                    this.val$downloadFromGatewayComboBox = jComboBox;
                    this.val$mapFileName = string;
                    this.val$mapFile = file;
                    this.val$mapPreviewPanel = jPanel;
                    this.val$controlBox = box3;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$downloadBox.remove(this.val$downloadSourceBox);
                    this.val$downloadButton.setEnabled(false);
                    this.val$downloadInfoLabel.setText(Language.getText("module.repAnalyzer.tab.mapPreview.downloadingMap"));
                    String string = String.valueOf(((ReplayConsts.Gateway)((Object)this.val$downloadFromGatewayComboBox.getSelectedItem())).depotServerUrl) + this.val$mapFileName;
                    Downloader[] downloaderArray = new Downloader[1];
                    Downloader downloader = downloaderArray[0] = new Downloader(string, this.val$mapFile, new Downloader.Callback(downloaderArray){
                        private final InternalFrameListener downloadStopperListener;
                        {
                            this.downloadStopperListener = new InternalFrameAdapter(){

                                @Override
                                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                    downloaderArray[0].requestToCancel();
                                }
                            };
                            ReplayAnalyzer.this.addInternalFrameListener(this.downloadStopperListener);
                        }

                        @Override
                        public void downloadFinished(boolean bl) {
                            ReplayAnalyzer.this.removeInternalFrameListener(this.downloadStopperListener);
                            if (!ReplayAnalyzer.this.isClosed()) {
                                val$downloadInfoLabel.setText(Language.getText(bl ? "module.repAnalyzer.tab.mapPreview.mapDownloaded" : "module.repAnalyzer.tab.mapPreview.mapDownloadFailed"));
                                val$controlBox.remove(val$downloadButton);
                                JButton jButton = new JButton(Icons.ARROW_CIRCLE_DOUBLE);
                                GuiUtils.updateButtonText(jButton, "module.repAnalyzer.tab.mapPreview.reopenReplayButton", new Object[0]);
                                jButton.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        try {
                                            ReplayAnalyzer.this.setClosed(true);
                                        }
                                        catch (PropertyVetoException propertyVetoException) {
                                            // empty catch block
                                        }
                                        MainFrame.INSTANCE.openReplayFile(ReplayAnalyzer.this.replayFile);
                                    }
                                });
                                val$controlBox.add(jButton);
                                val$mapPreviewPanel.validate();
                            }
                        }
                    });
                    this.val$downloadBox.add(downloader.progressBar);
                    this.val$mapPreviewPanel.validate();
                    downloader.start();
                }
            });
            box2.add(jButton);
            ((Container)object).add(box2);
            box3.add(new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.downloadFromGateway")));
            box3.add(jComboBox);
            ((Container)object).add(box3);
            box.add((Component)object);
        }
        serializable = Box.createHorizontalBox();
        ((Container)serializable).add(new JLabel(Language.getText("module.repAnalyzer.tab.mapPreview.zoom")));
        object2 = new JSlider(0, 6, Settings.getInt("module.repAnalyzer.mapPreview.zoom"));
        ((JSlider)object2).setPaintLabels(true);
        ((JSlider)object2).setPaintTicks(true);
        ((JSlider)object2).setSnapToTicks(true);
        ((JSlider)object2).setMajorTickSpacing(1);
        ((JSlider)object2).setLabelTable(LABEL_DICTIONARY);
        object = new ChangeListener((JSlider)object2, jLabel){
            private final /* synthetic */ JSlider val$zoomSlider;
            private final /* synthetic */ JLabel val$mapPreviewLabel;
            {
                this.val$zoomSlider = jSlider;
                this.val$mapPreviewLabel = jLabel;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (this.val$zoomSlider.getValueIsAdjusting()) {
                    return;
                }
                int n = this.val$zoomSlider.getValue();
                if (((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo == null) {
                    this.val$mapPreviewLabel.setText(Language.getText("module.repAnalyzer.tab.mapPreview.previewNotAvailable"));
                } else {
                    int n2 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getIconWidth();
                    int n3 = ((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getIconHeight();
                    this.val$mapPreviewLabel.setIcon(new ImageIcon(((ReplayAnalyzer)ReplayAnalyzer.this).replay.mapInfo.previewIcon.getImage().getScaledInstance(n == 0 ? n2 / 2 : n2 * n, n == 0 ? n3 / 2 : n3 * n, 4)));
                }
                if (changeEvent != null) {
                    Settings.set("module.repAnalyzer.mapPreview.zoom", n);
                }
            }
        };
        object.stateChanged(null);
        ((JSlider)object2).addChangeListener((ChangeListener)object);
        ((Container)serializable).add((Component)object2);
        box.add((Component)serializable);
        jPanel.add((Component)GuiUtils.wrapInPanel(box), "North");
        jLabel.setHorizontalAlignment(0);
        GuiUtils.makeComponentDragScrollable(jLabel);
        jPanel.add((Component)new JScrollPane(jLabel), "Center");
        return jPanel;
    }

    public static enum ChartType {
        APM("module.repAnalyzer.tab.charts.chartType.apm"),
        HOTKEYS("module.repAnalyzer.tab.charts.chartType.hotkeys"),
        BUILDS_TECH("module.repAnalyzer.tab.charts.chartType.buildsTech"),
        BUILDS_TECH_STAT("module.repAnalyzer.tab.charts.chartType.buildsTechStat"),
        MAP_VIEW("module.repAnalyzer.tab.charts.chartType.mapView");

        public final String stringValue;
        public final KeyStroke keyStroke;

        private ChartType(String string2) {
            this.stringValue = Language.getText(string2);
            this.keyStroke = KeyStroke.getKeyStroke(49 + this.ordinal(), 2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum MapBackground {
        MAP_IMAGE("module.repAnalyzer.tab.charts.mapView.background.mapImage"),
        HOT_POINTS("module.repAnalyzer.tab.charts.mapView.background.hotPoints"),
        MAP_IMAGE_AND_HOT_POINTS("module.repAnalyzer.tab.charts.mapView.background.mapImageAndHotPoints"),
        HOT_AREAS("module.repAnalyzer.tab.charts.mapView.background.hotAreas"),
        BLANK("module.repAnalyzer.tab.charts.mapView.background.blank");

        public final String stringValue;

        private MapBackground(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum MapViewQuality {
        LOW("module.repAnalyzer.tab.charts.mapView.quality.low", RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR),
        MEDIUM("module.repAnalyzer.tab.charts.mapView.quality.medium", RenderingHints.VALUE_INTERPOLATION_BILINEAR),
        HIGH("module.repAnalyzer.tab.charts.mapView.quality.high", RenderingHints.VALUE_INTERPOLATION_BICUBIC);

        public final String stringValue;
        public final Object hintValue;

        private MapViewQuality(String string2, Object object) {
            this.stringValue = Language.getText(string2);
            this.hintValue = object;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

