/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.multirepanal;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.DateRangeStatistics;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.PlayerGameParticipationStats;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.Record;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.IntHolder;
import hu.belicza.andras.sc2gears.util.NullAwareComparable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PlayerStatistics
extends DateRangeStatistics {
    public final String name;
    public final String fullName;
    public final int battleNetId;
    public final int battleNetSubid;
    public final ReplayConsts.PlayerType playerType;
    public final ReplayConsts.Gateway gateway;
    public long totalTimeSecInGames;
    public long totalTimeSecInGamesForApm;
    public long totalActions;
    public final Record record = new Record();
    public final Map<ReplayConsts.Race, IntHolder> raceDistributionMap = new EnumMap<ReplayConsts.Race, IntHolder>(ReplayConsts.Race.class);
    public final Map<String, IntHolder> mapDistributionMap = new HashMap<String, IntHolder>(8);
    public final List<PlayerGameParticipationStats> playerGameParticipationStatsList = new ArrayList<PlayerGameParticipationStats>();

    public PlayerStatistics(Details.Player player, ReplayConsts.Gateway gateway) {
        if (player != null) {
            this.name = player.name;
            this.fullName = player.fullName;
            this.battleNetId = player.battleNetId;
            this.battleNetSubid = player.battleNetSubid;
            this.playerType = player.type;
        } else {
            this.name = null;
            this.fullName = null;
            this.battleNetId = 0;
            this.battleNetSubid = 0;
            this.playerType = null;
        }
        this.gateway = gateway;
    }

    public void buildInPlayerGameParticipation(PlayerGameParticipationStats playerGameParticipationStats) {
        IntHolder intHolder;
        this.registerDate(playerGameParticipationStats.date);
        this.totalTimeSecInGames += (long)playerGameParticipationStats.timeSecInGame;
        this.totalTimeSecInGamesForApm += (long)playerGameParticipationStats.timeSecInGameForApm;
        ++this.record.totalGames;
        this.totalActions += (long)playerGameParticipationStats.actions;
        if (playerGameParticipationStats.isWinner != null) {
            if (playerGameParticipationStats.isWinner.booleanValue()) {
                ++this.record.wins;
            } else {
                ++this.record.losses;
            }
        }
        if ((intHolder = this.raceDistributionMap.get((Object)playerGameParticipationStats.race)) == null) {
            this.raceDistributionMap.put(playerGameParticipationStats.race, new IntHolder(1));
        } else {
            ++intHolder.value;
        }
        IntHolder intHolder2 = this.mapDistributionMap.get(playerGameParticipationStats.mapName);
        if (intHolder2 == null) {
            this.mapDistributionMap.put(playerGameParticipationStats.mapName, new IntHolder(1));
        } else {
            ++intHolder2.value;
        }
    }

    public String getRaceDistributionString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<ReplayConsts.Race, IntHolder> entry : this.raceDistributionMap.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey().letter).append(":").append(entry.getValue().value * 100 / this.record.totalGames).append('%');
        }
        return stringBuilder.toString();
    }

    public float getAvgGamesPerDay() {
        return (float)this.record.totalGames / (float)this.getPresence();
    }

    public int getAvgGameLength() {
        return (int)(this.totalTimeSecInGames / (long)this.record.totalGames);
    }

    public int getAvgApm() {
        return this.totalTimeSecInGamesForApm == 0L ? 0 : (int)(this.totalActions * 60L / this.totalTimeSecInGamesForApm);
    }

    public NullAwareComparable<Long> getFormattedTotalTimeInGames() {
        return new NullAwareComparable<Long>(Long.valueOf(this.totalTimeSecInGames)){

            public String toString() {
                return GeneralUtils.formatLongSeconds((Long)this.value);
            }
        };
    }
}

