/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PlayerPopupMenu
extends JPopupMenu
implements ActionListener {
    private final String playerName;
    private final int battleNetId;
    private final int battleNetSubid;
    private final ReplayConsts.Gateway gateway;
    private final JMenuItem viewCharacterProfileMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.viewCharacterProfile"), Icons.PROFILE);
    private final JMenuItem addToFavoredPlayerListMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.addToFavoredPlayerList"), Icons.USER_PLUS);
    private final JMenuItem removeFromFavoredPlayerListMenuItem = new JMenuItem(Language.getText("module.repAnalyzer.tab.charts.playerMenu.removeFromFavoredPlayerList"), Icons.USER_MINUS);

    public PlayerPopupMenu(final String string, final int n, final int n2, final ReplayConsts.Gateway gateway, ReplayConsts.PlayerType playerType) {
        List<Object> list;
        this.playerName = string;
        this.battleNetId = n;
        this.battleNetSubid = n2;
        this.gateway = gateway;
        if (gateway == ReplayConsts.Gateway.UNKNOWN || playerType != ReplayConsts.PlayerType.HUMAN) {
            this.viewCharacterProfileMenuItem.setEnabled(false);
        }
        this.viewCharacterProfileMenuItem.addActionListener(this);
        this.add(this.viewCharacterProfileMenuItem);
        JMenu jMenu = new JMenu(Language.getText("module.repAnalyzer.tab.charts.playerMenu.viewCharacterProfileInLanguage"));
        jMenu.setIcon(Icons.PROFILE);
        if (gateway == ReplayConsts.Gateway.UNKNOWN || playerType != ReplayConsts.PlayerType.HUMAN) {
            jMenu.setEnabled(false);
        } else {
            list = new ArrayList<ReplayConsts.BnetLanguage>(gateway.availableLanguageSet);
            Collections.sort(list);
            for (final ReplayConsts.BnetLanguage bnetLanguage : list) {
                Object object = new JMenuItem(bnetLanguage.stringValue, Icons.getLanguageIcon(Language.getDefaultText(bnetLanguage.textKey)));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SharedUtils.showURLInBrowser(gateway.getBnetProfileUrl(string, n, n2, bnetLanguage));
                    }
                });
                jMenu.add((JMenuItem)object);
            }
        }
        this.add(jMenu);
        this.addSeparator();
        list = GeneralUtils.getFavoredPlayerList();
        boolean bl = list.contains(string);
        this.addToFavoredPlayerListMenuItem.setEnabled(!bl);
        this.addToFavoredPlayerListMenuItem.addActionListener(this);
        this.add(this.addToFavoredPlayerListMenuItem);
        JMenu jMenu2 = new JMenu(Language.getText("module.repAnalyzer.tab.charts.playerMenu.insertToFavoredPlayerList"));
        jMenu2.setIcon(Icons.USER_PLUS);
        jMenu2.setEnabled(!bl);
        if (!bl) {
            for (Object object : list) {
                JMenuItem jMenuItem = new JMenuItem((String)object);
                jMenuItem.addActionListener(new ActionListener((String)object, list, string){
                    private final /* synthetic */ String val$favoredPlayerName;
                    private final /* synthetic */ List val$favoredPlayerList;
                    private final /* synthetic */ String val$playerName;
                    {
                        this.val$favoredPlayerName = string;
                        this.val$favoredPlayerList = list;
                        this.val$playerName = string2;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        List<String> list = GeneralUtils.getFavoredPlayerList();
                        int n = list.indexOf(this.val$favoredPlayerName);
                        if (n >= 0) {
                            this.val$favoredPlayerList.add(n, this.val$playerName);
                            Settings.set("settings.misc.favoredPlayerList", PlayerPopupMenu.getFavoredPlayerListString(this.val$favoredPlayerList));
                        }
                    }
                });
                jMenu2.add(jMenuItem);
            }
        }
        this.add(jMenu2);
        this.removeFromFavoredPlayerListMenuItem.setEnabled(bl);
        this.removeFromFavoredPlayerListMenuItem.addActionListener(this);
        this.add(this.removeFromFavoredPlayerListMenuItem);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.viewCharacterProfileMenuItem) {
            SharedUtils.showURLInBrowser(this.gateway.getBnetProfileUrl(this.playerName, this.battleNetId, this.battleNetSubid, ReplayConsts.BnetLanguage.values()[Settings.getInt("settings.misc.preferredBnetLanguage")]));
        } else if (actionEvent.getSource() == this.addToFavoredPlayerListMenuItem) {
            List<String> list = GeneralUtils.getFavoredPlayerList();
            list.add(this.playerName);
            Settings.set("settings.misc.favoredPlayerList", PlayerPopupMenu.getFavoredPlayerListString(list));
        } else if (actionEvent.getSource() == this.removeFromFavoredPlayerListMenuItem) {
            List<String> list = GeneralUtils.getFavoredPlayerList();
            list.remove(this.playerName);
            Settings.set("settings.misc.favoredPlayerList", PlayerPopupMenu.getFavoredPlayerListString(list));
        }
    }

    private static String getFavoredPlayerListString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

