/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.icons;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Icons {
    private static final String FLAG_ICONS_FOLDER_NAME = "flags";
    private static final Map<String, ImageIcon> LANGUAGE_FLAG_ICON_MAP = new HashMap<String, ImageIcon>();
    public static final ImageIcon SC2GEARS = new ImageIcon(Icons.class.getResource("my/sc2gears.png"));
    public static final ImageIcon SC2GEARS_LOGO = new ImageIcon(Icons.class.getResource("my/sc2gears_logo.png"));
    public static final ImageIcon FORMAT = new ImageIcon(Icons.class.getResource("my/format.png"));
    public static final ImageIcon SC2_BIG = new ImageIcon(Icons.class.getResource("sc2/misc/sc2.png"));
    public static final ImageIcon SC2 = new ImageIcon(SC2_BIG.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon REPLAY = new ImageIcon(Icons.class.getResource("sc2/misc/replay.png"));
    public static final ImageIcon PROFILE = new ImageIcon(Icons.class.getResource("sc2/misc/profile.png"));
    public static final ImageIcon ALARM_CLOCK = new ImageIcon(Icons.class.getResource("fugue/alarm-clock.png"));
    public static final ImageIcon APPLICATION_DIALOG = new ImageIcon(Icons.class.getResource("fugue/application-dialog.png"));
    public static final ImageIcon APPLICATION_DOCK_180 = new ImageIcon(Icons.class.getResource("fugue/application-dock-180.png"));
    public static final ImageIcon APPLICATION_DOCK_TAB = new ImageIcon(Icons.class.getResource("fugue/application-dock-tab.png"));
    public static final ImageIcon APPLICATION_DOCK = new ImageIcon(Icons.class.getResource("fugue/application-dock.png"));
    public static final ImageIcon APPLICATION_RESIZE_FULL = new ImageIcon(Icons.class.getResource("fugue/application-resize-full.png"));
    public static final ImageIcon APPLICATION_RESIZE_ACTUAL = new ImageIcon(Icons.class.getResource("fugue/application-resize-actual.png"));
    public static final ImageIcon APPLICATION_SHARE = new ImageIcon(Icons.class.getResource("fugue/application-share.png"));
    public static final ImageIcon APPLICATION_SIDEBAR_LIST = new ImageIcon(Icons.class.getResource("fugue/application-sidebar-list.png"));
    public static final ImageIcon APPLICATION_SIDEBAR = new ImageIcon(Icons.class.getResource("fugue/application-sidebar.png"));
    public static final ImageIcon APPLICATION_SPLIT_TILE = new ImageIcon(Icons.class.getResource("fugue/application-split-tile.png"));
    public static final ImageIcon APPLICATION_TILE_VERTICAL = new ImageIcon(Icons.class.getResource("fugue/application-tile-vertical.png"));
    public static final ImageIcon APPLICATIONS_STACK = new ImageIcon(Icons.class.getResource("fugue/applications-stack.png"));
    public static final ImageIcon ARROW_180 = new ImageIcon(Icons.class.getResource("fugue/arrow-180.png"));
    public static final ImageIcon ARROW_CIRCLE_315 = new ImageIcon(Icons.class.getResource("fugue/arrow-circle-315.png"));
    public static final ImageIcon ARROW_CIRCLE_DOUBLE = new ImageIcon(Icons.class.getResource("fugue/arrow-circle-double.png"));
    public static final ImageIcon ARROW = new ImageIcon(Icons.class.getResource("fugue/arrow.png"));
    public static final ImageIcon BALLOONS = new ImageIcon(Icons.class.getResource("fugue/balloons.png"));
    public static final ImageIcon BINOCULAR_ARROW = new ImageIcon(Icons.class.getResource("fugue/binocular--arrow.png"));
    public static final ImageIcon BINOCULAR = new ImageIcon(Icons.class.getResource("fugue/binocular.png"));
    public static final ImageIcon BLOCK = new ImageIcon(Icons.class.getResource("fugue/block.png"));
    public static final ImageIcon BROOM = new ImageIcon(Icons.class.getResource("fugue/broom.png"));
    public static final ImageIcon CALCULATOR = new ImageIcon(Icons.class.getResource("fugue/calculator.png"));
    public static final ImageIcon CALENDAR_SELECT = new ImageIcon(Icons.class.getResource("fugue/calendar-select.png"));
    public static final ImageIcon CARD = new ImageIcon(Icons.class.getResource("fugue/card.png"));
    public static final ImageIcon CHART_UP_COLOR = new ImageIcon(Icons.class.getResource("fugue/chart-up-color.png"));
    public static final ImageIcon CHART_UP = new ImageIcon(Icons.class.getResource("fugue/chart-up.png"));
    public static final ImageIcon CHART = new ImageIcon(Icons.class.getResource("fugue/chart.png"));
    public static final ImageIcon CLOCK = new ImageIcon(Icons.class.getResource("fugue/clock.png"));
    public static final ImageIcon CONTROL_DOUBLE = new ImageIcon(Icons.class.getResource("fugue/control-double.png"));
    public static final ImageIcon CONTROL_DOUBLE_180 = new ImageIcon(Icons.class.getResource("fugue/control-double-180.png"));
    public static final ImageIcon CONTROL_PAUSE = new ImageIcon(Icons.class.getResource("fugue/control-pause.png"));
    public static final ImageIcon CONTROL_SKIP_180 = new ImageIcon(Icons.class.getResource("fugue/control-skip-180.png"));
    public static final ImageIcon CONTROL_SKIP = new ImageIcon(Icons.class.getResource("fugue/control-skip.png"));
    public static final ImageIcon CONTROL = new ImageIcon(Icons.class.getResource("fugue/control.png"));
    public static final ImageIcon COUNTER_COUNT_UP = new ImageIcon(Icons.class.getResource("fugue/counter-count-up.png"));
    public static final ImageIcon COUNTER_RESET = new ImageIcon(Icons.class.getResource("fugue/counter-reset.png"));
    public static final ImageIcon CROSS_BUTTON = new ImageIcon(Icons.class.getResource("fugue/cross-button.png"));
    public static final ImageIcon CROSS_OCTAGON = new ImageIcon(Icons.class.getResource("fugue/cross-octagon.png"));
    public static final ImageIcon CROSS_SMALL = new ImageIcon(Icons.class.getResource("fugue/cross-small.png"));
    public static final ImageIcon CROSS = new ImageIcon(Icons.class.getResource("fugue/cross.png"));
    public static final ImageIcon CROSS_WHITE = new ImageIcon(Icons.class.getResource("fugue/cross-white.png"));
    public static final ImageIcon DOCUMENT_COPY = new ImageIcon(Icons.class.getResource("fugue/document-copy.png"));
    public static final ImageIcon DOCUMENT_EXPORT = new ImageIcon(Icons.class.getResource("fugue/document-export.png"));
    public static final ImageIcon DOCUMENT_RENAME = new ImageIcon(Icons.class.getResource("fugue/document-rename.png"));
    public static final ImageIcon DOCUMENT_ZIPPER = new ImageIcon(Icons.class.getResource("fugue/document-zipper.png"));
    public static final ImageIcon DISK_ARROW = new ImageIcon(Icons.class.getResource("fugue/disk--arrow.png"));
    public static final ImageIcon DISK = new ImageIcon(Icons.class.getResource("fugue/disk.png"));
    public static final ImageIcon DOOR_OPEN_IN = new ImageIcon(Icons.class.getResource("fugue/door-open-in.png"));
    public static final ImageIcon DRIVE_DOWNLOAD = new ImageIcon(Icons.class.getResource("fugue/drive-download.png"));
    public static final ImageIcon EDIT_COLUMN = new ImageIcon(Icons.class.getResource("fugue/edit-column.png"));
    public static final ImageIcon EQUALIZER = new ImageIcon(Icons.class.getResource("fugue/equalizer.png"));
    public static final ImageIcon FOLDER = new ImageIcon(Icons.class.getResource("fugue/folder.png"));
    public static final ImageIcon FOLDER_MINUS = new ImageIcon(Icons.class.getResource("fugue/folder--minus.png"));
    public static final ImageIcon FOLDER_BOOKMARK = new ImageIcon(Icons.class.getResource("fugue/folder-bookmark.png"));
    public static final ImageIcon FOLDER_OPEN = new ImageIcon(Icons.class.getResource("fugue/folder-open.png"));
    public static final ImageIcon FOLDERS_STACK = new ImageIcon(Icons.class.getResource("fugue/folders-stack.png"));
    public static final ImageIcon FOLDERS = new ImageIcon(Icons.class.getResource("fugue/folders.png"));
    public static final ImageIcon GLOBE_ARROW = new ImageIcon(Icons.class.getResource("fugue/globe--arrow.png"));
    public static final ImageIcon HOME_ARROW = new ImageIcon(Icons.class.getResource("fugue/home--arrow.png"));
    public static final ImageIcon INFORMATION = new ImageIcon(Icons.class.getResource("fugue/information.png"));
    public static final ImageIcon INFORMATION_BALLOON = new ImageIcon(Icons.class.getResource("fugue/information-balloon.png"));
    public static final ImageIcon LOCALE = new ImageIcon(Icons.class.getResource("fugue/locale.png"));
    public static final ImageIcon MAP_PENCIL = new ImageIcon(Icons.class.getResource("fugue/map--pencil.png"));
    public static final ImageIcon MAP = new ImageIcon(Icons.class.getResource("fugue/map.png"));
    public static final ImageIcon MAPS_STACK = new ImageIcon(Icons.class.getResource("fugue/maps-stack.png"));
    public static final ImageIcon MICROPHONE = new ImageIcon(Icons.class.getResource("fugue/microphone.png"));
    public static final ImageIcon MINUS_SMALL = new ImageIcon(Icons.class.getResource("fugue/minus-small.png"));
    public static final ImageIcon MINUS = new ImageIcon(Icons.class.getResource("fugue/minus.png"));
    public static final ImageIcon NEWSPAPER = new ImageIcon(Icons.class.getResource("fugue/newspaper.png"));
    public static final ImageIcon PLUS_SMALL = new ImageIcon(Icons.class.getResource("fugue/plus-small.png"));
    public static final ImageIcon PLUS = new ImageIcon(Icons.class.getResource("fugue/plus.png"));
    public static final ImageIcon REPORT_EXCLAMATION = new ImageIcon(Icons.class.getResource("fugue/report--exclamation.png"));
    public static final ImageIcon SORT_ALPHABET = new ImageIcon(Icons.class.getResource("fugue/sort-alphabet.png"));
    public static final ImageIcon SPEAKER_VOLUME = new ImageIcon(Icons.class.getResource("fugue/speaker-volume.png"));
    public static final ImageIcon TABLE_DELETE_ROW = new ImageIcon(Icons.class.getResource("fugue/table-delete-row.png"));
    public static final ImageIcon TABLE_EXPORT = new ImageIcon(Icons.class.getResource("fugue/table-export.png"));
    public static final ImageIcon TABLE = new ImageIcon(Icons.class.getResource("fugue/table.png"));
    public static final ImageIcon TOGGLE = new ImageIcon(Icons.class.getResource("fugue/toggle.png"));
    public static final ImageIcon TOGGLE_EXPAND = new ImageIcon(Icons.class.getResource("fugue/toggle-expand.png"));
    public static final ImageIcon TROPHY = new ImageIcon(Icons.class.getResource("fugue/trophy.png"));
    public static final ImageIcon UI_FLOW = new ImageIcon(Icons.class.getResource("fugue/ui-flow.png"));
    public static final ImageIcon UI_LAYOUT_PANEL = new ImageIcon(Icons.class.getResource("fugue/ui-layout-panel.png"));
    public static final ImageIcon UI_SCROLL_PANE_LIST = new ImageIcon(Icons.class.getResource("fugue/ui-scroll-pane-list.png"));
    public static final ImageIcon USER_ARROW = new ImageIcon(Icons.class.getResource("fugue/user--arrow.png"));
    public static final ImageIcon USER_PLUS = new ImageIcon(Icons.class.getResource("fugue/user--plus.png"));
    public static final ImageIcon USER_MINUS = new ImageIcon(Icons.class.getResource("fugue/user--minus.png"));
    public static final ImageIcon USER = new ImageIcon(Icons.class.getResource("fugue/user.png"));
    public static final ImageIcon USERS = new ImageIcon(Icons.class.getResource("fugue/users.png"));
    public static final ImageIcon WRENCH = new ImageIcon(Icons.class.getResource("fugue/wrench.png"));
    public static final ImageIcon RACE_TERRAN = new ImageIcon(Icons.class.getResource("sc2/races/terran.png"));
    public static final ImageIcon RACE_PROTOSS = new ImageIcon(Icons.class.getResource("sc2/races/protoss.png"));
    public static final ImageIcon RACE_ZERG = new ImageIcon(Icons.class.getResource("sc2/races/zerg.png"));
    public static final ImageIcon RACE_RANDOM = new ImageIcon(Icons.class.getResource("sc2/races/random.png"));
    public static final ImageIcon RACE_ANY = new ImageIcon(Icons.class.getResource("sc2/races/any.png"));
    public static final ImageIcon RACE_ALL = new ImageIcon(Icons.class.getResource("sc2/races/all.png"));
    public static final ImageIcon CHART_CURVE = new ImageIcon(Icons.class.getResource("famfamfam/chart_curve.png"));
    public static final ImageIcon DATABASE_SAVE = new ImageIcon(Icons.class.getResource("famfamfam/database_save.png"));
    public static final ImageIcon GROUP_LINK = new ImageIcon(Icons.class.getResource("famfamfam/group_link.png"));
    public static final ImageIcon HANDICAP = new ImageIcon(Icons.class.getResource("misc/handicap.gif"));
    private static final Map<ReplayConsts.Building, IconHandler> buildingIcons = new EnumMap<ReplayConsts.Building, IconHandler>(ReplayConsts.Building.class);
    private static final Map<ReplayConsts.Unit, IconHandler> unitIcons = new EnumMap<ReplayConsts.Unit, IconHandler>(ReplayConsts.Unit.class);
    private static final Map<ReplayConsts.Upgrade, IconHandler> upgradeIcons = new EnumMap<ReplayConsts.Upgrade, IconHandler>(ReplayConsts.Upgrade.class);
    private static final Map<ReplayConsts.Research, IconHandler> researchIcons = new EnumMap<ReplayConsts.Research, IconHandler>(ReplayConsts.Research.class);
    private static final Map<ReplayConsts.AbilityGroup, IconHandler> abilityGroupIcons = new EnumMap<ReplayConsts.AbilityGroup, IconHandler>(ReplayConsts.AbilityGroup.class);

    private Icons() {
    }

    public static ImageIcon getLanguageIcon(String string) {
        ImageIcon imageIcon = LANGUAGE_FLAG_ICON_MAP.get(string);
        if (imageIcon == null) {
            URL uRL = Icons.class.getResource("flags/" + string + ".gif");
            if (uRL == null) {
                try {
                    uRL = new File("Languages/" + string + ".gif").toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            imageIcon = uRL == null ? new ImageIcon() : new ImageIcon(uRL);
            LANGUAGE_FLAG_ICON_MAP.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static Icon getBuildingIcon(ReplayConsts.Building building, IconHandler.Size size) {
        IconHandler iconHandler = buildingIcons.get((Object)building);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/buildings/" + building.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            buildingIcons.put(building, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getUnitIcon(ReplayConsts.Unit unit, IconHandler.Size size) {
        IconHandler iconHandler = unitIcons.get((Object)unit);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/units/" + unit.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            unitIcons.put(unit, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getUpgradeIcon(ReplayConsts.Upgrade upgrade, IconHandler.Size size) {
        IconHandler iconHandler = upgradeIcons.get((Object)upgrade);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/upgrades/" + upgrade.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            upgradeIcons.put(upgrade, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getResearchIcon(ReplayConsts.Research research, IconHandler.Size size) {
        IconHandler iconHandler = researchIcons.get((Object)research);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/researches/" + research.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            researchIcons.put(research, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getAbilityGroupIcon(ReplayConsts.AbilityGroup abilityGroup, IconHandler.Size size) {
        if (abilityGroup == null) {
            return IconHandler.NULL.get((Object)size);
        }
        IconHandler iconHandler = abilityGroupIcons.get((Object)abilityGroup);
        if (iconHandler == null) {
            URL uRL = Icons.class.getResource("sc2/abilitygroups/" + abilityGroup.name() + ".jpg");
            iconHandler = new IconHandler(uRL == null ? null : new ImageIcon(uRL));
            abilityGroupIcons.put(abilityGroup, iconHandler);
        }
        return iconHandler.get(size);
    }

    public static Icon getEntityIcon(Object object, IconHandler.Size size) {
        if (object instanceof ReplayConsts.Unit) {
            return Icons.getUnitIcon((ReplayConsts.Unit)((Object)object), size);
        }
        if (object instanceof ReplayConsts.Building) {
            return Icons.getBuildingIcon((ReplayConsts.Building)((Object)object), size);
        }
        if (object instanceof ReplayConsts.AbilityGroup) {
            return Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)((Object)object), size);
        }
        if (object instanceof ReplayConsts.Research) {
            return Icons.getResearchIcon((ReplayConsts.Research)((Object)object), size);
        }
        if (object instanceof ReplayConsts.Upgrade) {
            return Icons.getUpgradeIcon((ReplayConsts.Upgrade)((Object)object), size);
        }
        return IconHandler.NULL.get((Object)size);
    }

    public static ImageIcon getRaceIcon(ReplayConsts.Race race) {
        if (race == null) {
            return null;
        }
        switch (race) {
            case TERRAN: {
                return RACE_TERRAN;
            }
            case PROTOSS: {
                return RACE_PROTOSS;
            }
            case ZERG: {
                return RACE_ZERG;
            }
            case RANDOM: {
                return RACE_RANDOM;
            }
        }
        return null;
    }
}

