/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.dialogs;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayCache;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.ui.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.dialogs.AutoSaveNameTemplateEditorDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.BaseDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class MiscSettingsDialog
extends BaseDialog {
    public static final String TAB_TEXT_KEY_REPLAY_AUTO_SAVE = "miscSettings.tab.replayAutoSave";
    public static final String TAB_TEXT_KEY_APM_ALERT = "miscSettings.tab.apmAlert";
    public static final String TAB_TEXT_KEY_USER_INTERFACE = "miscSettings.tab.userInterface";
    public static final String TAB_TEXT_KEY_ANALYZER = "miscSettings.tab.analyzer";
    public static final String TAB_TEXT_KEY_INTERNAL = "miscSettings.tab.internal";
    public static final String TAB_TEXT_KEY_FOLDERS = "miscSettings.tab.folders";

    /*
     * WARNING - void declaration
     */
    public MiscSettingsDialog(String string) {
        super("miscSettings.title", Icons.EQUALIZER);
        int n;
        Object object;
        SettingRow[] settingRowArray;
        JComponent jComponent;
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        final JSlider jSlider = new JSlider(0, 100, Settings.getInt("settings.misc.soundVolume"));
        jSlider.setMajorTickSpacing(20);
        jSlider.setMinorTickSpacing(10);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        JButton jButton = new JButton(Icons.CONTROL);
        GuiUtils.updateButtonText(jButton, "miscSettings.testSoundButton", new Object[0]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Sounds.playSoundSample("sc2gears", false, jSlider.getValue());
            }
        });
        final JTextField jTextField = new JTextField(Settings.getString("settings.misc.repAutoSaveNameTemplate"));
        jTextField.setToolTipText(Language.getText("miscSettings.repAutoSaveNameTemplateToolTip"));
        JButton jButton2 = new JButton(Icons.UI_SCROLL_PANE_LIST);
        GuiUtils.updateButtonText(jButton2, "miscSettings.editTemplateButton", new Object[0]);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new AutoSaveNameTemplateEditorDialog((Dialog)MiscSettingsDialog.this, jTextField);
            }
        });
        JTextField jTextField2 = new JTextField(Settings.getString("settings.misc.favoredPlayerList"));
        jTextField2.setToolTipText(Language.getText("miscSettings.favoredPlayerListToolTip"));
        JComboBox<ReplayConsts.BnetLanguage> jComboBox = new JComboBox<ReplayConsts.BnetLanguage>(ReplayConsts.BnetLanguage.values());
        jComboBox.setToolTipText(Language.getText("miscSettings.preferredBnetLanguageToolTip"));
        jComboBox.setMaximumRowCount(jComboBox.getModel().getSize());
        jComboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object object) {
                return Icons.getLanguageIcon(Language.getDefaultText(((ReplayConsts.BnetLanguage)((Object)object)).textKey));
            }
        });
        try {
            jComboBox.setSelectedIndex(Settings.getInt("settings.misc.preferredBnetLanguage"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        JButton jButton3 = new JButton(Icons.CROSS);
        GuiUtils.updateButtonText(jButton3, "miscSettings.emptyReplayCacheButton", new Object[0]);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GuiUtils.showConfirmDialog(Language.getText("miscSettings.confirmEmptyCache"), true) != 0) {
                    return;
                }
                ReplayCache.emptyCache();
            }
        });
        final SettingRow[][] settingRowArray2 = new SettingRow[][]{{new SettingRow("miscSettings.repAutoSaveNameTemplate", "settings.misc.repAutoSaveNameTemplate", jTextField, jButton2), new SettingRow("miscSettings.newRepCheckIntervalSec", "settings.misc.newRepCheckIntervalSec", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.newRepCheckIntervalSec"), 1, 100, 1)), new JLabel(Language.getText("miscSettings.seconds"))), new SettingRow("miscSettings.deleteSuccessfullyAutoSavedReplays", "settings.misc.deleteAutoSavedReplays", new JCheckBox(Language.getText("miscSettings.deleteAutoSavedReplays"), Settings.getBoolean("settings.misc.deleteAutoSavedReplays")), new JLabel()), new SettingRow("miscSettings.autoOpenNewReplaysInAnalyzer", "settings.misc.autoOpenNewReplays", new JCheckBox(Language.getText("miscSettings.autoOpenNewReplays"), Settings.getBoolean("settings.misc.autoOpenNewReplays")), new JLabel())}, {new SettingRow("miscSettings.apmAlertLevel", "settings.misc.apmAlertLevel", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.apmAlertLevel"), 0, 1000, 1)), new JLabel(Language.getText("miscSettings.apm"))), new SettingRow("miscSettings.apmWarmupTime", "settings.misc.apmWarmupTime", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.apmWarmupTime"), 0, 300, 1)), new JLabel(Language.getText("miscSettings.seconds"))), new SettingRow("miscSettings.apmCheckIntervalSec", "settings.misc.apmCheckIntervalSec", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.apmCheckIntervalSec"), 1, 15, 1)), new JLabel(Language.getText("miscSettings.seconds"))), new SettingRow("miscSettings.alertWhenApmIsAboveAlertLevelAgain", "settings.misc.alertWhenApmIsBackToNormal", new JCheckBox(Language.getText("miscSettings.alertWhenApmIsBackToNormal"), Settings.getBoolean("settings.misc.alertWhenApmIsBackToNormal")), new JLabel()), new SettingRow("miscSettings.alertOnGameStartEvents", "settings.misc.alertOnGameStart", new JCheckBox(Language.getText("miscSettings.alertWhenGamesStarts"), Settings.getBoolean("settings.misc.alertOnGameStart")), new JLabel()), new SettingRow("miscSettings.alertOnGameEndEvents", "settings.misc.alertOnGameEnd", new JCheckBox(Language.getText("miscSettings.alertWhenGamesEnd"), Settings.getBoolean("settings.misc.alertOnGameEnd")), new JLabel())}, {new SettingRow("miscSettings.preferredBnetLanguage", "settings.misc.preferredBnetLanguage", jComboBox, new JLabel()), new SettingRow("miscSettings.navBarInitialWidth", "settings.misc.navBarInitialWidth", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.navBarInitialWidth"), 0, 1000, 1)), new JLabel(Language.getText("miscSettings.pixels"))), new SettingRow("miscSettings.chartsActionListPartition", "settings.misc.chartsActionListPartitioning", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.chartsActionListPartitioning"), 0, 100, 1)), new JLabel(Language.getText("miscSettings.percent"))), new SettingRow("miscSettings.toolTipInitialDelay", "settings.misc.toolTipInitialDelay", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.toolTipInitialDelay"), 0, 10000, 1)), new JLabel(Language.getText("miscSettings.ms"))), new SettingRow("miscSettings.toolTipDismissDelay", "settings.misc.toolTipDismissDelay", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.toolTipDismissDelay"), 0, 50000, 1)), new JLabel(Language.getText("miscSettings.ms")))}, {new SettingRow("miscSettings.useRealTimeMeasurement", "settings.misc.useRealTimeMeasurement", new JCheckBox(Language.getText("miscSettings.convertGameTimeToRealTime"), Settings.getBoolean("settings.misc.useRealTimeMeasurement")), new JLabel()), new SettingRow("miscSettings.timeLimitForMultiRepAnalysis", "settings.misc.timeLimitForMultiRepAnalysis", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.timeLimitForMultiRepAnalysis"), 0, 1000, 1)), new JLabel(Language.getText("miscSettings.seconds"))), new SettingRow("miscSettings.buildOrderLength", "settings.misc.buildOrderLength", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.buildOrderLength"), 1, 100, 1)), new JLabel(Language.getText("miscSettings.buildings"))), new SettingRow("miscSettings.initialTimeToExcludeFromApm", "settings.misc.initialTimeToExcludeFromApm", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.initialTimeToExcludeFromApm"), 0, 1000, 1)), new JLabel(Language.getText("miscSettings.seconds"))), new SettingRow("miscSettings.favoredPlayerList", "settings.misc.favoredPlayerList", jTextField2, new JLabel()), new SettingRow("miscSettings.rearrangePlayersInRepAnalyzer", "settings.misc.rearrangePlayersInRepAnalyzer", new JCheckBox(Language.getText("miscSettings.applyFavoredListInRepAnalyzer"), Settings.getBoolean("settings.misc.rearrangePlayersInRepAnalyzer")), new JLabel()), new SettingRow("miscSettings.showWinners", "settings.misc.showWinners", new JCheckBox(Language.getText("miscSettings.showWinners2"), Settings.getBoolean("settings.misc.showWinners")), new JLabel()), new SettingRow("miscSettings.declareLargestWinner", "settings.misc.declareLargestAsWinner", new JCheckBox(Language.getText("miscSettings.largestRemainingTeamWins"), Settings.getBoolean("settings.misc.declareLargestAsWinner")), new JLabel()), new SettingRow("miscSettings.animateRefreshRate", "settings.misc.animatorFps", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.animatorFps"), 1, 30, 1)), new JLabel(Language.getText("miscSettings.fps"))), new SettingRow("miscSettings.animatorJumpTime", "settings.misc.animatorJumpTime", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.animatorJumpTime"), 1, 1200, 1)), new JLabel(Language.getText("miscSettings.seconds")))}, {new SettingRow("miscSettings.soundVolume", "settings.misc.soundVolume", jSlider, jButton), new SettingRow("miscSettings.timeToKeepLogFiles", "settings.misc.timeToKeepLogFiles", new JSpinner(new SpinnerNumberModel(Settings.getInt("settings.misc.timeToKeepLogFiles"), 0, 1000, 1)), new JLabel(Language.getText("miscSettings.days"))), new SettingRow("miscSettings.enableInternalPreprocessedReplayCache", "settings.misc.cachePreprocessedReplays", new JCheckBox(Language.getText("miscSettings.cachePreprocessedReplays"), Settings.getBoolean("settings.misc.cachePreprocessedReplays")), jButton3)}};
        String[] stringArray = new String[]{TAB_TEXT_KEY_REPLAY_AUTO_SAVE, TAB_TEXT_KEY_APM_ALERT, TAB_TEXT_KEY_USER_INTERFACE, TAB_TEXT_KEY_ANALYZER, TAB_TEXT_KEY_INTERNAL};
        Icon[] iconArray = new Icon[]{Icons.DATABASE_SAVE, Icons.ALARM_CLOCK, Icons.UI_LAYOUT_PANEL, Icons.CHART_CURVE, Icons.WRENCH};
        int n2 = 0;
        while (n2 < settingRowArray2.length) {
            jComponent = Box.createVerticalBox();
            jComponent.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
            GuiUtils.addNewTab(Language.getText(stringArray[n2]), iconArray[n2], false, jTabbedPane, GuiUtils.wrapInPanel(jComponent), null);
            if (string != null && stringArray[n2].equals(string)) {
                jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
            }
            object = settingRowArray = settingRowArray2[n2];
            int n3 = settingRowArray.length;
            n = 0;
            while (n < n3) {
                SettingRow object3 = object[n];
                jComponent.add(object3.box);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 3) {
            void var16_25;
            int n4;
            int n5;
            SettingRow[] settingRowArray3;
            void var16_23;
            int n6 = 0;
            SettingRow[][] settingRowArray4 = settingRowArray2;
            n = settingRowArray2.length;
            boolean n7 = false;
            while (var16_23 < n) {
                settingRowArray3 = settingRowArray = settingRowArray4[var16_23];
                n5 = settingRowArray.length;
                n4 = 0;
                while (n4 < n5) {
                    object = settingRowArray3[n4];
                    n6 = Math.max(object.box.getComponent((int)n2).getPreferredSize().width, n6);
                    ++n4;
                }
                ++var16_23;
            }
            settingRowArray4 = settingRowArray2;
            n = settingRowArray2.length;
            boolean bl = false;
            while (var16_25 < n) {
                settingRowArray3 = settingRowArray = settingRowArray4[var16_25];
                n5 = settingRowArray.length;
                n4 = 0;
                while (n4 < n5) {
                    object = settingRowArray3[n4];
                    object.box.getComponent(n2).setPreferredSize(new Dimension(n6, object.box.getComponent((int)n2).getPreferredSize().height));
                    ++n4;
                }
                ++var16_25;
            }
            ++n2;
        }
        final ArrayList<FolderRow> arrayList = new ArrayList<FolderRow>();
        jComponent = Box.createVerticalBox();
        jComponent.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        arrayList.add(new FolderRow("folderSettings.sc2InstallationFolder", "settings.folders.sc2Installation", false, null, null));
        arrayList.add(new FolderRow("folderSettings.sc2AutoReplay", "settings.folders.sc2AutoReplay", true, null, null));
        int n8 = 2;
        while (n8 <= 5) {
            arrayList.add(new FolderRow("folderSettings.sc2AutoReplay", "settings.folders.sc2AutoReplay", true, n8, "settings.folders.enableExtraSc2AutoReplay"));
            ++n8;
        }
        arrayList.add(new FolderRow("folderSettings.sc2Maps", "settings.folders.sc2Maps", false, null, null));
        arrayList.add(new FolderRow("folderSettings.defaultFolder", "settings.folders.defaultReplay", false, null, null));
        arrayList.add(new FolderRow("folderSettings.replayAutoSaveFolder", "settings.folders.replayAutoSave", false, null, null));
        n8 = 0;
        for (FolderRow folderRow : arrayList) {
            jComponent.add(folderRow.getComponent());
            n8 = Math.max(folderRow.infoComponent.getPreferredSize().width, n8);
        }
        for (FolderRow folderRow : arrayList) {
            folderRow.infoComponent.setPreferredSize(new Dimension(n8, folderRow.infoComponent.getPreferredSize().height));
        }
        GuiUtils.addNewTab(Language.getText(TAB_TEXT_KEY_FOLDERS), Icons.FOLDERS, false, jTabbedPane, GuiUtils.wrapInPanel(jComponent), null);
        if (string != null && TAB_TEXT_KEY_FOLDERS.equals(string)) {
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        }
        this.getContentPane().add((Component)jTabbedPane, "Center");
        jComponent = new JPanel();
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JButton jButton4 = new JButton();
        GuiUtils.updateButtonText(jButton4, "button.ok", new Object[0]);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingRow[][] settingRowArray = settingRowArray2;
                int n = settingRowArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = settingRowArray[n2];
                    SettingRow[] settingRowArray22 = object;
                    int n3 = ((SettingRow[])object).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SettingRow settingRow = settingRowArray22[n4];
                        settingRow.storeSetting();
                        ++n4;
                    }
                    ++n2;
                }
                GeneralUtils.setToolTipDelays();
                for (Object object : arrayList) {
                    ((FolderRow)object).storeSetting();
                }
                MiscSettingsDialog.this.dispose();
            }
        });
        jComponent.add(jButton4);
        JButton jButton5 = this.createCloseButton("button.cancel");
        jComponent.add(jButton5);
        this.getContentPane().add((Component)jComponent, "South");
        this.packAndShow(jButton5, true);
    }

    public static JLabel createLinkLabelToSettings(final String string) {
        JLabel jLabel = SharedUtils.createLinkStyledLabel(Language.getText("misc.settingsOf", Language.getText(string)));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                new MiscSettingsDialog(string);
            }
        });
        return jLabel;
    }

    private static class FolderRow {
        private final String settingKeyForDefault;
        private final Integer multiplicationIndex;
        private final String checkBoxSettingKey;
        private final String settingKey;
        public final JComponent infoComponent;
        private final JTextField textField;
        private final boolean isUserHomeRelative;

        public FolderRow(String string, String string2, boolean bl, Integer n, String string3) {
            this.settingKeyForDefault = string2;
            this.multiplicationIndex = n;
            this.checkBoxSettingKey = string3;
            this.settingKey = n == null ? string2 : String.valueOf(string2) + n;
            this.infoComponent = n == null ? new JLabel(Language.getText(string)) : new JCheckBox(String.valueOf(Language.getText(string)) + " #" + n, Settings.getBoolean(String.valueOf(string3) + n));
            this.textField = new JTextField(Settings.getString(this.settingKey), 30);
            this.isUserHomeRelative = bl;
        }

        public JComponent getComponent() {
            Box box = Box.createHorizontalBox();
            box.add(this.infoComponent);
            box.add(this.textField);
            final JButton jButton = new JButton(Language.getText("folderSettings.chooseFolder"), Icons.FOLDER);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Serializable serializable;
                    String string = FolderRow.this.isUserHomeRelative ? (((File)(serializable = new File(FolderRow.this.textField.getText()))).exists() ? ((File)serializable).getAbsolutePath() : new File(Consts.FOLDER_USER_HOME, FolderRow.this.textField.getText()).getAbsolutePath()) : FolderRow.this.textField.getText();
                    System.out.println(string);
                    serializable = new JFileChooser(string);
                    ((JFileChooser)serializable).setDialogTitle(Language.getText("folderSettings.chooseFolder"));
                    ((JFileChooser)serializable).setFileSelectionMode(1);
                    if (((JFileChooser)serializable).showOpenDialog(MainFrame.INSTANCE) == 0) {
                        String string2 = ((JFileChooser)serializable).getSelectedFile().getAbsolutePath();
                        if (FolderRow.this.isUserHomeRelative && string2.toLowerCase().startsWith(Consts.FOLDER_USER_HOME.toLowerCase())) {
                            string2 = string2.substring(Consts.FOLDER_USER_HOME.length());
                        }
                        FolderRow.this.textField.setText(string2);
                    }
                }
            });
            box.add(jButton);
            final JButton jButton2 = new JButton(Language.getText("folderSettings.restoreDefaultFolder"), Icons.FOLDER_MINUS);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FolderRow.this.textField.setText(Settings.getDefaultString(FolderRow.this.settingKeyForDefault));
                }
            });
            box.add(jButton2);
            if (this.infoComponent instanceof JCheckBox) {
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = ((JCheckBox)FolderRow.this.infoComponent).isSelected();
                        FolderRow.this.textField.setEnabled(bl);
                        jButton.setEnabled(bl);
                        jButton2.setEnabled(bl);
                    }
                };
                actionListener.actionPerformed(null);
                ((JCheckBox)this.infoComponent).addActionListener(actionListener);
            }
            return box;
        }

        public void storeSetting() {
            Settings.set(this.settingKey, this.textField.getText());
            if (this.infoComponent instanceof JCheckBox) {
                Settings.set(String.valueOf(this.checkBoxSettingKey) + this.multiplicationIndex, ((JCheckBox)this.infoComponent).isSelected());
            }
        }
    }

    private static class SettingRow {
        private final String settingKey;
        public final JComponent component;
        public final Box box = Box.createHorizontalBox();

        public SettingRow(String string, final String string2, final JComponent jComponent, JComponent jComponent2) {
            Serializable serializable;
            this.settingKey = string2;
            this.component = jComponent;
            if (jComponent instanceof JSpinner && ((JSpinner)jComponent).getModel() instanceof SpinnerNumberModel) {
                serializable = (SpinnerNumberModel)((JSpinner)jComponent).getModel();
                jComponent.setToolTipText(Language.getText("miscSettings.validRangeToolTip", ((SpinnerNumberModel)serializable).getMinimum(), ((SpinnerNumberModel)serializable).getMaximum()));
            }
            this.box.add(new JLabel(Language.getText(string)));
            this.box.add(jComponent instanceof JCheckBox ? GuiUtils.wrapInPanelLeftAligned(jComponent) : jComponent);
            this.box.add(jComponent2);
            serializable = new JButton();
            GuiUtils.updateButtonText((AbstractButton)serializable, "miscSettings.restoreDefault", new Object[0]);
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jComponent instanceof JSpinner) {
                        ((JSpinner)jComponent).setValue(Settings.getDefaultInt(string2));
                    } else if (jComponent instanceof JSlider) {
                        ((JSlider)jComponent).setValue(Settings.getDefaultInt(string2));
                    } else if (jComponent instanceof JTextField) {
                        ((JTextField)jComponent).setText(Settings.getDefaultString(string2));
                    } else if (jComponent instanceof JCheckBox) {
                        ((JCheckBox)jComponent).setSelected(Settings.getDefaultBoolean(string2));
                    } else if (jComponent instanceof JComboBox) {
                        ((JComboBox)jComponent).setSelectedIndex(Settings.getDefaultInt(string2));
                    }
                }
            });
            this.box.add((Component)serializable);
        }

        public void storeSetting() {
            if (this.component instanceof JSpinner) {
                Settings.set(this.settingKey, ((JSpinner)this.component).getValue());
            } else if (this.component instanceof JSlider) {
                Settings.set(this.settingKey, ((JSlider)this.component).getValue());
            } else if (this.component instanceof JTextField) {
                Settings.set(this.settingKey, ((JTextField)this.component).getText());
            } else if (this.component instanceof JCheckBox) {
                Settings.set(this.settingKey, ((JCheckBox)this.component).isSelected());
            } else if (this.component instanceof JComboBox) {
                Settings.set(this.settingKey, ((JComboBox)this.component).getSelectedIndex());
            }
        }
    }
}

