/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.dialogs.ReplayRenameDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ReplayOperationsPopupMenu
extends JPopupMenu
implements ActionListener {
    public final JMenuItem openInAnalyzerMenuItem = new JMenuItem(Language.getText("replayops.openInAnalyzer"), Icons.CHART);
    public final JMenuItem openInMultiRepAnalMenuItem = new JMenuItem(Language.getText("replayops.openInMultiRepAnal"), Icons.CHART_UP_COLOR);
    public final JMenuItem watchReplayMenuItem = new JMenuItem(Language.getText("replayops.watchReplay"), Icons.REPLAY);
    public final JMenuItem copyReplaysMenuItem = new JMenuItem(Language.getText("replayops.copyReplays"), Icons.DOCUMENT_COPY);
    public final JMenuItem moveReplaysMenuItem = new JMenuItem(Language.getText("replayops.moveReplays"), Icons.DOCUMENT_EXPORT);
    public final JMenuItem packReplaysMenuItem = new JMenuItem(Language.getText("replayops.packReplays"), Icons.DOCUMENT_ZIPPER);
    public final JMenuItem renameReplaysMenuItem = new JMenuItem(Language.getText("replayops.renameReplays"), Icons.DOCUMENT_RENAME);
    public final JMenuItem deleteReplaysMenuItem = new JMenuItem(Language.getText("replayops.deleteReplays"), Icons.CROSS);
    public final JMenuItem openReplaysFolderMenuItem = new JMenuItem(Language.getText("replayops.openReplaysFolder"), Icons.FOLDER_OPEN);
    private final File[] files;
    private final ReplayOpCallback replayOpCallback;

    public ReplayOperationsPopupMenu(File[] fileArray, ReplayOpCallback replayOpCallback) {
        this.files = fileArray;
        this.replayOpCallback = replayOpCallback;
        this.openInAnalyzerMenuItem.addActionListener(this);
        this.add(this.openInAnalyzerMenuItem);
        this.openInMultiRepAnalMenuItem.addActionListener(this);
        this.add(this.openInMultiRepAnalMenuItem);
        this.watchReplayMenuItem.addActionListener(this);
        this.add(this.watchReplayMenuItem);
        this.addSeparator();
        this.copyReplaysMenuItem.addActionListener(this);
        this.add(this.copyReplaysMenuItem);
        this.moveReplaysMenuItem.addActionListener(this);
        this.add(this.moveReplaysMenuItem);
        this.packReplaysMenuItem.addActionListener(this);
        this.add(this.packReplaysMenuItem);
        this.renameReplaysMenuItem.addActionListener(this);
        this.add(this.renameReplaysMenuItem);
        this.deleteReplaysMenuItem.addActionListener(this);
        this.add(this.deleteReplaysMenuItem);
        this.addSeparator();
        this.openReplaysFolderMenuItem.setEnabled(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN));
        this.openReplaysFolderMenuItem.addActionListener(this);
        this.add(this.openReplaysFolderMenuItem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block67: {
            Object object;
            if (actionEvent.getSource() == this.openInAnalyzerMenuItem) {
                MainFrame.INSTANCE.openReplayFile(this.files[0]);
                return;
            }
            if (actionEvent.getSource() == this.openInMultiRepAnalMenuItem) {
                MainFrame.INSTANCE.openReplaysInMultiRepAnalysis(this.files);
                return;
            }
            if (actionEvent.getSource() == this.watchReplayMenuItem) {
                try {
                    Runtime.getRuntime().exec(new String[]{new File(Settings.getString("settings.folders.sc2Installation"), GeneralUtils.isOsMac() ? "StarCraft II.app/Contents/MacOS/StarCraft II" : "StarCraft II.exe").getAbsolutePath(), this.files[0].getAbsolutePath()});
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            if (actionEvent.getSource() != this.copyReplaysMenuItem && actionEvent.getSource() != this.moveReplaysMenuItem && actionEvent.getSource() != this.deleteReplaysMenuItem) break block67;
            boolean bl = actionEvent.getSource() == this.copyReplaysMenuItem;
            boolean bl2 = actionEvent.getSource() == this.moveReplaysMenuItem;
            boolean bl3 = actionEvent.getSource() == this.deleteReplaysMenuItem;
            boolean bl4 = bl || bl2;
            boolean bl5 = bl2 || bl3;
            File file = null;
            if (bl4) {
                object = new JFileChooser();
                ((JFileChooser)object).setFileSelectionMode(1);
                ((JFileChooser)object).setDialogTitle(Language.getText(bl ? "replayops.selectCopyTargetFolder" : "replayops.selectMoveTargetFolder"));
                ((JFileChooser)object).setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                if (((JFileChooser)object).showOpenDialog(MainFrame.INSTANCE) != 0) return;
                file = ((JFileChooser)object).getSelectedFile();
            } else if (GuiUtils.showConfirmDialog(Language.getText("replayops.deleteConfirmation", this.files.length), true) != 0) {
                return;
            }
            object = new byte[16384];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.files.length) {
                block69: {
                    File file2;
                    block68: {
                        file2 = this.files[n3];
                        if (!bl4) break block68;
                        if (!GeneralUtils.copyFile(file2, file, (byte[])object, null)) break block69;
                        ++n;
                    }
                    if (bl5) {
                        if (file2.delete()) {
                            if (!bl2 && this.replayOpCallback != null) {
                                this.replayOpCallback.replayDeleted(file2, n3);
                            }
                            ++n2;
                        }
                        if (bl2 && this.replayOpCallback != null) {
                            this.replayOpCallback.replayMoved(file2, file, n3);
                        }
                    }
                }
                ++n3;
            }
            if (this.replayOpCallback != null) {
                this.replayOpCallback.moveRenameDeleteEnded();
            }
            ArrayList<String> arrayList = new ArrayList<String>(3);
            if (bl) {
                arrayList.add(Language.getText("replayops.successfullyCopied", n));
                if (n < this.files.length) {
                    arrayList.add(Language.getText("replayops.failedToCopy", this.files.length - n));
                }
            } else if (bl2) {
                arrayList.add(Language.getText("replayops.successfullyMoved", n2));
                if (n2 < n) {
                    arrayList.add(Language.getText("replayops.successfullyCopied", n - n2));
                    arrayList.add(Language.getText("replayops.failedToDelete", n - n2));
                }
                if (n < this.files.length) {
                    arrayList.add(Language.getText("replayops.failedToCopy", this.files.length - n));
                }
            } else if (bl3) {
                arrayList.add(Language.getText("replayops.successfullyDeleted", n2));
                if (n2 < this.files.length) {
                    arrayList.add(Language.getText("replayops.failedToDelete", this.files.length - n2));
                }
            }
            if (bl4 && n != this.files.length) {
                GuiUtils.showErrorDialog(arrayList.toArray());
                return;
            } else {
                GuiUtils.showInfoDialog(arrayList.toArray());
            }
            return;
        }
        if (actionEvent.getSource() == this.packReplaysMenuItem) {
            int n;
            block66: {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(Language.getText("replayops.selectFileToPackTo"));
                jFileChooser.setFileFilter(GuiUtils.ZIP_FILE_FILTER);
                jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                JCheckBox jCheckBox = GuiUtils.createCheckBox("replayops.includePathInZip", "module.repSearch.results.includePathInZip");
                jFileChooser.setAccessory(jCheckBox);
                if (jFileChooser.showSaveDialog(MainFrame.INSTANCE) != 0) return;
                File file = jFileChooser.getSelectedFile();
                if (!GuiUtils.ZIP_FILE_FILTER.accept(file)) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".zip");
                }
                n = 0;
                ZipOutputStream zipOutputStream = null;
                try {
                    try {
                        zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
                        boolean bl = jCheckBox.isSelected();
                        byte[] byArray = new byte[16384];
                        File[] fileArray = this.files;
                        int n4 = this.files.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            block64: {
                                File file3 = fileArray[n5];
                                ZipEntry zipEntry = new ZipEntry(bl ? file3.getAbsolutePath() : file3.getName());
                                zipEntry.setTime(file3.lastModified());
                                zipOutputStream.putNextEntry(zipEntry);
                                FileInputStream fileInputStream = null;
                                try {
                                    try {
                                        int n6;
                                        fileInputStream = new FileInputStream(file3);
                                        while ((n6 = fileInputStream.read(byArray)) > 0) {
                                            zipOutputStream.write(byArray, 0, n6);
                                        }
                                        fileInputStream.close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        if (fileInputStream != null) {
                                            try {
                                                fileInputStream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block64;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (fileInputStream == null) throw throwable;
                                    try {
                                        fileInputStream.close();
                                        throw throwable;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                if (fileInputStream != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            zipOutputStream.closeEntry();
                            ++n;
                            ++n5;
                        }
                        zipOutputStream.flush();
                        zipOutputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (zipOutputStream != null) {
                            try {
                                zipOutputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block66;
                    }
                }
                catch (Throwable throwable) {
                    if (zipOutputStream == null) throw throwable;
                    try {
                        zipOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (n == this.files.length) {
                GuiUtils.showInfoDialog(Language.getText("replayops.successfullyPacked", n));
                return;
            } else {
                GuiUtils.showErrorDialog(new Object[]{Language.getText("replayops.successfullyPacked", n), Language.getText("replayops.failedToPack", this.files.length - n)});
            }
            return;
        }
        if (actionEvent.getSource() == this.renameReplaysMenuItem) {
            new ReplayRenameDialog(this.replayOpCallback, this.files);
            return;
        }
        if (actionEvent.getSource() != this.openReplaysFolderMenuItem) return;
        try {
            Desktop.getDesktop().open(this.files[0].getParentFile());
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static interface ReplayOpCallback {
        public void replayMoved(File var1, File var2, int var3);

        public void replayDeleted(File var1, int var2);

        public void replayRenamed(File var1, File var2, int var3);

        public void moveRenameDeleteEnded();
    }
}

