/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay.model;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import java.util.Map;

public class GameEvents {
    public String[] playerNames;
    public boolean displayInSeconds;
    public Action[] actions;
    public final Map<Short, String> unitTypeNameMap;
    private static String[] SPACES = new String[30];
    private final Replay replay;

    static {
        GameEvents.SPACES[0] = "";
        int n = 1;
        while (n < SPACES.length) {
            GameEvents.SPACES[n] = String.valueOf(SPACES[n - 1]) + ' ';
            ++n;
        }
    }

    public GameEvents(Replay replay, Map<Short, String> map) {
        this.replay = replay;
        Details.Player[] playerArray = replay.details.players;
        int n = 0;
        Details.Player[] playerArray2 = playerArray;
        int n2 = playerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Details.Player player = playerArray2[n3];
            if (n < player.name.length()) {
                n = player.name.length();
            }
            ++n3;
        }
        this.playerNames = new String[playerArray.length];
        int n4 = 0;
        while (n4 < this.playerNames.length) {
            this.playerNames[n4] = "  " + playerArray[n4].name + SPACES[n - playerArray[n4].name.length() + 2];
            ++n4;
        }
        this.unitTypeNameMap = map;
    }

    public class Action {
        public int frame;
        public byte player;
        public byte opCode;
        public ReplayConsts.ActionType type = ReplayConsts.ActionType.OTHER;

        protected String toStringTemplate() {
            return String.valueOf(GameEvents.this.displayInSeconds ? ReplayUtils.formatFramesShort(this.frame, ((GameEvents)GameEvents.this).replay.converterGameSpeed) : String.format("%6d", this.frame)) + GameEvents.this.playerNames[this.player];
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(GameEvents.this.displayInSeconds ? ReplayUtils.formatFramesShort(this.frame, ((GameEvents)GameEvents.this).replay.converterGameSpeed) : String.format("%6d", this.frame));
            stringBuilder.append(GameEvents.this.playerNames[this.player]);
            this.customToString(stringBuilder);
            return stringBuilder.toString();
        }

        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("0x").append(Integer.toHexString(this.opCode & 0xFF));
        }
    }

    public class AllianceAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Set Alliance");
        }
    }

    public class BaseUseAbilityAction
    extends Action {
        public int abilityCode;
        public String abilityName;
        public ReplayConsts.AbilityGroup abilityGroup;
        public boolean targetIsUnit;
        public int targetP1;
        public int targetP2;

        public BaseUseAbilityAction() {
        }

        public BaseUseAbilityAction(String string, ReplayConsts.AbilityGroup abilityGroup) {
            this.abilityName = string;
            this.abilityGroup = abilityGroup;
        }

        @Override
        protected final void customToString(StringBuilder stringBuilder) {
            this.customAbilToString(stringBuilder);
            if (this.targetIsUnit) {
                stringBuilder.append("; target: ");
                String string = GameEvents.this.unitTypeNameMap.get((short)this.targetP2);
                if (string == null) {
                    stringBuilder.append("Unknown[").append(Integer.toHexString(this.targetP2)).append(']');
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(" (").append(Integer.toHexString(this.targetP1)).append(')');
            } else if (this.targetP1 != 256 || this.targetP2 != 256) {
                stringBuilder.append("; target: ");
                stringBuilder.append("x=").append(ReplayUtils.formatCoordinate(this.targetP1)).append(",y=").append(ReplayUtils.formatCoordinate(this.targetP2));
            }
        }

        protected void customAbilToString(StringBuilder stringBuilder) {
            if (this.abilityName == null) {
                stringBuilder.append("Use ability ").append(String.format("%6x", this.abilityCode));
            } else {
                stringBuilder.append(this.abilityName);
            }
        }

        public boolean hasTargetPoint() {
            return !this.targetIsUnit && (this.targetP1 != 256 || this.targetP2 != 256);
        }
    }

    public class BuildAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Building building;

        public BuildAction(ReplayConsts.Building building) {
            this.type = ReplayConsts.ActionType.BUILD;
            this.building = building;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Build ").append(this.building.stringValue);
        }
    }

    public class CancelResRequestAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Cancel trade");
        }
    }

    public class DecreaseGameSpeedAction
    extends Action {
        public DecreaseGameSpeedAction() {
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Decrease Game Speed");
        }
    }

    public class HotkeyAction
    extends Action {
        public boolean isSelect;

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Hotkey ").append(this.isSelect ? "Select " : "Assign ").append((this.opCode & 0xFF) >> 4);
        }
    }

    public class IncreaseGameSpeedAction
    extends Action {
        public IncreaseGameSpeedAction() {
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Increase Game Speed");
        }
    }

    public class LeaveGameAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Leave game");
        }
    }

    public class MoveScreenAction
    extends Action {
        public int x;
        public int y;
        public boolean zooming;
        public boolean rotating;

        public MoveScreenAction() {
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Move screen x=").append(this.x >> 8).append('.').append(ReplayUtils.DECIMAL_TABLE[this.x & 0xFF]).append(",y=").append(this.y >> 8).append('.').append(ReplayUtils.DECIMAL_TABLE[this.y & 0xFF]);
            if (this.zooming) {
                stringBuilder.append(", Zoom camera");
            }
            if (this.rotating) {
                stringBuilder.append(", Rotate camera");
            }
        }
    }

    public class RequestResoucesAction
    extends Action {
        public int minRequested;
        public int gasRequested;

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Request resources ").append(this.minRequested).append(',').append(this.gasRequested);
        }
    }

    public class ResearchAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Research research;

        public ResearchAction(ReplayConsts.Research research) {
            this.type = ReplayConsts.ActionType.RESEARCH;
            this.research = research;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Research ").append(this.research.stringValue);
        }
    }

    public class SelectAction
    extends Action {
        public boolean automatic;
        public int deselectionBitsCount;
        public byte[] deselectionUnitBitmap;
        public short[] unitTypes;
        public byte[] unitsOfTypeCounts;
        public int[] unitIds;

        public SelectAction() {
            this.type = ReplayConsts.ActionType.SELECT;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            if (this.automatic) {
                stringBuilder.append("Selection auto-update ");
            }
            int n = 0;
            if (this.unitTypes != null) {
                int n2 = 0;
                while (n2 < this.unitTypes.length) {
                    stringBuilder.append(n2 == 0 ? "Select " : ", ");
                    String string = GameEvents.this.unitTypeNameMap.get(this.unitTypes[n2]);
                    if (string == null) {
                        stringBuilder.append("Unknown[").append(Integer.toHexString(this.unitTypes[n2])).append(']');
                    } else {
                        stringBuilder.append(string);
                    }
                    int n3 = this.unitsOfTypeCounts[n2];
                    if (n3 > 1) {
                        stringBuilder.append(" x").append(this.unitsOfTypeCounts[n2]);
                    }
                    stringBuilder.append(" (");
                    int n4 = n3;
                    while (n4 > 0) {
                        stringBuilder.append(Integer.toHexString(this.unitIds[n])).append(',');
                        --n4;
                        ++n;
                    }
                    stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
                    ++n2;
                }
            }
            if (this.deselectionBitsCount != 0) {
                if (this.unitTypes != null && this.unitTypes.length > 0) {
                    stringBuilder.append(", ");
                }
                if (this.deselectionBitsCount < 0) {
                    stringBuilder.append("Deselect all");
                } else {
                    stringBuilder.append("Deselect ").append(this.deselectionBitsCount).append(this.deselectionBitsCount == 1 ? " unit" : " units");
                }
            }
        }
    }

    public class SendResourcesAction
    extends Action {
        public int targetPlayer;
        public int minSent;
        public int gasSent;

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Send resources to ").append(((GameEvents)GameEvents.this).replay.details.players[this.targetPlayer].name).append("; minerals: ").append(this.minSent).append(", gas: ").append(this.gasSent);
        }
    }

    public class TrainAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Unit unit;

        public TrainAction(ReplayConsts.Unit unit) {
            this.type = ReplayConsts.ActionType.TRAIN;
            this.unit = unit;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue);
        }
    }

    public class TrainHallucinatedAction
    extends TrainAction {
        public TrainHallucinatedAction(ReplayConsts.Unit unit) {
            super(unit);
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue).append(" Hallucination (Sentry)");
        }
    }

    public class UpgradeAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Upgrade upgrade;

        public UpgradeAction(ReplayConsts.Upgrade upgrade) {
            this.type = ReplayConsts.ActionType.UPGRADE;
            this.upgrade = upgrade;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Upgrade ").append(this.upgrade.stringValue);
        }
    }

    public class UseBuildingAbilityAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.BuildingAbility buildingAbility;
        public final ReplayConsts.Building building;

        public UseBuildingAbilityAction(ReplayConsts.BuildingAbility buildingAbility, ReplayConsts.Building building) {
            this.buildingAbility = buildingAbility;
            this.building = building;
            this.abilityGroup = buildingAbility.abilityGroup;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append(this.buildingAbility.stringValue).append(" (").append(this.building.stringValue).append(')');
        }
    }

    public class UseUnitAbilityAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.UnitAbility unitAbility;
        public final ReplayConsts.Unit unit;

        public UseUnitAbilityAction(ReplayConsts.UnitAbility unitAbility, ReplayConsts.Unit unit) {
            this.unitAbility = unitAbility;
            this.unit = unit;
            this.abilityGroup = unitAbility.abilityGroup;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append((Object)this.unitAbility).append(" (").append(this.unit.stringValue).append(')');
        }
    }

    public class WarpAction
    extends TrainAction {
        public WarpAction(ReplayConsts.Unit unit) {
            super(unit);
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue).append(" (Warp gate)");
        }
    }
}

