/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.sc2replay.AbilityCodes;
import hu.belicza.andras.sc2gears.sc2replay.BitBufferView;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParser;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;

class ReplayParserV10
extends ReplayParser {
    public ReplayParserV10(Replay replay) {
        super(replay);
    }

    @Override
    protected GameEvents.HotkeyAction readHotkeyAction() {
        GameEvents.HotkeyAction hotkeyAction = this.replay.gameEvents.new GameEvents.HotkeyAction();
        int n = this.wrapper.get() & 0xFF;
        boolean bl = hotkeyAction.isSelect = (n & 2) == 2;
        if (hotkeyAction.isSelect) {
            hotkeyAction.type = ReplayConsts.ActionType.SELECT;
        }
        if (n > 3) {
            this.wrapper.position(this.wrapper.position() + (n >> 3) + ((n & 4) == 4 ? ((this.wrapper.get(this.wrapper.position()) & 6) == 6 ? 2 : 1) : 0));
        }
        return hotkeyAction;
    }

    @Override
    protected void readCustomSelectAction(GameEvents.SelectAction selectAction) {
        this.wrapper.get();
        selectAction.deselectionBitsCount = this.wrapper.get() & 0xFF;
        if ((selectAction.deselectionBitsCount & 7) == 0) {
            int n;
            if (selectAction.deselectionBitsCount > 0) {
                selectAction.deselectionUnitBitmap = new byte[selectAction.deselectionBitsCount >> 3];
                n = 0;
                while (n < selectAction.deselectionUnitBitmap.length) {
                    selectAction.deselectionUnitBitmap[n] = this.wrapper.get();
                    ++n;
                }
            }
            n = this.wrapper.get() & 0xFF;
            selectAction.unitTypes = new short[n];
            selectAction.unitsOfTypeCounts = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                selectAction.unitTypes[n2] = (short)(((this.wrapper.get() & 0xFF) << 8) + (this.wrapper.get() & 0xFF));
                this.wrapper.get();
                selectAction.unitsOfTypeCounts[n2] = this.wrapper.get();
                ++n2;
            }
            n2 = this.wrapper.get() & 0xFF;
            selectAction.unitIds = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                selectAction.unitIds[n3] = (this.wrapper.get() & 0xFF) << 8 | this.wrapper.get() & 0xFF | (this.wrapper.get() & 0xFF) << 24 | (this.wrapper.get() & 0xFF) << 16;
                ++n3;
            }
        } else {
            int n;
            int n4;
            selectAction.deselectionUnitBitmap = new byte[selectAction.deselectionBitsCount + 7 >> 3];
            int n5 = 0;
            while (n5 < selectAction.deselectionUnitBitmap.length - 1) {
                selectAction.deselectionUnitBitmap[n5] = this.wrapper.get();
                ++n5;
            }
            BitBufferView bitBufferView = new BitBufferView(this.wrapper, selectAction.deselectionBitsCount & 7);
            selectAction.deselectionUnitBitmap[selectAction.deselectionUnitBitmap.length - 1] = bitBufferView.initialBits;
            int n6 = bitBufferView.get();
            if (n6 > 0) {
                selectAction.unitTypes = new short[n6];
                selectAction.unitsOfTypeCounts = new byte[n6];
                n4 = 0;
                while (n4 < n6) {
                    selectAction.unitTypes[n4] = bitBufferView.get2Bytes();
                    bitBufferView.get();
                    selectAction.unitsOfTypeCounts[n4] = (byte)bitBufferView.get();
                    ++n4;
                }
            }
            if ((n4 = bitBufferView.get()) > 0) {
                selectAction.unitIds = new int[n4];
                n = 0;
                while (n < n4) {
                    selectAction.unitIds[n] = bitBufferView.getInt();
                    selectAction.unitIds[n] = (selectAction.unitIds[n] & 0xFF00) >> 8 | (selectAction.unitIds[n] & 0xFF) << 8 | (selectAction.unitIds[n] & 0xFF000000) >>> 8 | (selectAction.unitIds[n] & 0xFF0000) << 8;
                    ++n;
                }
            }
            if ((n = bitBufferView.getRemainder()) > 0) {
                this.wrapper.position(this.wrapper.position() + n);
            }
        }
    }

    @Override
    protected GameEvents.BaseUseAbilityAction readUseAbilityAction(AbilityCodes abilityCodes) {
        GameEvents.BaseUseAbilityAction baseUseAbilityAction;
        this.wrapper.getInt();
        int n = ((this.wrapper.get() & 0xFF) << 16) + ((this.wrapper.get() & 0xFF) << 8) + (this.wrapper.get() & 0xFF);
        ReplayConsts.Unit unit = null;
        ReplayConsts.Building building = null;
        ReplayConsts.Upgrade upgrade = null;
        ReplayConsts.Research research = null;
        GameEvents gameEvents = this.replay.gameEvents;
        Object[] objectArray = abilityCodes.COMMON_BASE_ABILITY_CODES.get(n);
        if (objectArray != null) {
            GameEvents gameEvents2 = gameEvents;
            gameEvents2.getClass();
            baseUseAbilityAction = gameEvents2.new GameEvents.BaseUseAbilityAction((String)objectArray[0], (ReplayConsts.AbilityGroup)((Object)objectArray[1]));
        } else {
            unit = abilityCodes.TRAIN_ABILITY_CODES.get(n);
            if (unit != null) {
                GameEvents gameEvents3 = gameEvents;
                gameEvents3.getClass();
                baseUseAbilityAction = gameEvents3.new GameEvents.TrainAction(unit);
            } else {
                building = abilityCodes.BUILD_ABILITY_CODES.get(n);
                if (building != null) {
                    GameEvents gameEvents4 = gameEvents;
                    gameEvents4.getClass();
                    baseUseAbilityAction = gameEvents4.new GameEvents.BuildAction(building);
                } else {
                    objectArray = abilityCodes.USE_UNIT_ABILITY.get(n);
                    if (objectArray != null) {
                        GameEvents gameEvents5 = gameEvents;
                        gameEvents5.getClass();
                        baseUseAbilityAction = gameEvents5.new GameEvents.UseUnitAbilityAction((ReplayConsts.UnitAbility)((Object)objectArray[0]), (ReplayConsts.Unit)((Object)objectArray[1]));
                    } else {
                        objectArray = abilityCodes.USE_BUILDING_ABILITY.get(n);
                        if (objectArray != null) {
                            GameEvents gameEvents6 = gameEvents;
                            gameEvents6.getClass();
                            baseUseAbilityAction = gameEvents6.new GameEvents.UseBuildingAbilityAction((ReplayConsts.BuildingAbility)((Object)objectArray[0]), (ReplayConsts.Building)((Object)objectArray[1]));
                        } else {
                            unit = abilityCodes.WARP_ABILITY_CODES.get(n);
                            if (unit != null) {
                                GameEvents gameEvents7 = gameEvents;
                                gameEvents7.getClass();
                                baseUseAbilityAction = gameEvents7.new GameEvents.WarpAction(unit);
                            } else {
                                unit = abilityCodes.TRAIN_HALLU_ABILITY_CODES.get(n);
                                if (unit != null) {
                                    GameEvents gameEvents8 = gameEvents;
                                    gameEvents8.getClass();
                                    baseUseAbilityAction = gameEvents8.new GameEvents.TrainHallucinatedAction(unit);
                                } else {
                                    upgrade = abilityCodes.UPGRADE_ABILITY_CODES.get(n);
                                    if (upgrade != null) {
                                        GameEvents gameEvents9 = gameEvents;
                                        gameEvents9.getClass();
                                        baseUseAbilityAction = gameEvents9.new GameEvents.UpgradeAction(upgrade);
                                    } else {
                                        research = abilityCodes.RESEARCH_ABILITY_CODES.get(n);
                                        if (research != null) {
                                            GameEvents gameEvents10 = gameEvents;
                                            gameEvents10.getClass();
                                            baseUseAbilityAction = gameEvents10.new GameEvents.ResearchAction(research);
                                        } else {
                                            baseUseAbilityAction = gameEvents.new GameEvents.BaseUseAbilityAction();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        baseUseAbilityAction.abilityCode = n;
        boolean bl = baseUseAbilityAction.targetIsUnit = (this.wrapper.get() & 0x10) != 0;
        if (baseUseAbilityAction.targetIsUnit) {
            this.wrapper.position(this.wrapper.position() + 6);
            baseUseAbilityAction.targetP1 = this.wrapper.getInt();
            baseUseAbilityAction.targetP1 = (baseUseAbilityAction.targetP1 & 0xFFF) << 4 | (baseUseAbilityAction.targetP1 & 0xF000) >> 12 | (baseUseAbilityAction.targetP1 & 0xFF000000) >>> 8 | (baseUseAbilityAction.targetP1 & 0xFF0000) << 8;
            baseUseAbilityAction.targetP2 = (this.wrapper.get() & 0xFF) << 4 | this.wrapper.get() & 0xF;
            this.wrapper.position(this.wrapper.position() + 13);
        } else {
            this.wrapper.position(this.wrapper.position() + 12);
            baseUseAbilityAction.targetP1 = Integer.reverseBytes(this.wrapper.getInt()) << 1;
            baseUseAbilityAction.targetP2 = Integer.reverseBytes(this.wrapper.getInt()) << 1;
            this.wrapper.position(this.wrapper.position() + 4);
        }
        return baseUseAbilityAction;
    }
}

