/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.InitData;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class ReplayCache {
    public static final short CACHE_VERSION = 2;

    public static Replay getReplay(File file, Integer n, Integer n2, boolean bl, boolean bl2, Set<ReplayFactory.ReplayContent> set) {
        Object object;
        String string;
        if (!file.exists()) {
            return null;
        }
        if (bl || bl2) {
            string = SharedUtils.calculateFileMd5(file);
            if (string.length() == 0) {
                return null;
            }
        } else {
            string = null;
        }
        if (!(!bl || (object = ReplayCache.readCachedReplay(string)) == null || n != null && ((CacheInfo)object).buildOrderLength < n || n2 != null && ((CacheInfo)object).replay.excludedInitialFrames != n2)) {
            return ((CacheInfo)object).replay;
        }
        object = ReplayFactory.parseReplay(file.getAbsolutePath(), set == null ? ReplayFactory.GENERAL_DATA_CONTENT : set);
        if (object != null && bl2) {
            ReplayCache.cacheReplay((Replay)object, n, string);
        }
        return object;
    }

    private static CacheInfo readCachedReplay(String string) {
        CacheInfo cacheInfo;
        File file = new File("User Content/Replay cache", String.valueOf(string.substring(0, 2)) + "/" + string);
        if (!file.exists()) {
            return null;
        }
        CacheInfo cacheInfo2 = new CacheInfo();
        FilterInputStream filterInputStream = null;
        try {
            Object object;
            filterInputStream = new DataInputStream(new FileInputStream(file));
            short s = ((DataInputStream)filterInputStream).readShort();
            if (s != 2) {
                return null;
            }
            cacheInfo2.buildOrderLength = ((DataInputStream)filterInputStream).readShort();
            Replay replay = cacheInfo2.replay = new Replay();
            replay.initData = new InitData();
            replay.details = new Details();
            int[] nArray = new int[4];
            int n = 0;
            while (n < 4) {
                nArray[n] = ((DataInputStream)filterInputStream).readInt();
                ++n;
            }
            replay.setBuildNumbers(nArray);
            replay.setGameDuration(((DataInputStream)filterInputStream).readInt());
            replay.excludedInitialFrames = ((DataInputStream)filterInputStream).readInt();
            replay.initData.gateway = ReplayConsts.Gateway.values()[((DataInputStream)filterInputStream).readByte()];
            replay.initData.format = ReplayConsts.Format.values()[((DataInputStream)filterInputStream).readByte()];
            replay.initData.gameSpeed = ReplayConsts.GameSpeed.values()[((DataInputStream)filterInputStream).readByte()];
            replay.converterGameSpeed = Settings.getBoolean("settings.misc.useRealTimeMeasurement") ? replay.initData.gameSpeed : ReplayConsts.GameSpeed.NORMAL;
            replay.initData.gameType = ReplayConsts.GameType.values()[((DataInputStream)filterInputStream).readByte()];
            replay.details.saveTime = ((DataInputStream)filterInputStream).readLong();
            replay.details.mapName = ((DataInputStream)filterInputStream).readUTF();
            replay.details.players = new Details.Player[((DataInputStream)filterInputStream).readByte()];
            n = 0;
            while (n < replay.details.players.length) {
                replay.details.players[n] = new Details.Player();
                object = replay.details.players[n];
                ((Details.Player)object).name = ((DataInputStream)filterInputStream).readUTF();
                ((Details.Player)object).fullName = ((DataInputStream)filterInputStream).readUTF();
                ((Details.Player)object).battleNetId = ((DataInputStream)filterInputStream).readInt();
                ((Details.Player)object).battleNetSubid = ((DataInputStream)filterInputStream).readInt();
                ((Details.Player)object).type = ReplayConsts.PlayerType.values()[((DataInputStream)filterInputStream).readByte()];
                ((Details.Player)object).lastActionFrame = ((DataInputStream)filterInputStream).readInt();
                ((Details.Player)object).race = ReplayConsts.Race.values()[((DataInputStream)filterInputStream).readByte()];
                ((Details.Player)object).finalRace = ReplayConsts.Race.values()[((DataInputStream)filterInputStream).readByte()];
                ((Details.Player)object).team = ((DataInputStream)filterInputStream).readInt();
                if (((DataInputStream)filterInputStream).readBoolean()) {
                    ((Details.Player)object).isWinner = ((DataInputStream)filterInputStream).readBoolean();
                }
                ((Details.Player)object).actionsCount = ((DataInputStream)filterInputStream).readInt();
                ((Details.Player)object).excludedActionsCount = ((DataInputStream)filterInputStream).readInt();
                ++n;
            }
            replay.gameEvents = new GameEvents(replay, null);
            n = ((DataInputStream)filterInputStream).readShort();
            object = new ArrayList(n);
            int n2 = n - 1;
            while (n2 >= 0) {
                GameEvents gameEvents = replay.gameEvents;
                gameEvents.getClass();
                GameEvents.BuildAction buildAction = gameEvents.new GameEvents.BuildAction(ReplayConsts.Building.values()[((DataInputStream)filterInputStream).readByte()]);
                buildAction.player = ((DataInputStream)filterInputStream).readByte();
                object.add(buildAction);
                --n2;
            }
            replay.gameEvents.actions = object.toArray(new GameEvents.Action[n]);
            cacheInfo = cacheInfo2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            CacheInfo cacheInfo3 = cacheInfo2;
            return cacheInfo3;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return cacheInfo;
    }

    private static void cacheReplay(Replay replay, Integer n, String string) {
        block19: {
            File file = new File("User Content/Replay cache", string.substring(0, 2));
            if (!file.exists() && !file.mkdirs()) {
                return;
            }
            File file2 = new File(file, string);
            FilterOutputStream filterOutputStream = null;
            try {
                try {
                    filterOutputStream = new DataOutputStream(new FileOutputStream(file2));
                    ((DataOutputStream)filterOutputStream).writeShort(2);
                    int n2 = n == null ? Settings.getInt("settings.misc.buildOrderLength") : n;
                    ((DataOutputStream)filterOutputStream).writeShort(n2);
                    Object object = replay.buildNumbers;
                    int n3 = replay.buildNumbers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = object[n4];
                        ((DataOutputStream)filterOutputStream).writeInt(n5);
                        ++n4;
                    }
                    ((DataOutputStream)filterOutputStream).writeInt(replay.frames);
                    ((DataOutputStream)filterOutputStream).writeInt(replay.excludedInitialFrames);
                    ((DataOutputStream)filterOutputStream).writeByte(replay.initData.gateway.ordinal());
                    ((DataOutputStream)filterOutputStream).writeByte(replay.initData.format.ordinal());
                    ((DataOutputStream)filterOutputStream).writeByte(replay.initData.gameSpeed.ordinal());
                    ((DataOutputStream)filterOutputStream).writeByte(replay.initData.gameType.ordinal());
                    ((DataOutputStream)filterOutputStream).writeLong(replay.details.saveTime);
                    ((DataOutputStream)filterOutputStream).writeUTF(replay.details.mapName);
                    ((DataOutputStream)filterOutputStream).writeByte(replay.details.players.length);
                    object = replay.details.players;
                    n3 = replay.details.players.length;
                    n4 = 0;
                    while (n4 < n3) {
                        int n6 = object[n4];
                        ((DataOutputStream)filterOutputStream).writeUTF(n6.name);
                        ((DataOutputStream)filterOutputStream).writeUTF(n6.fullName);
                        ((DataOutputStream)filterOutputStream).writeInt(n6.battleNetId);
                        ((DataOutputStream)filterOutputStream).writeInt(n6.battleNetSubid);
                        ((DataOutputStream)filterOutputStream).writeByte(n6.type.ordinal());
                        ((DataOutputStream)filterOutputStream).writeInt(n6.lastActionFrame);
                        ((DataOutputStream)filterOutputStream).writeByte(n6.race.ordinal());
                        ((DataOutputStream)filterOutputStream).writeByte(n6.finalRace.ordinal());
                        ((DataOutputStream)filterOutputStream).writeInt(n6.team);
                        ((DataOutputStream)filterOutputStream).writeBoolean(n6.isWinner != null);
                        if (n6.isWinner != null) {
                            ((DataOutputStream)filterOutputStream).writeBoolean(n6.isWinner);
                        }
                        ((DataOutputStream)filterOutputStream).writeInt(n6.actionsCount);
                        ((DataOutputStream)filterOutputStream).writeInt(n6.excludedActionsCount);
                        ++n4;
                    }
                    int[] nArray = new int[replay.details.players.length];
                    n4 = 0;
                    ArrayList<GameEvents.BuildAction> arrayList = new ArrayList<GameEvents.BuildAction>(Math.min(300, nArray.length * n2));
                    GameEvents.Action[] actionArray = replay.gameEvents.actions;
                    int n7 = replay.gameEvents.actions.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        object = actionArray[n8];
                        if (object instanceof GameEvents.BuildAction && nArray[object.player] < n2) {
                            arrayList.add((GameEvents.BuildAction)object);
                            byte by = object.player;
                            nArray[by] = nArray[by] + 1;
                            if (nArray[by] == n2 && ++n4 == nArray.length) break;
                        }
                        ++n8;
                    }
                    ((DataOutputStream)filterOutputStream).writeShort(arrayList.size());
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        object = (GameEvents.BuildAction)iterator.next();
                        ((DataOutputStream)filterOutputStream).writeByte(object.building.ordinal());
                        ((DataOutputStream)filterOutputStream).writeByte(object.player);
                    }
                    ((DataOutputStream)filterOutputStream).flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (filterOutputStream == null) break block19;
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void emptyCache() {
        System.out.println("Clearing preprocessed replay cache...");
        File[] fileArray = new File("User Content/Replay cache").listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray2[n2];
                ReplayCache.deleteFile(file);
                ++n2;
            }
        }
    }

    private static void deleteFile(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                ReplayCache.deleteFile(file2);
                ++n2;
            }
        }
        file.delete();
    }

    private static class CacheInfo {
        public int buildOrderLength;
        public Replay replay;

        private CacheInfo() {
        }
    }
}

