/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.logger.Log;
import hu.belicza.andras.sc2gears.sc2replay.ReplayCache;
import hu.belicza.andras.sc2gears.services.InstanceMonitor;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedConsts;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.WelcomeFrame;
import java.io.File;
import javax.swing.UIManager;

public class Sc2gears {
    private Sc2gears() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Sc2gears.checkFolders();
        Settings.loadProperties();
        InstanceMonitor.checkRunningInstance(stringArray);
        Log.init();
        Sc2gears.checkAndPerformPostUpdate();
        Sc2gears.installExtraLAFs();
        GuiUtils.setLAF(Settings.getString("settings.laf"));
        if (Settings.doesSettingsFileExist()) {
            Language.loadLanguage(Settings.getString("settings.language"));
        } else {
            WelcomeFrame welcomeFrame;
            WelcomeFrame welcomeFrame2 = welcomeFrame = new WelcomeFrame();
            synchronized (welcomeFrame2) {
                try {
                    welcomeFrame.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        GuiUtils.initFileFilters();
        new MainFrame(stringArray);
    }

    private static void checkFolders() {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"User Content", "User Content/Logs", "User Content/Replay sources", "User Content/Replay lists", "User Content/Replay cache"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            ++n2;
        }
    }

    public static boolean checkAndPerformPostUpdate() {
        File file = new File(SharedConsts.LIB_UPDATER_FOLDER, "Sc2gearsUpdater2.jar").getAbsoluteFile();
        if (file.exists()) {
            System.out.println("Performing post-update...");
            File file2 = new File(SharedConsts.LIB_UPDATER_FOLDER, "Sc2gearsUpdater.jar").getAbsoluteFile();
            int n = 0;
            while (n < 20) {
                if (!file2.exists() || file2.delete()) {
                    if (file.renameTo(file2)) {
                        ReplayCache.emptyCache();
                        System.out.println("Post-update completed.");
                        return true;
                    }
                    System.err.println("Could not rename file: " + file.getAbsolutePath());
                    System.err.println("\tto: " + file2.getAbsolutePath());
                    System.err.println("Post-update could not be performed!");
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                ++n;
            }
            System.err.println("Could not delete file: " + file2.getAbsolutePath());
            System.err.println("Post-update could not be performed!");
            return false;
        }
        return true;
    }

    private static void installExtraLAFs() {
        UIManager.installLookAndFeel("EaSynthLookAndFeel", "com.easynth.lookandfeel.EaSynthLookAndFeel");
        UIManager.installLookAndFeel("Office 2003", "org.fife.plaf.Office2003.Office2003LookAndFeel");
        UIManager.installLookAndFeel("Office XP", "org.fife.plaf.OfficeXP.OfficeXPLookAndFeel");
        UIManager.installLookAndFeel("Visual Studio 2005", "org.fife.plaf.VisualStudio2005.VisualStudio2005LookAndFeel");
    }
}

