/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalReplayFilter;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.searchfieldimpl.IntervalSearchField;
import java.io.File;
import java.util.Date;

public class DateSearchField
extends IntervalSearchField {
    private static final long MS_IN_A_DAY = 86400000L;

    public DateSearchField() {
        super("module.repSearch.tab.filters.name.date");
        Date date = new Date();
        String string = Language.getText("module.repSearch.tab.filters.name.dateToolTip", Language.formatDate(date), Language.formatDateTime(date));
        this.minTextField.setToolTipText(string);
        this.maxTextField.setToolTipText(string);
    }

    @Override
    public boolean customValidateMin() {
        String string = this.minTextField.getText();
        if (string.length() == 0) {
            return true;
        }
        Date date = DateSearchField.parseDate(string);
        return date != null;
    }

    @Override
    public boolean customValidateMax() {
        String string = this.maxTextField.getText();
        if (string.length() == 0) {
            return true;
        }
        Date date = DateSearchField.parseDate(string);
        return date != null;
    }

    @Override
    public ReplayFilter getFilter() {
        return this.minTextField.getText().length() == 0 && this.maxTextField.getText().length() == 0 ? null : new IntervalReplayFilter(this){
            private final long minDate;
            private final long maxDate;
            {
                this.minDate = this.minText.length() > 0 ? DateSearchField.parseDate(this.minText).getTime() : 0L;
                this.maxDate = this.maxText.length() > 0 ? DateSearchField.parseDate(this.maxText).getTime() + 86400000L : 0L;
            }

            @Override
            public boolean accept(File file, Replay replay) {
                if (this.minText.length() > 0 && replay.details.saveTime < this.minDate) {
                    return false;
                }
                return this.maxText.length() <= 0 || replay.details.saveTime <= this.maxDate;
            }
        };
    }

    private static Date parseDate(String string) {
        Date date = Language.parseDateTime(string, true);
        if (date == null) {
            date = Language.parseDate(string);
        }
        return date;
    }
}

