/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.ui.BaseLabelListCellRenderer;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WelcomeFrame
extends JFrame {
    private final JLabel welcomeLabel = new JLabel();
    private final JLabel firstRunLabel = new JLabel();
    private final JLabel chooseLabel = new JLabel();
    private final JLabel thankYouLabel = new JLabel();
    private final JLabel languageLabel = new JLabel();
    private final JLabel voiceLabel = new JLabel();
    private final JButton okButton = new JButton();
    private final JButton cancelButton = new JButton();

    public WelcomeFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WelcomeFrame.this.cancel();
            }
        });
        this.setIconImage(Icons.SC2GEARS.getImage());
        Box box = Box.createVerticalBox();
        GuiUtils.changeFontToBold(this.welcomeLabel);
        box.add(Box.createVerticalStrut(15));
        box.add(GuiUtils.wrapInPanel(this.welcomeLabel));
        box.add(Box.createVerticalStrut(15));
        box.add(GuiUtils.wrapInPanel(this.firstRunLabel));
        box.add(GuiUtils.wrapInPanel(this.chooseLabel));
        box.add(Box.createVerticalStrut(15));
        box.add(GuiUtils.wrapInPanel(this.thankYouLabel));
        box.add(Box.createVerticalStrut(15));
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 1));
        jPanel.add(this.languageLabel);
        final JComboBox<String> jComboBox = new JComboBox<String>(Language.getAvailableLanguages());
        jComboBox.setMaximumRowCount(jComboBox.getModel().getSize());
        jComboBox.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object object) {
                return Icons.getLanguageIcon(object.toString());
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox.getSelectedItem();
                Language.loadLanguage(string);
                WelcomeFrame.this.reassignTexts();
            }
        });
        jPanel.add(jComboBox);
        box.add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 1));
        jPanel2.add(this.voiceLabel);
        final JComboBox<Sounds.VoiceDescription> jComboBox2 = new JComboBox<Sounds.VoiceDescription>(Sounds.VOICE_DESCRIPTIONS);
        jComboBox2.setMaximumRowCount(15);
        jComboBox2.setRenderer(new BaseLabelListCellRenderer(){

            @Override
            public Icon getIcon(Object object) {
                return Icons.getLanguageIcon(((Sounds.VoiceDescription)object).language);
            }
        });
        jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Sounds.VoiceDescription voiceDescription = (Sounds.VoiceDescription)jComboBox2.getSelectedItem();
                Settings.set("settings.voice", voiceDescription.name);
                Sounds.playSoundSample("welcome", false);
            }
        });
        jPanel2.add(jComboBox2);
        box.add(jPanel2);
        int n = Math.max(jComboBox.getPreferredSize().width, jComboBox2.getPreferredSize().width);
        jComboBox.setPreferredSize(new Dimension(n += 5, jComboBox.getPreferredSize().height));
        jComboBox2.setPreferredSize(new Dimension(n, jComboBox2.getPreferredSize().height));
        box.add(Box.createVerticalStrut(15));
        JPanel jPanel3 = new JPanel();
        this.okButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeFrame.this.dispose();
                Settings.set("settings.language", (String)jComboBox.getSelectedItem());
                Settings.saveProperties();
                WelcomeFrame welcomeFrame = WelcomeFrame.this;
                synchronized (welcomeFrame) {
                    Sounds.playSoundSample("thank_you", false);
                    WelcomeFrame.this.notify();
                }
            }
        });
        jPanel3.add(this.okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeFrame.this.cancel();
            }
        });
        jPanel3.add(this.cancelButton);
        box.add(jPanel3);
        box.add(Box.createVerticalStrut(15));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(Box.createHorizontalStrut(15));
        jPanel4.add(box);
        jPanel4.add(Box.createHorizontalStrut(15));
        this.getContentPane().add(jPanel4);
        this.setResizable(false);
        this.reassignTexts();
        this.setVisible(true);
        this.okButton.requestFocusInWindow();
        Sounds.playSoundSample("welcome", false);
    }

    private void reassignTexts() {
        this.setTitle(Language.getText("welcome.welcome"));
        this.welcomeLabel.setText(String.valueOf(Language.getText("welcome.welcome")) + '!');
        this.firstRunLabel.setText(Language.getText("welcome.firstRun", "Sc2gears"));
        this.chooseLabel.setText(Language.getText("welcome.selectLanguage"));
        this.thankYouLabel.setText(Language.getText("welcome.thankYou", "Sc2gears"));
        this.languageLabel.setText(Language.getText("welcome.language"));
        this.voiceLabel.setText(Language.getText("welcome.voice"));
        this.languageLabel.setPreferredSize(null);
        this.voiceLabel.setPreferredSize(null);
        int n = Math.max(this.languageLabel.getPreferredSize().width, this.voiceLabel.getPreferredSize().width);
        this.languageLabel.setPreferredSize(new Dimension(n, this.languageLabel.getPreferredSize().height));
        this.voiceLabel.setPreferredSize(new Dimension(n, this.voiceLabel.getPreferredSize().height));
        GuiUtils.updateButtonText(this.okButton, "button.ok", new Object[0]);
        GuiUtils.updateButtonText(this.cancelButton, "button.cancel", new Object[0]);
        this.pack();
        GuiUtils.centerWindow(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        this.dispose();
        Language.loadLanguage("English");
        Settings.remove("settings.voice");
        WelcomeFrame welcomeFrame = this;
        synchronized (welcomeFrame) {
            Sounds.playSoundSample("thank_you", false);
            this.notify();
        }
    }
}

