/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.ui;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.services.ApmAlert;
import hu.belicza.andras.sc2gears.services.ReplayAutoSaver;
import hu.belicza.andras.sc2gears.services.UpdateChecker;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.dialogs.AboutDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.GameTimeRealTimeConverterDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.RenameItemDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.SystemMessagesDialog;
import hu.belicza.andras.sc2gears.ui.icons.IconHandler;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.ui.moduls.ModuleFrame;
import hu.belicza.andras.sc2gears.ui.moduls.multirepanal.MultiRepAnalysis;
import hu.belicza.andras.sc2gears.ui.moduls.replayanal.ReplayAnalyzer;
import hu.belicza.andras.sc2gears.ui.moduls.replaysearch.ReplaySearch;
import hu.belicza.andras.sc2gears.ui.moduls.startpage.StartPage;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame {
    private static final int MAX_RECENT_REPLAYS = 15;
    public static MainFrame INSTANCE;
    private TrayIcon trayIcon;
    private final JSplitPane mainSplitPane = new JSplitPane(1, true);
    private final CheckboxMenuItem enableReplayAutoSaveTrayMenuItem = new CheckboxMenuItem(Language.getText("tray.enableReplayAutoSave"), Settings.getBoolean("settings.enableReplayAutoSave"));
    private final CheckboxMenuItem enableApmAlertTrayMenuItem = new CheckboxMenuItem(Language.getText("tray.enableApmAlert"), Settings.getBoolean("settings.enableApmAlert"));
    private final JMenuItem openLastReplayMenuItem = new JMenuItem(Icons.SC2);
    private final JMenu recentReplaysMenu = new JMenu();
    private final JCheckBoxMenuItem enableReplayAutoSaveMenuItem = GuiUtils.createCheckBoxMenuItem("menu.settings.enableReplayAutoSave", "settings.enableReplayAutoSave", Icons.DATABASE_SAVE);
    private final JCheckBoxMenuItem enableApmAlertMenuItem = GuiUtils.createCheckBoxMenuItem("menu.settings.enableApmAlert", "settings.enableApmAlert", Icons.ALARM_CLOCK);
    private final JMenuItem minimizeToTrayMenuItem = new JMenuItem(Icons.APPLICATION_DOCK_TAB);
    private final JMenuItem startMinimizedToTrayMenuItem = GuiUtils.createCheckBoxMenuItem("menu.window.startMinimimizedToTray", "window.startMinimizedToTray", Icons.APPLICATION_DOCK_TAB);
    public final JMenuItem viewSystemMessagesMenuItem = new JMenuItem(Icons.REPORT_EXCLAMATION);
    private final JMenuItem checkUpdatesMenuItem = new JMenuItem(Icons.ARROW_CIRCLE_DOUBLE);
    private final JScrollPane navigationBar = new JScrollPane();
    private final JTree navigationTree = new JTree();
    private final DefaultMutableTreeNode repAnalNode = new DefaultMutableTreeNode(Language.getText("module.repAnalyzer.name"));
    private final DefaultMutableTreeNode newRepAnalNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode multiRepAnalNode = new DefaultMutableTreeNode(Language.getText("module.multiRepAnal.name"));
    private final DefaultMutableTreeNode newMultiRepAnalNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode repSearchNode = new DefaultMutableTreeNode(Language.getText("module.repSearch.name"));
    private final DefaultMutableTreeNode newRepSearchNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.new") + '>');
    private final DefaultMutableTreeNode repSourcesNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repSources.name"));
    public final DefaultMutableTreeNode sc2AutoRepsRepSourceNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repSources.sc2AutoReps.name"));
    public final DefaultMutableTreeNode autoSavedRepsRepSourceNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repSources.autoSavedReps.name"));
    public final DefaultMutableTreeNode emptyRepSourceNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.empty") + '>');
    private final DefaultMutableTreeNode repListsNode = new DefaultMutableTreeNode(Language.getText("navigationTree.repLists.name"));
    public final DefaultMutableTreeNode emptyRepListNode = new DefaultMutableTreeNode(String.valueOf('<') + Language.getText("navigationTree.empty") + '>');
    private final JDesktopPane desktopPane = new JDesktopPane();
    private MenuItem hideTrayMenuItem;
    private MenuItem restoreTrayMenuItem;
    private boolean windowSizeInitialized;
    private StartPage startPage;

    public MainFrame(String[] stringArray) {
        super("Sc2gears 3.00");
        if (INSTANCE != null) {
            throw new RuntimeException("Only one instance of MainFrame is allowed!");
        }
        INSTANCE = this;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (Settings.getBoolean("window.minimizeToTrayOnClose")) {
                    MainFrame.this.minimizeToTrayMenuItem.doClick();
                } else {
                    MainFrame.exit(false, new String[0]);
                }
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                if (Settings.getBoolean("window.minimizeToTrayOnMinimize")) {
                    MainFrame.this.minimizeToTrayMenuItem.doClick();
                }
            }
        });
        this.setIconImage(Icons.SC2GEARS.getImage());
        this.installTrayIcon();
        this.buildGUI();
        GeneralUtils.setToolTipDelays();
        if (stringArray.length == 0 && this.trayIcon != null && this.startMinimizedToTrayMenuItem.isSelected()) {
            this.hideMainFrame();
            this.trayIcon.displayMessage(null, Language.getText("trayIcon.startedMinimized", "Sc2gears"), TrayIcon.MessageType.INFO);
        } else {
            this.restoreMainFrame();
        }
        if (Settings.getBoolean("settings.checkUpdatesOnStartup")) {
            this.checkUpdatesMenuItem.doClick();
        }
        this.rebuildRecentReplaysMenu();
        if (Settings.getBoolean("settings.showStartPageOnStartup")) {
            this.showStartPage(false);
        }
        if (stringArray.length > 0) {
            this.openArguments(stringArray);
        } else {
            Enum enum_;
            Enum[] enumArray = ReplayConsts.Building.values();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                enum_ = enumArray[n2];
                Icons.getBuildingIcon((ReplayConsts.Building)enum_, IconHandler.Size.BIG);
                ++n2;
            }
            enumArray = ReplayConsts.Unit.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                enum_ = enumArray[n2];
                Icons.getUnitIcon((ReplayConsts.Unit)enum_, IconHandler.Size.BIG);
                ++n2;
            }
            enumArray = ReplayConsts.AbilityGroup.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                enum_ = enumArray[n2];
                Icons.getAbilityGroupIcon((ReplayConsts.AbilityGroup)enum_, IconHandler.Size.BIG);
                ++n2;
            }
        }
        this.startPage.refresh();
    }

    private void showStartPage(boolean bl) {
        if (this.startPage == null) {
            this.startPage = new StartPage();
            this.addNewInternalFrame(this.startPage);
            this.startPage.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    MainFrame.this.startPage = null;
                }
            });
            if (bl) {
                this.startPage.refresh();
            }
        } else {
            this.selectFrame(this.startPage);
        }
    }

    public void openArguments(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    File file = new File(string);
                    if (GuiUtils.SC2_REPLAY_LIST_FILE_FILTER.accept(file)) {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                    } else if (GuiUtils.SC2_REPLAY_SOURCE_FILE_FILTER.accept(file)) {
                        MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                    } else {
                        MainFrame.this.openReplayFile(new File(string));
                    }
                    ++n2;
                }
            }
        });
    }

    private void installTrayIcon() {
        if (SystemTray.isSupported()) {
            TrayIcon trayIcon = new TrayIcon(Icons.SC2GEARS.getImage(), Language.getText("trayIcon.running", "Sc2gears"));
            trayIcon.setImageAutoSize(true);
            PopupMenu popupMenu = new PopupMenu();
            this.hideTrayMenuItem = new MenuItem(Language.getText("tray.hide"));
            this.hideTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.hideMainFrame();
                }
            });
            popupMenu.add(this.hideTrayMenuItem);
            this.restoreTrayMenuItem = new MenuItem(Language.getText("tray.restore"));
            this.restoreTrayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.restoreMainFrame();
                }
            });
            popupMenu.add(this.restoreTrayMenuItem);
            popupMenu.addSeparator();
            this.enableReplayAutoSaveTrayMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    MainFrame.this.enableReplayAutoSaveMenuItem.doClick();
                }
            });
            popupMenu.add(this.enableReplayAutoSaveTrayMenuItem);
            if (ApmAlert.supported) {
                this.enableApmAlertTrayMenuItem.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        MainFrame.this.enableApmAlertMenuItem.doClick();
                    }
                });
            } else {
                this.enableApmAlertTrayMenuItem.setEnabled(false);
            }
            popupMenu.add(this.enableApmAlertTrayMenuItem);
            popupMenu.addSeparator();
            MenuItem menuItem = new MenuItem(Language.getText("tray.openLastReplay"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.restoreMainFrame();
                    MainFrame.this.openLastReplayMenuItem.doClick();
                }
            });
            popupMenu.add(menuItem);
            popupMenu.addSeparator();
            MenuItem menuItem2 = new MenuItem(Language.getText("tray.exit"));
            menuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.exit(false, new String[0]);
                }
            });
            popupMenu.add(menuItem2);
            trayIcon.setPopupMenu(popupMenu);
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.restoreMainFrame();
                }
            });
            try {
                SystemTray.getSystemTray().add(trayIcon);
                this.trayIcon = trayIcon;
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    private void buildGUI() {
        this.buildNavigationBar();
        this.mainSplitPane.setDividerSize(6);
        this.getContentPane().add(this.mainSplitPane);
        this.arrangeContent();
        this.buildMenuBar();
    }

    private void buildNavigationBar() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.repAnalNode.add(this.newRepAnalNode);
        defaultMutableTreeNode.add(this.repAnalNode);
        this.multiRepAnalNode.add(this.newMultiRepAnalNode);
        defaultMutableTreeNode.add(this.multiRepAnalNode);
        this.repSearchNode.add(this.newRepSearchNode);
        defaultMutableTreeNode.add(this.repSearchNode);
        defaultMutableTreeNode.add(this.repSourcesNode);
        defaultMutableTreeNode.add(this.repListsNode);
        this.refreshNavigationTree();
        ((DefaultTreeModel)this.navigationTree.getModel()).setRoot(defaultMutableTreeNode);
        this.navigationTree.setRootVisible(false);
        this.navigationTree.setShowsRootHandles(true);
        this.navigationTree.getSelectionModel().setSelectionMode(1);
        this.navigationTree.setCellRenderer(this.createTreeCellRenderer());
        if (Settings.getBoolean("navigation.useSmallFont")) {
            this.navigationTree.setFont(new Font(this.navigationTree.getFont().getName(), 0, 10));
        }
        this.expandAllNavigationRow();
        this.navigationTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 || mouseEvent.getClickCount() == 2) {
                    TreePath treePath = MainFrame.this.navigationTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    final DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode || defaultMutableTreeNode2 == MainFrame.this.repListsNode) {
                        if (defaultMutableTreeNode == MainFrame.this.emptyRepSourceNode) {
                            GuiUtils.showInfoDialog(Language.getText("navigationTree.info.newRepSource"));
                        } else if (defaultMutableTreeNode == MainFrame.this.emptyRepListNode) {
                            GuiUtils.showInfoDialog(Language.getText("navigationTree.info.newRepList"));
                        } else {
                            File file;
                            File[] fileArray;
                            if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode) {
                                    fileArray = GeneralUtils.getAutoRepFolderList().toArray(new File[0]);
                                    file = null;
                                } else if (defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                                    file = new File(Settings.getString("settings.folders.replayAutoSave"));
                                    fileArray = null;
                                } else {
                                    file = new File("User Content/Replay sources", String.valueOf(defaultMutableTreeNode.getUserObject().toString()) + ".sc2repsrc");
                                    fileArray = null;
                                }
                            } else {
                                file = new File("User Content/Replay lists", String.valueOf(defaultMutableTreeNode.getUserObject().toString()) + ".csv");
                                fileArray = null;
                            }
                            if (mouseEvent.getButton() == 3) {
                                MainFrame.this.navigationTree.setSelectionPath(treePath);
                                JPopupMenu jPopupMenu = new JPopupMenu();
                                JMenuItem jMenuItem = new JMenuItem(Icons.CHART_UP_COLOR);
                                GuiUtils.updateButtonText(jMenuItem, "navigationTree.popup.openInMultiRepAnalysis", new Object[0]);
                                jMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == (this).MainFrame.this.autoSavedRepsRepSourceNode) {
                                            File[] fileArray3;
                                            MainFrame mainFrame = MainFrame.this;
                                            DefaultMutableTreeNode defaultMutableTreeNode3 = MainFrame.this.newMultiRepAnalNode;
                                            Object[] objectArray = new Object[3];
                                            objectArray[0] = null;
                                            objectArray[1] = null;
                                            if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode) {
                                                fileArray3 = fileArray;
                                            } else {
                                                File[] fileArray2 = new File[1];
                                                fileArray3 = fileArray2;
                                                fileArray2[0] = file;
                                            }
                                            objectArray[2] = fileArray3;
                                            mainFrame.createNewInternalFrame(defaultMutableTreeNode3, objectArray);
                                        } else if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                            MainFrame.this.createNewInternalFrame(MainFrame.this.newMultiRepAnalNode, new Object[]{file, null, null});
                                        } else {
                                            MainFrame.this.createNewInternalFrame(MainFrame.this.newMultiRepAnalNode, new Object[]{null, file, null});
                                        }
                                    }
                                });
                                jPopupMenu.add(jMenuItem);
                                JMenuItem jMenuItem2 = new JMenuItem(Icons.BINOCULAR_ARROW);
                                GuiUtils.updateButtonText(jMenuItem2, "navigationTree.popup.listAllReplays", new Object[0]);
                                jMenuItem2.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                            if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == (this).MainFrame.this.autoSavedRepsRepSourceNode) {
                                                File[] fileArray3;
                                                MainFrame mainFrame = MainFrame.this;
                                                DefaultMutableTreeNode defaultMutableTreeNode3 = MainFrame.this.newRepSearchNode;
                                                Object[] objectArray = new Object[3];
                                                objectArray[0] = null;
                                                objectArray[1] = null;
                                                if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode) {
                                                    fileArray3 = fileArray;
                                                } else {
                                                    File[] fileArray2 = new File[1];
                                                    fileArray3 = fileArray2;
                                                    fileArray2[0] = file;
                                                }
                                                objectArray[2] = fileArray3;
                                                mainFrame.createNewInternalFrame(defaultMutableTreeNode3, objectArray);
                                            } else {
                                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                                            }
                                        } else {
                                            MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                                        }
                                    }
                                });
                                jPopupMenu.add(jMenuItem2);
                                JMenuItem jMenuItem3 = new JMenuItem(Icons.EDIT_COLUMN);
                                GuiUtils.updateButtonText(jMenuItem3, "navigationTree.popup.openInRepSearchForFiltering", new Object[0]);
                                jMenuItem3.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                            if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == (this).MainFrame.this.autoSavedRepsRepSourceNode) {
                                                File[] fileArray3;
                                                MainFrame mainFrame = MainFrame.this;
                                                DefaultMutableTreeNode defaultMutableTreeNode3 = MainFrame.this.newRepSearchNode;
                                                Object[] objectArray = new Object[4];
                                                objectArray[0] = null;
                                                objectArray[1] = null;
                                                if (defaultMutableTreeNode == (this).MainFrame.this.sc2AutoRepsRepSourceNode) {
                                                    fileArray3 = fileArray;
                                                } else {
                                                    File[] fileArray2 = new File[1];
                                                    fileArray3 = fileArray2;
                                                    fileArray2[0] = file;
                                                }
                                                objectArray[2] = fileArray3;
                                                objectArray[3] = Boolean.FALSE;
                                                mainFrame.createNewInternalFrame(defaultMutableTreeNode3, objectArray);
                                            } else {
                                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null, null, Boolean.FALSE});
                                            }
                                        } else {
                                            MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file, null, Boolean.FALSE});
                                        }
                                    }
                                });
                                jPopupMenu.add(jMenuItem3);
                                jPopupMenu.addSeparator();
                                JMenuItem jMenuItem4 = new JMenuItem(Icons.DOCUMENT_RENAME);
                                if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                                    jMenuItem4.setEnabled(false);
                                }
                                GuiUtils.updateButtonText(jMenuItem4, "navigationTree.popup.renameItem", new Object[0]);
                                jMenuItem4.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        new RenameItemDialog(defaultMutableTreeNode, file);
                                    }
                                });
                                jPopupMenu.add(jMenuItem4);
                                JMenuItem jMenuItem5 = new JMenuItem(Icons.CROSS);
                                if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                                    jMenuItem5.setEnabled(false);
                                }
                                GuiUtils.updateButtonText(jMenuItem5, "navigationTree.popup.deleteItem", new Object[0]);
                                jMenuItem5.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (GuiUtils.showConfirmDialog(Language.getText("navigationTree.popup.areYouSureToDelete", GeneralUtils.getFileNameWithoutExt(file)), true) == 0 && file.delete()) {
                                            MainFrame.this.refreshNavigationTree();
                                        }
                                    }
                                });
                                jPopupMenu.add(jMenuItem5);
                                jPopupMenu.show(MainFrame.this.navigationTree, mouseEvent.getX(), mouseEvent.getY());
                            } else if (defaultMutableTreeNode2 == MainFrame.this.repSourcesNode) {
                                if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                                    File[] fileArray2;
                                    DefaultMutableTreeNode defaultMutableTreeNode3 = MainFrame.this.newRepSearchNode;
                                    Object[] objectArray = new Object[3];
                                    objectArray[0] = null;
                                    objectArray[1] = null;
                                    if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode) {
                                        fileArray2 = fileArray;
                                    } else {
                                        File[] fileArray3 = new File[1];
                                        fileArray2 = fileArray3;
                                        fileArray3[0] = file;
                                    }
                                    objectArray[2] = fileArray2;
                                    MainFrame.this.createNewInternalFrame(defaultMutableTreeNode3, objectArray);
                                } else {
                                    MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{file, null});
                                }
                            } else {
                                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepSearchNode, new Object[]{null, file});
                            }
                        }
                    } else if (mouseEvent.getClickCount() == 2) {
                        MainFrame.this.createNewInternalFrame(defaultMutableTreeNode, new Object[0]);
                    }
                }
            }
        });
        this.navigationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                if (defaultMutableTreeNode.getUserObject() instanceof JInternalFrame) {
                    MainFrame.this.selectFrame((JInternalFrame)defaultMutableTreeNode.getUserObject());
                }
            }
        });
        this.navigationBar.setViewportView(this.navigationTree);
        this.navigationBar.setVisible(Settings.getBoolean("navigation.showNavbar"));
    }

    private void selectFrame(JInternalFrame jInternalFrame) {
        try {
            if (jInternalFrame.isIcon()) {
                jInternalFrame.setIcon(false);
            }
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    private TreeCellRenderer createTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode != MainFrame.this.newRepAnalNode && defaultMutableTreeNode != MainFrame.this.newMultiRepAnalNode && defaultMutableTreeNode != MainFrame.this.newRepSearchNode && defaultMutableTreeNode != MainFrame.this.emptyRepSourceNode && defaultMutableTreeNode != MainFrame.this.emptyRepListNode) {
                    if (defaultMutableTreeNode == MainFrame.this.sc2AutoRepsRepSourceNode || defaultMutableTreeNode == MainFrame.this.autoSavedRepsRepSourceNode) {
                        this.setIcon(Icons.FOLDER_BOOKMARK);
                    } else {
                        TreeNode treeNode = defaultMutableTreeNode.getParent();
                        if (treeNode == MainFrame.this.repAnalNode) {
                            this.setIcon(Icons.CHART);
                        } else if (treeNode == MainFrame.this.multiRepAnalNode) {
                            this.setIcon(Icons.CHART_UP_COLOR);
                        } else if (treeNode == MainFrame.this.repSearchNode) {
                            this.setIcon(Icons.BINOCULAR);
                        } else if (treeNode == MainFrame.this.repSourcesNode) {
                            this.setIcon(Icons.FOLDERS_STACK);
                        } else if (treeNode == MainFrame.this.repListsNode) {
                            this.setIcon(Icons.TABLE);
                        }
                    }
                }
                return this;
            }
        };
    }

    private void expandAllNavigationRow() {
        int n = 0;
        while (n < this.navigationTree.getRowCount()) {
            this.navigationTree.expandRow(n);
            ++n;
        }
    }

    public void refreshNavigationTree() {
        int n = 0;
        while (n < 2) {
            String string;
            String string2;
            String[] stringArray;
            DefaultMutableTreeNode defaultMutableTreeNode = n == 0 ? this.repSourcesNode : this.repListsNode;
            defaultMutableTreeNode.removeAllChildren();
            if (defaultMutableTreeNode == this.repSourcesNode) {
                defaultMutableTreeNode.add(this.sc2AutoRepsRepSourceNode);
                defaultMutableTreeNode.add(this.autoSavedRepsRepSourceNode);
            }
            if ((stringArray = new File(string2 = n == 0 ? "User Content/Replay sources" : "User Content/Replay lists").list(new FilenameFilter(string = n == 0 ? ".sc2repsrc" : ".csv"){
                private final /* synthetic */ String val$extension;
                {
                    this.val$extension = string;
                }

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(this.val$extension);
                }
            })) == null || stringArray.length == 0) {
                defaultMutableTreeNode.add(defaultMutableTreeNode == this.repSourcesNode ? this.emptyRepSourceNode : this.emptyRepListNode);
            } else {
                Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = stringArray2[n3];
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(string3.substring(0, string3.lastIndexOf(46))));
                    ++n3;
                }
            }
            ((DefaultTreeModel)this.navigationTree.getModel()).reload(defaultMutableTreeNode);
            ++n;
        }
    }

    public void refreshRepAnalNavigationNode() {
        ((DefaultTreeModel)this.navigationTree.getModel()).reload(this.repAnalNode);
    }

    private void buildMenuBar() {
        Object object;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        GuiUtils.updateButtonText(jMenu, "menu.file", new Object[0]);
        JMenuItem jMenuItem = new JMenuItem(Icons.SC2);
        GuiUtils.updateButtonText(jMenuItem, "menu.file.openReplay", new Object[0]);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepAnalNode, new Object[0]);
            }
        });
        jMenu.add(jMenuItem);
        GuiUtils.updateButtonText(this.openLastReplayMenuItem, "menu.file.openLastReplay", new Object[0]);
        this.openLastReplayMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        this.openLastReplayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<File> list = GeneralUtils.getAutoRepFolderList();
                File file = null;
                boolean bl = false;
                for (File file2 : list) {
                    if (!file2.exists()) continue;
                    bl = true;
                    file = GeneralUtils.getLastReplay(file2, file);
                }
                if (file == null) {
                    GuiUtils.showErrorDialog(new Object[]{Language.getText(bl ? "misc.autorepFolderEmpty" : "misc.autorepFolderNotExists"), list.get(0).getAbsolutePath(), " ", MiscSettingsDialog.createLinkLabelToSettings("miscSettings.tab.folders")});
                    return;
                }
                MainFrame.this.createNewInternalFrame(MainFrame.this.newRepAnalNode, new Object[]{file});
            }
        });
        jMenu.add(this.openLastReplayMenuItem);
        jMenu.addSeparator();
        GuiUtils.updateButtonText(this.recentReplaysMenu, "menu.file.recentReplays", new Object[0]);
        jMenu.add(this.recentReplaysMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(Icons.DOOR_OPEN_IN);
        GuiUtils.updateButtonText(jMenuItem2, "menu.file.exit", new Object[0]);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.exit(false, new String[0]);
            }
        });
        jMenu.add(jMenuItem2);
        jMenuBar.add(jMenu);
        jMenuItem = new JMenu();
        GuiUtils.updateButtonText(jMenuItem, "menu.navigation", new Object[0]);
        jMenuItem2 = new JMenuItem(Icons.TOGGLE_EXPAND);
        GuiUtils.updateButtonText(jMenuItem2, "menu.navigation.expandAll", new Object[0]);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.expandAllNavigationRow();
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(Icons.TOGGLE);
        GuiUtils.updateButtonText(jMenuItem3, "menu.navigation.collapseAll", new Object[0]);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < MainFrame.this.navigationTree.getRowCount()) {
                    MainFrame.this.navigationTree.collapseRow(n);
                    ++n;
                }
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem3);
        Serializable serializable = new JMenuItem(Icons.ARROW_CIRCLE_315);
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.navigation.refreshTree", new Object[0]);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.refreshNavigationTree();
            }
        });
        ((JMenu)jMenuItem).add((JMenuItem)serializable);
        ((JMenu)jMenuItem).addSeparator();
        Object object2 = GuiUtils.createCheckBoxMenuItem("menu.navigation.useSmallFont", "navigation.useSmallFont", Icons.APPLICATION_SIDEBAR_LIST);
        JMenu jMenu2 = new JMenu();
        final JCheckBoxMenuItem jCheckBoxMenuItem = GuiUtils.createCheckBoxMenuItem("menu.navigation.showNavbar", "navigation.showNavbar", Icons.APPLICATION_SIDEBAR);
        jCheckBoxMenuItem.addActionListener(new ActionListener((JCheckBoxMenuItem)object2, jMenu2){
            private int storedLeftComponentWidth = 170;
            private final /* synthetic */ JCheckBoxMenuItem val$useSmallFontMenuItem;
            private final /* synthetic */ JMenu val$navigationBarPositionMenu;
            {
                this.val$useSmallFontMenuItem = jCheckBoxMenuItem2;
                this.val$navigationBarPositionMenu = jMenu;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem.isSelected()) {
                    this.storedLeftComponentWidth = MainFrame.this.mainSplitPane.getLeftComponent().getWidth();
                }
                MainFrame.this.navigationBar.setVisible(jCheckBoxMenuItem.isSelected());
                this.val$useSmallFontMenuItem.setEnabled(jCheckBoxMenuItem.isSelected());
                this.val$navigationBarPositionMenu.setEnabled(jCheckBoxMenuItem.isSelected());
                if (jCheckBoxMenuItem.isSelected()) {
                    MainFrame.this.mainSplitPane.setDividerLocation(this.storedLeftComponentWidth);
                }
                MainFrame.this.mainSplitPane.validate();
            }
        });
        ((JMenu)jMenuItem).add(jCheckBoxMenuItem);
        ((JMenuItem)object2).setEnabled(Settings.getBoolean("navigation.showNavbar"));
        ((AbstractButton)object2).addActionListener(new ActionListener((JCheckBoxMenuItem)object2){
            private final /* synthetic */ JCheckBoxMenuItem val$useSmallFontMenuItem;
            {
                this.val$useSmallFontMenuItem = jCheckBoxMenuItem;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.navigationTree.setFont(new Font(MainFrame.this.navigationTree.getFont().getName(), 0, this.val$useSmallFontMenuItem.isSelected() ? 10 : 12));
            }
        });
        ((JMenu)jMenuItem).add((JMenuItem)object2);
        jMenu2.setEnabled(Settings.getBoolean("navigation.showNavbar"));
        GuiUtils.updateButtonText(jMenu2, "menu.navigation.navbarPosition", new Object[0]);
        Object[] objectArray = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem(Icons.APPLICATION_DOCK_180), new JRadioButtonMenuItem(Icons.APPLICATION_DOCK)};
        GuiUtils.updateButtonText(objectArray[0], "menu.navigation.navbarPosition.left", new Object[0]);
        GuiUtils.updateButtonText(objectArray[1], "menu.navigation.navbarPosition.right", new Object[0]);
        objectArray[Settings.getInt("navigation.position")].setSelected(true);
        String[] stringArray = new ButtonGroup();
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            stringArray.add((AbstractButton)object);
            final int n2 = n++;
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Settings.set("navigation.position", n2);
                    MainFrame.this.arrangeContent();
                }
            });
            jMenu2.add((JMenuItem)object);
        }
        ((JMenu)jMenuItem).add(jMenu2);
        jMenuBar.add((JMenu)jMenuItem);
        jMenuItem2 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem2, "menu.settings", new Object[0]);
        jMenuItem3 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem3, "menu.settings.laf", new Object[0]);
        jMenuItem3.setIcon(Icons.UI_FLOW);
        serializable = new ButtonGroup();
        objectArray = GuiUtils.getSortedInstalledLAFInfos();
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object2 = objectArray[n4];
            stringArray = new JRadioButtonMenuItem(((UIManager.LookAndFeelInfo)object2).getName(), ((UIManager.LookAndFeelInfo)object2).getName().equals(UIManager.getLookAndFeel().getName()));
            ((ButtonGroup)serializable).add((AbstractButton)stringArray);
            stringArray.addActionListener(new ActionListener((UIManager.LookAndFeelInfo)object2){
                private final /* synthetic */ UIManager.LookAndFeelInfo val$lookAndFeelInfo;
                {
                    this.val$lookAndFeelInfo = lookAndFeelInfo;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Settings.getBoolean("settings.enableVoiceNotifications") && !Settings.getString("settings.laf").equals(this.val$lookAndFeelInfo.getName())) {
                        Sounds.playSoundSample("changing_theme", false);
                    }
                    if (GuiUtils.setLAF(this.val$lookAndFeelInfo.getName())) {
                        SwingUtilities.updateComponentTreeUI(MainFrame.this);
                        MainFrame.this.navigationTree.setCellRenderer(MainFrame.this.createTreeCellRenderer());
                        Settings.set("settings.laf", this.val$lookAndFeelInfo.getName());
                    }
                }
            });
            jMenuItem3.add((Component)stringArray);
            ++n4;
        }
        ((JMenu)jMenuItem2).add(jMenuItem3);
        serializable = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.settings.language", new Object[0]);
        ((AbstractButton)serializable).setIcon(Icons.LOCALE);
        object2 = new ButtonGroup();
        stringArray = Language.getAvailableLanguages();
        int n5 = stringArray.length;
        n3 = 0;
        while (n3 < n5) {
            final String string = stringArray[n3];
            n = string.equals(Settings.getString("settings.language")) ? 1 : 0;
            object = new JRadioButtonMenuItem(n != 0 ? String.valueOf('*') + string + '*' : string, Icons.getLanguageIcon(string), n != 0);
            ((ButtonGroup)object2).add((AbstractButton)object);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Settings.getBoolean("settings.enableVoiceNotifications") && !Settings.getString("settings.language").equals(string)) {
                        Sounds.playSoundSample("changing_language", false);
                    }
                    Settings.set("settings.language", string);
                }
            });
            ((JMenu)serializable).add((JMenuItem)object);
            ++n3;
        }
        ((JMenu)jMenuItem2).add((JMenuItem)serializable);
        object2 = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)object2, "menu.settings.voice", new Object[0]);
        ((AbstractButton)object2).setIcon(Icons.MICROPHONE);
        Object object3 = Settings.getString("settings.voice");
        Object object4 = new ButtonGroup();
        object = Sounds.VOICE_DESCRIPTIONS;
        n = Sounds.VOICE_DESCRIPTIONS.length;
        int n6 = 0;
        while (n6 < n) {
            final Sounds.VoiceDescription voiceDescription = object[n6];
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(voiceDescription.displayName, Icons.getLanguageIcon(voiceDescription.language), voiceDescription.name.equals(object3));
            ((ButtonGroup)object4).add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Settings.set("settings.voice", voiceDescription.name);
                    if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                        Sounds.playSoundSample("voice_name", false);
                    }
                }
            });
            ((Container)object2).add(jRadioButtonMenuItem);
            ++n6;
        }
        ((JMenu)jMenuItem2).add((JMenuItem)object2);
        ((JMenu)jMenuItem2).addSeparator();
        object3 = new JMenuItem(Icons.EQUALIZER);
        GuiUtils.updateButtonText((AbstractButton)object3, "menu.settings.miscellaneous", new Object[0]);
        ((JMenuItem)object3).setAccelerator(KeyStroke.getKeyStroke(80, 128));
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new MiscSettingsDialog(null);
            }
        });
        ((JMenu)jMenuItem2).add((JMenuItem)object3);
        ((JMenu)jMenuItem2).addSeparator();
        object4 = new ActionListener(){
            private ReplayAutoSaver replayAutoSaver;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.enableReplayAutoSaveMenuItem.isSelected()) {
                    this.replayAutoSaver = new ReplayAutoSaver();
                    this.replayAutoSaver.start();
                } else if (this.replayAutoSaver != null) {
                    this.replayAutoSaver.requestToCancel();
                }
                if (MainFrame.this.trayIcon != null) {
                    MainFrame.this.enableReplayAutoSaveTrayMenuItem.setState(MainFrame.this.enableReplayAutoSaveMenuItem.isSelected());
                }
            }
        };
        object4.actionPerformed(null);
        this.enableReplayAutoSaveMenuItem.addActionListener((ActionListener)object4);
        ((JMenu)jMenuItem2).add(this.enableReplayAutoSaveMenuItem);
        if (ApmAlert.supported) {
            ActionListener actionListener = new ActionListener(){
                private ApmAlert apmAlert;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.enableApmAlertMenuItem.isSelected()) {
                        this.apmAlert = new ApmAlert();
                        this.apmAlert.start();
                    } else if (this.apmAlert != null) {
                        this.apmAlert.requestToCancel();
                    }
                    if (MainFrame.this.trayIcon != null) {
                        MainFrame.this.enableApmAlertTrayMenuItem.setState(MainFrame.this.enableApmAlertMenuItem.isSelected());
                    }
                }
            };
            actionListener.actionPerformed(null);
            this.enableApmAlertMenuItem.addActionListener(actionListener);
        } else {
            this.enableApmAlertMenuItem.setEnabled(false);
        }
        ((JMenu)jMenuItem2).add(this.enableApmAlertMenuItem);
        final JMenuItem jMenuItem4 = GuiUtils.createCheckBoxMenuItem("menu.settings.enableVoiceNotifications", "settings.enableVoiceNotifications", Icons.SPEAKER_VOLUME);
        ((JMenu)jMenuItem2).add(jMenuItem4);
        final JMenuItem jMenuItem5 = GuiUtils.createCheckBoxMenuItem("menu.settings.allowOnlyOneInstance", "settings.allowOnlyOneInstance", Icons.APPLICATION_SHARE);
        ((JMenu)jMenuItem2).add(jMenuItem5);
        final JMenuItem jMenuItem6 = GuiUtils.createCheckBoxMenuItem("menu.settings.showStartPageOnStartup", "settings.showStartPageOnStartup", Icons.NEWSPAPER);
        ((JMenu)jMenuItem2).add(jMenuItem6);
        object = GuiUtils.createCheckBoxMenuItem("menu.settings.checkUpdatesOnStartup", "settings.checkUpdatesOnStartup", Icons.ARROW_CIRCLE_DOUBLE);
        ((JMenu)jMenuItem2).add((JMenuItem)object);
        ((JMenu)jMenuItem2).addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem(Icons.DISK);
        GuiUtils.updateButtonText(jMenuItem7, "menu.settings.saveNow", new Object[0]);
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.saveProperties();
            }
        });
        ((JMenu)jMenuItem2).add(jMenuItem7);
        Object object5 = GuiUtils.createCheckBoxMenuItem("menu.settings.saveOnExit", "settings.saveOnExit", Icons.DISK_ARROW);
        ((JMenu)jMenuItem2).add((JMenuItem)object5);
        jMenuBar.add((JMenu)jMenuItem2);
        jMenuItem3 = new JMenu();
        GuiUtils.updateButtonText(jMenuItem3, "menu.tools", new Object[0]);
        serializable = new JMenuItem(Icons.CALCULATOR);
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.tools.gameTimeRealTimeConverter", new Object[0]);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new GameTimeRealTimeConverterDialog();
            }
        });
        ((JMenu)jMenuItem3).add((JMenuItem)serializable);
        jMenuBar.add((JMenu)jMenuItem3);
        serializable = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)serializable, "menu.window", new Object[0]);
        object2 = new JCheckBoxMenuItem(Icons.APPLICATION_RESIZE_FULL);
        GuiUtils.updateButtonText((AbstractButton)object2, "menu.window.fullscreen", new Object[0]);
        ((JMenuItem)object2).setAccelerator(KeyStroke.getKeyStroke(122, 0));
        ((AbstractButton)object2).addActionListener(new ActionListener((JCheckBoxMenuItem)object2){
            private Rectangle storedBounds;
            private final /* synthetic */ JCheckBoxMenuItem val$fullscreenMenuItem;
            {
                this.val$fullscreenMenuItem = jCheckBoxMenuItem;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                    if (this.val$fullscreenMenuItem.isSelected()) {
                        this.storedBounds = MainFrame.this.getBounds();
                    }
                    MainFrame.this.dispose();
                    MainFrame.this.setUndecorated(this.val$fullscreenMenuItem.isSelected());
                    MainFrame.this.setExtendedState(this.val$fullscreenMenuItem.isSelected() ? 6 : 0);
                    if (!this.val$fullscreenMenuItem.isSelected()) {
                        MainFrame.this.setBounds(this.storedBounds);
                    }
                    MainFrame.this.setVisible(true);
                    this.val$fullscreenMenuItem.setIcon(this.val$fullscreenMenuItem.isSelected() ? Icons.APPLICATION_RESIZE_ACTUAL : Icons.APPLICATION_RESIZE_FULL);
                }
            }
        });
        ((JMenu)serializable).add((JMenuItem)object2);
        ((JMenu)serializable).addSeparator();
        GuiUtils.updateButtonText(this.minimizeToTrayMenuItem, "menu.window.mimimizeToTray", new Object[0]);
        this.minimizeToTrayMenuItem.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        this.minimizeToTrayMenuItem.setEnabled(this.trayIcon != null);
        this.minimizeToTrayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.trayIcon != null) {
                    MainFrame.this.hideMainFrame();
                }
            }
        });
        ((JMenu)serializable).add(this.minimizeToTrayMenuItem);
        ((JMenu)serializable).add(this.startMinimizedToTrayMenuItem);
        object3 = GuiUtils.createCheckBoxMenuItem("menu.window.minimizeToTrayOnMinimize", "window.minimizeToTrayOnMinimize", Icons.APPLICATION_DOCK_TAB);
        ((JMenu)serializable).add((JMenuItem)object3);
        object4 = GuiUtils.createCheckBoxMenuItem("menu.window.minimizeToTrayOnClose", "window.minimizeToTrayOnClose", Icons.APPLICATION_DOCK_TAB);
        ((JMenu)serializable).add((JMenuItem)object4);
        ((JMenu)serializable).addSeparator();
        jMenuItem4 = new JMenuItem(Icons.APPLICATION_SPLIT_TILE);
        jMenuItem5 = new JMenuItem(Icons.APPLICATIONS_STACK);
        jMenuItem6 = new JMenuItem(Icons.APPLICATION_SPLIT_TILE);
        object = new JMenuItem(Icons.APPLICATIONS_STACK);
        int n7 = 25;
        object5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                boolean bl = actionEvent.getSource() == jMenuItem4 || actionEvent.getSource() == jMenuItem6;
                boolean bl2 = actionEvent.getSource() == jMenuItem4 || actionEvent.getSource() == jMenuItem5;
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n4 = jInternalFrameArray.length;
                if (!bl2) {
                    JInternalFrame[] jInternalFrameArray2 = jInternalFrameArray;
                    n3 = jInternalFrameArray.length;
                    n2 = 0;
                    while (n2 < n3) {
                        JInternalFrame jInternalFrame = jInternalFrameArray2[n2];
                        if (jInternalFrame.isIcon()) {
                            --n4;
                        }
                        ++n2;
                    }
                }
                int n5 = 1;
                n2 = 1;
                if (bl) {
                    n3 = Settings.getBoolean("window.verticalTileStrategy") ? 1 : 0;
                    while (n5 * n2 < n4) {
                        if (n3 != 0) {
                            if (n5 == n2) {
                                ++n2;
                                continue;
                            }
                            ++n5;
                            continue;
                        }
                        if (n5 == n2) {
                            ++n5;
                            continue;
                        }
                        ++n2;
                    }
                }
                if (bl) {
                    n3 = MainFrame.this.desktopPane.getWidth() / n5;
                    n = (MainFrame.this.desktopPane.getHeight() - (bl2 ? 0 : 25)) / n2;
                } else {
                    n3 = MainFrame.this.desktopPane.getWidth() - n4 * 25;
                    n = MainFrame.this.desktopPane.getHeight() - n4 * 25;
                }
                int n6 = 0;
                while (n6 < jInternalFrameArray.length) {
                    try {
                        JInternalFrame jInternalFrame = jInternalFrameArray[n6];
                        if (bl2 && jInternalFrame.isIcon()) {
                            jInternalFrame.setIcon(false);
                        }
                        if (jInternalFrame.isMaximum()) {
                            jInternalFrame.setMaximum(false);
                        }
                        if (bl) {
                            jInternalFrame.setBounds(n6 % n5 * n3, n6 / n5 * n, n3, n);
                        } else {
                            jInternalFrame.setBounds(n6 * 25, n6 * 25, n3, n);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n6;
                }
            }
        };
        GuiUtils.updateButtonText(jMenuItem4, "menu.window.tileAllWindows", new Object[0]);
        jMenuItem4.addActionListener((ActionListener)object5);
        ((JMenu)serializable).add(jMenuItem4);
        GuiUtils.updateButtonText(jMenuItem5, "menu.window.cascadeAllWindows", new Object[0]);
        jMenuItem5.addActionListener((ActionListener)object5);
        ((JMenu)serializable).add(jMenuItem5);
        GuiUtils.updateButtonText(jMenuItem6, "menu.window.tileVisibleWindows", new Object[0]);
        jMenuItem6.addActionListener((ActionListener)object5);
        ((JMenu)serializable).add(jMenuItem6);
        GuiUtils.updateButtonText((AbstractButton)object, "menu.window.cascadeVisibleWindows", new Object[0]);
        ((AbstractButton)object).addActionListener((ActionListener)object5);
        ((JMenu)serializable).add((JMenuItem)object);
        JMenuItem jMenuItem8 = new JMenuItem(Icons.APPLICATION_DIALOG);
        GuiUtils.updateButtonText(jMenuItem8, "menu.window.minimizeAll", new Object[0]);
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                    try {
                        jInternalFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        ((JMenu)serializable).add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem(Icons.CROSS_BUTTON);
        GuiUtils.updateButtonText(jMenuItem9, "menu.window.closeAll", new Object[0]);
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JInternalFrame[] jInternalFrameArray = MainFrame.this.desktopPane.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        ((JMenu)serializable).add(jMenuItem9);
        ((JMenu)serializable).addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem2 = GuiUtils.createCheckBoxMenuItem("menu.window.useVerticalTileStrategy", "window.verticalTileStrategy", Icons.APPLICATION_TILE_VERTICAL);
        ((JMenu)serializable).add(jCheckBoxMenuItem2);
        jMenuBar.add((JMenu)serializable);
        object2 = new JMenu();
        GuiUtils.updateButtonText((AbstractButton)object2, "menu.help", new Object[0]);
        object3 = new JMenuItem(Icons.HOME_ARROW);
        GuiUtils.updateButtonText((AbstractButton)object3, "menu.help.visitHomePage", new Object[0]);
        ((JMenuItem)object3).setAccelerator(KeyStroke.getKeyStroke(112, 0));
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SharedUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/");
            }
        });
        ((JMenu)object2).add((JMenuItem)object3);
        object4 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText((AbstractButton)object4, "menu.help.viewVersionHistory", new Object[0]);
        ((AbstractButton)object4).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SharedUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/version-history");
            }
        });
        ((JMenu)object2).add((JMenuItem)object4);
        jMenuItem4 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem4, "menu.help.viewFaq", new Object[0]);
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SharedUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/faq");
            }
        });
        ((JMenu)object2).add(jMenuItem4);
        jMenuItem5 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem5, "menu.help.visitForum", new Object[0]);
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SharedUtils.showURLInBrowser("http://groups.google.com/group/sc2gears");
            }
        });
        ((JMenu)object2).add(jMenuItem5);
        jMenuItem6 = new JMenuItem(Icons.GLOBE_ARROW);
        GuiUtils.updateButtonText(jMenuItem6, "menu.help.donate", new Object[0]);
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SharedUtils.showURLInBrowser("http://sites.google.com/site/sc2gears/donate");
            }
        });
        ((JMenu)object2).add(jMenuItem6);
        ((JMenu)object2).addSeparator();
        GuiUtils.updateButtonText(this.viewSystemMessagesMenuItem, "menu.help.viewSystemMessages", new Object[0]);
        this.viewSystemMessagesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SystemMessagesDialog();
            }
        });
        ((JMenu)object2).add(this.viewSystemMessagesMenuItem);
        ((JMenu)object2).addSeparator();
        GuiUtils.updateButtonText(this.checkUpdatesMenuItem, "menu.help.checkUpdates", new Object[0]);
        this.checkUpdatesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new UpdateChecker(MainFrame.this.checkUpdatesMenuItem);
            }
        });
        ((JMenu)object2).add(this.checkUpdatesMenuItem);
        ((JMenu)object2).addSeparator();
        object = new JMenuItem(Icons.NEWSPAPER);
        GuiUtils.updateButtonText((AbstractButton)object, "menu.help.showStartPage", new Object[0]);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showStartPage(true);
            }
        });
        ((JMenu)object2).add((JMenuItem)object);
        JMenuItem jMenuItem10 = new JMenuItem(Icons.INFORMATION);
        GuiUtils.updateButtonText(jMenuItem10, "menu.help.about", "Sc2gears");
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new AboutDialog();
            }
        });
        ((JMenu)object2).add(jMenuItem10);
        jMenuBar.add((JMenu)object2);
        this.setJMenuBar(jMenuBar);
    }

    private void createNewInternalFrame(MutableTreeNode mutableTreeNode, Object ... objectArray) {
        ModuleFrame moduleFrame = null;
        if (mutableTreeNode == this.newRepAnalNode) {
            moduleFrame = new ReplayAnalyzer(objectArray);
        } else if (mutableTreeNode == this.newMultiRepAnalNode) {
            moduleFrame = new MultiRepAnalysis(objectArray);
        } else if (mutableTreeNode == this.newRepSearchNode) {
            moduleFrame = new ReplaySearch(objectArray);
        }
        if (moduleFrame != null && !moduleFrame.isClosed()) {
            final DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(moduleFrame);
            ((DefaultTreeModel)this.navigationTree.getModel()).insertNodeInto(defaultMutableTreeNode, (DefaultMutableTreeNode)mutableTreeNode.getParent(), 1);
            final TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.navigationTree.setSelectionPath(treePath);
            moduleFrame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    ((DefaultTreeModel)MainFrame.this.navigationTree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
                }

                @Override
                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                    if (!((JInternalFrame)internalFrameEvent.getSource()).isIcon()) {
                        MainFrame.this.navigationTree.setSelectionPath(treePath);
                        MainFrame.this.navigationTree.scrollPathToVisible(treePath);
                    }
                }
            });
            this.addNewInternalFrame(moduleFrame);
        }
    }

    private void addNewInternalFrame(JInternalFrame jInternalFrame) {
        jInternalFrame.setDefaultCloseOperation(2);
        this.desktopPane.add(jInternalFrame);
        try {
            jInternalFrame.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        jInternalFrame.setVisible(true);
    }

    public void openReplayFile(File file) {
        this.createNewInternalFrame(this.newRepAnalNode, file);
    }

    public void updateRecentReplays(File file) {
        int n = Settings.getInt("recentReplays.count");
        ArrayList<String> arrayList = new ArrayList<String>(n + 1);
        String string = file.getAbsolutePath();
        arrayList.add(string);
        int n2 = 0;
        while (n2 < n) {
            String string2 = Settings.getString("recentReplays.entry." + n2);
            if (!string.equals(string2)) {
                arrayList.add(string2);
            }
            ++n2;
        }
        while (arrayList.size() > 15) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() != n) {
            n = arrayList.size();
            Settings.set("recentReplays.count", n);
        }
        n2 = 0;
        while (n2 < n) {
            Settings.set("recentReplays.entry." + n2, arrayList.get(n2));
            ++n2;
        }
        this.rebuildRecentReplaysMenu();
    }

    public void openReplaysInMultiRepAnalysis(File[] fileArray) {
        this.createNewInternalFrame(this.newMultiRepAnalNode, null, null, fileArray);
    }

    private void rebuildRecentReplaysMenu() {
        this.recentReplaysMenu.removeAll();
        int n = Settings.getInt("recentReplays.count");
        int n2 = 0;
        while (n2 < n) {
            final File file = new File(Settings.getString("recentReplays.entry." + n2));
            JMenuItem jMenuItem = new JMenuItem(String.valueOf(n2 + 1) + " " + file.getName(), Icons.SC2);
            if (n2 < 9) {
                jMenuItem.setMnemonic(49 + n2);
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.openReplayFile(file);
                }
            });
            this.recentReplaysMenu.add(jMenuItem);
            ++n2;
        }
    }

    private void arrangeContent() {
        this.mainSplitPane.setLeftComponent(null);
        this.mainSplitPane.setRightComponent(null);
        if (Settings.getInt("navigation.position") == 0) {
            if (this.navigationBar.getWidth() != 0) {
                this.mainSplitPane.setDividerLocation(this.navigationBar.getWidth());
            }
            this.mainSplitPane.setLeftComponent(this.navigationBar);
            this.mainSplitPane.setRightComponent(this.desktopPane);
        } else {
            if (this.desktopPane.getWidth() != 0) {
                this.mainSplitPane.setDividerLocation(this.desktopPane.getWidth());
            }
            this.mainSplitPane.setLeftComponent(this.desktopPane);
            this.mainSplitPane.setRightComponent(this.navigationBar);
        }
    }

    private void hideMainFrame() {
        this.setVisible(false);
        this.hideTrayMenuItem.setEnabled(false);
        this.restoreTrayMenuItem.setEnabled(true);
    }

    public void restoreMainFrame() {
        if (this.windowSizeInitialized) {
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            this.toFront();
        } else {
            this.windowSizeInitialized = true;
            Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            this.setBounds(rectangle.x + insets.left + 10, rectangle.y + insets.top + 10, rectangle.width - insets.left - insets.right - 20, rectangle.height - insets.top - insets.bottom - 20);
            this.setVisible(true);
            double d = (double)Settings.getInt("settings.misc.navBarInitialWidth") / (double)this.getWidth();
            if (d > 1.0) {
                d = 1.0;
            }
            this.mainSplitPane.setDividerLocation(Settings.getInt("navigation.position") == 0 ? d : 1.0 - d);
        }
        if (this.trayIcon != null) {
            this.hideTrayMenuItem.setEnabled(true);
            this.restoreTrayMenuItem.setEnabled(false);
        }
    }

    public static void exit(boolean bl, String ... stringArray) {
        if (Settings.getBoolean("settings.saveOnExit")) {
            Settings.saveProperties();
        }
        if (bl) {
            try {
                Runtime.getRuntime().exec("java -cp lib-updater/Sc2gearsUpdater.jar hu/belicza/andras/sc2gearsupdater/Updater " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3]);
            }
            catch (IOException iOException) {
                System.err.println("Failed to start Sc2gears Updater!");
                iOException.printStackTrace();
            }
        }
        System.exit(0);
    }
}

