/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services;

import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.util.ControlledThread;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.TemplateEngine;
import java.io.File;
import java.io.FileFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReplayAutoSaver
extends ControlledThread
implements FileFilter {
    private static final DateFormat AUTO_REPLAY_NAME_FORMAT = new SimpleDateFormat("yy-MM-dd HH-mm-ss");
    private long previousReplayDate = new Date().getTime();

    public ReplayAutoSaver() {
        super("Replay auto-saver");
    }

    @Override
    public void run() {
        while (!this.requestedToCancel) {
            try {
                File file = null;
                for (File file2 : GeneralUtils.getAutoRepFolderList()) {
                    file = this.getLastReplay(file2);
                    if (file != null) break;
                }
                if (file != null) {
                    File file2;
                    ReplayAutoSaver.sleep(1500L);
                    this.previousReplayDate = file.lastModified();
                    file2 = new File(Settings.getString("settings.folders.replayAutoSave"));
                    if (!file2.exists() && !file2.mkdirs()) {
                        System.out.println("Failed to create replay auto-save folder: " + file2.getAbsolutePath());
                    }
                    if (file2.exists()) {
                        Object object = null;
                        try {
                            object = new TemplateEngine(Settings.getString("settings.misc.repAutoSaveNameTemplate")).applyToReplay(file, file2);
                        }
                        catch (Exception exception) {
                            System.out.println("Failed to apply auto-save name template: " + Settings.getString("settings.misc.repAutoSaveNameTemplate"));
                        }
                        if (object == null || ((String)object).length() == 0) {
                            object = String.valueOf(AUTO_REPLAY_NAME_FORMAT.format(new Date(file.lastModified()))) + ".SC2Replay";
                        }
                        if (!((String)object).toLowerCase().endsWith(".sc2replay")) {
                            object = String.valueOf(object) + ".SC2Replay";
                        }
                        if (new File(file2, (String)object).exists()) {
                            if (((String)object).toLowerCase().endsWith(".sc2replay")) {
                                object = ((String)object).substring(0, ((String)object).length() - 10);
                            }
                            int n = 2;
                            while (new File(file2, String.valueOf(object) + " (" + n + ").SC2Replay").exists()) {
                                ++n;
                            }
                            object = String.valueOf(object) + " (" + n + ").SC2Replay";
                        }
                        File file3 = new File(file2, (String)object);
                        boolean bl = GeneralUtils.copyFile(file, file2, null, (String)object);
                        if (bl) {
                            boolean bl2 = false;
                            if (Settings.getBoolean("settings.misc.deleteAutoSavedReplays")) {
                                bl2 = file.delete();
                            }
                            System.out.println("Successfully " + (bl2 ? "moved" : "copied") + " last replay to: " + file3.getAbsolutePath());
                            if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                                Sounds.playSoundSample("replay_saved", false);
                            }
                        } else {
                            System.out.println("Failed to copy last replay to: " + file3.getAbsolutePath());
                            if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                                Sounds.playSoundSample("replay_save_failed", false);
                            }
                        }
                        if (Settings.getBoolean("settings.misc.autoOpenNewReplays")) {
                            MainFrame.INSTANCE.openReplayFile(bl ? file3 : file);
                        }
                    }
                }
                ReplayAutoSaver.sleep(Settings.getInt("settings.misc.newRepCheckIntervalSec") * 1000);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private File getLastReplay(File file) {
        File[] fileArray = file.listFiles(this);
        if (fileArray == null) {
            return null;
        }
        int n = fileArray.length - 1;
        while (n >= 0) {
            File file2 = fileArray[n];
            if (file2.isFile()) {
                return file2;
            }
            File file3 = this.getLastReplay(file2);
            if (file3 != null) {
                return file3;
            }
            --n;
        }
        return null;
    }

    @Override
    public boolean accept(File file) {
        return file.isDirectory() || file.lastModified() > this.previousReplayDate && file.getName().toLowerCase().endsWith(".sc2replay");
    }
}

