/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services;

import hu.belicza.andras.sc2gears.util.ControlledThread;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JProgressBar;

public class Downloader
extends ControlledThread {
    private final String url;
    private final File destination;
    private final Callback callback;
    public final JProgressBar progressBar = new JProgressBar();

    public Downloader(String string, File file, Callback callback) {
        super("Downloader");
        this.url = string;
        this.destination = file;
        this.callback = callback;
        this.progressBar.setString("");
        this.progressBar.setStringPainted(true);
    }

    @Override
    public void run() {
        InputStream inputStream = null;
        File file = null;
        OutputStream outputStream = null;
        try {
            int n;
            URLConnection uRLConnection = new URL(this.url).openConnection();
            int n2 = uRLConnection.getContentLength();
            if (n2 < 0) {
                this.progressBar.setString("Downloading... (size unknown)");
            } else {
                this.progressBar.setString(null);
                this.progressBar.setMaximum(n2);
            }
            inputStream = uRLConnection.getInputStream();
            file = File.createTempFile("Sc2gears", "s2ma");
            file.deleteOnExit();
            outputStream = new FileOutputStream(file);
            int n3 = 0;
            byte[] byArray = new byte[8192];
            while (!this.requestedToCancel && (n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
                n3 += n;
                if (n2 <= 0) continue;
                this.progressBar.setValue(n3);
            }
            outputStream.flush();
            if (!this.requestedToCancel && n2 < 0) {
                this.progressBar.setValue(this.progressBar.getMaximum());
                this.progressBar.setString(null);
            }
            if (this.requestedToCancel) {
                this.callback.downloadFinished(false);
                return;
            }
            try {
                this.callback.downloadFinished(GeneralUtils.copyFile(file, this.destination.getParentFile(), byArray, this.destination.getName()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.callback.downloadFinished(false);
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (file != null) {
                file.delete();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static interface Callback {
        public void downloadFinished(boolean var1);
    }
}

