/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.shared.SharedUtils;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.util.ControlledThread;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;

public class ApmAlert
extends ControlledThread {
    public static final boolean supported = SharedUtils.isWindows();
    private static final ProcessBuilder APM_QUERY_PROCESS_BUILDER = supported ? new ProcessBuilder("reg.exe", "QUERY", "HKCU\\Software\\Razer\\Starcraft2", "/v", "APMValue") : null;
    private static final ProcessBuilder GAME_STATUS_QUERY_PROCESS_BUILDER = supported ? new ProcessBuilder("reg.exe", "QUERY", "HKCU\\Software\\Razer\\Starcraft2", "/v", "StartModule") : null;
    private static final String TYPE_NAME_DWORD = "REG_DWORD";
    private static final int GAME_STATUS_UNKNOWN = -1;
    private static final int GAME_STATUS_NO_GAME = 0;
    private static final int GAME_STATUS_STARTED = 1;
    private int gameStatus = -1;
    private Long warmUpTimeStart;
    private boolean apmOk;

    public ApmAlert() {
        super("APM alert");
    }

    @Override
    public void run() {
        while (!this.requestedToCancel) {
            try {
                Integer n;
                Integer n2 = ApmAlert.getRegQueryResult(GAME_STATUS_QUERY_PROCESS_BUILDER);
                if (n2 != null) {
                    if (this.gameStatus != 1 && n2 == 1) {
                        if (this.gameStatus == 0) {
                            this.warmUpTimeStart = new Date().getTime();
                            if (Settings.getBoolean("settings.misc.alertOnGameStart") && Settings.getBoolean("settings.enableVoiceNotifications")) {
                                Sounds.playSoundSample("game_started", false);
                            }
                        } else {
                            this.warmUpTimeStart = null;
                        }
                        this.apmOk = true;
                    }
                    if (this.gameStatus == 1 && n2 == 0 && Settings.getBoolean("settings.misc.alertOnGameEnd") && Settings.getBoolean("settings.enableVoiceNotifications")) {
                        Sounds.playSoundSample("game_ended", false);
                    }
                    this.gameStatus = n2;
                }
                if (this.gameStatus == 1 && (this.warmUpTimeStart == null || new Date().getTime() > this.warmUpTimeStart + (long)(Settings.getInt("settings.misc.apmWarmupTime") * 1000)) && (n = ApmAlert.getRegQueryResult(APM_QUERY_PROCESS_BUILDER)) != null) {
                    if (Settings.getBoolean("settings.misc.useRealTimeMeasurement")) {
                        n = ReplayConsts.GameSpeed.FASTER.convertToGameTime(n);
                    }
                    if (n > Settings.getInt("settings.misc.apmAlertLevel")) {
                        if (!this.apmOk) {
                            if (Settings.getBoolean("settings.misc.alertWhenApmIsBackToNormal") && Settings.getBoolean("settings.enableVoiceNotifications")) {
                                Sounds.playSoundSample("apm_ok", false);
                            }
                            this.apmOk = true;
                        }
                    } else if (this.apmOk) {
                        if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                            Sounds.playSoundSample("low_apm", false);
                        }
                        this.apmOk = false;
                    }
                }
                ApmAlert.sleep(Settings.getInt("settings.misc.apmCheckIntervalSec") * 1000);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static Integer getRegQueryResult(ProcessBuilder processBuilder) {
        try {
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            process.waitFor();
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                int n = string.indexOf(TYPE_NAME_DWORD);
                if (n < 0) continue;
                return Integer.valueOf(string.substring(string.indexOf("0x", n + TYPE_NAME_DWORD.length()) + 2), 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

