/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2map;

import hu.belicza.andras.sc2gears.mpq.MpqParser;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.MapInfo;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.Pair;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapParser {
    public static void parseMapInfo(Replay replay) {
        File file = MapParser.getMapFile(replay);
        if (file == null || !file.exists()) {
            return;
        }
        MpqParser mpqParser = null;
        try {
            mpqParser = new MpqParser(file.getAbsolutePath());
            MapInfo mapInfo = new MapInfo();
            byte[] byArray = mpqParser.getFile(ReplayFactory.ReplayContent.MAP_INFO.hash1, ReplayFactory.ReplayContent.MAP_INFO.hash2, ReplayFactory.ReplayContent.MAP_INFO.hash3);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            if (byteBuffer.getInt() != 1298231369) {
                return;
            }
            try {
                byteBuffer.position(byteBuffer.position() + 12);
                mapInfo.width = byteBuffer.getInt();
                mapInfo.height = byteBuffer.getInt();
                byteBuffer.position(byteBuffer.position() + 12);
                while (byteBuffer.get() != 0) {
                }
                while (byteBuffer.get() != 0) {
                }
                mapInfo.boundaryLeft = byteBuffer.getInt();
                mapInfo.boundaryBottom = byteBuffer.getInt();
                mapInfo.boundaryRight = byteBuffer.getInt();
                mapInfo.boundaryTop = byteBuffer.getInt();
                mapInfo.previewIcon = replay.details.mapPreviewFileName.equals(ReplayFactory.ReplayContent.MINIMAP_TGA.fileName) ? ReplayUtils.parseTgaImage(mpqParser.getFile(ReplayFactory.ReplayContent.MINIMAP_TGA.hash1, ReplayFactory.ReplayContent.MINIMAP_TGA.hash2, ReplayFactory.ReplayContent.MINIMAP_TGA.hash3)) : ReplayUtils.parseTgaImage(mpqParser.getFile(replay.details.mapPreviewFileName));
                replay.mapInfo = mapInfo;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    public static void parseExtendedMapInfo(Replay replay) {
        File file = MapParser.getMapFile(replay);
        if (file == null || !file.exists()) {
            return;
        }
        MpqParser mpqParser = null;
        try {
            try {
                GameEvents.Action[] actionArray;
                Object object;
                mpqParser = new MpqParser(file.getAbsolutePath());
                byte[] byArray = mpqParser.getFile(ReplayFactory.ReplayContent.MAP_OBJECTS.hash1, ReplayFactory.ReplayContent.MAP_OBJECTS.hash2, ReplayFactory.ReplayContent.MAP_OBJECTS.hash3);
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
                Element element = document.getDocumentElement();
                ArrayList<Pair<MapInfo.MapObject, Point>> arrayList = new ArrayList<Pair<MapInfo.MapObject, Point>>(128);
                NodeList nodeList = element.getElementsByTagName("ObjectUnit");
                int n = nodeList.getLength() - 1;
                while (n >= 0) {
                    object = (Element)nodeList.item(n);
                    MapInfo.MapObject mapObject = MapInfo.MapObject.fromBinaryValue(object.getAttribute("UnitType"));
                    if (mapObject != null) {
                        arrayList.add(new Pair<MapInfo.MapObject, Point>(mapObject, MapParser.parsePoint(object.getAttribute("Position"))));
                    }
                    --n;
                }
                replay.mapInfo.mapObjectList = arrayList;
                ArrayList<Point> arrayList2 = new ArrayList<Point>();
                object = element.getElementsByTagName("ObjectPoint");
                int n2 = object.getLength() - 1;
                while (n2 >= 0) {
                    actionArray = (GameEvents.Action[])object.item(n2);
                    if ("StartLoc".equals(actionArray.getAttribute("Type"))) {
                        arrayList2.add(MapParser.parsePoint(actionArray.getAttribute("Position")));
                    }
                    --n2;
                }
                replay.mapInfo.startLocationList = arrayList2;
                if (arrayList2.size() > 0) {
                    GameEvents.MoveScreenAction[] moveScreenActionArray = new GameEvents.MoveScreenAction[replay.details.players.length];
                    actionArray = replay.gameEvents.actions;
                    int n3 = actionArray.length;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n3) {
                        GameEvents.Action action = actionArray[n5];
                        if (action instanceof GameEvents.MoveScreenAction && moveScreenActionArray[action.player] == null) {
                            moveScreenActionArray[action.player] = (GameEvents.MoveScreenAction)action;
                            if (++n4 == moveScreenActionArray.length) break;
                        }
                        ++n5;
                    }
                    int n6 = moveScreenActionArray.length - 1;
                    while (n6 >= 0) {
                        GameEvents.MoveScreenAction moveScreenAction = moveScreenActionArray[n6];
                        if (moveScreenAction != null) {
                            int n7 = Integer.MAX_VALUE;
                            Point point = null;
                            for (Point point2 : arrayList2) {
                                int n8 = GeneralUtils.distanceSquare(moveScreenAction.x << 8, moveScreenAction.y << 8, point2.x, point2.y);
                                if (n8 >= n7) continue;
                                n7 = n8;
                                point = point2;
                            }
                            replay.details.players[n6].startLocation = point;
                        }
                        --n6;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (mpqParser != null) {
                    mpqParser.close();
                }
            }
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    private static Point parsePoint(String string) {
        int n = string.indexOf(44);
        return new Point((int)(Float.parseFloat(string.substring(0, n)) * 65536.0f), (int)(Float.parseFloat(string.substring(n + 1, string.indexOf(44, n + 1))) * 65536.0f));
    }

    public static File getMapFile(Replay replay) {
        if (replay.initData.mapFileName == null) {
            return null;
        }
        return new File(Settings.getString("settings.folders.sc2Maps"), replay.initData.mapFileName);
    }
}

