/*
 * Decompiled with CFR 0.152.
 */
package com.easynth.designer.laf.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;

public class EaSynthGraphicsUtils
extends SynthGraphicsUtils {
    public void drawLine(SynthContext context, Object paintKey, Graphics g, int x1, int y1, int x2, int y2) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        int arcWidth = uiDefaults.getInt("EaSynth.graphicsutils.drawline.arc.width");
        int arcHeight = uiDefaults.getInt("EaSynth.graphicsutils.drawline.arc.height");
        Color lineColor = uiDefaults.getColor("EaSynth.graphicsutils.drawline.color");
        if (lineColor != null) {
            g.setColor(lineColor);
        }
        if ("Tree.verticalLine".equals(paintKey)) {
            int deltaY = y2 - y1 - arcHeight / 2;
            if (deltaY > 0) {
                super.drawLine(context, paintKey, g, x1, y1, x2, y1 + deltaY);
            } else {
                super.drawLine(context, paintKey, g, x1, y1, x2, y2);
            }
        } else if ("Tree.horizontalLine".equals(paintKey)) {
            if (Math.abs(x2 - x1) >= arcWidth / 2) {
                if (x1 < x2) {
                    g.drawArc(x1, y2 - arcHeight, arcWidth, arcHeight, 180, 90);
                    g.drawLine(x1 + arcWidth / 2, y2, x2, y2);
                } else {
                    super.drawLine(context, paintKey, g, x1, y1, x2, y2);
                }
            } else {
                super.drawLine(context, paintKey, g, x1, y1, x2, y2);
            }
        } else {
            super.drawLine(context, paintKey, g, x1, y1, x2, y2);
        }
    }

    public static void drawImageWith9Grids(Graphics g, Image img, int dx1, int dy1, int dx2, int dy2, Insets insets, boolean paintCenter) {
        int imgWidth = img.getWidth(null);
        int imgHeight = img.getHeight(null);
        g.drawImage(img, dx1, dy1, dx1 + insets.left, dy1 + insets.top, 0, 0, insets.left, insets.top, null);
        g.drawImage(img, dx2 - insets.right, dy1, dx2, dy1 + insets.top, imgWidth - insets.right, 0, imgWidth, insets.top, null);
        g.drawImage(img, dx1, dy2 - insets.bottom, dx1 + insets.left, dy2, 0, imgHeight - insets.bottom, insets.left, imgHeight, null);
        g.drawImage(img, dx2 - insets.right, dy2 - insets.bottom, dx2, dy2, imgWidth - insets.right, imgHeight - insets.bottom, imgWidth, imgHeight, null);
        g.drawImage(img, dx1 + insets.left, dy1, dx2 - insets.right, dy1 + insets.top, insets.left, 0, imgWidth - insets.right, insets.top, null);
        g.drawImage(img, dx1 + insets.left, dy2 - insets.bottom, dx2 - insets.right, dy2, insets.left, imgHeight - insets.bottom, imgWidth - insets.right, imgHeight, null);
        g.drawImage(img, dx1, dy1 + insets.top, dx1 + insets.left, dy2 - insets.bottom, 0, insets.top, insets.left, imgHeight - insets.bottom, null);
        g.drawImage(img, dx2 - insets.right, dy1 + insets.top, dx2, dy2 - insets.bottom, imgWidth - insets.right, insets.top, imgWidth, imgHeight - insets.bottom, null);
        if (paintCenter) {
            g.drawImage(img, dx1 + insets.left, dy1 + insets.top, dx2 - insets.right, dy2 - insets.bottom, insets.left, insets.top, imgWidth - insets.right, imgHeight - insets.bottom, null);
        }
    }
}

